<?php


abstract class BaseSlideBanner extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $language_id;


	
	protected $image;


	
	protected $link;


	
	protected $description;


	
	protected $is_active = true;


	
	protected $opt_culture;

	
	protected $aLanguage;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getLanguageId()
    {

            return $this->language_id;
    }

    
    public function getImage()
    {

            return $this->image;
    }

    
    public function getLink()
    {

            return $this->link;
    }

    
    public function getDescription()
    {

            return $this->description;
    }

    
    public function getIsActive()
    {

            return $this->is_active;
    }

    
    public function getOptCulture()
    {

            return $this->opt_culture;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = SlideBannerPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = SlideBannerPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = SlideBannerPeer::ID;
        }

	} 
	
	public function setLanguageId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->language_id !== $v) {
          $this->language_id = $v;
          $this->modifiedColumns[] = SlideBannerPeer::LANGUAGE_ID;
        }

		if ($this->aLanguage !== null && $this->aLanguage->getId() !== $v) {
			$this->aLanguage = null;
		}

	} 
	
	public function setImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->image !== $v) {
          $this->image = $v;
          $this->modifiedColumns[] = SlideBannerPeer::IMAGE;
        }

	} 
	
	public function setLink($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->link !== $v) {
          $this->link = $v;
          $this->modifiedColumns[] = SlideBannerPeer::LINK;
        }

	} 
	
	public function setDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->description !== $v) {
          $this->description = $v;
          $this->modifiedColumns[] = SlideBannerPeer::DESCRIPTION;
        }

	} 
	
	public function setIsActive($v)
	{

        if ($this->is_active !== $v || $v === true) {
          $this->is_active = $v;
          $this->modifiedColumns[] = SlideBannerPeer::IS_ACTIVE;
        }

	} 
	
	public function setOptCulture($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_culture !== $v) {
          $this->opt_culture = $v;
          $this->modifiedColumns[] = SlideBannerPeer::OPT_CULTURE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'SlideBanner.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->language_id = $rs->getInt($startcol + 3);

      $this->image = $rs->getString($startcol + 4);

      $this->link = $rs->getString($startcol + 5);

      $this->description = $rs->getString($startcol + 6);

      $this->is_active = $rs->getBoolean($startcol + 7);

      $this->opt_culture = $rs->getString($startcol + 8);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'SlideBanner.postHydrate', array('resultset' => $rs, 'startcol' => 9)));

            return $startcol + 9; 
    } catch (Exception $e) {
      throw new PropelException("Error populating SlideBanner object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseSlideBanner:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(SlideBannerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			SlideBannerPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseSlideBanner:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'SlideBanner.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseSlideBanner:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(SlideBannerPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(SlideBannerPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(SlideBannerPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'SlideBanner.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseSlideBanner:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aLanguage !== null) {
				if ($this->aLanguage->isModified() || $this->aLanguage->getCurrentLanguageI18n()->isModified()) {
					$affectedRows += $this->aLanguage->save($con);
				}
				$this->setLanguage($this->aLanguage);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = SlideBannerPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += SlideBannerPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aLanguage !== null) {
				if (!$this->aLanguage->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aLanguage->getValidationFailures());
				}
			}


			if (($retval = SlideBannerPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = SlideBannerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getLanguageId();
				break;
			case 4:
				return $this->getImage();
				break;
			case 5:
				return $this->getLink();
				break;
			case 6:
				return $this->getDescription();
				break;
			case 7:
				return $this->getIsActive();
				break;
			case 8:
				return $this->getOptCulture();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = SlideBannerPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getLanguageId(),
			$keys[4] => $this->getImage(),
			$keys[5] => $this->getLink(),
			$keys[6] => $this->getDescription(),
			$keys[7] => $this->getIsActive(),
			$keys[8] => $this->getOptCulture(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = SlideBannerPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setLanguageId($value);
				break;
			case 4:
				$this->setImage($value);
				break;
			case 5:
				$this->setLink($value);
				break;
			case 6:
				$this->setDescription($value);
				break;
			case 7:
				$this->setIsActive($value);
				break;
			case 8:
				$this->setOptCulture($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = SlideBannerPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setLanguageId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setImage($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setLink($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setDescription($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setIsActive($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOptCulture($arr[$keys[8]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(SlideBannerPeer::DATABASE_NAME);

		if ($this->isColumnModified(SlideBannerPeer::CREATED_AT)) $criteria->add(SlideBannerPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(SlideBannerPeer::UPDATED_AT)) $criteria->add(SlideBannerPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(SlideBannerPeer::ID)) $criteria->add(SlideBannerPeer::ID, $this->id);
		if ($this->isColumnModified(SlideBannerPeer::LANGUAGE_ID)) $criteria->add(SlideBannerPeer::LANGUAGE_ID, $this->language_id);
		if ($this->isColumnModified(SlideBannerPeer::IMAGE)) $criteria->add(SlideBannerPeer::IMAGE, $this->image);
		if ($this->isColumnModified(SlideBannerPeer::LINK)) $criteria->add(SlideBannerPeer::LINK, $this->link);
		if ($this->isColumnModified(SlideBannerPeer::DESCRIPTION)) $criteria->add(SlideBannerPeer::DESCRIPTION, $this->description);
		if ($this->isColumnModified(SlideBannerPeer::IS_ACTIVE)) $criteria->add(SlideBannerPeer::IS_ACTIVE, $this->is_active);
		if ($this->isColumnModified(SlideBannerPeer::OPT_CULTURE)) $criteria->add(SlideBannerPeer::OPT_CULTURE, $this->opt_culture);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(SlideBannerPeer::DATABASE_NAME);

		$criteria->add(SlideBannerPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setLanguageId($this->language_id);

		$copyObj->setImage($this->image);

		$copyObj->setLink($this->link);

		$copyObj->setDescription($this->description);

		$copyObj->setIsActive($this->is_active);

		$copyObj->setOptCulture($this->opt_culture);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new SlideBannerPeer();
		}
		return self::$peer;
	}

	
	public function setLanguage($v)
	{


		if ($v === null) {
			$this->setLanguageId(NULL);
		} else {
			$this->setLanguageId($v->getId());
		}


		$this->aLanguage = $v;
	}


	
	public function getLanguage($con = null)
	{
		if ($this->aLanguage === null && ($this->language_id !== null)) {
						$this->aLanguage = LanguagePeer::retrieveByPK($this->language_id, $con);

			
		}
		return $this->aLanguage;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'SlideBanner.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseSlideBanner:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseSlideBanner::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 