<?php

/**
 * SOTESHOP/stAdminGeneratorPlugin
 *
 * Ten plik należy do aplikacji stAdminGeneratorPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stAdminGeneratorPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 396 2009-09-09 07:59:20Z marcin $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/**
 * stSlideBannerBackend actions.
 *
 * @author Your name here
 *
 * @package     stAdminGeneratorPlugin
 * @subpackage  actions
 */
class stSlideBannerBackendActions extends autostSlideBannerBackendActions
{

   protected function updateSlideBannerFromRequest()
   {
      parent::updateSlideBannerFromRequest();

      $slide_banner = $this->getRequestParameter('slide_banner');

      $currentFile = sfConfig::get('sf_upload_dir') . $this->slide_banner->getImage();
      
      if (!$this->getRequest()->hasErrors() && $this->getRequest()->getFileSize('slide_banner[image]'))
      {
         $fileName = md5($this->getRequest()->getFileName('slide_banner[image]') . time() . rand(0, 99999));
         $ext = $this->getRequest()->getFileExtension('slide_banner[image]');
         if (is_file($currentFile))
         {
            unlink($currentFile);
         }

         $this->slide_banner->setImage("/picture/" . $this->slide_banner->getLanguage()->getOriginalLanguage() . '/' . $fileName . $ext);

         $this->getRequest()->moveFile('slide_banner[image]', sfConfig::get('sf_upload_dir') . $this->slide_banner->getImage());
         
      }
   }

   public function executeSaveConfigContent()
   {
        if ($this->getRequest()->getMethod() == sfRequest::POST)
        {
            $updateBanner = $this->getRequestParameter('banner');

            $this->bannerConfig = stConfig::getInstance($this->getContext(), 'stSlideBannerBackend');

            $this->bannerConfig->load();

            if(isset($updateBanner['banner_on'])){
                $this->bannerConfig->set('banner_on',$updateBanner['banner_on']);
            }
            else
            {
                $this->bannerConfig->set('banner_on',0);
            }

            $this->bannerConfig->set('width',$updateBanner['width']);

            $this->bannerConfig->set('height',$updateBanner['height']);

            $this->bannerConfig->set('effect',$updateBanner['effect']);

            $this->bannerConfig->set('caption_background_color',$updateBanner['caption_background_color']);

            $this->bannerConfig->set('caption_text_color',$updateBanner['caption_text_color']);

            $this->bannerConfig->set('ignore_language',$updateBanner['ignore_language']);

            $this->bannerConfig->set('anim',$updateBanner['anim']);

            $this->bannerConfig->set('pause',$updateBanner['pause']);
            
            $this->bannerConfig->save(true);

            $this->redirect('stSlideBannerBackend/configCustom');
        }
    }
}