<?php


abstract class BaseTax extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $vat = 0;


	
	protected $is_default = false;


	
	protected $vat_name;


	
	protected $update_resume;

	
	protected $collDeliverys;

	
	protected $lastDeliveryCriteria = null;

	
	protected $collProducts;

	
	protected $lastProductCriteria = null;

	
	protected $collOrderProducts;

	
	protected $lastOrderProductCriteria = null;

	
	protected $collOrderDeliverys;

	
	protected $lastOrderDeliveryCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getVat()
    {

            return null !== $this->vat ? (string)$this->vat : null;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getVatName()
    {

            return $this->vat_name;
    }

    
    public function getUpdateResume()
    {

            return $this->update_resume;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = TaxPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = TaxPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = TaxPeer::ID;
        }

	} 
	
	public function setVat($v)
	{

        if ($this->vat !== $v || $v === 0) {
          $this->vat = $v;
          $this->modifiedColumns[] = TaxPeer::VAT;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = TaxPeer::IS_DEFAULT;
        }

	} 
	
	public function setVatName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->vat_name !== $v) {
          $this->vat_name = $v;
          $this->modifiedColumns[] = TaxPeer::VAT_NAME;
        }

	} 
	
	public function setUpdateResume($v)
	{

        if ($this->update_resume !== $v) {
          $this->update_resume = $v;
          $this->modifiedColumns[] = TaxPeer::UPDATE_RESUME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Tax.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->vat = $rs->getString($startcol + 3, null);

      $this->vat = $rs->getFloat($startcol + 3);

      $this->is_default = $rs->getBoolean($startcol + 4);

      $this->vat_name = $rs->getString($startcol + 5);

      $this->update_resume = $rs->getString($startcol + 6) ? unserialize($rs->getString($startcol + 6)) : null;

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Tax.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Tax object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseTax:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TaxPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			TaxPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseTax:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Tax.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseTax:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(TaxPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(TaxPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TaxPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Tax.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseTax:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
              $o_update_resume = $this->update_resume;
              if (null !== $this->update_resume && $this->isColumnModified(TaxPeer::UPDATE_RESUME)) {
                  $this->update_resume = serialize($this->update_resume);
              }

				if ($this->isNew()) {
					$pk = TaxPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += TaxPeer::doUpdate($this, $con);
				}
				$this->resetModified();
             $this->update_resume = $o_update_resume;
 			}

			if ($this->collDeliverys !== null) {
				foreach($this->collDeliverys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProducts !== null) {
				foreach($this->collProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderProducts !== null) {
				foreach($this->collOrderProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderDeliverys !== null) {
				foreach($this->collOrderDeliverys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = TaxPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collDeliverys !== null) {
					foreach($this->collDeliverys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProducts !== null) {
					foreach($this->collProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderProducts !== null) {
					foreach($this->collOrderProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderDeliverys !== null) {
					foreach($this->collOrderDeliverys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TaxPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getVat();
				break;
			case 4:
				return $this->getIsDefault();
				break;
			case 5:
				return $this->getVatName();
				break;
			case 6:
				return $this->getUpdateResume();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TaxPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getVat(),
			$keys[4] => $this->getIsDefault(),
			$keys[5] => $this->getVatName(),
			$keys[6] => $this->getUpdateResume(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TaxPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setVat($value);
				break;
			case 4:
				$this->setIsDefault($value);
				break;
			case 5:
				$this->setVatName($value);
				break;
			case 6:
				$this->setUpdateResume($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TaxPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setVat($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setIsDefault($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setVatName($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setUpdateResume($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(TaxPeer::DATABASE_NAME);

		if ($this->isColumnModified(TaxPeer::CREATED_AT)) $criteria->add(TaxPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(TaxPeer::UPDATED_AT)) $criteria->add(TaxPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(TaxPeer::ID)) $criteria->add(TaxPeer::ID, $this->id);
		if ($this->isColumnModified(TaxPeer::VAT)) $criteria->add(TaxPeer::VAT, $this->vat);
		if ($this->isColumnModified(TaxPeer::IS_DEFAULT)) $criteria->add(TaxPeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(TaxPeer::VAT_NAME)) $criteria->add(TaxPeer::VAT_NAME, $this->vat_name);
		if ($this->isColumnModified(TaxPeer::UPDATE_RESUME)) $criteria->add(TaxPeer::UPDATE_RESUME, $this->update_resume);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(TaxPeer::DATABASE_NAME);

		$criteria->add(TaxPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setVat($this->vat);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setVatName($this->vat_name);

		$copyObj->setUpdateResume($this->update_resume);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getDeliverys() as $relObj) {
				$copyObj->addDelivery($relObj->copy($deepCopy));
			}

			foreach($this->getProducts() as $relObj) {
				$copyObj->addProduct($relObj->copy($deepCopy));
			}

			foreach($this->getOrderProducts() as $relObj) {
				$copyObj->addOrderProduct($relObj->copy($deepCopy));
			}

			foreach($this->getOrderDeliverys() as $relObj) {
				$copyObj->addOrderDelivery($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new TaxPeer();
		}
		return self::$peer;
	}

	
	public function initDeliverys()
	{
		if ($this->collDeliverys === null) {
			$this->collDeliverys = array();
		}
	}

	
	public function getDeliverys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverys === null) {
			if ($this->isNew()) {
			   $this->collDeliverys = array();
			} else {

				$criteria->add(DeliveryPeer::TAX_ID, $this->getId());

				DeliveryPeer::addSelectColumns($criteria);
				$this->collDeliverys = DeliveryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DeliveryPeer::TAX_ID, $this->getId());

				DeliveryPeer::addSelectColumns($criteria);
				if (!isset($this->lastDeliveryCriteria) || !$this->lastDeliveryCriteria->equals($criteria)) {
					$this->collDeliverys = DeliveryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDeliveryCriteria = $criteria;
		return $this->collDeliverys;
	}

	
	public function countDeliverys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DeliveryPeer::TAX_ID, $this->getId());

		return DeliveryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDelivery(Delivery $l)
	{
		$this->collDeliverys[] = $l;
		$l->setTax($this);
	}


	
	public function getDeliverysJoinCountriesArea($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverys === null) {
			if ($this->isNew()) {
				$this->collDeliverys = array();
			} else {

				$criteria->add(DeliveryPeer::TAX_ID, $this->getId());

				$this->collDeliverys = DeliveryPeer::doSelectJoinCountriesArea($criteria, $con);
			}
		} else {
									
			$criteria->add(DeliveryPeer::TAX_ID, $this->getId());

			if (!isset($this->lastDeliveryCriteria) || !$this->lastDeliveryCriteria->equals($criteria)) {
				$this->collDeliverys = DeliveryPeer::doSelectJoinCountriesArea($criteria, $con);
			}
		}
		$this->lastDeliveryCriteria = $criteria;

		return $this->collDeliverys;
	}

	
	public function initProducts()
	{
		if ($this->collProducts === null) {
			$this->collProducts = array();
		}
	}

	
	public function getProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
			   $this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::TAX_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				$this->collProducts = ProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductPeer::TAX_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
					$this->collProducts = ProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductCriteria = $criteria;
		return $this->collProducts;
	}

	
	public function countProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductPeer::TAX_ID, $this->getId());

		return ProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProduct(Product $l)
	{
		$this->collProducts[] = $l;
		$l->setTax($this);
	}


	
	public function getProductsJoinProductRelatedByParentId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::TAX_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::TAX_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::TAX_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::TAX_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinProducer($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::TAX_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::TAX_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinAvailability($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::TAX_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::TAX_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}

	
	public function initOrderProducts()
	{
		if ($this->collOrderProducts === null) {
			$this->collOrderProducts = array();
		}
	}

	
	public function getOrderProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
			   $this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::TAX_ID, $this->getId());

				OrderProductPeer::addSelectColumns($criteria);
				$this->collOrderProducts = OrderProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderProductPeer::TAX_ID, $this->getId());

				OrderProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
					$this->collOrderProducts = OrderProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderProductCriteria = $criteria;
		return $this->collOrderProducts;
	}

	
	public function countOrderProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderProductPeer::TAX_ID, $this->getId());

		return OrderProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderProduct(OrderProduct $l)
	{
		$this->collOrderProducts[] = $l;
		$l->setTax($this);
	}


	
	public function getOrderProductsJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
				$this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::TAX_ID, $this->getId());

				$this->collOrderProducts = OrderProductPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderProductPeer::TAX_ID, $this->getId());

			if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
				$this->collOrderProducts = OrderProductPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastOrderProductCriteria = $criteria;

		return $this->collOrderProducts;
	}


	
	public function getOrderProductsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderProducts === null) {
			if ($this->isNew()) {
				$this->collOrderProducts = array();
			} else {

				$criteria->add(OrderProductPeer::TAX_ID, $this->getId());

				$this->collOrderProducts = OrderProductPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderProductPeer::TAX_ID, $this->getId());

			if (!isset($this->lastOrderProductCriteria) || !$this->lastOrderProductCriteria->equals($criteria)) {
				$this->collOrderProducts = OrderProductPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastOrderProductCriteria = $criteria;

		return $this->collOrderProducts;
	}

	
	public function initOrderDeliverys()
	{
		if ($this->collOrderDeliverys === null) {
			$this->collOrderDeliverys = array();
		}
	}

	
	public function getOrderDeliverys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderDeliverys === null) {
			if ($this->isNew()) {
			   $this->collOrderDeliverys = array();
			} else {

				$criteria->add(OrderDeliveryPeer::TAX_ID, $this->getId());

				OrderDeliveryPeer::addSelectColumns($criteria);
				$this->collOrderDeliverys = OrderDeliveryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderDeliveryPeer::TAX_ID, $this->getId());

				OrderDeliveryPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderDeliveryCriteria) || !$this->lastOrderDeliveryCriteria->equals($criteria)) {
					$this->collOrderDeliverys = OrderDeliveryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderDeliveryCriteria = $criteria;
		return $this->collOrderDeliverys;
	}

	
	public function countOrderDeliverys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderDeliveryPeer::TAX_ID, $this->getId());

		return OrderDeliveryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderDelivery(OrderDelivery $l)
	{
		$this->collOrderDeliverys[] = $l;
		$l->setTax($this);
	}


	
	public function getOrderDeliverysJoinDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderDeliverys === null) {
			if ($this->isNew()) {
				$this->collOrderDeliverys = array();
			} else {

				$criteria->add(OrderDeliveryPeer::TAX_ID, $this->getId());

				$this->collOrderDeliverys = OrderDeliveryPeer::doSelectJoinDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderDeliveryPeer::TAX_ID, $this->getId());

			if (!isset($this->lastOrderDeliveryCriteria) || !$this->lastOrderDeliveryCriteria->equals($criteria)) {
				$this->collOrderDeliverys = OrderDeliveryPeer::doSelectJoinDelivery($criteria, $con);
			}
		}
		$this->lastOrderDeliveryCriteria = $criteria;

		return $this->collOrderDeliverys;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Tax.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseTax:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseTax::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 