<?php


abstract class BaseText extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $system_name;


	
	protected $is_system_default = true;


	
	protected $active;


	
	protected $opt_name;


	
	protected $opt_content;

	
	protected $collTextI18ns;

	
	protected $lastTextI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSystemName()
    {

            return $this->system_name;
    }

    
    public function getIsSystemDefault()
    {

            return $this->is_system_default;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptContent()
    {

            return $this->opt_content;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = TextPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = TextPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = TextPeer::ID;
        }

	} 
	
	public function setSystemName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->system_name !== $v) {
          $this->system_name = $v;
          $this->modifiedColumns[] = TextPeer::SYSTEM_NAME;
        }

	} 
	
	public function setIsSystemDefault($v)
	{

        if ($this->is_system_default !== $v || $v === true) {
          $this->is_system_default = $v;
          $this->modifiedColumns[] = TextPeer::IS_SYSTEM_DEFAULT;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v) {
          $this->active = $v;
          $this->modifiedColumns[] = TextPeer::ACTIVE;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = TextPeer::OPT_NAME;
        }

	} 
	
	public function setOptContent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_content !== $v) {
          $this->opt_content = $v;
          $this->modifiedColumns[] = TextPeer::OPT_CONTENT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Text.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->system_name = $rs->getString($startcol + 3);

      $this->is_system_default = $rs->getBoolean($startcol + 4);

      $this->active = $rs->getBoolean($startcol + 5);

      $this->opt_name = $rs->getString($startcol + 6);

      $this->opt_content = $rs->getString($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Text.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Text object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseText:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TextPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			TextPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseText:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Text.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseText:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(TextPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(TextPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TextPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Text.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseText:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = TextPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += TextPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collTextI18ns !== null) {
				foreach($this->collTextI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = TextPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collTextI18ns !== null) {
					foreach($this->collTextI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TextPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSystemName();
				break;
			case 4:
				return $this->getIsSystemDefault();
				break;
			case 5:
				return $this->getActive();
				break;
			case 6:
				return $this->getOptName();
				break;
			case 7:
				return $this->getOptContent();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TextPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSystemName(),
			$keys[4] => $this->getIsSystemDefault(),
			$keys[5] => $this->getActive(),
			$keys[6] => $this->getOptName(),
			$keys[7] => $this->getOptContent(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TextPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSystemName($value);
				break;
			case 4:
				$this->setIsSystemDefault($value);
				break;
			case 5:
				$this->setActive($value);
				break;
			case 6:
				$this->setOptName($value);
				break;
			case 7:
				$this->setOptContent($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TextPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSystemName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setIsSystemDefault($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setActive($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptName($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptContent($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(TextPeer::DATABASE_NAME);

		if ($this->isColumnModified(TextPeer::CREATED_AT)) $criteria->add(TextPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(TextPeer::UPDATED_AT)) $criteria->add(TextPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(TextPeer::ID)) $criteria->add(TextPeer::ID, $this->id);
		if ($this->isColumnModified(TextPeer::SYSTEM_NAME)) $criteria->add(TextPeer::SYSTEM_NAME, $this->system_name);
		if ($this->isColumnModified(TextPeer::IS_SYSTEM_DEFAULT)) $criteria->add(TextPeer::IS_SYSTEM_DEFAULT, $this->is_system_default);
		if ($this->isColumnModified(TextPeer::ACTIVE)) $criteria->add(TextPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(TextPeer::OPT_NAME)) $criteria->add(TextPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(TextPeer::OPT_CONTENT)) $criteria->add(TextPeer::OPT_CONTENT, $this->opt_content);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(TextPeer::DATABASE_NAME);

		$criteria->add(TextPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSystemName($this->system_name);

		$copyObj->setIsSystemDefault($this->is_system_default);

		$copyObj->setActive($this->active);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptContent($this->opt_content);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getTextI18ns() as $relObj) {
				$copyObj->addTextI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new TextPeer();
		}
		return self::$peer;
	}

	
	public function initTextI18ns()
	{
		if ($this->collTextI18ns === null) {
			$this->collTextI18ns = array();
		}
	}

	
	public function getTextI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTextI18ns === null) {
			if ($this->isNew()) {
			   $this->collTextI18ns = array();
			} else {

				$criteria->add(TextI18nPeer::ID, $this->getId());

				TextI18nPeer::addSelectColumns($criteria);
				$this->collTextI18ns = TextI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(TextI18nPeer::ID, $this->getId());

				TextI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastTextI18nCriteria) || !$this->lastTextI18nCriteria->equals($criteria)) {
					$this->collTextI18ns = TextI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTextI18nCriteria = $criteria;
		return $this->collTextI18ns;
	}

	
	public function countTextI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TextI18nPeer::ID, $this->getId());

		return TextI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addTextI18n(TextI18n $l)
	{
		$this->collTextI18ns[] = $l;
		$l->setText($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentTextI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentTextI18n()->setName($value);
  }

  public function getContent()
  {
    $obj = $this->getCurrentTextI18n();

    return ($obj ? $obj->getContent() : null);
  }

  public function setContent($value)
  {
    $this->getCurrentTextI18n()->setContent($value);
  }

  protected $current_i18n = array();

  public function getCurrentTextI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = TextI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setTextI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setTextI18nForCulture(new TextI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setTextI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addTextI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Text.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseText:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseText::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 