<?php

/**
 * Subclass for representing a row from the 'st_theme' table.
 *
 * @package     stThemePlugin
 * @subpackage  libs
 */
class Theme extends BaseTheme
{
   protected $themeConfig = null;
   
   protected $editorImages = null;

   public function __toString()
   {
      return $this->getName();
   }
   
   public function getColorScheme()
   {
      return $this->getOptColorScheme();
   }

   public function getIsSystemDefault()
   {
      return parent::getIsSystemDefault() || $this->getTheme() == 'default' || $this->getTheme() == 'homeelectronics' || $this->getActive();
   }

   /**
    *
    * alias for Theme::setBaseThemeId
    * 
    * @param int $v 
    */
   public function setBaseThemeList($v)
   {
      $this->setBaseThemeId($v ? $v : null);
   }

   /**
    * Przeciążenie zapisu
    */
   public function delete($con = null)
   {
      $ret = parent::delete($con);

      stTheme::clearCache();

      return $ret;
   }

   public function setName($v)
   {
      $this->setTheme($v);
   }

   public function getName()
   {
      return $this->getTheme();
   }

   public function getBaseTheme()
   {
      return $this->getThemeRelatedByBaseThemeId();
   }

   /**
    * Przeciążenie zapisu
    */
   public function save($con = null)
   {
      if ($this->isColumnModified(ThemePeer::ACTIVE) && $this->getActive())
      {
         $theme = ThemePeer::doSelectActive();

         if ($theme)
         {
            $theme->setActive(false);

            $theme->save();
         }
      }

      if ($this->isNew() && !$this->isColumnModified(ThemePeer::VERSION))
      {
         $this->setVersion(2);

         $default = ThemePeer::doSelectByName('default2');

         $this->setBaseThemeId($default ? $default->getId() : null);
      }

      $ret = parent::save($con);

      stTheme::clearCache();

      return $ret;
   }
   
   public function getConfigurationPath($system = false)
   {
      return $system ? sfConfig::get('sf_root_dir').'/config/theme/'.$this->theme.'.yml' : 'config/theme/'.$this->theme.'.yml';
   }
   
   public function getCssDir($system_path = false)
   {
      return $system_path ? sfConfig::get('sf_web_dir').'/css/frontend/theme/'.$this->theme : '/css/frontend/theme/'.$this->theme;
   }
   
   public function getImageDir($system_path = false)
   {
      return $system_path ? sfConfig::get('sf_web_dir').'/images/frontend/theme/'.$this->theme : '/images/frontend/theme/'.$this->theme;
   }
     
   public function getEditorCssPath($css, $system_path = false)
   {
      return $this->getCssDir($system_path).'/_editor/'.$css;
   }
   
   public function getEditorImageDir($system_path = false)
   {
      return $this->getImageDir($system_path).'/_editor';
   }

   public function getThemeConfig()
   {
      if (null === $this->themeConfig)
      {
         $c = new Criteria();

         $c->setLimit(1);

         $configs = $this->getThemeConfigs($c);

         $this->themeConfig = $configs ? $configs[0] : array();
      }

      return $this->themeConfig;
   }
   
   public function getEditorImagePath($image, $system_path = false)
   {
      return $this->getImageDir($system_path).'/'.$image;
   }
      
   public function getImagePath($image, $system_path = false)
   {           
      if (null === $this->editorImages)
      {
         $this->editorImages = stThemeConfigGenerator::loadImageConfig($this, SF_ENVIRONMENT == 'theme');
      }
            
      return $this->getImageDir($system_path).'/'.(isset($this->editorImages[$image]) ? $this->editorImages[$image] : $image);
   }   
}
