<?php

/**
 * SOTESHOP/stThemePlugin
 *
 * Ten plik należy do aplikacji stThemePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stThemePlugin
 * @subpackage  lib
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id:  $
 * @author      Michal Prochowski <michal.prochowski@sote.pl>
 */

/**
 * Klasa ThemePeer
 *
 * @package     stThemePlugin
 * @subpackage  lib
 */
class ThemePeer extends BaseThemePeer
{
   /**
    * Aktywny temat graficzny
    * @var Theme
    */
   protected static $activeTheme = null;

   /**
    * Pobieranie aktywnego tematu graficznego
    *
    * @return Theme
    */
   public static function doSelectActive()
   {
      if (null === self::$activeTheme)
      {
         $c = new Criteria();

         $c->add(self::ACTIVE, true);

         $fc = new stFunctionCache('stThemePlugin');

         self::$activeTheme = $fc->cacheCall(array('ThemePeer', 'doSelectOne'), array($c), array('namespace' => 'model'));
      }

      return self::$activeTheme;
   }
   
   public static function doSelectBaseTheme(Criteria $c)
   {
      $c = clone $c;
      
      $c->add(self::BASE_THEME_ID, null, Criteria::ISNULL);
      
      $c->add(self::VERSION, 2, Criteria::GREATER_EQUAL);
      
      return self::doSelect($c);
   }
      
   public static function doSelectByName($name)
   {
      $c = new Criteria();
      
      $c->add(self::THEME, $name);
      
      return self::doSelectOne($c);
   }
}