<?php


abstract class BaseTheme extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $base_theme_id;


	
	protected $theme;


	
	protected $active = false;


	
	protected $opt_color_scheme;


	
	protected $version;


	
	protected $is_system_default = false;

	
	protected $aThemeRelatedByBaseThemeId;

	
	protected $collThemeLayouts;

	
	protected $lastThemeLayoutCriteria = null;

	
	protected $collThemesRelatedByBaseThemeId;

	
	protected $lastThemeRelatedByBaseThemeIdCriteria = null;

	
	protected $collThemeCsss;

	
	protected $lastThemeCssCriteria = null;

	
	protected $collThemeColorSchemes;

	
	protected $lastThemeColorSchemeCriteria = null;

	
	protected $collThemeConfigs;

	
	protected $lastThemeConfigCriteria = null;

	
	protected $collThemeSlots;

	
	protected $lastThemeSlotCriteria = null;

	
	protected $collThemeComponents;

	
	protected $lastThemeComponentCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getBaseThemeId()
    {

            return $this->base_theme_id;
    }

    
    public function getTheme()
    {

            return $this->theme;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getOptColorScheme()
    {

            return $this->opt_color_scheme;
    }

    
    public function getVersion()
    {

            return $this->version;
    }

    
    public function getIsSystemDefault()
    {

            return $this->is_system_default;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ThemePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ThemePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ThemePeer::ID;
        }

	} 
	
	public function setBaseThemeId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->base_theme_id !== $v) {
          $this->base_theme_id = $v;
          $this->modifiedColumns[] = ThemePeer::BASE_THEME_ID;
        }

		if ($this->aThemeRelatedByBaseThemeId !== null && $this->aThemeRelatedByBaseThemeId->getId() !== $v) {
			$this->aThemeRelatedByBaseThemeId = null;
		}

	} 
	
	public function setTheme($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->theme !== $v) {
          $this->theme = $v;
          $this->modifiedColumns[] = ThemePeer::THEME;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === false) {
          $this->active = $v;
          $this->modifiedColumns[] = ThemePeer::ACTIVE;
        }

	} 
	
	public function setOptColorScheme($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_color_scheme !== $v) {
          $this->opt_color_scheme = $v;
          $this->modifiedColumns[] = ThemePeer::OPT_COLOR_SCHEME;
        }

	} 
	
	public function setVersion($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->version !== $v) {
          $this->version = $v;
          $this->modifiedColumns[] = ThemePeer::VERSION;
        }

	} 
	
	public function setIsSystemDefault($v)
	{

        if ($this->is_system_default !== $v || $v === false) {
          $this->is_system_default = $v;
          $this->modifiedColumns[] = ThemePeer::IS_SYSTEM_DEFAULT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Theme.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->base_theme_id = $rs->getInt($startcol + 3);

      $this->theme = $rs->getString($startcol + 4);

      $this->active = $rs->getBoolean($startcol + 5);

      $this->opt_color_scheme = $rs->getString($startcol + 6);

      $this->version = $rs->getInt($startcol + 7);

      $this->is_system_default = $rs->getBoolean($startcol + 8);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Theme.postHydrate', array('resultset' => $rs, 'startcol' => 9)));

            return $startcol + 9; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Theme object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseTheme:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ThemePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ThemePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseTheme:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Theme.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseTheme:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ThemePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ThemePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ThemePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Theme.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseTheme:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aThemeRelatedByBaseThemeId !== null) {
				if ($this->aThemeRelatedByBaseThemeId->isModified()) {
					$affectedRows += $this->aThemeRelatedByBaseThemeId->save($con);
				}
				$this->setThemeRelatedByBaseThemeId($this->aThemeRelatedByBaseThemeId);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ThemePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ThemePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collThemeLayouts !== null) {
				foreach($this->collThemeLayouts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collThemesRelatedByBaseThemeId !== null) {
				foreach($this->collThemesRelatedByBaseThemeId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collThemeCsss !== null) {
				foreach($this->collThemeCsss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collThemeColorSchemes !== null) {
				foreach($this->collThemeColorSchemes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collThemeConfigs !== null) {
				foreach($this->collThemeConfigs as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collThemeSlots !== null) {
				foreach($this->collThemeSlots as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collThemeComponents !== null) {
				foreach($this->collThemeComponents as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aThemeRelatedByBaseThemeId !== null) {
				if (!$this->aThemeRelatedByBaseThemeId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aThemeRelatedByBaseThemeId->getValidationFailures());
				}
			}


			if (($retval = ThemePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collThemeLayouts !== null) {
					foreach($this->collThemeLayouts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collThemeCsss !== null) {
					foreach($this->collThemeCsss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collThemeColorSchemes !== null) {
					foreach($this->collThemeColorSchemes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collThemeConfigs !== null) {
					foreach($this->collThemeConfigs as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collThemeSlots !== null) {
					foreach($this->collThemeSlots as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collThemeComponents !== null) {
					foreach($this->collThemeComponents as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ThemePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getBaseThemeId();
				break;
			case 4:
				return $this->getTheme();
				break;
			case 5:
				return $this->getActive();
				break;
			case 6:
				return $this->getOptColorScheme();
				break;
			case 7:
				return $this->getVersion();
				break;
			case 8:
				return $this->getIsSystemDefault();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ThemePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getBaseThemeId(),
			$keys[4] => $this->getTheme(),
			$keys[5] => $this->getActive(),
			$keys[6] => $this->getOptColorScheme(),
			$keys[7] => $this->getVersion(),
			$keys[8] => $this->getIsSystemDefault(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ThemePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setBaseThemeId($value);
				break;
			case 4:
				$this->setTheme($value);
				break;
			case 5:
				$this->setActive($value);
				break;
			case 6:
				$this->setOptColorScheme($value);
				break;
			case 7:
				$this->setVersion($value);
				break;
			case 8:
				$this->setIsSystemDefault($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ThemePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setBaseThemeId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setTheme($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setActive($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptColorScheme($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setVersion($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setIsSystemDefault($arr[$keys[8]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ThemePeer::DATABASE_NAME);

		if ($this->isColumnModified(ThemePeer::CREATED_AT)) $criteria->add(ThemePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ThemePeer::UPDATED_AT)) $criteria->add(ThemePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ThemePeer::ID)) $criteria->add(ThemePeer::ID, $this->id);
		if ($this->isColumnModified(ThemePeer::BASE_THEME_ID)) $criteria->add(ThemePeer::BASE_THEME_ID, $this->base_theme_id);
		if ($this->isColumnModified(ThemePeer::THEME)) $criteria->add(ThemePeer::THEME, $this->theme);
		if ($this->isColumnModified(ThemePeer::ACTIVE)) $criteria->add(ThemePeer::ACTIVE, $this->active);
		if ($this->isColumnModified(ThemePeer::OPT_COLOR_SCHEME)) $criteria->add(ThemePeer::OPT_COLOR_SCHEME, $this->opt_color_scheme);
		if ($this->isColumnModified(ThemePeer::VERSION)) $criteria->add(ThemePeer::VERSION, $this->version);
		if ($this->isColumnModified(ThemePeer::IS_SYSTEM_DEFAULT)) $criteria->add(ThemePeer::IS_SYSTEM_DEFAULT, $this->is_system_default);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ThemePeer::DATABASE_NAME);

		$criteria->add(ThemePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setBaseThemeId($this->base_theme_id);

		$copyObj->setTheme($this->theme);

		$copyObj->setActive($this->active);

		$copyObj->setOptColorScheme($this->opt_color_scheme);

		$copyObj->setVersion($this->version);

		$copyObj->setIsSystemDefault($this->is_system_default);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getThemeLayouts() as $relObj) {
				$copyObj->addThemeLayout($relObj->copy($deepCopy));
			}

			foreach($this->getThemesRelatedByBaseThemeId() as $relObj) {
				if($this->getPrimaryKey() === $relObj->getPrimaryKey()) {
						continue;
				}

				$copyObj->addThemeRelatedByBaseThemeId($relObj->copy($deepCopy));
			}

			foreach($this->getThemeCsss() as $relObj) {
				$copyObj->addThemeCss($relObj->copy($deepCopy));
			}

			foreach($this->getThemeColorSchemes() as $relObj) {
				$copyObj->addThemeColorScheme($relObj->copy($deepCopy));
			}

			foreach($this->getThemeConfigs() as $relObj) {
				$copyObj->addThemeConfig($relObj->copy($deepCopy));
			}

			foreach($this->getThemeSlots() as $relObj) {
				$copyObj->addThemeSlot($relObj->copy($deepCopy));
			}

			foreach($this->getThemeComponents() as $relObj) {
				$copyObj->addThemeComponent($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ThemePeer();
		}
		return self::$peer;
	}

	
	public function setThemeRelatedByBaseThemeId($v)
	{


		if ($v === null) {
			$this->setBaseThemeId(NULL);
		} else {
			$this->setBaseThemeId($v->getId());
		}


		$this->aThemeRelatedByBaseThemeId = $v;
	}


	
	public function getThemeRelatedByBaseThemeId($con = null)
	{
		if ($this->aThemeRelatedByBaseThemeId === null && ($this->base_theme_id !== null)) {
						$this->aThemeRelatedByBaseThemeId = ThemePeer::retrieveByPK($this->base_theme_id, $con);

			
		}
		return $this->aThemeRelatedByBaseThemeId;
	}

	
	public function initThemeLayouts()
	{
		if ($this->collThemeLayouts === null) {
			$this->collThemeLayouts = array();
		}
	}

	
	public function getThemeLayouts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeLayouts === null) {
			if ($this->isNew()) {
			   $this->collThemeLayouts = array();
			} else {

				$criteria->add(ThemeLayoutPeer::THEME_ID, $this->getId());

				ThemeLayoutPeer::addSelectColumns($criteria);
				$this->collThemeLayouts = ThemeLayoutPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeLayoutPeer::THEME_ID, $this->getId());

				ThemeLayoutPeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeLayoutCriteria) || !$this->lastThemeLayoutCriteria->equals($criteria)) {
					$this->collThemeLayouts = ThemeLayoutPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeLayoutCriteria = $criteria;
		return $this->collThemeLayouts;
	}

	
	public function countThemeLayouts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeLayoutPeer::THEME_ID, $this->getId());

		return ThemeLayoutPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeLayout(ThemeLayout $l)
	{
		$this->collThemeLayouts[] = $l;
		$l->setTheme($this);
	}


	
	public function getThemeLayoutsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeLayouts === null) {
			if ($this->isNew()) {
				$this->collThemeLayouts = array();
			} else {

				$criteria->add(ThemeLayoutPeer::THEME_ID, $this->getId());

				$this->collThemeLayouts = ThemeLayoutPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(ThemeLayoutPeer::THEME_ID, $this->getId());

			if (!isset($this->lastThemeLayoutCriteria) || !$this->lastThemeLayoutCriteria->equals($criteria)) {
				$this->collThemeLayouts = ThemeLayoutPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastThemeLayoutCriteria = $criteria;

		return $this->collThemeLayouts;
	}

	
	public function initThemesRelatedByBaseThemeId()
	{
		if ($this->collThemesRelatedByBaseThemeId === null) {
			$this->collThemesRelatedByBaseThemeId = array();
		}
	}

	
	public function getThemesRelatedByBaseThemeId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemesRelatedByBaseThemeId === null) {
			if ($this->isNew()) {
			   $this->collThemesRelatedByBaseThemeId = array();
			} else {

				$criteria->add(ThemePeer::BASE_THEME_ID, $this->getId());

				ThemePeer::addSelectColumns($criteria);
				$this->collThemesRelatedByBaseThemeId = ThemePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemePeer::BASE_THEME_ID, $this->getId());

				ThemePeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeRelatedByBaseThemeIdCriteria) || !$this->lastThemeRelatedByBaseThemeIdCriteria->equals($criteria)) {
					$this->collThemesRelatedByBaseThemeId = ThemePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeRelatedByBaseThemeIdCriteria = $criteria;
		return $this->collThemesRelatedByBaseThemeId;
	}

	
	public function countThemesRelatedByBaseThemeId($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemePeer::BASE_THEME_ID, $this->getId());

		return ThemePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeRelatedByBaseThemeId(Theme $l)
	{
		$this->collThemesRelatedByBaseThemeId[] = $l;
		$l->setThemeRelatedByBaseThemeId($this);
	}

	
	public function initThemeCsss()
	{
		if ($this->collThemeCsss === null) {
			$this->collThemeCsss = array();
		}
	}

	
	public function getThemeCsss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeCsss === null) {
			if ($this->isNew()) {
			   $this->collThemeCsss = array();
			} else {

				$criteria->add(ThemeCssPeer::THEME_ID, $this->getId());

				ThemeCssPeer::addSelectColumns($criteria);
				$this->collThemeCsss = ThemeCssPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeCssPeer::THEME_ID, $this->getId());

				ThemeCssPeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeCssCriteria) || !$this->lastThemeCssCriteria->equals($criteria)) {
					$this->collThemeCsss = ThemeCssPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeCssCriteria = $criteria;
		return $this->collThemeCsss;
	}

	
	public function countThemeCsss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeCssPeer::THEME_ID, $this->getId());

		return ThemeCssPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeCss(ThemeCss $l)
	{
		$this->collThemeCsss[] = $l;
		$l->setTheme($this);
	}

	
	public function initThemeColorSchemes()
	{
		if ($this->collThemeColorSchemes === null) {
			$this->collThemeColorSchemes = array();
		}
	}

	
	public function getThemeColorSchemes($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeColorSchemes === null) {
			if ($this->isNew()) {
			   $this->collThemeColorSchemes = array();
			} else {

				$criteria->add(ThemeColorSchemePeer::THEME_ID, $this->getId());

				ThemeColorSchemePeer::addSelectColumns($criteria);
				$this->collThemeColorSchemes = ThemeColorSchemePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeColorSchemePeer::THEME_ID, $this->getId());

				ThemeColorSchemePeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeColorSchemeCriteria) || !$this->lastThemeColorSchemeCriteria->equals($criteria)) {
					$this->collThemeColorSchemes = ThemeColorSchemePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeColorSchemeCriteria = $criteria;
		return $this->collThemeColorSchemes;
	}

	
	public function countThemeColorSchemes($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeColorSchemePeer::THEME_ID, $this->getId());

		return ThemeColorSchemePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeColorScheme(ThemeColorScheme $l)
	{
		$this->collThemeColorSchemes[] = $l;
		$l->setTheme($this);
	}

	
	public function initThemeConfigs()
	{
		if ($this->collThemeConfigs === null) {
			$this->collThemeConfigs = array();
		}
	}

	
	public function getThemeConfigs($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeConfigs === null) {
			if ($this->isNew()) {
			   $this->collThemeConfigs = array();
			} else {

				$criteria->add(ThemeConfigPeer::ID, $this->getId());

				ThemeConfigPeer::addSelectColumns($criteria);
				$this->collThemeConfigs = ThemeConfigPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeConfigPeer::ID, $this->getId());

				ThemeConfigPeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeConfigCriteria) || !$this->lastThemeConfigCriteria->equals($criteria)) {
					$this->collThemeConfigs = ThemeConfigPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeConfigCriteria = $criteria;
		return $this->collThemeConfigs;
	}

	
	public function countThemeConfigs($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeConfigPeer::ID, $this->getId());

		return ThemeConfigPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeConfig(ThemeConfig $l)
	{
		$this->collThemeConfigs[] = $l;
		$l->setTheme($this);
	}

	
	public function initThemeSlots()
	{
		if ($this->collThemeSlots === null) {
			$this->collThemeSlots = array();
		}
	}

	
	public function getThemeSlots($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeSlots === null) {
			if ($this->isNew()) {
			   $this->collThemeSlots = array();
			} else {

				$criteria->add(ThemeSlotPeer::THEME_ID, $this->getId());

				ThemeSlotPeer::addSelectColumns($criteria);
				$this->collThemeSlots = ThemeSlotPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeSlotPeer::THEME_ID, $this->getId());

				ThemeSlotPeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeSlotCriteria) || !$this->lastThemeSlotCriteria->equals($criteria)) {
					$this->collThemeSlots = ThemeSlotPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeSlotCriteria = $criteria;
		return $this->collThemeSlots;
	}

	
	public function countThemeSlots($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeSlotPeer::THEME_ID, $this->getId());

		return ThemeSlotPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeSlot(ThemeSlot $l)
	{
		$this->collThemeSlots[] = $l;
		$l->setTheme($this);
	}

	
	public function initThemeComponents()
	{
		if ($this->collThemeComponents === null) {
			$this->collThemeComponents = array();
		}
	}

	
	public function getThemeComponents($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeComponents === null) {
			if ($this->isNew()) {
			   $this->collThemeComponents = array();
			} else {

				$criteria->add(ThemeComponentPeer::THEME_ID, $this->getId());

				ThemeComponentPeer::addSelectColumns($criteria);
				$this->collThemeComponents = ThemeComponentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeComponentPeer::THEME_ID, $this->getId());

				ThemeComponentPeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeComponentCriteria) || !$this->lastThemeComponentCriteria->equals($criteria)) {
					$this->collThemeComponents = ThemeComponentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeComponentCriteria = $criteria;
		return $this->collThemeComponents;
	}

	
	public function countThemeComponents($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeComponentPeer::THEME_ID, $this->getId());

		return ThemeComponentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeComponent(ThemeComponent $l)
	{
		$this->collThemeComponents[] = $l;
		$l->setTheme($this);
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Theme.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseTheme:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseTheme::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 