<?php

/**
 * SOTESHOP/stThemePlugin
 *
 * Ten plik należy do aplikacji stThemePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stThemePlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stTheme.class.php 653 2009-04-16 06:18:48Z michal $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/**
 * Klasa obsługująca tematy w aplikacji frontend
 *
 * @package     stThemePlugin
 * @subpackage  libs
 */
class stTheme
{

   protected
   $context,
   $response,
   $theme = null,
   $baseTheme = null,
   $layoutName,
   $cssDir = null,
   $stylesheetPath = array(),
   $layoutConfig = array();
   protected static $pluginModulePaths = null;
   protected static $instance = null;

   /**
    * Zwraca instancje obiektu
    *
    * @param sfContext $context
    *
    * @return      stTheme     object
    */
   public static function getInstance(sfContext $context)
   {
      if (!isset(self::$instance))
      {
         $class = __CLASS__;
         self::$instance = new $class();
         self::$instance->initialize($context);
      }

      return self::$instance;
   }

   /**
    * Inicjalizuje podstawową konfigurację tematu
    *
    * @param        string      $context
    */
   public function initialize(sfContext $context)
   {
      $this->layoutConfig = array();

      $this->cssDir = sfConfig::get('sf_web_dir') . DIRECTORY_SEPARATOR . 'css';

      $this->context = $context;

      $this->response = $context->getResponse();

      if (SF_ENVIRONMENT == 'theme')
      {
         if ($this->context->getRequest()->hasParameter('theme'))
         {
            $this->context->getUser()->setAttribute('name', $this->context->getRequest()->getParameter('theme'), 'soteshop/stTheme');
         }

         $theme_name = $this->context->getUser()->getAttribute('name', null, 'soteshop/stTheme');

         if ($theme_name)
         {
            $this->setThemeName($theme_name);
         }
      }

      $theme = $this->getTheme();

      if ($theme->getVersion() < 2)
      {
         include(sfConfigCache::getInstance()->checkConfig('config/module_finder.yml'));

         $plugin_module_config_dir = isset(self::$pluginModulePaths[$this->getModuleName()]) ? self::$pluginModulePaths[$this->getModuleName()] . DIRECTORY_SEPARATOR . sfConfig::get('sf_app_module_config_dir_name') : null;

         $module_config_dir = sfConfig::get('sf_app_module_dir') . DIRECTORY_SEPARATOR . $this->getModuleName() . DIRECTORY_SEPARATOR . sfConfig::get('sf_app_module_config_dir_name');

         $app_config_dir = sfConfig::get('sf_app_config_dir');

         //wczytaj globalna konfiguracje tematu
         $this->includeThemeConfig('soteshop.yml', $app_config_dir);

         //wczytaj konfiguracje tematu dla danego modułu
         $this->includeThemeConfig('soteshop.yml', $module_config_dir);

         if (!$this->includeLayoutConfig($this->getThemeName() . '.yml', $app_config_dir))
         {
            $this->includeLayoutConfig($this->getDefaultThemeName() . '.yml', $app_config_dir);
         }

         if (!$this->includeLayoutConfig($this->getThemeName() . '.yml', $plugin_module_config_dir))
         {
            $this->includeLayoutConfig($this->getDefaultThemeName() . '.yml', $plugin_module_config_dir);
         }

         if (!$this->includeLayoutConfig($this->getThemeName() . '.yml', $module_config_dir))
         {
            $this->includeLayoutConfig($this->getDefaultThemeName() . '.yml', $module_config_dir);
         }
      }
   }

   public function getActionName()
   {
      return $this->context->getActionName();
   }

   public function getModuleName()
   {
      return $this->context->getModuleName();
   }

   public function getVersion()
   {
      return $this->getTheme()->getVersion();
   }

   /**
    * Pobiera aktywny obiekt tematu
    *
    * @return   Theme
    */
   public function getTheme()
   {
      if (null === $this->theme)
      {
         $this->theme = self::getActiveTheme();
      }

      return $this->theme;
   }

   public function setTheme(Theme $theme)
   {
      $this->theme = $theme;
   }

   /**
    * Pobiera aktywny obiekt tematu
    *
    * @return   Theme
    */
   public static function getActiveTheme()
   {
      $theme = ThemePeer::doSelectActive();

      return $theme;
   }

   /**
    * Zwraca aktualnie ustawiony tematu
    *
    * @return   string
    */
   public function getThemeName()
   {
      return $this->getTheme()->getTheme();
   }

   /**
    * Ustawia temat
    *
    * @param   string      $name              Nazwa tematu
    */
   public function setThemeName($name)
   {
      $theme = ThemePeer::doSelectByName($name);

      if (null === $theme)
      {
         $theme = new Theme();

         $theme->setName($name);
      }

      $this->setTheme($theme);
   }

   public function getBaseTheme()
   {
      if (null === $this->baseTheme)
      {
         $this->baseTheme = $this->getTheme()->getBaseTheme();
      }

      return $this->baseTheme;
   }

   public function setBaseTheme(Theme $theme)
   {
      $this->baseTheme = $theme;
   }

   /**
    * Ustawia podstawy temat
    *
    * @param        string      $theme
    */
   public function setDefaultThemeName($name)
   {
      $theme = ThemePeer::doSelectByName($name);

      if (null === $theme)
      {
         $theme = new Theme();

         $theme->setName($name);
      }

      $this->setBaseTheme($theme);
   }

   public function getThemeColorScheme()
   {
      return $this->getTheme()->getColorScheme();
   }

   /**
    * Zwraca nazwe podstawowego tematu
    *
    * @return   string
    */
   public function getDefaultThemeName()
   {
      return $this->getBaseTheme() ? $this->getBaseTheme()->getName() : null;
   }

   /**
    * Ustawia układ strony
    *
    * @param   string      $layout             Nazwa układu strony (bez rozszerzenia .html)
    */
   public function setLayoutName($layout)
   {
      $this->layoutName = $layout;
   }

   /**
    * Zwraca aktualnie ustawiony układ strony
    *
    * @return   string
    */
   public function getLayoutName()
   {
      return $this->layoutName;
   }

   /**
    * Ustawia konfigurację danego układu strony dla danego kontenera
    *
    * @deprecated
    * 
    * @param   string      $container_name     Nazwa kontenera
    * @param   array       $display            Tablica komponentów które będą wyświetlone w kontenerze
    */
   public function setLayoutConfig($config = array())
   {
      $this->layoutConfig = array_merge_recursive($this->layoutConfig, $config);
   }

   /**
    * Zwraca konfigurację układu strony dla danego kontenera
    *
    * @deprecated
    * 
    * @param   string      $container_name     Nazwa kontenera
    * @return  array       Tablica komponentów które będą wyświetlone w kontenerze
    */
   public function getLayoutConfig($container_name)
   {
      $container_name = str_replace('st_layout_', '', $container_name);

      return isset($this->layoutConfig[$container_name]) ? $this->layoutConfig[$container_name] : array();
   }

   public function getThemeDir()
   {

      return 'frontend/theme/' . $this->getThemeName();
   }

   public function getThemeColorSchemeDir()
   {
      return $this->getThemeDir() . '/' . $this->getThemeColorScheme();
   }

   public function getDefaultThemeDir()
   {
      return 'frontend/theme/' . $this->getDefaultThemeName();
   }

   public function getTemplateDir($module = null)
   {
      return sfLoader::getTemplateDir($module ? $module : $this->context->getModuleName(), null) . DIRECTORY_SEPARATOR . 'theme';
   }

   public function getStylesheetPaths($stylesheet)
   {
      if (!isset($this->stylesheetPath[$stylesheet]))
      {
         $stylesheet_path = $this->getStylesheetPath($stylesheet);

         if ($stylesheet_path)
         {
            $this->stylesheetPath[$stylesheet]['default'] = $stylesheet_path;

            $stylesheet_path = $this->getStylesheetPath('my_' . $stylesheet);

            if ($stylesheet_path)
            {
               $this->stylesheetPath[$stylesheet]['my'] = $stylesheet_path;
            }
         }
         else
         {
            $this->stylesheetPath[$stylesheet] = null;
         }
      }

      return $this->stylesheetPath[$stylesheet];
   }

   public function addStylesheet($stylesheet, $position = '', $options = array())
   {
      $stylesheet_path = $this->getStylesheetPaths($stylesheet);

      if ($stylesheet_path)
      {
         $this->response->addStylesheet($stylesheet_path['default'], $position, $options);

         if (isset($stylesheet_path['my']))
         {
            $this->response->addStylesheet($stylesheet_path['my'], $position, $options);
         }
      }
   }

   public function addLess($less, $position = '')
   {
      $less_path = $this->getStylesheetPaths($less);

      if ($less_path)
      {
         $this->response->setParameter($less_path['default'], array(), 'helper/asset/auto/less' . ($position ? '/' . $position : ''));

         if (isset($less_path['my']))
         {
            $this->response->setParameter($less_path['my'], array(), 'helper/asset/auto/less' . ($position ? '/' . $position : ''));
         }
      }
   }

   /**
    * Get stylesheet path
    * @param string $stylesheet
    * @return string stylesheet path
    */
   protected function getStylesheetPath($stylesheet)
   {
      if ($this->getThemeColorScheme() && is_readable($this->cssDir . DIRECTORY_SEPARATOR . $this->getThemeColorSchemeDir() . DIRECTORY_SEPARATOR . $stylesheet))
      {
         return $this->getThemeColorSchemeDir() . '/' . $stylesheet;
      }
      elseif (is_readable($this->cssDir . DIRECTORY_SEPARATOR . $this->getThemeDir() . DIRECTORY_SEPARATOR . $stylesheet))
      {
         return $this->getThemeDir() . '/' . $stylesheet;
      }
      elseif ($this->getBaseTheme() && is_readable($this->cssDir . DIRECTORY_SEPARATOR . $this->getDefaultThemeDir() . DIRECTORY_SEPARATOR . $stylesheet))
      {
         return $this->getDefaultThemeDir() . '/' . $stylesheet;
      }

      return false;
   }

   /**
    * Ładuje konfiguracje tematu
    * 
    * @deprecated
    *
    * @param   string      $yml_config_name    Nazwa pliku yml
    * @param   string      $path               ścieżka częściowa lub pełna do pliku konfiguracyjnego
    * @return  bool        Zwraca true w przypadku powodzenia
    */
   private function includeThemeConfig($yml_config_name, $path)
   {
      $include_config = sfConfigCache::getInstance()->checkConfig($path . DIRECTORY_SEPARATOR . $yml_config_name, true);

      if ($include_config !== null)
      {
         include($include_config);
         return true;
      }

      return false;
   }

   /**
    * Ładuje konfiguracje układu strony
    * 
    * @deprecated
    *
    * @param   string      $yml_config_name    Nazwa pliku yml
    * @param   string      $path               ścieżka częściowa lub pełna do pliku konfiguracyjnego
    * @return  bool        Zwraca true w przypadku powodzenia
    */
   private function includeLayoutConfig($yml_config_name, $path)
   {
      $include_config = sfConfigCache::getInstance()->checkConfig($path . DIRECTORY_SEPARATOR . 'layout' . DIRECTORY_SEPARATOR . $yml_config_name, true);

      if ($include_config !== null)
      {
         include($include_config);
         return true;
      }

      return false;
   }

   /**
    * Dodaje plik CSS ktory zostanie zalaczony podczas wyświetlania strony
    *
    * @param   string      $stylesheet         Nazwa pliku css umieszczonego w katalogu 'frontend/theme/nazwa_tematu'
    */
   public static function useStylesheet($stylesheet, $position = '', $options = array())
   {
      $context = sfContext::getInstance();

      $theme = stTheme::getInstance($context);

      $theme->addStylesheet($stylesheet, $position, $options);
   }

   public static function getImagePath($image)
   {
      static $processed = array();

      static $theme = null;
      
      if (!isset($processed[$image]))
      {
         if (null === $theme)
         {
            $context = sfContext::getInstance();

            $theme = stTheme::getInstance($context);
         }

         $sf_web_dir = sfConfig::get('sf_web_dir') . DIRECTORY_SEPARATOR . 'images';

         if ($theme->getVersion() < 2 && $theme->getThemeColorScheme() && is_readable($sf_web_dir . DIRECTORY_SEPARATOR . $theme->getThemeColorSchemeDir() . DIRECTORY_SEPARATOR . $image))
         {
            $processed[$image] = $theme->getThemeColorSchemeDir() . '/' . $image;
         }
         elseif (!$theme->getBaseTheme() || is_readable($theme->getTheme()->getImagePath($image, true)))
         {
            $processed[$image] = $theme->getTheme()->getImagePath($image);
         }
         else
         {            
            $processed[$image] = $theme->getBaseTheme()->getImagePath($image);
         }
      }

      return $processed[$image];
   }

   public static function clearCache($clear_fast_cache = true)
   {
      $fc = new stFunctionCache('stThemePlugin');

      $fc->removeByNamespace('model');

      if ($clear_fast_cache)
      {
         stFastCacheManager::clearCache();
      }
   }
   
   public static function clearAssetsCache()
   {
      stWebFileManager::getInstance()->remove(sfConfig::get('sf_web_dir').'/cache/css');
      
      stWebFileManager::getInstance()->remove(sfConfig::get('sf_web_dir').'/cache/less');       
   }
   
   public static function clearEditorCache()
   {
      self::clearCache(false);
      
      stWebFileManager::getInstance()->remove(sfConfig::get('sf_web_dir').'/cache/css/_editor');
      
      stWebFileManager::getInstance()->remove(sfConfig::get('sf_web_dir').'/cache/less/_editor');       
   }

}
