<?php
/** 
 * SOTESHOP/stThemePlugin
 *
 * Ten plik należy do aplikacji stThemePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stThemePlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stThemeConfigHandler.class.php 256 2009-03-30 11:49:45Z marek $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/** 
 * Klasa odpowiadająca za generowanie konfiguracji dla tematów
 *
 * @package     stThemePlugin
 * @subpackage  libs
 */
class stThemeConfigHandler extends sfYamlConfigHandler
{
    public function execute($configFiles)
    {
        $prefix = strtolower($this->getParameterHolder()->get('prefix', ''));

        $theme = stTheme::getInstance(sfContext::getInstance());

        $data = array();

        $myConfig = $this->parseYamls($configFiles);

        $myConfig = sfToolkit::arrayDeepMerge(
            isset($myConfig['default']) && is_array($myConfig['default']) ? $myConfig['default'] : array(),
            isset($myConfig['all']) && is_array($myConfig['all']) ? $myConfig['all'] : array(),
            isset($myConfig[sfConfig::get('sf_environment')]) && is_array($myConfig[sfConfig::get('sf_environment')]) ? $myConfig[sfConfig::get('sf_environment')] : array()
        );

        if (isset($myConfig['.view']))
        {
            if (isset($myConfig['.view']['default_theme']))
            {
                $data[] = sprintf("\$this->setDefaultThemeName('%s');", $myConfig['.view']['default_theme']);
            }

            if (isset($myConfig['.view']['theme']))
            {
                $data[] = sprintf("\$this->setThemeName('%s');", $myConfig['.view']['theme']);
            }
        }
        elseif (!isset($myConfig['.layout']))
        {
            $data[] = sprintf('$layout = %s;', var_export($myConfig, true));

            $data[] = '$current_layout = isset($layout[$this->getActionName()]) ? $layout[$this->getActionName()] : $layout[\'default\'];';

            $data[] = 'if (isset($current_layout[\'layout_name\'])) {';

            $data[] = '$this->setLayoutName($current_layout[\'layout_name\']);';

            $data[] = '} elseif (isset($layout[\'default\'][\'layout_name\'])) {';

            $data[] = '$this->setLayoutName($layout[\'default\'][\'layout_name\']);';

            $data[] = '}';

            $data[] = 'if (isset($current_layout[\'layout_containers\'])) {';

            $data[] = '$this->setLayoutConfig($current_layout[\'layout_containers\']);';

            $data[] = '} elseif (isset($layout[\'default\'][\'layout_containers\'])) {';

            $data[] = '$this->setLayoutConfig($layout[\'default\'][\'layout_containers\']);';

            $data[] = '}';
        }
        else
        {
            $data[] = '$layout = array();';

            foreach ($myConfig['.layout'] as $key => $value)
            {
                if ($key == 'name')
                {
                    $data[] = '$this->setLayoutName(\''.$value.'\');';
                }
                else
                {
                    $data[] = '$layout[\''.$key.'\'] = ' . var_export($value, true) . ';';
                }

            }

            $data[] = '$this->setLayoutConfig($layout);';
        }


        // compile data
        $retval = sprintf("<?php\n".
            "// auto-generated by stThemeConfigHandler\n".
            "// date: %s\n%s\n",
            date('Y/m/d H:i:s'),
            implode("\n", $data)
        );

        return $retval;
    }
}