<?php

/**
 * SOTESHOP/stThemePlugin 
 * 
 * Ten plik należy do aplikacji stThemePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stThemePlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stThemeView.php 653 2009-04-16 06:18:48Z michal $
 * @author      Marcin Butlak <marcin.butlak@sote.pl>
 */

/**
 * Klasa rozszerzająca warstwę view dla stTheme
 *
 * @package     stThemePlugin
 * @subpackage  libs
 */
class stThemeView extends sfPHPView
{

   protected $theme = null;

   /**
    * Zwraca instancję obiektu stTheme
    *
    * @return   stTheme
    */
   public function getTheme()
   {
      if (null === $this->theme)
      {
         $this->theme = $this->getContext()->getController()->getTheme();
      }

      return $this->theme;
   }

   public function smartyIncludeStylesheets($params, &$smarty)
   {
      if (SF_ENVIRONMENT == 'theme')
      {
         echo minify_get_stylesheets($this->getContext()->getResponse(), isset($params['minify']) && $params['minify'] == 'true', 'cache/css/_editor');
      }
      else
      {
         echo minify_get_stylesheets($this->getContext()->getResponse(), isset($params['minify']) && $params['minify'] == 'true');
      }
   }

   public function smartyIncludeJavascripts($params, &$smarty)
   {
      echo minify_get_javascripts($this->getContext()->getResponse(), isset($params['minify']) && $params['minify'] == 'true');
   }
   
   public function smartyIncludeLess($params, &$smarty)
   {
      if (SF_ENVIRONMENT == 'theme')
      {
         echo minify_get_less($this->getContext()->getResponse(), 'cache/less/_editor');
      }
      else
      {
         echo minify_get_less($this->getContext()->getResponse());
      }
   }   

   public function smartyIncludeMeta($params, &$smarty)
   {
      $smarty->smartySet($params, $smarty);

      $response = $this->getContext()->getResponse();

      foreach ($response->getHttpMetas() as $httpequiv => $value)
      {
         echo tag('meta', array('http-equiv' => $httpequiv, 'content' => $value))."\n";
      }

      foreach ($response->getMetas() as $name => $content)
      {
         if ($name == 'title')
         {
            continue;
         }

         echo tag('meta', array('name' => $name, 'content' => $content))."\n";
      }

      echo content_tag('title', $response->getTitle())."\n";
   }

   public function smartyThemeEdit($params, $content)
   {
      $decorator = '';

      $decorator = st_drop_menu_load_view();

      $decorator .= st_drop_menu_load_config();

      if (SF_ENVIRONMENT == 'edit')
      {
         $decorator .= st_get_component('stThemeFrontend', 'editThemeHead');
      }
      else
      {
         $decorator .= content_tag('a', '', array('id' => 'portal-block-list-link', 'name' => 'portal-block-list-link'));
      }

      $decorator .= $content;

      if (SF_ENVIRONMENT == 'edit')
      {
         $decorator .= st_get_component('stThemeFrontend', 'editThemeFoot');
      }
      else
      {
         $decorator .= content_tag('div', content_tag('div', content_tag('div', '', array('id' => 'magazine1', 'class' => 'portal-column'))), array('id' => 'portal-column-block-list', 'style' => 'display:none'));
      }

      return $decorator;
   }

   public function renderLayout($content, $default_layout)
   {
      $smarty = new stSmarty();
      
      sfLoader::loadHelpers('stUsersOnline');

      $smarty->assign('users_online', st_get_online_users());

      $smarty->assign('show_online_users', st_show_online_users());

      if ($this->getTheme()->getVersion() >= 2 && SF_ENVIRONMENT == 'theme')
      {
         $this->getContext()->getResponse()->addStylesheet('/css/frontend/stThemeEditor.css', 'last');
         
         $this->getContext()->getResponse()->addJavascript('/js/jquery.cookie.js', 'last');
         
         sfLoader::loadHelpers('stPartial');
         
         $content .= st_get_partial('stThemeFrontend/theme_editor', array('theme' => $this->getTheme()->getTheme()));
      }
      
      $smarty->assign('content', $content);

      $smarty->assignLinkTo('new_products_title', 'NOWOŚCI', 'product/list?new=1');

      $smarty->assignLinkTo('promotion_products_title', 'PROMOCJE', 'product/list?group_id=1');

      $smarty->assignComponent('stSearch', 'stSearchFrontend', 'searchBox');
      
      $smarty->assignComponent('stPartner', 'stPartnerFrontend', 'checkHash');

      $smarty->assignPartial('stNavigationShowLocation', 'stNavigationFrontend', 'showLocation');

      $smarty->assignPartial('selectLanguage', 'stLanguageFrontend', 'showLanguages');

      $smarty->assignComponent('header', 'stWebpageFrontend', 'groupWebpage', array('group_page' => 'HEADER'));

      $smarty->fc_assign('stBasketList',st_get_component('stBasket', 'show'));

      $smarty->assignComponent('stCurrencyPickCurrency', 'stCurrencyFrontend', 'pickCurrency');

      $smarty->assignComponent('footer', 'stWebpageFrontend', 'groupWebpage', array('group_page' => 'FOOTER'));
      
      $smarty->assign('theme', $this->getThemeConfiguration());

      $smarty->assign('edit_environment', SF_ENVIRONMENT == 'edit' && sfConfig::get('sf_st_theme_clipboard'));

      $smarty->assign('open', stLicense::isOpen());

      $layout = $this->getTheme()->getLayoutName();

      return $smarty->fetch(($layout ? $layout : $default_layout).'.html').st_get_component('stFastCacheFrontend', 'cache');
   }

   public function smartyRenderLayout($source, $smarty)
   {
      if (preg_match_all('/{render_layout default="([^"]+)"}/', $source, $matches))
      {

         $code = array();

         foreach ($matches[0] as $i => $search)
         {
            $layout_name = $matches[1][$i];

            $code[] = sprintf('{php}$this->_tpl_vars[\'_layout_%1$s\'] = $this->_tpl_vars[\'view\']->renderLayout($this->_tpl_vars[\'content\'], \'%1$s\');{/php}', $layout_name);

            $source = str_replace($search, sprintf('{php}echo $this->_tpl_vars[\'_layout_%s\'];{/php}', $layout_name), $source);
         }

         return implode("\n", $code)."\n".$source;
      }

      return $source;
   }

   protected function decorate($content)
   {
      return $this->decorator ? $this->decorateContent($content) : null;
   }

   protected function decorateContent($content)
   {
      sfLoader::loadHelpers('SfMinify');

      $smarty = new stSmarty();

      $smarty->register_function('include_meta', array($this, 'smartyIncludeMeta'));

      $smarty->register_function('include_javascripts', array($this, 'smartyIncludeJavascripts'));

      $smarty->register_function('include_stylesheets', array($this, 'smartyIncludeStylesheets'));
      
      $smarty->register_function('include_less', array($this, 'smartyIncludeLess'));

      $smarty->register_prefilter(array($this, 'smartyRenderLayout'));

      $smarty->assign('content', $content);

      $smarty->assign('view', $this);

      $smarty->assign('lang', stLanguage::getLayoutLanguage());

      if ($this->getTheme()->getTheme()->getVersion() < 2)
      {
         sfLoader::loadHelpers('stDropMenu');

         $smarty->register_block('theme_edit', array($this, 'smartyThemeEdit'));

         $smarty->register_function('include_theme_edit_stylesheets', 'st_drop_menu_extend_css');

         $this->getTheme()->useStylesheet('style.css', 'first');

         $this->getTheme()->useStylesheet($this->getTheme()->getLayoutName().'.css', 'first');

         $this->getTheme()->useStylesheet($this->getTheme()->getThemeName().'.css', 'last');        
      }
      else
      {
         $theme = $this->getTheme()->getTheme();
         
         if (SF_ENVIRONMENT == 'theme')
         {
            if (is_file($theme->getEditorCssPath('preview_config.less', true)))
            {
               $this->getTheme()->addLess('_editor/preview_config.less', 'last');
            }

            if (is_file($theme->getEditorCssPath('preview_style.css', true)))
            {
               $this->getTheme()->useStylesheet('_editor/preview_style.css', 'last');
            }  
         } 
         else
         {
            if (is_file($theme->getEditorCssPath('config.less', true)))
            {
               $this->getTheme()->addLess('_editor/config.less', 'last');
            }

            if (is_file($theme->getEditorCssPath('style.css', true)))
            {
               $this->getTheme()->useStylesheet('_editor/style.css', 'last');
            }             
         }
      }

      return $smarty->fetch('base.html');
   }

   protected function preRenderCheck()
   {
      if ($this->template == null)
      {
         // a template has not been set
         $error = 'A template has not been set';

         throw new sfRenderException($error);
      }

      $template = $this->directory.'/'.$this->template;

      if (!is_readable($template))
      {
         // the template isn't readable
         throw new sfRenderException(sprintf('The template "%s" does not exist in: %s', $template, $this->directory));
      }
   }
   
   protected function getThemeConfiguration()
   {
      $config = stConfig::getInstance('stThemeBackend');
      
      $tmp = array();
      
      $tmp['logo'] = array('name' => $config->get('logo_name_text', null, true), 'desc' => $config->get('logo_desc_text', null, true));
      
      return $tmp;
   }

}
