<?php

/**
 * SOTESHOP/stThemePlugin
 *
 * Ten plik należy do aplikacji stThemePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stThemePlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: actions.class.php 256 2009-03-30 11:49:45Z marek $
 */

/**
 * Klasa stThemeBackendActions
 *
 * @package     stThemePlugin
 * @subpackage  actions
 */
class stThemeBackendActions extends autoStThemeBackendActions
{

   protected $editorConfiguration = null;

   public function executeGraphicSave()
   {
      $this->forward('stThemeBackend', 'graphicEdit');
   }

   public function executeList()
   {
      parent::executeList();

      $path = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'soteshop.yml';

      $config = sfYaml::load($path);

      $this->developerTheme = $config['all']['.view']['theme'];
   }

   public function executeSetDefault()
   {
      $pk = $this->getRequestParameter('id');

      $theme = ThemePeer::retrieveByPK($pk);

      $theme->setActive(true);

      $theme->save();

      $redirect = urlencode($this->getRequest()->getReferer());
          
      return $this->redirect('http://'.$this->getRequest()->getHost().'/frontend_theme.php/stThemeFrontend/editorMessage?redirect='.$redirect.'&default');
   }

   public function executeApplyChanges()
   {
      $this->theme_config = $this->getThemeConfigOrCreate();

      $this->editor_config = $this->loadEditorConfiguration($this->theme_config);

      if ($this->hasRequestParameter('save'))
      {
         $generator = new stThemeConfigGenerator($this->editor_config);

         $generator->generateLess();

         $generator->generateGraphic();
         
         stTheme::clearCache(true);
         
         stTheme::clearAssetsCache();
         
         if ($this->getRequestParameter('save') == 'redirect')
         {
            $redirect = urlencode($this->getRequest()->getReferer());
          
            return $this->redirect('http://'.$this->getRequest()->getHost().'/frontend_theme.php/stThemeFrontend/editorMessage?redirect='.$redirect.'&apply');
         }
         else
         {
            $this->setFlash('notice', $this->getContext()->getI18N()->__('Twoje zmiany zostały zastosowane do aktualnego tematu'));         
            
            return $this->redirect('stThemeBackend/applyChanges?id='.$this->theme_config->getId());
         }
      }
   }

   public function executeColorRestore()
   {
      $pk = $this->getRequestParameter('id');

      $theme_config = ThemeConfigPeer::retrieveByPK($pk);

      $theme_config->restoreLess();

      $theme_config->save();

      $this->setFlash('notice', $this->getContext()->getI18N()->__('Domyślne ustawienia zostały przywrócone'));

      stTheme::clearCache(false);

      return $this->redirect('stThemeBackend/colorEdit?id='.$pk);
   }

   public function validateColorEdit()
   {
      $ok = true;

      $this->theme_config = $this->getThemeConfigOrCreate();

      $this->editor_config = $this->loadEditorConfiguration($this->theme_config);

      return $ok;
   }

   public function validateGraphicEdit()
   {
      $ok = true;

      $this->theme_config = $this->getThemeConfigOrCreate();

      $this->editor_config = $this->loadEditorConfiguration($this->theme_config);

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->labels = array();

         $validator = new stAssetFileValidator();

         $validator->initialize($this->getContext(), array('mime_types' => '@web_images', 'required' => false));

         $files = $this->getRequest()->getFiles();

         if (isset($files['theme_config']))
         {
            foreach ($files['theme_config']['name'] as $category => $fields)
            {
               foreach ($fields as $name => $value)
               {
                  $value = $this->getRequest()->getFileValues('theme_config['.$category.']['.$name.']');

                  if ($value && !$validator->execute($value, $error))
                  {
                     $this->getRequest()->setError('theme_config{'.$category.'}{'.$name.'}', $error);

                     $ok = false;

                     $this->labels['theme_config{'.$category.'}{'.$name.'}'] = $this->editor_config->getGraphicCategoryLabel($category).' -> '.$this->editor_config->getGraphicFieldParameter($category, $name, 'label');
                  }
               }
            }
         }
      }

      return $ok;
   }

   public function handleErrorGraphicEdit()
   {
      $this->updateThemeConfigFromRequest($this->theme_config, $this->editor_config);

      return sfView::SUCCESS;
   }

   public function executeGraphicRestore()
   {
      $pk = $this->getRequestParameter('id');

      $theme_config = ThemeConfigPeer::retrieveByPK($pk);
      
      $theme_config->restoreCss();

      $theme_config->restoreImages();

      $theme_config->save();

      $this->setFlash('notice', $this->getContext()->getI18N()->__('Domyślne ustawienia zostały przywrócone'));

      stTheme::clearCache(false);

      return $this->redirect('stThemeBackend/graphicEdit?id='.$pk);
   }

   public function executeColorEdit()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->updateThemeConfigFromRequest($this->theme_config, $this->editor_config);

         $this->saveThemeConfig($this->theme_config, $this->editor_config);

         $generator = new stThemeConfigGenerator($this->editor_config);

         $generator->generateLess(true);

         stTheme::clearCache(false);

         if ($this->hasRequestParameter('preview_save'))
         {
            return $this->redirectToPreview($this->theme_config);
         }
         else
         {
            $this->setFlash('notice', $this->getContext()->getI18N()->__('Twoje zmiany zostały zapisane', array(), 'stAdminGeneratorPlugin'));

            return $this->redirect('stThemeBackend/colorEdit?id='.$this->theme_config->getId());
         }
      }
   }

   public function executeGraphicEdit()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->updateThemeConfigFromRequest($this->theme_config, $this->editor_config);

         $this->saveThemeConfig($this->theme_config, $this->editor_config);

         $generator = new stThemeConfigGenerator($this->editor_config);

         $generator->generateGraphic(true);

         stTheme::clearCache(false);

         if ($this->hasRequestParameter('preview_save'))
         {
            return $this->redirectToPreview($this->theme_config);
         }
         else
         {
            $this->setFlash('notice', $this->getContext()->getI18N()->__('Twoje zmiany zostały zapisane', array(), 'stAdminGeneratorPlugin'));

            return $this->redirect('stThemeBackend/graphicEdit?id='.$this->theme_config->getId());
         }
      }
   }

   protected function redirectToPreview(ThemeConfig $theme_config)
   {
      return $this->redirect('http://'.$this->getRequest()->getHost().'/frontend_theme.php?theme='.$theme_config->getTheme()->getName());
   }

   protected function uploadImage(ThemeConfig $theme_config, $field_name, $prev_image)
   {
      $image = null;

      if ($this->getRequest()->getFileError($field_name) == UPLOAD_ERR_OK)
      {
         $filename = $this->getRequest()->getFileName($field_name);

         $fileinfo = pathinfo($filename);

         $image = '_editor/preview/'.md5($filename.microtime(true)).'.'.$fileinfo['extension'];

         if ($prev_image && is_file($theme_config->getTheme()->getImageDir(true).'/'.$prev_image))
         {
            unlink($theme_config->getTheme()->getImageDir(true).'/'.$prev_image);
         }

         $this->getRequest()->moveFile($field_name, $theme_config->getTheme()->getImageDir(true).'/'.$image, 0664, true, 0775);
      }

      return $image;
   }

   protected function saveThemeConfig(ThemeConfig $theme_config, stThemeEditorConfig $editor_config)
   {
      $files = $this->getRequest()->getFiles();

      if (isset($files['theme_config']))
      {
         foreach ($files['theme_config']['name'] as $category => $fields)
         {
            foreach ($fields as $name => $value)
            {
               if ($editor_config->hasGraphicFieldType($category, $name, 'css') && $editor_config->hasGraphicFieldProperty($category, $name, 'background-image'))
               {
                  $image = $this->uploadImage($theme_config, 'theme_config['.$category.']['.$name.']', $theme_config->getCss($category, $name));

                  if ($image)
                  {
                     $theme_config->setCss($category, $name, $image);
                  }
               }
               elseif ($editor_config->hasGraphicFieldType($category, $name, 'image'))
               {
                  $image = $this->uploadImage($theme_config, 'theme_config['.$category.']['.$name.']', $theme_config->getImage($category, $name));

                  if ($image)
                  {
                     $theme_config->setImage($category, $name, $image);
                  }
               }
            }
         }
      }

      $theme_config->save();
   }

   protected function loadEditorConfiguration(ThemeConfig $theme_config)
   {
      $editor_config = new stThemeEditorConfig();

      $editor_config->load($theme_config);

      return $editor_config;
   }

   protected function updateThemeConfigFromRequest(ThemeConfig $theme_config, stThemeEditorConfig $editor_config)
   {
      $request = $this->getRequestParameter('theme_config');

      foreach ($request as $category => $fields)
      {
         foreach ($fields as $name => $value)
         {
            if ($category == '_less')
            {
               if (is_array($value) && isset($value['default']))
               {
                  $theme_config->removeLess($name);
               }
               else
               {
                  $theme_config->setLess($name, $value);
               }
            }
            elseif ($editor_config->hasGraphicFieldType($category, $name, 'css'))
            {
               if (is_array($value) && isset($value['restore']))
               {
                  $theme_config->removeCssImage($category, $name);
               }
               elseif (is_array($value) && isset($value['default']))
               {
                  $theme_config->removeCss($category, $name);
               }
               else
               {
                  $theme_config->setCss($category, $name, $value);
               }
            }
            elseif (is_array($value) && isset($value['restore']) && $editor_config->hasGraphicFieldType($category, $name, 'image'))
            {
               $theme_config->removeImage($category, $name);
            }
         }
      }
   }

   protected function getThemeConfigOrCreate()
   {
      $theme_id = $this->getRequestParameter('id');

      $theme_config = ThemeConfigPeer::retrieveByPk($theme_id);

      if (null === $theme_config)
      {
         $theme_config = new ThemeConfig();

         $theme_config->setId($theme_id);
      }

      return $theme_config;
   }

   public function saveTheme($current_theme)
   {
      $theme_name = preg_replace('/[^0-9a-z_\-]+/', '', strtolower($current_theme->getTheme()));

      $current_theme->setTheme($theme_name);

      if (!$this->getRequest()->getParameter('id'))
      {

         $dir = $path = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.$current_theme->getTheme();

         $manager = new stWebFileManager();

         $manager->mkdir($dir);

         $oldfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.'default2'.DIRECTORY_SEPARATOR.'config.less';
         $newfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.$current_theme->getTheme().DIRECTORY_SEPARATOR.'config.less';

         $manager->copy($oldfile, $newfile);

         $oldfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.'default2'.DIRECTORY_SEPARATOR.'one_column_layout.less';
         $newfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.$current_theme->getTheme().DIRECTORY_SEPARATOR.'one_column_layout.less';

         $manager->copy($oldfile, $newfile);

         $oldfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.'default2'.DIRECTORY_SEPARATOR.'two_column_layout.less';
         $newfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.$current_theme->getTheme().DIRECTORY_SEPARATOR.'two_column_layout.less';

         $manager->copy($oldfile, $newfile);

         $oldfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.'default2'.DIRECTORY_SEPARATOR.'three_column_layout.less';
         $newfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.$current_theme->getTheme().DIRECTORY_SEPARATOR.'three_column_layout.less';

         $manager->copy($oldfile, $newfile);

         $oldfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.'default2'.DIRECTORY_SEPARATOR.'style.less';
         $newfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.$current_theme->getTheme().DIRECTORY_SEPARATOR.'style.less';

         $manager->copy($oldfile, $newfile);

         $oldfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.'default2'.DIRECTORY_SEPARATOR.'theme.less';
         $newfile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR.'css'.DIRECTORY_SEPARATOR.'frontend'.DIRECTORY_SEPARATOR.'theme'.DIRECTORY_SEPARATOR.$current_theme->getTheme().DIRECTORY_SEPARATOR.'theme.less';

         $manager->copy($oldfile, $newfile);
      }
      parent::saveTheme($current_theme);
   }

   public function handleErrorSave()
   {
      return $this->forward('stThemeBackend', 'edit');
   }

   public function executeDownloadTheme()
   {
      if ($this->getRequest()->hasParameter('id'))
      {
         $c = new Criteria();
         $c->add(ThemePeer::ID, $this->getRequest()->getParameter('id'));
         $theme = ThemePeer::doSelectOne($c);

         if (is_object($theme))
         {
            $td = new stThemeDownloader($theme->getName());
            $td->makePackage();

            $this->setLayout(false);
            $response = $this->getContext()->getResponse();
            $response->setContentType('application/octet-stream');
            $response->setHttpHeader('Content-Disposition', 'attachment; filename="'.$theme->getName().'.tgz"');

            $this->handle = fopen($td->getPackagePath(), 'r');
         }
      }
   }

   public function executeSaveConfig()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->config = stConfig::getInstance($this->getContext(), 'stThemeBackend');

         $this->config->setFromRequest('themeBackend');

         $this->config->save();

         $this->setFlash('notice', 'Twoje zmiany zostały zapisane');

         $this->redirect('theme/configCustom');
      }
   }

}