<?php
/**
 * SOTESHOP/stThemePlugin
 *
 * Ten plik należy do aplikacji stThemePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stThemePlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: components.class.php 256 2009-03-30 11:49:45Z marek $
 */

/**
 * Klasa stThemeBackendComponents
 *
 * @package     stThemePlugin
 * @subpackage  actions
 */
class stThemeBackendComponents extends autoStThemeBackendComponents
{
   public function executeStylingForm()
   {
      $name = $this->theme_config->getTheme()->getName();
      
      $parser = new sfYamlParser();
      
      $this->config = $parser->parse(file_get_contents(sfConfig::get('sf_config_dir').'/theme/'.$name.'.yml'));
   }
   
   public function executeBaseThemeList()
   {
      if ($this->theme->isNew() || $this->theme->getVersion() >= 2)
      {
         $c = new Criteria();
         
         $c->add(ThemePeer::ID, $this->theme->getId(), Criteria::NOT_EQUAL);
      
         $this->base_themes = ThemePeer::doSelectBaseTheme($c);
      }
      else
      {
         $this->base_themes = null;
      }
      
      if ($this->theme->isNew())
      {
         $theme = ThemePeer::doSelectByName('default2');
         
         $this->selected = $theme ? $theme->getId() : null;
      }
      else
      {
         $this->selected = $this->theme->getBaseThemeId();
      }
   }

   public function executeConfigContent()
   {
        $this->config = stConfig::getInstance($this->getContext(), 'stThemeBackend');
   }
}