<?php
/**
 * Dispatcher
 */
$dispatcher = stEventDispatcher::getInstance();

if (SF_APP == 'backend')
{
	/**
	 * Włączanie modułów
	 */
	stPluginHelper::addEnableModule('stTrustedShopsBackend', 'backend');

	/**
	 * Dodawanie routingów
	 */
	stPluginHelper::addRouting('stTrustedShopsPlugin', '/trustedshops/:action/*', 'stTrustedShopsBackend', 'index', 'backend');

	/**
	 * Dodanie ikonki na stronie głównej panelu
	 */
	stPluginHelper::addToBackendDesktop('stTrustedShopsPlugin');
	
	/**
	 * Dispatcher
	 */
	$dispatcher->connect('TrustedShops.postSave', array('stTrustedShopsListener', 'saveTrustedShops'));
}
if (SF_APP == 'frontend')
{
	/**
	 * Włączanie modułów
	 */
	stPluginHelper::addEnableModule('stTrustedShopsFrontend', 'frontend');

	/**
	 * Dodawanie routingów
	 */
	stPluginHelper::addRouting('stTrustedShopsPlugin', '/trustedshops/:action/*', 'stTrustedShopsFrontend', 'index', 'frontend');

	/**
	 * Ładownie komponentów przez socket
	 */
	stSocketView::addComponent('stOrderSummary', 'stTrustedShopsFrontend', 'showClassicBuyerProtection');

	/**
	 * Dispatcher
	 */
	$dispatcher->connect('stDeliveryFrontendComponents.preExecuteBasketSummary', array('stTrustedShopsListener', 'preBasketSummary'));
	$dispatcher->connect('stDeliveryFrontendActions.postExecuteAjaxDeliveryUpdate', array('stTrustedShopsListener', 'postAjaxPaymentUpdate'));
	$dispatcher->connect('stDeliveryFrontendActions.postExecuteAjaxPaymentUpdate', array('stTrustedShopsListener', 'postAjaxPaymentUpdate'));
	$dispatcher->connect('stOrderActions.postExecuteConfirm', array('stTrustedShopsListener', 'preBasketSummary'));
	$dispatcher->connect('stOrderActions.postExecuteSave', array('stTrustedShopsListener', 'postOrderSave'));
}