<?php

/**
 * Klasa TrustedShops
 */
class TrustedShops extends BaseTrustedShops
{
	/**
	 * Pobieranie typu certyfikatu
	 *
	 * @return string
	 */
	public function getType()
	{
		return ucfirst(strtolower($this->type));
	}

	/**
	 * Przeciążenie usuwania
	 */
	public function delete($con = null)
	{
		parent::delete($con);

		$stCache = new stFunctionCache('stTrustedShopsPlugin');
		$stCache->removeAll();
	}

	/**
	 * Przeciążenie zapisu
	 */
	public function save($con = null)
	{
		$isNew = false;
		if($this->isNew())
		{
			$connector = new stTrustedShopsConnector();
			$result = $connector->checkCertificate($this->certificate);

			$this->setType($result->typeEnum);
			$this->setStatus($result->stateEnum);
			$this->setUrl($result->url);
			$this->setLanguage($result->certificationLanguage);

			$isNew = true;
		}

		$stCache = new stFunctionCache('stTrustedShopsPlugin');
		$stCache->removeAll();

		parent::save($con);

		if($isNew)
		{
			foreach (PaymentTypePeer::doSelect(new Criteria()) as $paymentType)
			{
				$method = 'OTHER';
				if ($paymentType->getModuleName() == 'stPaypal') $method = 'PAYPAL';
				if ($paymentType->getModuleName() == 'stDotpay') $method = 'OTHER';
				if ($paymentType->getModuleName() == 'stEcard') $method = 'CREDIT_CARD';
				if ($paymentType->getModuleName() == 'stLukas') $method = 'OTHER';
				if ($paymentType->getModuleName() == 'stMoneybookers') $method = 'MONEYBOOKERS';
				if ($paymentType->getModuleName() == 'stPlatnosciPl') $method = 'OTHER';
				if ($paymentType->getModuleName() == 'stPolcard') $method = 'CREDIT_CARD';
				if ($paymentType->getModuleName() == 'stPrzelewy24') $method = 'OTHER';
				if ($paymentType->getModuleName() == 'stZagiel') $method = 'OTHER';
				if ($paymentType->getModuleName() == 'stStandardPayment' && $paymentType->getName() == 'Płatność gotówką') $method = 'CASH_ON_PICKUP';
				if ($paymentType->getModuleName() == 'stStandardPayment' && $paymentType->getName() == 'Płatność przelewem') $method = 'PREPAYMENT';

				$c = new Criteria();
				$c->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $this->getId());
				$c->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $paymentType->getId());
				$trustedShopsPaymentType = TrustedShopsHasPaymentTypePeer::doSelectOne($c);

				if (!is_object($trustedShopsPaymentType))
				{
					$trustedShopsPaymentType = new TrustedShopsHasPaymentType();
					$trustedShopsPaymentType->setTrustedShopsId($this->getId());
					$trustedShopsPaymentType->setPaymentTypeId($paymentType->getId());
					$trustedShopsPaymentType->setMethod($method);
					$trustedShopsPaymentType->save();
				}
			}
		}
	}
}