<?php

class TrustedShopsPeer extends BaseTrustedShopsPeer
{
	protected static $domainAndCulture = null;

	public static function retrieveByCultureAndDomain($culture, $domain)
	{
		if (is_null(self::$domainAndCulture))
		{
			$stCache = new stFunctionCache('stTrustedShopsPlugin');

			if ($culture == 'pl_PL') $language = 'pl';
			elseif ($culture == 'en_US') $language = 'en';
			else $language = $culture;

			$c = new Criteria();
			$c->add(self::URL, '%'.str_replace(array('https://', 'http://', 'www.'), '', $domain), Criteria::LIKE);
			$c->add(self::LANGUAGE, $language);
			self::$domainAndCulture = $stCache->add('domainAndCulture_'.$culture.'_'.$domain, "TrustedShopsPeer::doSelectOne", $c);

			return self::$domainAndCulture;
		} else {
			return self::$domainAndCulture;
		}
	}
}