<?php


abstract class BaseTrustedShops extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $certificate;


	
	protected $username;


	
	protected $password;


	
	protected $type;


	
	protected $url;


	
	protected $language;


	
	protected $status;


	
	protected $logo;


	
	protected $rating_widget;


	
	protected $rating_status;


	
	protected $rating_in_order_mail;

	
	protected $collTrustedShopsHasPaymentTypes;

	
	protected $lastTrustedShopsHasPaymentTypeCriteria = null;

	
	protected $collTrustedShopsProtectionProductss;

	
	protected $lastTrustedShopsProtectionProductsCriteria = null;

	
	protected $collTrustedShopsHasOrders;

	
	protected $lastTrustedShopsHasOrderCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCertificate()
    {

            return $this->certificate;
    }

    
    public function getUsername()
    {

            return $this->username;
    }

    
    public function getPassword()
    {

            return $this->password;
    }

    
    public function getType()
    {

            return $this->type;
    }

    
    public function getUrl()
    {

            return $this->url;
    }

    
    public function getLanguage()
    {

            return $this->language;
    }

    
    public function getStatus()
    {

            return $this->status;
    }

    
    public function getLogo()
    {

            return $this->logo;
    }

    
    public function getRatingWidget()
    {

            return $this->rating_widget;
    }

    
    public function getRatingStatus()
    {

            return $this->rating_status;
    }

    
    public function getRatingInOrderMail()
    {

            return $this->rating_in_order_mail;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = TrustedShopsPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = TrustedShopsPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::ID;
        }

	} 
	
	public function setCertificate($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->certificate !== $v) {
          $this->certificate = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::CERTIFICATE;
        }

	} 
	
	public function setUsername($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->username !== $v) {
          $this->username = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::USERNAME;
        }

	} 
	
	public function setPassword($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->password !== $v) {
          $this->password = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::PASSWORD;
        }

	} 
	
	public function setType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->type !== $v) {
          $this->type = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::TYPE;
        }

	} 
	
	public function setUrl($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->url !== $v) {
          $this->url = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::URL;
        }

	} 
	
	public function setLanguage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->language !== $v) {
          $this->language = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::LANGUAGE;
        }

	} 
	
	public function setStatus($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->status !== $v) {
          $this->status = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::STATUS;
        }

	} 
	
	public function setLogo($v)
	{

        if ($this->logo !== $v) {
          $this->logo = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::LOGO;
        }

	} 
	
	public function setRatingWidget($v)
	{

        if ($this->rating_widget !== $v) {
          $this->rating_widget = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::RATING_WIDGET;
        }

	} 
	
	public function setRatingStatus($v)
	{

        if ($this->rating_status !== $v) {
          $this->rating_status = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::RATING_STATUS;
        }

	} 
	
	public function setRatingInOrderMail($v)
	{

        if ($this->rating_in_order_mail !== $v) {
          $this->rating_in_order_mail = $v;
          $this->modifiedColumns[] = TrustedShopsPeer::RATING_IN_ORDER_MAIL;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShops.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->certificate = $rs->getString($startcol + 3);

      $this->username = $rs->getString($startcol + 4);

      $this->password = $rs->getString($startcol + 5);

      $this->type = $rs->getString($startcol + 6);

      $this->url = $rs->getString($startcol + 7);

      $this->language = $rs->getString($startcol + 8);

      $this->status = $rs->getString($startcol + 9);

      $this->logo = $rs->getBoolean($startcol + 10);

      $this->rating_widget = $rs->getBoolean($startcol + 11);

      $this->rating_status = $rs->getBoolean($startcol + 12);

      $this->rating_in_order_mail = $rs->getBoolean($startcol + 13);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShops.postHydrate', array('resultset' => $rs, 'startcol' => 14)));

            return $startcol + 14; 
    } catch (Exception $e) {
      throw new PropelException("Error populating TrustedShops object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseTrustedShops:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TrustedShopsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			TrustedShopsPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseTrustedShops:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShops.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseTrustedShops:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(TrustedShopsPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(TrustedShopsPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TrustedShopsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShops.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseTrustedShops:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = TrustedShopsPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += TrustedShopsPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collTrustedShopsHasPaymentTypes !== null) {
				foreach($this->collTrustedShopsHasPaymentTypes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collTrustedShopsProtectionProductss !== null) {
				foreach($this->collTrustedShopsProtectionProductss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collTrustedShopsHasOrders !== null) {
				foreach($this->collTrustedShopsHasOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = TrustedShopsPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collTrustedShopsHasPaymentTypes !== null) {
					foreach($this->collTrustedShopsHasPaymentTypes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collTrustedShopsProtectionProductss !== null) {
					foreach($this->collTrustedShopsProtectionProductss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collTrustedShopsHasOrders !== null) {
					foreach($this->collTrustedShopsHasOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TrustedShopsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCertificate();
				break;
			case 4:
				return $this->getUsername();
				break;
			case 5:
				return $this->getPassword();
				break;
			case 6:
				return $this->getType();
				break;
			case 7:
				return $this->getUrl();
				break;
			case 8:
				return $this->getLanguage();
				break;
			case 9:
				return $this->getStatus();
				break;
			case 10:
				return $this->getLogo();
				break;
			case 11:
				return $this->getRatingWidget();
				break;
			case 12:
				return $this->getRatingStatus();
				break;
			case 13:
				return $this->getRatingInOrderMail();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TrustedShopsPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCertificate(),
			$keys[4] => $this->getUsername(),
			$keys[5] => $this->getPassword(),
			$keys[6] => $this->getType(),
			$keys[7] => $this->getUrl(),
			$keys[8] => $this->getLanguage(),
			$keys[9] => $this->getStatus(),
			$keys[10] => $this->getLogo(),
			$keys[11] => $this->getRatingWidget(),
			$keys[12] => $this->getRatingStatus(),
			$keys[13] => $this->getRatingInOrderMail(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TrustedShopsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCertificate($value);
				break;
			case 4:
				$this->setUsername($value);
				break;
			case 5:
				$this->setPassword($value);
				break;
			case 6:
				$this->setType($value);
				break;
			case 7:
				$this->setUrl($value);
				break;
			case 8:
				$this->setLanguage($value);
				break;
			case 9:
				$this->setStatus($value);
				break;
			case 10:
				$this->setLogo($value);
				break;
			case 11:
				$this->setRatingWidget($value);
				break;
			case 12:
				$this->setRatingStatus($value);
				break;
			case 13:
				$this->setRatingInOrderMail($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TrustedShopsPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCertificate($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setUsername($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setPassword($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setType($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setUrl($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setLanguage($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setStatus($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setLogo($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setRatingWidget($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setRatingStatus($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setRatingInOrderMail($arr[$keys[13]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(TrustedShopsPeer::DATABASE_NAME);

		if ($this->isColumnModified(TrustedShopsPeer::CREATED_AT)) $criteria->add(TrustedShopsPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(TrustedShopsPeer::UPDATED_AT)) $criteria->add(TrustedShopsPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(TrustedShopsPeer::ID)) $criteria->add(TrustedShopsPeer::ID, $this->id);
		if ($this->isColumnModified(TrustedShopsPeer::CERTIFICATE)) $criteria->add(TrustedShopsPeer::CERTIFICATE, $this->certificate);
		if ($this->isColumnModified(TrustedShopsPeer::USERNAME)) $criteria->add(TrustedShopsPeer::USERNAME, $this->username);
		if ($this->isColumnModified(TrustedShopsPeer::PASSWORD)) $criteria->add(TrustedShopsPeer::PASSWORD, $this->password);
		if ($this->isColumnModified(TrustedShopsPeer::TYPE)) $criteria->add(TrustedShopsPeer::TYPE, $this->type);
		if ($this->isColumnModified(TrustedShopsPeer::URL)) $criteria->add(TrustedShopsPeer::URL, $this->url);
		if ($this->isColumnModified(TrustedShopsPeer::LANGUAGE)) $criteria->add(TrustedShopsPeer::LANGUAGE, $this->language);
		if ($this->isColumnModified(TrustedShopsPeer::STATUS)) $criteria->add(TrustedShopsPeer::STATUS, $this->status);
		if ($this->isColumnModified(TrustedShopsPeer::LOGO)) $criteria->add(TrustedShopsPeer::LOGO, $this->logo);
		if ($this->isColumnModified(TrustedShopsPeer::RATING_WIDGET)) $criteria->add(TrustedShopsPeer::RATING_WIDGET, $this->rating_widget);
		if ($this->isColumnModified(TrustedShopsPeer::RATING_STATUS)) $criteria->add(TrustedShopsPeer::RATING_STATUS, $this->rating_status);
		if ($this->isColumnModified(TrustedShopsPeer::RATING_IN_ORDER_MAIL)) $criteria->add(TrustedShopsPeer::RATING_IN_ORDER_MAIL, $this->rating_in_order_mail);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(TrustedShopsPeer::DATABASE_NAME);

		$criteria->add(TrustedShopsPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCertificate($this->certificate);

		$copyObj->setUsername($this->username);

		$copyObj->setPassword($this->password);

		$copyObj->setType($this->type);

		$copyObj->setUrl($this->url);

		$copyObj->setLanguage($this->language);

		$copyObj->setStatus($this->status);

		$copyObj->setLogo($this->logo);

		$copyObj->setRatingWidget($this->rating_widget);

		$copyObj->setRatingStatus($this->rating_status);

		$copyObj->setRatingInOrderMail($this->rating_in_order_mail);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getTrustedShopsHasPaymentTypes() as $relObj) {
				$copyObj->addTrustedShopsHasPaymentType($relObj->copy($deepCopy));
			}

			foreach($this->getTrustedShopsProtectionProductss() as $relObj) {
				$copyObj->addTrustedShopsProtectionProducts($relObj->copy($deepCopy));
			}

			foreach($this->getTrustedShopsHasOrders() as $relObj) {
				$copyObj->addTrustedShopsHasOrder($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new TrustedShopsPeer();
		}
		return self::$peer;
	}

	
	public function initTrustedShopsHasPaymentTypes()
	{
		if ($this->collTrustedShopsHasPaymentTypes === null) {
			$this->collTrustedShopsHasPaymentTypes = array();
		}
	}

	
	public function getTrustedShopsHasPaymentTypes($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasPaymentTypes === null) {
			if ($this->isNew()) {
			   $this->collTrustedShopsHasPaymentTypes = array();
			} else {

				$criteria->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $this->getId());

				TrustedShopsHasPaymentTypePeer::addSelectColumns($criteria);
				$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $this->getId());

				TrustedShopsHasPaymentTypePeer::addSelectColumns($criteria);
				if (!isset($this->lastTrustedShopsHasPaymentTypeCriteria) || !$this->lastTrustedShopsHasPaymentTypeCriteria->equals($criteria)) {
					$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTrustedShopsHasPaymentTypeCriteria = $criteria;
		return $this->collTrustedShopsHasPaymentTypes;
	}

	
	public function countTrustedShopsHasPaymentTypes($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $this->getId());

		return TrustedShopsHasPaymentTypePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addTrustedShopsHasPaymentType(TrustedShopsHasPaymentType $l)
	{
		$this->collTrustedShopsHasPaymentTypes[] = $l;
		$l->setTrustedShops($this);
	}


	
	public function getTrustedShopsHasPaymentTypesJoinPaymentType($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasPaymentTypes === null) {
			if ($this->isNew()) {
				$this->collTrustedShopsHasPaymentTypes = array();
			} else {

				$criteria->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $this->getId());

				$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelectJoinPaymentType($criteria, $con);
			}
		} else {
									
			$criteria->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $this->getId());

			if (!isset($this->lastTrustedShopsHasPaymentTypeCriteria) || !$this->lastTrustedShopsHasPaymentTypeCriteria->equals($criteria)) {
				$this->collTrustedShopsHasPaymentTypes = TrustedShopsHasPaymentTypePeer::doSelectJoinPaymentType($criteria, $con);
			}
		}
		$this->lastTrustedShopsHasPaymentTypeCriteria = $criteria;

		return $this->collTrustedShopsHasPaymentTypes;
	}

	
	public function initTrustedShopsProtectionProductss()
	{
		if ($this->collTrustedShopsProtectionProductss === null) {
			$this->collTrustedShopsProtectionProductss = array();
		}
	}

	
	public function getTrustedShopsProtectionProductss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsProtectionProductss === null) {
			if ($this->isNew()) {
			   $this->collTrustedShopsProtectionProductss = array();
			} else {

				$criteria->add(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID, $this->getId());

				TrustedShopsProtectionProductsPeer::addSelectColumns($criteria);
				$this->collTrustedShopsProtectionProductss = TrustedShopsProtectionProductsPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID, $this->getId());

				TrustedShopsProtectionProductsPeer::addSelectColumns($criteria);
				if (!isset($this->lastTrustedShopsProtectionProductsCriteria) || !$this->lastTrustedShopsProtectionProductsCriteria->equals($criteria)) {
					$this->collTrustedShopsProtectionProductss = TrustedShopsProtectionProductsPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTrustedShopsProtectionProductsCriteria = $criteria;
		return $this->collTrustedShopsProtectionProductss;
	}

	
	public function countTrustedShopsProtectionProductss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID, $this->getId());

		return TrustedShopsProtectionProductsPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addTrustedShopsProtectionProducts(TrustedShopsProtectionProducts $l)
	{
		$this->collTrustedShopsProtectionProductss[] = $l;
		$l->setTrustedShops($this);
	}

	
	public function initTrustedShopsHasOrders()
	{
		if ($this->collTrustedShopsHasOrders === null) {
			$this->collTrustedShopsHasOrders = array();
		}
	}

	
	public function getTrustedShopsHasOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasOrders === null) {
			if ($this->isNew()) {
			   $this->collTrustedShopsHasOrders = array();
			} else {

				$criteria->add(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID, $this->getId());

				TrustedShopsHasOrderPeer::addSelectColumns($criteria);
				$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID, $this->getId());

				TrustedShopsHasOrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastTrustedShopsHasOrderCriteria) || !$this->lastTrustedShopsHasOrderCriteria->equals($criteria)) {
					$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastTrustedShopsHasOrderCriteria = $criteria;
		return $this->collTrustedShopsHasOrders;
	}

	
	public function countTrustedShopsHasOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID, $this->getId());

		return TrustedShopsHasOrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addTrustedShopsHasOrder(TrustedShopsHasOrder $l)
	{
		$this->collTrustedShopsHasOrders[] = $l;
		$l->setTrustedShops($this);
	}


	
	public function getTrustedShopsHasOrdersJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collTrustedShopsHasOrders === null) {
			if ($this->isNew()) {
				$this->collTrustedShopsHasOrders = array();
			} else {

				$criteria->add(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID, $this->getId());

				$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID, $this->getId());

			if (!isset($this->lastTrustedShopsHasOrderCriteria) || !$this->lastTrustedShopsHasOrderCriteria->equals($criteria)) {
				$this->collTrustedShopsHasOrders = TrustedShopsHasOrderPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastTrustedShopsHasOrderCriteria = $criteria;

		return $this->collTrustedShopsHasOrders;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'TrustedShops.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseTrustedShops:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseTrustedShops::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 