<?php


abstract class BaseTrustedShopsHasOrder extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $trusted_shops_id;


	
	protected $order_id;


	
	protected $status;


	
	protected $checked;

	
	protected $aTrustedShops;

	
	protected $aOrder;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getTrustedShopsId()
    {

            return $this->trusted_shops_id;
    }

    
    public function getOrderId()
    {

            return $this->order_id;
    }

    
    public function getStatus()
    {

            return $this->status;
    }

    
    public function getChecked()
    {

            return $this->checked;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = TrustedShopsHasOrderPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = TrustedShopsHasOrderPeer::UPDATED_AT;
		}

	} 
	
	public function setTrustedShopsId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->trusted_shops_id !== $v) {
          $this->trusted_shops_id = $v;
          $this->modifiedColumns[] = TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID;
        }

		if ($this->aTrustedShops !== null && $this->aTrustedShops->getId() !== $v) {
			$this->aTrustedShops = null;
		}

	} 
	
	public function setOrderId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->order_id !== $v) {
          $this->order_id = $v;
          $this->modifiedColumns[] = TrustedShopsHasOrderPeer::ORDER_ID;
        }

		if ($this->aOrder !== null && $this->aOrder->getId() !== $v) {
			$this->aOrder = null;
		}

	} 
	
	public function setStatus($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->status !== $v) {
          $this->status = $v;
          $this->modifiedColumns[] = TrustedShopsHasOrderPeer::STATUS;
        }

	} 
	
	public function setChecked($v)
	{

        if ($this->checked !== $v) {
          $this->checked = $v;
          $this->modifiedColumns[] = TrustedShopsHasOrderPeer::CHECKED;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsHasOrder.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->trusted_shops_id = $rs->getInt($startcol + 2);

      $this->order_id = $rs->getInt($startcol + 3);

      $this->status = $rs->getString($startcol + 4);

      $this->checked = $rs->getBoolean($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsHasOrder.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating TrustedShopsHasOrder object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseTrustedShopsHasOrder:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TrustedShopsHasOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			TrustedShopsHasOrderPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseTrustedShopsHasOrder:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsHasOrder.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseTrustedShopsHasOrder:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(TrustedShopsHasOrderPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(TrustedShopsHasOrderPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TrustedShopsHasOrderPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsHasOrder.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseTrustedShopsHasOrder:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aTrustedShops !== null) {
				if ($this->aTrustedShops->isModified()) {
					$affectedRows += $this->aTrustedShops->save($con);
				}
				$this->setTrustedShops($this->aTrustedShops);
			}

			if ($this->aOrder !== null) {
				if ($this->aOrder->isModified()) {
					$affectedRows += $this->aOrder->save($con);
				}
				$this->setOrder($this->aOrder);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = TrustedShopsHasOrderPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setNew(false);
				} else {
					$affectedRows += TrustedShopsHasOrderPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aTrustedShops !== null) {
				if (!$this->aTrustedShops->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTrustedShops->getValidationFailures());
				}
			}

			if ($this->aOrder !== null) {
				if (!$this->aOrder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aOrder->getValidationFailures());
				}
			}


			if (($retval = TrustedShopsHasOrderPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TrustedShopsHasOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getTrustedShopsId();
				break;
			case 3:
				return $this->getOrderId();
				break;
			case 4:
				return $this->getStatus();
				break;
			case 5:
				return $this->getChecked();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TrustedShopsHasOrderPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getTrustedShopsId(),
			$keys[3] => $this->getOrderId(),
			$keys[4] => $this->getStatus(),
			$keys[5] => $this->getChecked(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TrustedShopsHasOrderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setTrustedShopsId($value);
				break;
			case 3:
				$this->setOrderId($value);
				break;
			case 4:
				$this->setStatus($value);
				break;
			case 5:
				$this->setChecked($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TrustedShopsHasOrderPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setTrustedShopsId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOrderId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setStatus($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setChecked($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(TrustedShopsHasOrderPeer::DATABASE_NAME);

		if ($this->isColumnModified(TrustedShopsHasOrderPeer::CREATED_AT)) $criteria->add(TrustedShopsHasOrderPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(TrustedShopsHasOrderPeer::UPDATED_AT)) $criteria->add(TrustedShopsHasOrderPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID)) $criteria->add(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID, $this->trusted_shops_id);
		if ($this->isColumnModified(TrustedShopsHasOrderPeer::ORDER_ID)) $criteria->add(TrustedShopsHasOrderPeer::ORDER_ID, $this->order_id);
		if ($this->isColumnModified(TrustedShopsHasOrderPeer::STATUS)) $criteria->add(TrustedShopsHasOrderPeer::STATUS, $this->status);
		if ($this->isColumnModified(TrustedShopsHasOrderPeer::CHECKED)) $criteria->add(TrustedShopsHasOrderPeer::CHECKED, $this->checked);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(TrustedShopsHasOrderPeer::DATABASE_NAME);

		$criteria->add(TrustedShopsHasOrderPeer::TRUSTED_SHOPS_ID, $this->trusted_shops_id);
		$criteria->add(TrustedShopsHasOrderPeer::ORDER_ID, $this->order_id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getTrustedShopsId();

		$pks[1] = $this->getOrderId();

		return $pks;
	}

	
	public function setPrimaryKey($keys)
	{

		$this->setTrustedShopsId($keys[0]);

		$this->setOrderId($keys[1]);

	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setStatus($this->status);

		$copyObj->setChecked($this->checked);


		$copyObj->setNew(true);

		$copyObj->setTrustedShopsId(NULL); 
		$copyObj->setOrderId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new TrustedShopsHasOrderPeer();
		}
		return self::$peer;
	}

	
	public function setTrustedShops($v)
	{


		if ($v === null) {
			$this->setTrustedShopsId(NULL);
		} else {
			$this->setTrustedShopsId($v->getId());
		}


		$this->aTrustedShops = $v;
	}


	
	public function getTrustedShops($con = null)
	{
		if ($this->aTrustedShops === null && ($this->trusted_shops_id !== null)) {
						$this->aTrustedShops = TrustedShopsPeer::retrieveByPK($this->trusted_shops_id, $con);

			
		}
		return $this->aTrustedShops;
	}

	
	public function setOrder($v)
	{


		if ($v === null) {
			$this->setOrderId(NULL);
		} else {
			$this->setOrderId($v->getId());
		}


		$this->aOrder = $v;
	}


	
	public function getOrder($con = null)
	{
		if ($this->aOrder === null && ($this->order_id !== null)) {
						$this->aOrder = OrderPeer::retrieveByPK($this->order_id, $con);

			
		}
		return $this->aOrder;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'TrustedShopsHasOrder.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseTrustedShopsHasOrder:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseTrustedShopsHasOrder::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 