<?php


abstract class BaseTrustedShopsProtectionProducts extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $trusted_shops_id;


	
	protected $currency;


	
	protected $gross;


	
	protected $netto;


	
	protected $amount;


	
	protected $duration;


	
	protected $product_id;

	
	protected $aTrustedShops;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getTrustedShopsId()
    {

            return $this->trusted_shops_id;
    }

    
    public function getCurrency()
    {

            return $this->currency;
    }

    
    public function getGross()
    {

            return null !== $this->gross ? (string)$this->gross : null;
    }

    
    public function getNetto()
    {

            return null !== $this->netto ? (string)$this->netto : null;
    }

    
    public function getAmount()
    {

            return null !== $this->amount ? (string)$this->amount : null;
    }

    
    public function getDuration()
    {

            return $this->duration;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::ID;
        }

	} 
	
	public function setTrustedShopsId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->trusted_shops_id !== $v) {
          $this->trusted_shops_id = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID;
        }

		if ($this->aTrustedShops !== null && $this->aTrustedShops->getId() !== $v) {
			$this->aTrustedShops = null;
		}

	} 
	
	public function setCurrency($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->currency !== $v) {
          $this->currency = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::CURRENCY;
        }

	} 
	
	public function setGross($v)
	{

        if ($this->gross !== $v) {
          $this->gross = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::GROSS;
        }

	} 
	
	public function setNetto($v)
	{

        if ($this->netto !== $v) {
          $this->netto = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::NETTO;
        }

	} 
	
	public function setAmount($v)
	{

        if ($this->amount !== $v) {
          $this->amount = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::AMOUNT;
        }

	} 
	
	public function setDuration($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->duration !== $v) {
          $this->duration = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::DURATION;
        }

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = TrustedShopsProtectionProductsPeer::PRODUCT_ID;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsProtectionProducts.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->trusted_shops_id = $rs->getInt($startcol + 3);

      $this->currency = $rs->getString($startcol + 4);

      $this->gross = $rs->getString($startcol + 5, null);

      $this->gross = $rs->getFloat($startcol + 5);

      $this->netto = $rs->getString($startcol + 6, null);

      $this->netto = $rs->getFloat($startcol + 6);

      $this->amount = $rs->getString($startcol + 7, null);

      $this->amount = $rs->getFloat($startcol + 7);

      $this->duration = $rs->getInt($startcol + 8);

      $this->product_id = $rs->getString($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsProtectionProducts.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating TrustedShopsProtectionProducts object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseTrustedShopsProtectionProducts:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TrustedShopsProtectionProductsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			TrustedShopsProtectionProductsPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseTrustedShopsProtectionProducts:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsProtectionProducts.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseTrustedShopsProtectionProducts:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(TrustedShopsProtectionProductsPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(TrustedShopsProtectionProductsPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(TrustedShopsProtectionProductsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'TrustedShopsProtectionProducts.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseTrustedShopsProtectionProducts:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aTrustedShops !== null) {
				if ($this->aTrustedShops->isModified()) {
					$affectedRows += $this->aTrustedShops->save($con);
				}
				$this->setTrustedShops($this->aTrustedShops);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = TrustedShopsProtectionProductsPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += TrustedShopsProtectionProductsPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aTrustedShops !== null) {
				if (!$this->aTrustedShops->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTrustedShops->getValidationFailures());
				}
			}


			if (($retval = TrustedShopsProtectionProductsPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TrustedShopsProtectionProductsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getTrustedShopsId();
				break;
			case 4:
				return $this->getCurrency();
				break;
			case 5:
				return $this->getGross();
				break;
			case 6:
				return $this->getNetto();
				break;
			case 7:
				return $this->getAmount();
				break;
			case 8:
				return $this->getDuration();
				break;
			case 9:
				return $this->getProductId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TrustedShopsProtectionProductsPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getTrustedShopsId(),
			$keys[4] => $this->getCurrency(),
			$keys[5] => $this->getGross(),
			$keys[6] => $this->getNetto(),
			$keys[7] => $this->getAmount(),
			$keys[8] => $this->getDuration(),
			$keys[9] => $this->getProductId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = TrustedShopsProtectionProductsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setTrustedShopsId($value);
				break;
			case 4:
				$this->setCurrency($value);
				break;
			case 5:
				$this->setGross($value);
				break;
			case 6:
				$this->setNetto($value);
				break;
			case 7:
				$this->setAmount($value);
				break;
			case 8:
				$this->setDuration($value);
				break;
			case 9:
				$this->setProductId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = TrustedShopsProtectionProductsPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setTrustedShopsId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setCurrency($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setGross($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setNetto($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setAmount($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setDuration($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setProductId($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(TrustedShopsProtectionProductsPeer::DATABASE_NAME);

		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::CREATED_AT)) $criteria->add(TrustedShopsProtectionProductsPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::UPDATED_AT)) $criteria->add(TrustedShopsProtectionProductsPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::ID)) $criteria->add(TrustedShopsProtectionProductsPeer::ID, $this->id);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID)) $criteria->add(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID, $this->trusted_shops_id);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::CURRENCY)) $criteria->add(TrustedShopsProtectionProductsPeer::CURRENCY, $this->currency);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::GROSS)) $criteria->add(TrustedShopsProtectionProductsPeer::GROSS, $this->gross);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::NETTO)) $criteria->add(TrustedShopsProtectionProductsPeer::NETTO, $this->netto);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::AMOUNT)) $criteria->add(TrustedShopsProtectionProductsPeer::AMOUNT, $this->amount);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::DURATION)) $criteria->add(TrustedShopsProtectionProductsPeer::DURATION, $this->duration);
		if ($this->isColumnModified(TrustedShopsProtectionProductsPeer::PRODUCT_ID)) $criteria->add(TrustedShopsProtectionProductsPeer::PRODUCT_ID, $this->product_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(TrustedShopsProtectionProductsPeer::DATABASE_NAME);

		$criteria->add(TrustedShopsProtectionProductsPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setTrustedShopsId($this->trusted_shops_id);

		$copyObj->setCurrency($this->currency);

		$copyObj->setGross($this->gross);

		$copyObj->setNetto($this->netto);

		$copyObj->setAmount($this->amount);

		$copyObj->setDuration($this->duration);

		$copyObj->setProductId($this->product_id);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new TrustedShopsProtectionProductsPeer();
		}
		return self::$peer;
	}

	
	public function setTrustedShops($v)
	{


		if ($v === null) {
			$this->setTrustedShopsId(NULL);
		} else {
			$this->setTrustedShopsId($v->getId());
		}


		$this->aTrustedShops = $v;
	}


	
	public function getTrustedShops($con = null)
	{
		if ($this->aTrustedShops === null && ($this->trusted_shops_id !== null)) {
						$this->aTrustedShops = TrustedShopsPeer::retrieveByPK($this->trusted_shops_id, $con);

			
		}
		return $this->aTrustedShops;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'TrustedShopsProtectionProducts.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseTrustedShopsProtectionProducts:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseTrustedShopsProtectionProducts::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 