<?php
class stTrustedShopsListener
{
	public static function saveTrustedShops(sfEvent $event)
	{
		$subject = $event->getSubject();

		if ($subject->getType() == 'Excellence')
		{
			$c = new Criteria();
			$c->add(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID, $subject->getId());
			TrustedShopsProtectionProductsPeer::doDelete($c);

			$connector = new stTrustedShopsConnector();
			$results = $connector->getProtectionItems($subject->getCertificate());

			foreach($results->item as $result)
			{
				$tspp = new TrustedShopsProtectionProducts();
				$tspp->setTrustedShopsId($subject->getId());
				$tspp->setCurrency($result->currency);
				$tspp->setGross($result->grossFee);
				$tspp->setNetto($result->netFee);
				$tspp->setAmount($result->protectedAmountDecimal);
				$tspp->setDuration($result->protectionDurationInt);
				$tspp->setProductId($result->tsProductID);
				$tspp->save();
			}
		}
	}

	public static function preBasketSummary(sfEvent $event)
	{
		if ($event->getSubject()->getUser()->getAttribute('ts_buyer_protection', false, 'soteshop/stTrustedShopsPlugin'))
		{
			$event->getSubject()->basket->get();
			$event->getSubject()->basket->getItems();

			$tsProduct = new BasketProduct();

			$tsppId = $event->getSubject()->getUser()->getAttribute('ts_buyer_protection_id', false, 'soteshop/stTrustedShopsPlugin');

			$tspp = TrustedShopsProtectionProductsPeer::retrieveByPK($tsppId);

			if (is_object($tspp))
			{
				$tsProduct->setName(sfContext::getInstance()->getI18n()->__('Ubezpieczenie Trusted Shops', null, 'stTrustedShopsFrontend'));
				$tsProduct->setBasePriceBrutto($tspp->getGross());
				$tsProduct->setVat(round((($tspp->getGross()/$tspp->getNetto())-1)*100));
				$tsProduct->setQuantity(1);
				$event->getSubject()->basket->get()->addBasketProduct($tsProduct);
			}
		}
	}

	public static function postAjaxPaymentUpdate(sfEvent $event)
	{
		$event->getSubject()->responseUpdateElement('st-trusted_shops', array('module' => 'stTrustedShopsFrontend', 'component'=> 'showExcellenceBuyerProtection'));
	}

	public static function postOrderSave(sfEvent $event)
	{
		if ($event->getSubject()->getUser()->getAttribute('ts_buyer_protection', false, 'soteshop/stTrustedShopsPlugin'))
		{
			$stWebRequest = new stWebRequest();
			$certificate = TrustedShopsPeer::retrieveByCultureAndDomain($event->getSubject()->getUser()->getCulture(), $stWebRequest->getHost());
			if (is_object($certificate) && $certificate->getType() == 'Excellence')
			{
				$order = $event->getSubject()->order;

				$amount = $order->getTotalAmountWithDelivery(true);

				$c = new Criteria();
				$c->add(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID, $certificate->getId());
				$c->add(TrustedShopsProtectionProductsPeer::CURRENCY, $order->getOrderCurrency()->getShortcut());
				$c->add(TrustedShopsProtectionProductsPeer::AMOUNT, $amount, Criteria::GREATER_EQUAL);
				$c->addAscendingOrderByColumn(TrustedShopsProtectionProductsPeer::AMOUNT);
				$tspp = TrustedShopsProtectionProductsPeer::doSelectOne($c);

				if (is_object($tspp))
				{
					$product = new OrderProduct();

					$product->setQuantity(1);
					$product->setCode($tspp->getProductId());
					$product->setName(sfContext::getInstance()->getI18n()->__('Ubezpieczenie Trusted Shops'));
					$product->setBasePriceNetto($tspp->getNetto());
					$product->setBasePriceBrutto($tspp->getGross());

					$c = new Criteria();
					$c->add(TaxPeer::VAT, round((($tspp->getGross()/$tspp->getNetto())-1)*100));
					$tax = TaxPeer::doSelectOne($c);
					if (is_object($tax)) $product->setTaxId($tax->getId());

					$order->addOrderProduct($product);
					$order->save();

					$basket = stBasket::getInstance($event->getSubject()->getUser());
					$delivery = stDeliveryFrontend::getInstance($basket);

					$c = new Criteria();
					$c->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $certificate->getId());
					$c->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $delivery->getDefaultDelivery()->getDefaultPayment()->getId());
					$payment = TrustedShopsHasPaymentTypePeer::doSelectOne($c);
					if (is_object($payment))
					{
						$paymentType = $payment->getMethod();
					} else {
						$paymentType = 'OTHER';
					}

					$date = $order->getCreatedAt('c');
					$date = explode('+', $date);
					$date = $date[0];

					$connector = new stTrustedShopsConnector();
					$result = $connector->requestForProtectionV2($certificate->getCertificate(),
					$tspp->getProductId(),
					$amount,
					$order->getOrderCurrency()->getShortcut(),
					$paymentType,
					$order->getGuardUser()->getUsername(),
					$order->getGuardUser()->getId(),
					$order->getNumber(),
					$date,
					$connector->getShopVersion(),
					$certificate->getUsername(),
					$certificate->getPassword());
						
					$tsOrder = new TrustedShopsHasOrder();
					$tsOrder->setOrderId($order->getId());
					$tsOrder->setTrustedShopsId($certificate->getId());
					$tsOrder->setStatus($result);
					$tsOrder->setChecked(false);
					$tsOrder->save();
				}
			}
		}
	}
}