<?php

class stTrustedShopsConnector
{
	protected $enviroment = 'production';

	protected $backendUrls = array ('sandbox' => 'https://qa.trustedshops.de/ts/services/TsProtection?wsdl',
	                                           'production' => 'https://www.trustedshops.de/ts/services/TsProtection?wsdl');

	protected $frontendUrls = array('sandbox' => 'https://protection-qa.trustedshops.com/ts/protectionservices/ApplicationRequestService?wsdl',
	                            'production' => 'https://protection.trustedshops.com/ts/protectionservices/ApplicationRequestService?wsdl');

	public function __construct()
	{
		$config = stConfig::getInstance(null, 'stTrustedShopsBackend');
		if ($config->get('test')) $this->enviroment = 'sandbox';
	}

	public function getShopVersion()
	{
		return 'SOTE';
	}

	protected function getSoapClient($url = 'backend')
	{
		return new SoapClient($this->{$url.'Urls'}[$this->enviroment], array('cache_wsdl' => 0, 'trace'=>1));
	}

	public function checkCertificate($certificate)
	{
		$client = $this->getSoapClient();

		try {
			$result = $client->checkCertificate($certificate);
		} catch (Exception $e) { }

		return $result;
	}

	public function checkLogin($certificate, $login, $password)
	{
		$client = $this->getSoapClient();

		try {
			$result = $client->checkLogin($certificate, $login, $password);
		} catch (Exception $e) { }

		return $result;
	}

	public function getCheckLoginError($errorCode)
	{
		$messages = array('-10001' => 'Nazwa użytkownika lub hasło są nieprawidłowe. Skontaktuj się z Trusted Shops pod adresem service@trustedshops.pl',
                          '-10002' => 'Ramy kredytowe w Trusted Shops zostały unieważnione. Skontaktuj się z Trusted Shops pod adresem service@trustedshops.pl',
                          '-10011' => 'Brak ram kredytowych w Trusted Shops. Skontaktuj się z Trusted Shops pod adresem service@trustedshops.pl',
                          '-11111' => 'Dane nie mogły zostać zapisane. Skontaktuj się z Trusted Shops pod adresem service@trustedshops.pl');

		return $messages[$errorCode];
	}

	public function getProtectionItems($certificate)
	{
		$client = $this->getSoapClient();

		try {
			$result = $client->getProtectionItems($certificate);
		} catch (Exception $e) { }

		return $result;
	}

	public function requestForProtectionV2($certificace, $tsProductId, $amount, $currency, $paymentType, $buyerEmail, $shopCustomerId, $shopOrderId, $orderDate, $shopSystemVersion, $wsUser, $wsPassword)
	{
		$client = $this->getSoapClient('frontend');

		try {
			$result = $client->requestForProtectionV2($certificace, $tsProductId, $amount, $currency, $paymentType, $buyerEmail, $shopCustomerId, $shopOrderId, $orderDate, $shopSystemVersion, $wsUser, $wsPassword);
		} catch (Exception $e) { }

		return $result;
	}
}