<?php
class stTrustedShopsBackendActions extends autostTrustedShopsBackendActions
{
	/**
	 * Przekierowanie na stronę informacyjną lub listę certyfikatów
	 */
	public function executeIndex()
	{
		if (!TrustedShopsPeer::doCount(new Criteria())) $this->forward('stTrustedShopsBackend', 'information');
		else $this->forward('stTrustedShopsBackend', 'list');
	}

	/**
	 * Strona informacyjna
	 */
	public function executeInformation(){}

	/**
	 * Przeciążenie aktualizacji danych podczas edycji certyfikatu
	 */
	protected function updateProtectionPaymentsTrustedShopsFromRequest()
	{
		parent::updateProtectionPaymentsTrustedShopsFromRequest();

		$trusted_shops = $this->getRequestParameter('trusted_shops');

		if(isset($trusted_shops['payment_method']))
		{
			foreach($trusted_shops['payment_method'] as $id => $method)
			{
				$c = new Criteria();
				$c->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $this->getRequestParameter('id'));
				$c->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $id);
				$trustedShopsPaymentType = TrustedShopsHasPaymentTypePeer::doSelectOne($c);

				if (!is_object($trustedShopsPaymentType))
				{
					$trustedShopsPaymentType = new TrustedShopsHasPaymentType();
					$trustedShopsPaymentType->setTrustedShopsId($this->getRequestParameter('id'));
					$trustedShopsPaymentType->setPaymentTypeId($id);
				}
				$trustedShopsPaymentType->setMethod($method);
				$trustedShopsPaymentType->save();
			}
		}
	}

	/**
	 * Walidacja edycji
	 */
	public function validateEdit()
	{
		$return = true;
		if ($this->getRequest()->getMethod() == sfRequest::POST)
		{
			if ($this->getRequest()->hasParameter('id') && $this->getRequest()->getParameter('id') != '')
			{
				$certificate = TrustedShopsPeer::retrieveByPK($this->getRequest()->getParameter('id'));
				if (is_object($certificate))
				{
					$trustedShops = $this->getRequest()->getParameter('trusted_shops');

					if (SF_ENVIRONMENT == 'dev')
					{
						$c = new Criteria();
						$c->add(TrustedShopsPeer::URL, $trustedShops['url']);
						$c->add(TrustedShopsPeer::LANGUAGE, $certificate->getLanguage());
						$c->add(TrustedShopsPeer::ID, $certificate->getId(), Criteria::NOT_EQUAL);
						if (TrustedShopsPeer::doCount($c))
						{
							$this->getRequest()->setError('trusted_shops{url}', 'Podany adres jest już przypisany do innego certyfikatu.');
							$return = false;
						}
					}

					if ($certificate->getType() == 'Excellence')
					{
						if (!isset($trustedShops['username']) || empty($trustedShops['username']))
						{
							$this->getRequest()->setError('trusted_shops{username}', 'Proszę uzupełnić pole.');
							$return = false;
						}

						if (!isset($trustedShops['password']) || empty($trustedShops['password']))
						{
							$this->getRequest()->setError('trusted_shops{password}', 'Proszę uzupełnić pole.');
							$return = false;
						}

						if ($return == true)
						{
							$connector = new stTrustedShopsConnector();
							$result = $connector->checkLogin($trustedShops['certificate'], $trustedShops['username'], $trustedShops['password']);

							if ($result != 1)
							{
								$this->getRequest()->setError('trusted_shops{username}', $connector->getCheckLoginError($result));
								$return = false;
							}
						}
					}
				}
			}
		}
		return $return;
	}

	public function executeRatingActive()
	{
		if ($this->getRequest()->hasParameter('id'))
		{
			$id = $this->getRequest()->getParameter('id');
			$certificate = TrustedShopsPeer::retrieveByPK($id);
			if (is_object($certificate))
			{
				$i18n = $this->getContext()->getI18N();

				$rating = new stTrustedShopsRating();
				$updateStatus = $rating->updateRating($certificate->getCertificate(), $this->getRequest()->getParameter('active', '1'));

				if ($updateStatus == 'OK')
				{
					$this->setFlash('notice', $i18n->__('Dziękujemy za aktywację funkcji Opinia Klienta Trusted Shops!'));
					$certificate->setRatingStatus(1);
				} else {
					if ($updateStatus == 'INVALID_TSID') $warning = $i18n->__('Nieprawidłowy identyfikator Trusted Shops.'); 
					elseif($updateStatus == 'NOT_REGISTERED_FOR_TRUSTEDRATING') $warning = $i18n->__('Dla tego identyfikatora Trusted Shops nie nastąpiła jeszcze aktywacja Opinii Klienta.');
					$this->setFlash('warning', $warning.$i18n->__('Zaloguj się').'<a href="'.stTrustedShopsRating::getRegisterUrl().'">'.$i18n->__('tutaj').'</a>'.$i18n->__('lub skontaktuj się z serwisem pod adresem serwis@trustedshops.pl.'));
					$certificate->setRatingStatus(0);
				}
				$certificate->save();
			}
		}
		$this->redirect('stTrustedShopsBackend/ratingEdit?id='.$id);
	}
}