<?php

/**
 * Klasa stTrustedShopsFrontendComponents
 */
class stTrustedShopsFrontendComponents extends sfComponents
{
	/**
	 * Wyświetlanie ochrony kupującego w koszyku
	 */
	public function executeShowExcellenceBuyerProtection()
	{
		$show = false;
		$this->smarty = new stSmarty('stTrustedShopsFrontend');

		$stWebRequest = new stWebRequest();
		$certificate = TrustedShopsPeer::retrieveByCultureAndDomain($this->getUser()->getCulture(), $stWebRequest->getHost());
		if (is_object($certificate) && $certificate->getType() == 'Excellence')
		{
			$this->certificate = $certificate->getCertificate();

			$stBasket = stBasket::getInstance($this->getUser());
			$stDelivery = stDeliveryFrontend::getInstance($stBasket);
			$stCurrency = stCurrency::getInstance($this->getContext());

			$c = new Criteria();
			$c->add(TrustedShopsProtectionProductsPeer::TRUSTED_SHOPS_ID, $certificate->getId());
			$c->add(TrustedShopsProtectionProductsPeer::CURRENCY, $stCurrency->get()->getShortcut());
			$c->add(TrustedShopsProtectionProductsPeer::AMOUNT, $stBasket->getTotalAmount(true) + $stDelivery->getTotalDeliveryCost(true), Criteria::GREATER_EQUAL);
			$c->addAscendingOrderByColumn(TrustedShopsProtectionProductsPeer::AMOUNT);
			$tspp = TrustedShopsProtectionProductsPeer::doSelectOne($c);

			if (is_object($tspp))
			{
				$show = true;
				$this->amount = $tspp->getAmount();
				$this->price = $tspp->getGross();
				$this->currency = $tspp->getCurrency();
				$this->getUser()->setAttribute('ts_buyer_protection_id', $tspp->getId(), 'soteshop/stTrustedShopsPlugin');
			}
		}

		$this->checked = $this->getUser()->getAttribute('ts_buyer_protection', false, 'soteshop/stTrustedShopsPlugin');

		if ($show == false) return sfView::NONE;
	}

	/**
	 * Wyświetlanie ochrony kupującego w ostatnim kroku podsumowaniu zamówienia
	 */
	public function executeShowClassicBuyerProtection()
	{
		$show = false;
		if ($this->getRequest()->hasParameter('id') && $this->getRequest()->hasParameter('hash_code'))
		{
			$this->smarty = new stSmarty('stTrustedShopsFrontend');

			$stWebRequest = new stWebRequest();
			$certificate = TrustedShopsPeer::retrieveByCultureAndDomain($this->getUser()->getCulture(), $stWebRequest->getHost());

			if (is_object($certificate) && $certificate->getType() == 'Classic')
			{
				$show = true;
				$this->certificate = $certificate->getCertificate();

				$id = $this->getRequestParameter('id');
				$hashCode = $this->getRequestParameter('hash_code');

				$order = OrderPeer::retrieveByIdAndHashCode($id, $hashCode);

				$this->email = $order->getGuardUser()->getUsername();
				$this->userId = $order->getGuardUser()->getId();
				$this->orderId = $order->getNumber();
				$this->orderAmount = number_format($order->getTotalAmount(true), 2, '.', '');
				$this->currency = $order->getOrderCurrency()->getShortcut();

				$c = new Criteria();
				$c->add(TrustedShopsHasPaymentTypePeer::TRUSTED_SHOPS_ID, $certificate->getId());
				$c->add(TrustedShopsHasPaymentTypePeer::PAYMENT_TYPE_ID, $order->getOrderPayment()->getId());
				$payment = TrustedShopsHasPaymentTypePeer::doSelectOne($c);
				if (is_object($payment))
				{
					$this->paymentType = $payment->getMethod();
				} else {
					$this->paymentType = 'OTHER';
				}
			}
		}
		if ($show == false) return sfView::NONE;
	}

	public function executeShowSealbox()
	{
		$show = false;
		$this->smarty = new stSmarty('stTrustedShopsFrontend');

		$stWebRequest = new stWebRequest();
		$certificate = TrustedShopsPeer::retrieveByCultureAndDomain($this->getUser()->getCulture(), $stWebRequest->getHost());

		if (is_object($certificate) && $certificate->getLogo())
		{
			$show = true;
			$this->certificate = $certificate->getCertificate();
			$this->shopName = $certificate->getUrl();
			$this->urlShopName = str_replace('.', '-', $this->shopName);
		}

		if ($show == false) return sfView::NONE;
	}

	public function executeShowRatingWidget()
	{
		$show = false;
		$this->smarty = new stSmarty('stTrustedShopsFrontend');

		$stWebRequest = new stWebRequest();
		$certificate = TrustedShopsPeer::retrieveByCultureAndDomain($this->getUser()->getCulture(), $stWebRequest->getHost());

		if (is_object($certificate) && $certificate->getRatingWidget())
		{
			$show = true;
			$this->certificate = $certificate->getCertificate();
			$this->shopName = $certificate->getUrl();
		}

		if ($show == false) return sfView::NONE;
	}

	public function executeShowInOrderMailHtml()
	{
		$show = false;
		$this->smarty = new stSmarty('stTrustedShopsFrontend');

		$stWebRequest = new stWebRequest();
		$certificate = TrustedShopsPeer::retrieveByCultureAndDomain($this->getUser()->getCulture(), $stWebRequest->getHost());

		if (is_object($certificate) && $certificate->getRatingInOrderMail())
		{
			$show = true;
			$this->certificate = $certificate->getCertificate();
			$this->params = '&buyerEmail='.urlencode(base64_encode($this->order->getSfGuardUser()->getUsername())).'&orderID='.urlencode(base64_encode($this->order->getNumber()));
		}

		if ($show == false) return sfView::NONE;
	}

	public function executeShowInOrderMailPlain()
	{
		$show = false;
		$this->smarty = new stSmarty('stTrustedShopsFrontend');

		$stWebRequest = new stWebRequest();
		$certificate = TrustedShopsPeer::retrieveByCultureAndDomain($this->getUser()->getCulture(), $stWebRequest->getHost());

		if (is_object($certificate) && $certificate->getRatingInOrderMail())
		{
			$show = true;
			$this->certificate = $certificate->getCertificate();
		}

		if ($show == false) return sfView::NONE;
	}
}