<?php
/**
 * SOTESHOP/stWebpagePlugin
 *
 * Ten plik należy do aplikacji stWebpagePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stWebpagePlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: Webpage.php 12414 2011-04-21 10:44:30Z michal $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl>
 */

/**
 * Klasa Webpage
 *
 * @package     stWebpagePlugin
 * @subpackage  libs
 */
class Webpage extends BaseWebpage
{

    /**
     * Pobieranie nazwy strony
     *
     * @return  string      nazwa strony
     */
    public function __toString()
    {
        return $this->getName();
    }


    /**
     * Pobieranie obiektu WebpageGroup
     *
     * @return  object      obiekt WebpageGroup
     */
    public function getWebpageGroup()
    {
        $c = new Criteria();
        $c->add(WebpageGroupHasWebpagePeer::WEBPAGE_ID,$this->getId());
        $c->addJoin(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID,WebpageGroupPeer::ID);
        $this->webpageGroup = WebpageGroupPeer::doSelect($c);
        return $this->webpageGroup;
    }

    /**
     * Pobieranie obiektu WebpageGroupHasWebpage
     */
    public function getWebpageGroupHasWebpage()
    {
        $c = new Criteria();
        $this->webpageGroup = WebpageGroupHasWebpagePeer::doSelectJoinAll();
    }

    /**
     * Pobiera zawartość przyciętą do określonej długości.
     * Funkcja nie dzieli słów.
     *
     * @param   integer     $length             Ilość znaków  
     * @return  string      Przycięty tekst 
     */
    public function getContentTrimed($length = 50)
    {
        $content = $this->getContent();
        $content = strip_tags($content);
        $contentLength = strlen($content);

        //sprawdzenie czy istnieje potrzeba przyciecia
        if($contentLength <= $length)
        {
            return strip_tags($this->getContent());
        }

        $content = trim(wordwrap($content, $length, "\n"));
        $table = explode("\n", $content);

        if(count($table) > 0)
        {
            return $table[0]."...";
        }
        return "";
    }
    /**
     * Zapisuje wartości domyślne dla zapisanej strony
     *
     * @param   string      domyślna           wartość stron $page  
     */
    public function setDefaultPages($page)
    {
        if ($page=="NONE") $page=NULL;
        $this->setPage($page);
    }

    /**
     * Przeciążenie hydrate
     *
     * @param ResultSet $rs
     * @param int $startcol
     * @return object
     */
    public function hydrate(ResultSet $rs, $startcol = 1)
    {
        $this->setCulture(stLanguage::getHydrateCulture());
        return parent::hydrate($rs, $startcol);
    }

    /**
     * Przeciążenie getName
     *
     * @return string
     */
    public function getName()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);
        }
        $v = parent::getName();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }

    /**
     * Przeciążenie setName
     *
     * @param string $v
     */
    public function setName($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }

        parent::setName($v);
    }

    /**
     * Przeciążenie getContent
     *
     * @return string
     */
    public function getContent()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);
        }
        $v = parent::getContent();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }

    /**
     * Przeciążenie setContent
     *
     * @param string $v
     */
    public function setContent($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }

        parent::setContent($v);
    }

    /**
     * Przeciążenie getUrl
     *
     * @return string
     */
    public function getUrl()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage()) return stLanguage::getDefaultValue($this, __METHOD__);

        $v = parent::getUrl();
        if (is_null($v)) $v = stLanguage::getDefaultValue($this, __METHOD__);
        return $v;
    }

    /**
     * Przeciążenie setUrl
     *
     * @param string $v
     */
    public function setUrl($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage()) stLanguage::setDefaultValue($this, __METHOD__, $v);
        parent::setUrl($v);
    }

    public function urlFilter($friendly_url)
    {
        $c = new Criteria();

        $c->add(WebpageI18nPeer::ID, $this->getPrimaryKey(), Criteria::NOT_EQUAL);

        $c->add(WebpageI18nPeer::URL, $friendly_url);

        if (WebpageI18nPeer::doCount($c) > 0)
        {
            return $friendly_url . '-' . $this->getPrimaryKey();
        }

        return false;
    }
}

sfPropelBehavior::add('Webpage', array('stPropelSeoUrlBehavior' => array('source_column' => 'Name', 'target_column' => 'Url', 'target_column_filter' => 'urlFilter')));