<?php
/** 
 * SOTESHOP/stWebpagePlugin
 *
 * Ten plik należy do aplikacji stWebpagePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stWebpagePlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: WebpageGroupPeer.php 6721 2010-07-21 11:43:09Z krzysiek $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl>
 */

/** 
 * Klasa WebpageGroupPeer
 *
 * @package     stWebpagePlugin
 * @subpackage  libs
 */
class WebpageGroupPeer extends BaseWebpageGroupPeer
{

        /**
     * Przeciążenie metody pobierającej grupy strony www w odpowiedniej wersji jezykowej
     *
     * @param Criteria $c Kryteria
     * @param mixed $culture Wersja językowa
     * @param CreoleConnection $con Połączenie z bazą danych
     * @return array Produkty
     */
    public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
    {
        if ($culture === null)
        {
            $culture = sfContext::getInstance()->getUser()->getCulture();
        }

        if ($c->getDbName() == Propel::getDefaultDB())
        {
            $c->setDbName(self::DATABASE_NAME);
        }

        WebpageGroupPeer::addSelectColumns($c);

        $startcol = (WebpageGroupPeer::NUM_COLUMNS - WebpageGroupPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

        WebpageGroupI18nPeer::addSelectColumns($c);

        $c->addJoin(WebpageGroupPeer::ID, sprintf("%s AND %s = '%s'", WebpageGroupI18nPeer::ID, WebpageGroupI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

        $rs = BasePeer::doSelect($c, $con);

        $results = array();

        while($rs->next())
        {

            $omClass = WebpageGroupPeer::getOMClass();

            $cls = Propel::import($omClass);
            $obj1 = new $cls();
            $obj1->hydrate($rs);
            $obj1->setCulture($culture);

            $omClass = WebpageGroupI18nPeer::getOMClass($rs, $startcol);

            $cls = Propel::import($omClass);
            $obj2 = new $cls();
            $obj2->hydrate($rs, $startcol);

            $obj1->setWebpageGroupI18nForCulture($obj2, $culture);
            $obj2->setWebpageGroup($obj1);

            $results[] = $obj1;
        }
        return $results;
    }

    public static function doCountWithI18n(Criteria $c, $con = null)
    {
        $c->addJoin(WebpageGroupI18nPeer::ID, WebpageGroupPeer::ID);

        $c->add(WebpageGroupI18nPeer::CULTURE, sfContext::getInstance()->getUser()->getCulture());

        return self::doCount($c, $con);
    }
}
