<?php
/** 
 * SOTESHOP/stWebpagePlugin
 *
 * Ten plik należy do aplikacji stWebpagePlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stWebpagePlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: WebpagePeer.php 11281 2011-02-25 09:41:18Z bartek $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl>
 */

/** 
 * Klasa WebpagePeer
 *
 * @package     stWebpagePlugin
 * @subpackage  libs
 */
class WebpagePeer extends BaseWebpagePeer
{
     protected static $showedWebpage = null;

     public static function setShowedWebpage($webpage)
     {
             WebpagePeer::$showedWebpage = $webpage;
     }

     public static function getShowedWebpage()
     {
             return WebpagePeer::$showedWebpage;
     }
	
    /**
     * Przeciążenie metody pobierającej strony www w odpowiedniej wersji jezykowej
     *
     * @param Criteria $c Kryteria
     * @param mixed $culture Wersja językowa
     * @param CreoleConnection $con Połączenie z bazą danych
     * @return array Produkty
     */
    public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
    {
        if ($culture === null)
        {
            $culture = sfContext::getInstance()->getUser()->getCulture();
        }

        if ($c->getDbName() == Propel::getDefaultDB())
        {
            $c->setDbName(self::DATABASE_NAME);
        }

        WebpagePeer::addSelectColumns($c);

        $startcol = (WebpagePeer::NUM_COLUMNS - WebpagePeer::NUM_LAZY_LOAD_COLUMNS) + 1;

        WebpageI18nPeer::addSelectColumns($c);

        $c->addJoin(WebpagePeer::ID, sprintf("%s AND %s = '%s'", WebpageI18nPeer::ID, WebpageI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

        $rs = BasePeer::doSelect($c, $con);

        $results = array();

        while($rs->next())
        {

            $omClass = WebpagePeer::getOMClass();

            $cls = Propel::import($omClass);
            $obj1 = new $cls();
            $obj1->hydrate($rs);
            $obj1->setCulture($culture);

            $omClass = WebpageI18nPeer::getOMClass($rs, $startcol);

            $cls = Propel::import($omClass);
            $obj2 = new $cls();
            $obj2->hydrate($rs, $startcol);

            $obj1->setWebpageI18nForCulture($obj2, $culture);
            $obj2->setWebpage($obj1);

            $results[] = $obj1;
        }
        return $results;
    }


    public static function doCountWithI18n(Criteria $c, $con = null)
    {
        $c->addJoin(WebpageI18nPeer::ID, WebpagePeer::ID);

        $c->add(WebpageI18nPeer::CULTURE, sfContext::getInstance()->getUser()->getCulture());

        return self::doCount($c, $con);
    }



}
