<?php


abstract class BaseWebpage extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $active = true;


	
	protected $opt_name;


	
	protected $opt_content;


	
	protected $opt_url;

	
	protected $collWebpageHasPositionings;

	
	protected $lastWebpageHasPositioningCriteria = null;

	
	protected $collWebpageGroupHasWebpages;

	
	protected $lastWebpageGroupHasWebpageCriteria = null;

	
	protected $collWebpageI18ns;

	
	protected $lastWebpageI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptContent()
    {

            return $this->opt_content;
    }

    
    public function getOptUrl()
    {

            return $this->opt_url;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = WebpagePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = WebpagePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = WebpagePeer::ID;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === true) {
          $this->active = $v;
          $this->modifiedColumns[] = WebpagePeer::ACTIVE;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = WebpagePeer::OPT_NAME;
        }

	} 
	
	public function setOptContent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_content !== $v) {
          $this->opt_content = $v;
          $this->modifiedColumns[] = WebpagePeer::OPT_CONTENT;
        }

	} 
	
	public function setOptUrl($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_url !== $v) {
          $this->opt_url = $v;
          $this->modifiedColumns[] = WebpagePeer::OPT_URL;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Webpage.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->active = $rs->getBoolean($startcol + 3);

      $this->opt_name = $rs->getString($startcol + 4);

      $this->opt_content = $rs->getString($startcol + 5);

      $this->opt_url = $rs->getString($startcol + 6);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Webpage.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Webpage object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseWebpage:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			WebpagePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseWebpage:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Webpage.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseWebpage:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(WebpagePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(WebpagePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Webpage.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseWebpage:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = WebpagePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += WebpagePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collWebpageHasPositionings !== null) {
				foreach($this->collWebpageHasPositionings as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collWebpageGroupHasWebpages !== null) {
				foreach($this->collWebpageGroupHasWebpages as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collWebpageI18ns !== null) {
				foreach($this->collWebpageI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = WebpagePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collWebpageHasPositionings !== null) {
					foreach($this->collWebpageHasPositionings as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collWebpageGroupHasWebpages !== null) {
					foreach($this->collWebpageGroupHasWebpages as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collWebpageI18ns !== null) {
					foreach($this->collWebpageI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getActive();
				break;
			case 4:
				return $this->getOptName();
				break;
			case 5:
				return $this->getOptContent();
				break;
			case 6:
				return $this->getOptUrl();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpagePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getActive(),
			$keys[4] => $this->getOptName(),
			$keys[5] => $this->getOptContent(),
			$keys[6] => $this->getOptUrl(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setActive($value);
				break;
			case 4:
				$this->setOptName($value);
				break;
			case 5:
				$this->setOptContent($value);
				break;
			case 6:
				$this->setOptUrl($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpagePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setActive($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setOptName($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOptContent($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptUrl($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(WebpagePeer::DATABASE_NAME);

		if ($this->isColumnModified(WebpagePeer::CREATED_AT)) $criteria->add(WebpagePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(WebpagePeer::UPDATED_AT)) $criteria->add(WebpagePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(WebpagePeer::ID)) $criteria->add(WebpagePeer::ID, $this->id);
		if ($this->isColumnModified(WebpagePeer::ACTIVE)) $criteria->add(WebpagePeer::ACTIVE, $this->active);
		if ($this->isColumnModified(WebpagePeer::OPT_NAME)) $criteria->add(WebpagePeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(WebpagePeer::OPT_CONTENT)) $criteria->add(WebpagePeer::OPT_CONTENT, $this->opt_content);
		if ($this->isColumnModified(WebpagePeer::OPT_URL)) $criteria->add(WebpagePeer::OPT_URL, $this->opt_url);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(WebpagePeer::DATABASE_NAME);

		$criteria->add(WebpagePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setActive($this->active);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptContent($this->opt_content);

		$copyObj->setOptUrl($this->opt_url);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getWebpageHasPositionings() as $relObj) {
				$copyObj->addWebpageHasPositioning($relObj->copy($deepCopy));
			}

			foreach($this->getWebpageGroupHasWebpages() as $relObj) {
				$copyObj->addWebpageGroupHasWebpage($relObj->copy($deepCopy));
			}

			foreach($this->getWebpageI18ns() as $relObj) {
				$copyObj->addWebpageI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new WebpagePeer();
		}
		return self::$peer;
	}

	
	public function initWebpageHasPositionings()
	{
		if ($this->collWebpageHasPositionings === null) {
			$this->collWebpageHasPositionings = array();
		}
	}

	
	public function getWebpageHasPositionings($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageHasPositionings === null) {
			if ($this->isNew()) {
			   $this->collWebpageHasPositionings = array();
			} else {

				$criteria->add(WebpageHasPositioningPeer::WEBPAGE_ID, $this->getId());

				WebpageHasPositioningPeer::addSelectColumns($criteria);
				$this->collWebpageHasPositionings = WebpageHasPositioningPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(WebpageHasPositioningPeer::WEBPAGE_ID, $this->getId());

				WebpageHasPositioningPeer::addSelectColumns($criteria);
				if (!isset($this->lastWebpageHasPositioningCriteria) || !$this->lastWebpageHasPositioningCriteria->equals($criteria)) {
					$this->collWebpageHasPositionings = WebpageHasPositioningPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastWebpageHasPositioningCriteria = $criteria;
		return $this->collWebpageHasPositionings;
	}

	
	public function countWebpageHasPositionings($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(WebpageHasPositioningPeer::WEBPAGE_ID, $this->getId());

		return WebpageHasPositioningPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addWebpageHasPositioning(WebpageHasPositioning $l)
	{
		$this->collWebpageHasPositionings[] = $l;
		$l->setWebpage($this);
	}

	
	public function initWebpageGroupHasWebpages()
	{
		if ($this->collWebpageGroupHasWebpages === null) {
			$this->collWebpageGroupHasWebpages = array();
		}
	}

	
	public function getWebpageGroupHasWebpages($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageGroupHasWebpages === null) {
			if ($this->isNew()) {
			   $this->collWebpageGroupHasWebpages = array();
			} else {

				$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_ID, $this->getId());

				WebpageGroupHasWebpagePeer::addSelectColumns($criteria);
				$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_ID, $this->getId());

				WebpageGroupHasWebpagePeer::addSelectColumns($criteria);
				if (!isset($this->lastWebpageGroupHasWebpageCriteria) || !$this->lastWebpageGroupHasWebpageCriteria->equals($criteria)) {
					$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastWebpageGroupHasWebpageCriteria = $criteria;
		return $this->collWebpageGroupHasWebpages;
	}

	
	public function countWebpageGroupHasWebpages($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_ID, $this->getId());

		return WebpageGroupHasWebpagePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addWebpageGroupHasWebpage(WebpageGroupHasWebpage $l)
	{
		$this->collWebpageGroupHasWebpages[] = $l;
		$l->setWebpage($this);
	}


	
	public function getWebpageGroupHasWebpagesJoinWebpageGroup($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageGroupHasWebpages === null) {
			if ($this->isNew()) {
				$this->collWebpageGroupHasWebpages = array();
			} else {

				$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_ID, $this->getId());

				$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelectJoinWebpageGroup($criteria, $con);
			}
		} else {
									
			$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_ID, $this->getId());

			if (!isset($this->lastWebpageGroupHasWebpageCriteria) || !$this->lastWebpageGroupHasWebpageCriteria->equals($criteria)) {
				$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelectJoinWebpageGroup($criteria, $con);
			}
		}
		$this->lastWebpageGroupHasWebpageCriteria = $criteria;

		return $this->collWebpageGroupHasWebpages;
	}

	
	public function initWebpageI18ns()
	{
		if ($this->collWebpageI18ns === null) {
			$this->collWebpageI18ns = array();
		}
	}

	
	public function getWebpageI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageI18ns === null) {
			if ($this->isNew()) {
			   $this->collWebpageI18ns = array();
			} else {

				$criteria->add(WebpageI18nPeer::ID, $this->getId());

				WebpageI18nPeer::addSelectColumns($criteria);
				$this->collWebpageI18ns = WebpageI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(WebpageI18nPeer::ID, $this->getId());

				WebpageI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastWebpageI18nCriteria) || !$this->lastWebpageI18nCriteria->equals($criteria)) {
					$this->collWebpageI18ns = WebpageI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastWebpageI18nCriteria = $criteria;
		return $this->collWebpageI18ns;
	}

	
	public function countWebpageI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(WebpageI18nPeer::ID, $this->getId());

		return WebpageI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addWebpageI18n(WebpageI18n $l)
	{
		$this->collWebpageI18ns[] = $l;
		$l->setWebpage($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentWebpageI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentWebpageI18n()->setName($value);
  }

  public function getContent()
  {
    $obj = $this->getCurrentWebpageI18n();

    return ($obj ? $obj->getContent() : null);
  }

  public function setContent($value)
  {
    $this->getCurrentWebpageI18n()->setContent($value);
  }

  public function getUrl()
  {
    $obj = $this->getCurrentWebpageI18n();

    return ($obj ? $obj->getUrl() : null);
  }

  public function setUrl($value)
  {
    $this->getCurrentWebpageI18n()->setUrl($value);
  }

  protected $current_i18n = array();

  public function getCurrentWebpageI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = WebpageI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setWebpageI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setWebpageI18nForCulture(new WebpageI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setWebpageI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addWebpageI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Webpage.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseWebpage:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseWebpage::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 