<?php


abstract class BaseWebpageGroup extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_name;


	
	protected $group_page;


	
	protected $show_footer;


	
	protected $show_header;

	
	protected $collWebpageGroupHasWebpages;

	
	protected $lastWebpageGroupHasWebpageCriteria = null;

	
	protected $collWebpageGroupI18ns;

	
	protected $lastWebpageGroupI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getGroupPage()
    {

            return $this->group_page;
    }

    
    public function getShowFooter()
    {

            return $this->show_footer;
    }

    
    public function getShowHeader()
    {

            return $this->show_header;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = WebpageGroupPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = WebpageGroupPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = WebpageGroupPeer::ID;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = WebpageGroupPeer::OPT_NAME;
        }

	} 
	
	public function setGroupPage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->group_page !== $v) {
          $this->group_page = $v;
          $this->modifiedColumns[] = WebpageGroupPeer::GROUP_PAGE;
        }

	} 
	
	public function setShowFooter($v)
	{

        if ($this->show_footer !== $v) {
          $this->show_footer = $v;
          $this->modifiedColumns[] = WebpageGroupPeer::SHOW_FOOTER;
        }

	} 
	
	public function setShowHeader($v)
	{

        if ($this->show_header !== $v) {
          $this->show_header = $v;
          $this->modifiedColumns[] = WebpageGroupPeer::SHOW_HEADER;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroup.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_name = $rs->getString($startcol + 3);

      $this->group_page = $rs->getString($startcol + 4);

      $this->show_footer = $rs->getBoolean($startcol + 5);

      $this->show_header = $rs->getBoolean($startcol + 6);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroup.postHydrate', array('resultset' => $rs, 'startcol' => 7)));

            return $startcol + 7; 
    } catch (Exception $e) {
      throw new PropelException("Error populating WebpageGroup object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseWebpageGroup:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			WebpageGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseWebpageGroup:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroup.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseWebpageGroup:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(WebpageGroupPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(WebpageGroupPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroup.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseWebpageGroup:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = WebpageGroupPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += WebpageGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collWebpageGroupHasWebpages !== null) {
				foreach($this->collWebpageGroupHasWebpages as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collWebpageGroupI18ns !== null) {
				foreach($this->collWebpageGroupI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = WebpageGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collWebpageGroupHasWebpages !== null) {
					foreach($this->collWebpageGroupHasWebpages as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collWebpageGroupI18ns !== null) {
					foreach($this->collWebpageGroupI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptName();
				break;
			case 4:
				return $this->getGroupPage();
				break;
			case 5:
				return $this->getShowFooter();
				break;
			case 6:
				return $this->getShowHeader();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageGroupPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptName(),
			$keys[4] => $this->getGroupPage(),
			$keys[5] => $this->getShowFooter(),
			$keys[6] => $this->getShowHeader(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptName($value);
				break;
			case 4:
				$this->setGroupPage($value);
				break;
			case 5:
				$this->setShowFooter($value);
				break;
			case 6:
				$this->setShowHeader($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageGroupPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setGroupPage($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setShowFooter($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setShowHeader($arr[$keys[6]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(WebpageGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(WebpageGroupPeer::CREATED_AT)) $criteria->add(WebpageGroupPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(WebpageGroupPeer::UPDATED_AT)) $criteria->add(WebpageGroupPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(WebpageGroupPeer::ID)) $criteria->add(WebpageGroupPeer::ID, $this->id);
		if ($this->isColumnModified(WebpageGroupPeer::OPT_NAME)) $criteria->add(WebpageGroupPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(WebpageGroupPeer::GROUP_PAGE)) $criteria->add(WebpageGroupPeer::GROUP_PAGE, $this->group_page);
		if ($this->isColumnModified(WebpageGroupPeer::SHOW_FOOTER)) $criteria->add(WebpageGroupPeer::SHOW_FOOTER, $this->show_footer);
		if ($this->isColumnModified(WebpageGroupPeer::SHOW_HEADER)) $criteria->add(WebpageGroupPeer::SHOW_HEADER, $this->show_header);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(WebpageGroupPeer::DATABASE_NAME);

		$criteria->add(WebpageGroupPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setGroupPage($this->group_page);

		$copyObj->setShowFooter($this->show_footer);

		$copyObj->setShowHeader($this->show_header);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getWebpageGroupHasWebpages() as $relObj) {
				$copyObj->addWebpageGroupHasWebpage($relObj->copy($deepCopy));
			}

			foreach($this->getWebpageGroupI18ns() as $relObj) {
				$copyObj->addWebpageGroupI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new WebpageGroupPeer();
		}
		return self::$peer;
	}

	
	public function initWebpageGroupHasWebpages()
	{
		if ($this->collWebpageGroupHasWebpages === null) {
			$this->collWebpageGroupHasWebpages = array();
		}
	}

	
	public function getWebpageGroupHasWebpages($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageGroupHasWebpages === null) {
			if ($this->isNew()) {
			   $this->collWebpageGroupHasWebpages = array();
			} else {

				$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID, $this->getId());

				WebpageGroupHasWebpagePeer::addSelectColumns($criteria);
				$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID, $this->getId());

				WebpageGroupHasWebpagePeer::addSelectColumns($criteria);
				if (!isset($this->lastWebpageGroupHasWebpageCriteria) || !$this->lastWebpageGroupHasWebpageCriteria->equals($criteria)) {
					$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastWebpageGroupHasWebpageCriteria = $criteria;
		return $this->collWebpageGroupHasWebpages;
	}

	
	public function countWebpageGroupHasWebpages($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID, $this->getId());

		return WebpageGroupHasWebpagePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addWebpageGroupHasWebpage(WebpageGroupHasWebpage $l)
	{
		$this->collWebpageGroupHasWebpages[] = $l;
		$l->setWebpageGroup($this);
	}


	
	public function getWebpageGroupHasWebpagesJoinWebpage($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageGroupHasWebpages === null) {
			if ($this->isNew()) {
				$this->collWebpageGroupHasWebpages = array();
			} else {

				$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID, $this->getId());

				$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelectJoinWebpage($criteria, $con);
			}
		} else {
									
			$criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID, $this->getId());

			if (!isset($this->lastWebpageGroupHasWebpageCriteria) || !$this->lastWebpageGroupHasWebpageCriteria->equals($criteria)) {
				$this->collWebpageGroupHasWebpages = WebpageGroupHasWebpagePeer::doSelectJoinWebpage($criteria, $con);
			}
		}
		$this->lastWebpageGroupHasWebpageCriteria = $criteria;

		return $this->collWebpageGroupHasWebpages;
	}

	
	public function initWebpageGroupI18ns()
	{
		if ($this->collWebpageGroupI18ns === null) {
			$this->collWebpageGroupI18ns = array();
		}
	}

	
	public function getWebpageGroupI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebpageGroupI18ns === null) {
			if ($this->isNew()) {
			   $this->collWebpageGroupI18ns = array();
			} else {

				$criteria->add(WebpageGroupI18nPeer::ID, $this->getId());

				WebpageGroupI18nPeer::addSelectColumns($criteria);
				$this->collWebpageGroupI18ns = WebpageGroupI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(WebpageGroupI18nPeer::ID, $this->getId());

				WebpageGroupI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastWebpageGroupI18nCriteria) || !$this->lastWebpageGroupI18nCriteria->equals($criteria)) {
					$this->collWebpageGroupI18ns = WebpageGroupI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastWebpageGroupI18nCriteria = $criteria;
		return $this->collWebpageGroupI18ns;
	}

	
	public function countWebpageGroupI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(WebpageGroupI18nPeer::ID, $this->getId());

		return WebpageGroupI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addWebpageGroupI18n(WebpageGroupI18n $l)
	{
		$this->collWebpageGroupI18ns[] = $l;
		$l->setWebpageGroup($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentWebpageGroupI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentWebpageGroupI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentWebpageGroupI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = WebpageGroupI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setWebpageGroupI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setWebpageGroupI18nForCulture(new WebpageGroupI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setWebpageGroupI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addWebpageGroupI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'WebpageGroup.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseWebpageGroup:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseWebpageGroup::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 