<?php


abstract class BaseWebpageGroupHasWebpage extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $webpage_id;


	
	protected $webpage_group_id;


	
	protected $rank;

	
	protected $aWebpage;

	
	protected $aWebpageGroup;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getWebpageId()
    {

            return $this->webpage_id;
    }

    
    public function getWebpageGroupId()
    {

            return $this->webpage_group_id;
    }

    
    public function getRank()
    {

            return $this->rank;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = WebpageGroupHasWebpagePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = WebpageGroupHasWebpagePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = WebpageGroupHasWebpagePeer::ID;
        }

	} 
	
	public function setWebpageId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->webpage_id !== $v) {
          $this->webpage_id = $v;
          $this->modifiedColumns[] = WebpageGroupHasWebpagePeer::WEBPAGE_ID;
        }

		if ($this->aWebpage !== null && $this->aWebpage->getId() !== $v) {
			$this->aWebpage = null;
		}

	} 
	
	public function setWebpageGroupId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->webpage_group_id !== $v) {
          $this->webpage_group_id = $v;
          $this->modifiedColumns[] = WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID;
        }

		if ($this->aWebpageGroup !== null && $this->aWebpageGroup->getId() !== $v) {
			$this->aWebpageGroup = null;
		}

	} 
	
	public function setRank($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->rank !== $v) {
          $this->rank = $v;
          $this->modifiedColumns[] = WebpageGroupHasWebpagePeer::RANK;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroupHasWebpage.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->webpage_id = $rs->getInt($startcol + 3);

      $this->webpage_group_id = $rs->getInt($startcol + 4);

      $this->rank = $rs->getInt($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroupHasWebpage.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating WebpageGroupHasWebpage object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseWebpageGroupHasWebpage:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageGroupHasWebpagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			WebpageGroupHasWebpagePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseWebpageGroupHasWebpage:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroupHasWebpage.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseWebpageGroupHasWebpage:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(WebpageGroupHasWebpagePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(WebpageGroupHasWebpagePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageGroupHasWebpagePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageGroupHasWebpage.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseWebpageGroupHasWebpage:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aWebpage !== null) {
				if ($this->aWebpage->isModified() || $this->aWebpage->getCurrentWebpageI18n()->isModified()) {
					$affectedRows += $this->aWebpage->save($con);
				}
				$this->setWebpage($this->aWebpage);
			}

			if ($this->aWebpageGroup !== null) {
				if ($this->aWebpageGroup->isModified() || $this->aWebpageGroup->getCurrentWebpageGroupI18n()->isModified()) {
					$affectedRows += $this->aWebpageGroup->save($con);
				}
				$this->setWebpageGroup($this->aWebpageGroup);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = WebpageGroupHasWebpagePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += WebpageGroupHasWebpagePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aWebpage !== null) {
				if (!$this->aWebpage->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aWebpage->getValidationFailures());
				}
			}

			if ($this->aWebpageGroup !== null) {
				if (!$this->aWebpageGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aWebpageGroup->getValidationFailures());
				}
			}


			if (($retval = WebpageGroupHasWebpagePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageGroupHasWebpagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getWebpageId();
				break;
			case 4:
				return $this->getWebpageGroupId();
				break;
			case 5:
				return $this->getRank();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageGroupHasWebpagePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getWebpageId(),
			$keys[4] => $this->getWebpageGroupId(),
			$keys[5] => $this->getRank(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageGroupHasWebpagePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setWebpageId($value);
				break;
			case 4:
				$this->setWebpageGroupId($value);
				break;
			case 5:
				$this->setRank($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageGroupHasWebpagePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setWebpageId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setWebpageGroupId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setRank($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(WebpageGroupHasWebpagePeer::DATABASE_NAME);

		if ($this->isColumnModified(WebpageGroupHasWebpagePeer::CREATED_AT)) $criteria->add(WebpageGroupHasWebpagePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(WebpageGroupHasWebpagePeer::UPDATED_AT)) $criteria->add(WebpageGroupHasWebpagePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(WebpageGroupHasWebpagePeer::ID)) $criteria->add(WebpageGroupHasWebpagePeer::ID, $this->id);
		if ($this->isColumnModified(WebpageGroupHasWebpagePeer::WEBPAGE_ID)) $criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_ID, $this->webpage_id);
		if ($this->isColumnModified(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID)) $criteria->add(WebpageGroupHasWebpagePeer::WEBPAGE_GROUP_ID, $this->webpage_group_id);
		if ($this->isColumnModified(WebpageGroupHasWebpagePeer::RANK)) $criteria->add(WebpageGroupHasWebpagePeer::RANK, $this->rank);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(WebpageGroupHasWebpagePeer::DATABASE_NAME);

		$criteria->add(WebpageGroupHasWebpagePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setWebpageId($this->webpage_id);

		$copyObj->setWebpageGroupId($this->webpage_group_id);

		$copyObj->setRank($this->rank);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new WebpageGroupHasWebpagePeer();
		}
		return self::$peer;
	}

	
	public function setWebpage($v)
	{


		if ($v === null) {
			$this->setWebpageId(NULL);
		} else {
			$this->setWebpageId($v->getId());
		}


		$this->aWebpage = $v;
	}


	
	public function getWebpage($con = null)
	{
		if ($this->aWebpage === null && ($this->webpage_id !== null)) {
						$this->aWebpage = WebpagePeer::retrieveByPK($this->webpage_id, $con);

			
		}
		return $this->aWebpage;
	}

	
	public function setWebpageGroup($v)
	{


		if ($v === null) {
			$this->setWebpageGroupId(NULL);
		} else {
			$this->setWebpageGroupId($v->getId());
		}


		$this->aWebpageGroup = $v;
	}


	
	public function getWebpageGroup($con = null)
	{
		if ($this->aWebpageGroup === null && ($this->webpage_group_id !== null)) {
						$this->aWebpageGroup = WebpageGroupPeer::retrieveByPK($this->webpage_group_id, $con);

			
		}
		return $this->aWebpageGroup;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'WebpageGroupHasWebpage.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseWebpageGroupHasWebpage:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseWebpageGroupHasWebpage::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 