<?php


abstract class BaseWebpageI18n extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $culture;


	
	protected $name;


	
	protected $content;


	
	protected $url;

	
	protected $aWebpage;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCulture()
    {

            return $this->culture;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getContent()
    {

            return $this->content;
    }

    
    public function getUrl()
    {

            return $this->url;
    }

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = WebpageI18nPeer::ID;
        }

		if ($this->aWebpage !== null && $this->aWebpage->getId() !== $v) {
			$this->aWebpage = null;
		}

	} 
	
	public function setCulture($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->culture !== $v) {
          $this->culture = $v;
          $this->modifiedColumns[] = WebpageI18nPeer::CULTURE;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = WebpageI18nPeer::NAME;
        }

	} 
	
	public function setContent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->content !== $v) {
          $this->content = $v;
          $this->modifiedColumns[] = WebpageI18nPeer::CONTENT;
        }

	} 
	
	public function setUrl($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->url !== $v) {
          $this->url = $v;
          $this->modifiedColumns[] = WebpageI18nPeer::URL;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageI18n.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->culture = $rs->getString($startcol + 1);

      $this->name = $rs->getString($startcol + 2);

      $this->content = $rs->getString($startcol + 3);

      $this->url = $rs->getString($startcol + 4);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'WebpageI18n.postHydrate', array('resultset' => $rs, 'startcol' => 5)));

            return $startcol + 5; 
    } catch (Exception $e) {
      throw new PropelException("Error populating WebpageI18n object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseWebpageI18n:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageI18nPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			WebpageI18nPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseWebpageI18n:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageI18n.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseWebpageI18n:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(WebpageI18nPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'WebpageI18n.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseWebpageI18n:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aWebpage !== null) {
				if ($this->aWebpage->isModified() || $this->aWebpage->getCurrentWebpageI18n()->isModified()) {
					$affectedRows += $this->aWebpage->save($con);
				}
				$this->setWebpage($this->aWebpage);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = WebpageI18nPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setNew(false);
				} else {
					$affectedRows += WebpageI18nPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aWebpage !== null) {
				if (!$this->aWebpage->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aWebpage->getValidationFailures());
				}
			}


			if (($retval = WebpageI18nPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageI18nPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getCulture();
				break;
			case 2:
				return $this->getName();
				break;
			case 3:
				return $this->getContent();
				break;
			case 4:
				return $this->getUrl();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageI18nPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getCulture(),
			$keys[2] => $this->getName(),
			$keys[3] => $this->getContent(),
			$keys[4] => $this->getUrl(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = WebpageI18nPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setCulture($value);
				break;
			case 2:
				$this->setName($value);
				break;
			case 3:
				$this->setContent($value);
				break;
			case 4:
				$this->setUrl($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = WebpageI18nPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setCulture($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setName($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setContent($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setUrl($arr[$keys[4]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(WebpageI18nPeer::DATABASE_NAME);

		if ($this->isColumnModified(WebpageI18nPeer::ID)) $criteria->add(WebpageI18nPeer::ID, $this->id);
		if ($this->isColumnModified(WebpageI18nPeer::CULTURE)) $criteria->add(WebpageI18nPeer::CULTURE, $this->culture);
		if ($this->isColumnModified(WebpageI18nPeer::NAME)) $criteria->add(WebpageI18nPeer::NAME, $this->name);
		if ($this->isColumnModified(WebpageI18nPeer::CONTENT)) $criteria->add(WebpageI18nPeer::CONTENT, $this->content);
		if ($this->isColumnModified(WebpageI18nPeer::URL)) $criteria->add(WebpageI18nPeer::URL, $this->url);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(WebpageI18nPeer::DATABASE_NAME);

		$criteria->add(WebpageI18nPeer::ID, $this->id);
		$criteria->add(WebpageI18nPeer::CULTURE, $this->culture);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		$pks = array();

		$pks[0] = $this->getId();

		$pks[1] = $this->getCulture();

		return $pks;
	}

	
	public function setPrimaryKey($keys)
	{

		$this->setId($keys[0]);

		$this->setCulture($keys[1]);

	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setName($this->name);

		$copyObj->setContent($this->content);

		$copyObj->setUrl($this->url);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
		$copyObj->setCulture(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new WebpageI18nPeer();
		}
		return self::$peer;
	}

	
	public function setWebpage($v)
	{


		if ($v === null) {
			$this->setId(NULL);
		} else {
			$this->setId($v->getId());
		}


		$this->aWebpage = $v;
	}


	
	public function getWebpage($con = null)
	{
		if ($this->aWebpage === null && ($this->id !== null)) {
						$this->aWebpage = WebpagePeer::retrieveByPK($this->id, $con);

			
		}
		return $this->aWebpage;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'WebpageI18n.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseWebpageI18n:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseWebpageI18n::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 