<?php


abstract class BaseProductHasWholesale extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $product_id;


	
	protected $price_a;


	
	protected $price_b;


	
	protected $price_c;


	
	protected $opt_price_brutto_a;


	
	protected $opt_price_brutto_b;


	
	protected $opt_price_brutto_c;

	
	protected $aProduct;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getProductId()
    {

            return $this->product_id;
    }

    
    public function getPriceA()
    {

            return null !== $this->price_a ? (string)$this->price_a : null;
    }

    
    public function getPriceB()
    {

            return null !== $this->price_b ? (string)$this->price_b : null;
    }

    
    public function getPriceC()
    {

            return null !== $this->price_c ? (string)$this->price_c : null;
    }

    
    public function getOptPriceBruttoA()
    {

            return null !== $this->opt_price_brutto_a ? (string)$this->opt_price_brutto_a : null;
    }

    
    public function getOptPriceBruttoB()
    {

            return null !== $this->opt_price_brutto_b ? (string)$this->opt_price_brutto_b : null;
    }

    
    public function getOptPriceBruttoC()
    {

            return null !== $this->opt_price_brutto_c ? (string)$this->opt_price_brutto_c : null;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = ProductHasWholesalePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = ProductHasWholesalePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::ID;
        }

	} 
	
	public function setProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->product_id !== $v) {
          $this->product_id = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::PRODUCT_ID;
        }

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

	} 
	
	public function setPriceA($v)
	{

        if ($this->price_a !== $v) {
          $this->price_a = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::PRICE_A;
        }

	} 
	
	public function setPriceB($v)
	{

        if ($this->price_b !== $v) {
          $this->price_b = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::PRICE_B;
        }

	} 
	
	public function setPriceC($v)
	{

        if ($this->price_c !== $v) {
          $this->price_c = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::PRICE_C;
        }

	} 
	
	public function setOptPriceBruttoA($v)
	{

        if ($this->opt_price_brutto_a !== $v) {
          $this->opt_price_brutto_a = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::OPT_PRICE_BRUTTO_A;
        }

	} 
	
	public function setOptPriceBruttoB($v)
	{

        if ($this->opt_price_brutto_b !== $v) {
          $this->opt_price_brutto_b = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::OPT_PRICE_BRUTTO_B;
        }

	} 
	
	public function setOptPriceBruttoC($v)
	{

        if ($this->opt_price_brutto_c !== $v) {
          $this->opt_price_brutto_c = $v;
          $this->modifiedColumns[] = ProductHasWholesalePeer::OPT_PRICE_BRUTTO_C;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'ProductHasWholesale.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->product_id = $rs->getInt($startcol + 3);

      $this->price_a = $rs->getString($startcol + 4, null);

      $this->price_a = $rs->getFloat($startcol + 4);

      $this->price_b = $rs->getString($startcol + 5, null);

      $this->price_b = $rs->getFloat($startcol + 5);

      $this->price_c = $rs->getString($startcol + 6, null);

      $this->price_c = $rs->getFloat($startcol + 6);

      $this->opt_price_brutto_a = $rs->getString($startcol + 7, null);

      $this->opt_price_brutto_a = $rs->getFloat($startcol + 7);

      $this->opt_price_brutto_b = $rs->getString($startcol + 8, null);

      $this->opt_price_brutto_b = $rs->getFloat($startcol + 8);

      $this->opt_price_brutto_c = $rs->getString($startcol + 9, null);

      $this->opt_price_brutto_c = $rs->getFloat($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'ProductHasWholesale.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating ProductHasWholesale object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseProductHasWholesale:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductHasWholesalePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			ProductHasWholesalePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProductHasWholesale:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductHasWholesale.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseProductHasWholesale:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(ProductHasWholesalePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(ProductHasWholesalePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductHasWholesalePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'ProductHasWholesale.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseProductHasWholesale:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductHasWholesalePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += ProductHasWholesalePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}


			if (($retval = ProductHasWholesalePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductHasWholesalePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getProductId();
				break;
			case 4:
				return $this->getPriceA();
				break;
			case 5:
				return $this->getPriceB();
				break;
			case 6:
				return $this->getPriceC();
				break;
			case 7:
				return $this->getOptPriceBruttoA();
				break;
			case 8:
				return $this->getOptPriceBruttoB();
				break;
			case 9:
				return $this->getOptPriceBruttoC();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductHasWholesalePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getProductId(),
			$keys[4] => $this->getPriceA(),
			$keys[5] => $this->getPriceB(),
			$keys[6] => $this->getPriceC(),
			$keys[7] => $this->getOptPriceBruttoA(),
			$keys[8] => $this->getOptPriceBruttoB(),
			$keys[9] => $this->getOptPriceBruttoC(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductHasWholesalePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setProductId($value);
				break;
			case 4:
				$this->setPriceA($value);
				break;
			case 5:
				$this->setPriceB($value);
				break;
			case 6:
				$this->setPriceC($value);
				break;
			case 7:
				$this->setOptPriceBruttoA($value);
				break;
			case 8:
				$this->setOptPriceBruttoB($value);
				break;
			case 9:
				$this->setOptPriceBruttoC($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductHasWholesalePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setProductId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setPriceA($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setPriceB($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setPriceC($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptPriceBruttoA($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setOptPriceBruttoB($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setOptPriceBruttoC($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductHasWholesalePeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductHasWholesalePeer::CREATED_AT)) $criteria->add(ProductHasWholesalePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(ProductHasWholesalePeer::UPDATED_AT)) $criteria->add(ProductHasWholesalePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(ProductHasWholesalePeer::ID)) $criteria->add(ProductHasWholesalePeer::ID, $this->id);
		if ($this->isColumnModified(ProductHasWholesalePeer::PRODUCT_ID)) $criteria->add(ProductHasWholesalePeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(ProductHasWholesalePeer::PRICE_A)) $criteria->add(ProductHasWholesalePeer::PRICE_A, $this->price_a);
		if ($this->isColumnModified(ProductHasWholesalePeer::PRICE_B)) $criteria->add(ProductHasWholesalePeer::PRICE_B, $this->price_b);
		if ($this->isColumnModified(ProductHasWholesalePeer::PRICE_C)) $criteria->add(ProductHasWholesalePeer::PRICE_C, $this->price_c);
		if ($this->isColumnModified(ProductHasWholesalePeer::OPT_PRICE_BRUTTO_A)) $criteria->add(ProductHasWholesalePeer::OPT_PRICE_BRUTTO_A, $this->opt_price_brutto_a);
		if ($this->isColumnModified(ProductHasWholesalePeer::OPT_PRICE_BRUTTO_B)) $criteria->add(ProductHasWholesalePeer::OPT_PRICE_BRUTTO_B, $this->opt_price_brutto_b);
		if ($this->isColumnModified(ProductHasWholesalePeer::OPT_PRICE_BRUTTO_C)) $criteria->add(ProductHasWholesalePeer::OPT_PRICE_BRUTTO_C, $this->opt_price_brutto_c);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductHasWholesalePeer::DATABASE_NAME);

		$criteria->add(ProductHasWholesalePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setProductId($this->product_id);

		$copyObj->setPriceA($this->price_a);

		$copyObj->setPriceB($this->price_b);

		$copyObj->setPriceC($this->price_c);

		$copyObj->setOptPriceBruttoA($this->opt_price_brutto_a);

		$copyObj->setOptPriceBruttoB($this->opt_price_brutto_b);

		$copyObj->setOptPriceBruttoC($this->opt_price_brutto_c);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductHasWholesalePeer();
		}
		return self::$peer;
	}

	
	public function setProduct($v)
	{


		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}


		$this->aProduct = $v;
	}


	
	public function getProduct($con = null)
	{
		if ($this->aProduct === null && ($this->product_id !== null)) {
						$this->aProduct = ProductPeer::retrieveByPK($this->product_id, $con);

			
		}
		return $this->aProduct;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'ProductHasWholesale.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseProductHasWholesale:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseProductHasWholesale::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 