<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  tests
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stRecommendPluginTest.php 1221 2009-10-07 13:45:16Z pawel $
 * @author      Paweł Byszewski <pawel.byszewski@sote.pl>
 */

/** 
 * Konfiguracja i inicjacja środowiska testów. 
 */
include(dirname(__FILE__).'/../../bootstrap/functional.php');

// create a new test browser
$browser = new stTestBrowser();
$browser->initialize();
$browser->login();

/** 
 * Sprawdza istnienie modułu w backendzie
 */
$browser->test()->diag('Sprawdza istnienie modułu w backendzie');
$browser->get('/recommend_send')->isStatusCode(200);
$browser->isRequestParameter('module', 'stRecommendSendBackend');
$browser->isRequestParameter('action', 'list');
$browser->responseContains('Wysłane polecenia produktów');
$browser->responseContains('Polecony produkt');

$browser->test()->diag('Sprawdza istnienie modułu w backendzie');
$browser->get('/recommend_shop_send')->isStatusCode(200);
$browser->isRequestParameter('module', 'stRecommendShopSendBackend');
$browser->isRequestParameter('action', 'list');
$browser->responseContains('Wysłane polecenia sklepu');

$browser->test()->diag('Sprawdza istnienie konfiguracji do modułu w backendzie');
$browser->get('/recommend_config')->isStatusCode(200);
$browser->isRequestParameter('module', 'stRecommendSendBackend');
$browser->isRequestParameter('action', 'config');
$browser->responseContains('Konfiguracja rekomendacji');
$browser->responseContains('Polecenie produktu');
$browser->responseContains('Polecenie sklepu');

?>