<?php
/** 
 * SOTESHOP/stRecommendPlugin 
 * 
 * Ten plik należy do aplikacji stRecommendPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stRecommendPlugin
 * @subpackage  tests
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stRecommendPluginTest.php 1221 2009-10-07 13:45:16Z pawel $
 * @author      Paweł Byszewski <pawel.byszewski@sote.pl>
 */

/** 
 * Test stRecommendProductFrontend
 */
include(dirname(__FILE__).'/../../bootstrap/functional.php');

// create a new test browser
$browser = new stTestBrowser();
$browser->initialize();

/** 
 * Sprawdza istnienie pluginu rekomendacja produktu
 */

$browser->test()->diag('Sprawdzam możliwośc dodania rekomendacji produktu');
$browser->get('/product/show/id/5/product_description/2')->isStatusCode(200);
$browser->responseContains('treść wiadomości');
$browser->responseContains('informacje dodatkowe');
$browser->responseContains('adres e-mail Twojego znajomego');
$browser->setField('recommend_product[additional_info]','To jest treść polecenia produktu');
$browser->setField('recommend_product[from]','fromtest@example.com');
$browser->setField('recommend_product[to]','totest@example.com');


/** 
 * Sprawdza istnienie pluginu rekomendacja produktu
 */
$browser->test()->diag('Sprawdzam możliwośc dodania rekomendacji sklepu');
$browser->get('/recommend_shop')->isStatusCode(200);
$browser->isRequestParameter('module', 'stRecommendShopFrontend');
$browser->isRequestParameter('action', 'index');
$browser->responseContains('Polecenie sklepu');
$browser->responseContains('twój adres e-mail');
$browser->responseContains('treść wiadomości');
$browser->responseContains('adres e-mail Twojego znajomego');

$browser->setField('recommend_shop[additional_info]','To jest treść polecenia sklepu');
$browser->setField('recommend_shop[from]','fromtest@example.com');
$browser->setField('recommend_shop[to]','totest@example.com');

?>