jQuery(function($) {
   $.fn.stColorPicker = function(options)
   {
      var input = $(this);
      
      var trigger = $('#'+input.attr('id')+'-trigger');

      if (options == undefined)
      {
         options = {};
      }

      trigger.click(function() {
         input.ColorPickerShow();
      });

      $.extend(options, {
         onSubmit: function(hsb, hex, rgb, el)
         {
            $(el).val(hex);
            $(el).ColorPickerHide();
         },
         onBeforeShow: function ()
         {
            $(this).ColorPickerSetColor(this.value);
         },
         onChange: function (hsb, hex, rgb)
         {
            input.val(hex);

            trigger.css('background-color', '#'+hex);
         },
         onHide: function()
         {
            input.trigger('onHide');
         },
         onShow: function()
         {
            return !input.attr('disabled');
         }
      });

      input.ColorPicker(options)
      .bind('keyup', function()
      {
         $(this).ColorPickerSetColor(this.value);

         trigger.css('background-color', '#'+this.value);
      });
   }
});


