
function stOrderPriceModifiers() { }

stOrderPriceModifiers.params = {};

function stOrderProductPriceManagment(fields)
{
   function updateTotalAmount()
   {
      stOrderProductPriceManagment.updateTotalAmount(fields);
   }

   $(fields.discount).observe('change', function() {
      this.value = stPrice.fixNumberFormat(this.value, 0);

      if (this.value > 99)
      {
         stPrice.updateField(this, 99);
      }

      stOrderProductPriceManagment.updateTotalAmount(fields);
   });

   fields.quantity.observe('change', function() {
      this.value = stPrice.fixNumberFormat(this.value);

      stOrderProductPriceManagment.updateTotalAmount(fields);
   });

   return new stPriceTaxManagment({
      taxValues: stOrderProductPriceManagment.params.taxValues,
      taxField: $(fields.tax).id,
      onChange: updateTotalAmount,
      priceFields: [{
         price: $(fields.price_netto).id,
         priceWithTax: $(fields.price_brutto).id
      }]
   });
}

stOrderProductPriceManagment.updateProductForm = function updateProductForm(value, data)
{
   stPrice.updateField('code', data.c);

   stPrice.updateField('name', data.n);

   stPrice.updateField('price_netto', stPrice.round(data.pn));

   $$('#tax option').each(function(e) {
      if (e.value == data.t) {
         e.selected = true
      }
   });

   stPrice.updateField('price_brutto', stPrice.round(data.pb));

//   $('hidden_data').value = Object.toJSON(data.hd);

   stOrderProductPriceManagment.updateTotalAmount({
      price_brutto: 'price_brutto',
      discount: 'discount',
      quantity: 'quantity',
      total_amount: 'total_amount',
      tax: 'tax',
      price_netto_discount: 'price_netto_discount',
      price_brutto_discount: 'price_brutto_discount'
   });
}

stOrderProductPriceManagment.updateTotalAmount = function(fields)
{

   var tax_index = $(fields.tax).selectedIndex;

   var tax_value = stOrderProductPriceManagment.params.taxValues[tax_index];

   var price_value = stPrice.applyDiscount($(fields.price_brutto).value, $(fields.discount).value);

   stPrice.updateField($(fields.price_netto_discount), stPrice.extract(price_value, tax_value), true)

   stPrice.updateField($(fields.price_brutto_discount), price_value, true);

   stPrice.updateField($(fields.total_amount), stPrice.round(price_value * $(fields.quantity).value), true);
}

jQuery(function($)
{
   stOrderProductPriceManagment.fnFormatResult = function(value, data, currentValue)
   {
      var pattern = '(' + currentValue.replace($.fn.autocomplete.escapePattern, '\\$1') + ')';

      var name = data.c+': '+data.n;

//      if (data.hd.pm.length)
//      {
//         var option_label = '';
//
//         $.each(data.hd.pm, function()
//         {
//            option_label += ', '+this.label;
//         });
//
//         name += ' ['+option_label.substr(2)+']';
//      }
      
      name = name.replace(new RegExp(pattern, 'gi'), '<strong>$1<\/strong>');

      var template = $('#st_order-autocomplete-template');

      template.find('h2').html(name);

      template.find('.price_netto').html(stPrice.round(data.pn));

      template.find('.price_brutto').html(stPrice.round(data.pb));

      template.find('img').attr('src', data.ip);

      return template.html();
   }

   stOrderProductPriceManagment.getPriceModifiersLabel = function(price_modifiers)
   {
      var option_label = '';

      $.each(price_modifiers, function()
      {
         option_label += ', '+this.label;
      });

      return option_label.substr(2);
   }

   stOrderPriceModifiers.show = function(target)
   {
      var hidden_data = target.parents('tr').find('.hidden_data').val().evalJSON(true);

      var url = stOrderPriceModifiers.params.url+'?id='+hidden_data.id+'&ids='+hidden_data.pm.map(function(data) { return data.custom.id }).join('-');

      var container = target.data('container');

      if (container == undefined)
      {
         $.getJSON(url, function(data) {
         
            container = stOrderPriceModifiers.createContainer(data.data);

            container.appendTo(target.parent('div'));

            target.data('container', container);        
         });
      }
      else
      {
         container.show();
      }
   }


   stOrderPriceModifiers.update = function()
   {
      var container = $(this).parent('div');

      var values = container.find('select').serializeArray();

      var hidden_data_field = $(this).parents('tr').find('.hidden_data');

      var hidden_data = hidden_data_field.val().evalJSON(true);

      var ids = $.map(values, function(data) {return data.value});
      
      var url = stOrderPriceModifiers.params.url+'?id='+hidden_data.id+'&ids='+ids.join('-');

      $.getJSON(url, function(data) {

         var parent = container.parent('div');

         container.remove();

         container = stOrderPriceModifiers.createContainer(data.data);

         container.appendTo(parent);

         parent.find('a').data('container', container);
      });
   }

   stOrderPriceModifiers.hide = function(target)
   {
      var container = target.data('container');

      if (container)
      {
         container.hide();
      }
   }

   stOrderPriceModifiers.createContainer = function(data)
   {
      container = $('<div></div>');

      $.each(data, function(index) {
         var current = this;

         container.append($('<p>'+this.field+'</p>'));

         var select = $('<select name="price_modifier['+index+']"></select>');

         $.each(current.data, function(index){

            var option = $('<option value="'+index+'">'+this+'</option>');

            if (current.selected == index)
            {
               option.attr('selected', 'selected');
            }

            select.append(option)
         });

         select.change(stOrderPriceModifiers.update);

         container.append(select);
      });

      return container;
   }
});

stOrderProductPriceManagment.setParams = function(params)
{
   stOrderProductPriceManagment.params = params;
}


