/**
* 
* @package stProductOptionsTemplatePlugin
* @author Daniel Mendalka <daniel.mendalka@sote.pl>
* @copyright SOTE
* @license SOTE
* @version $Id$
*/
var tree;

stProductOptionsTree = function() {
    return {
        create : function(root_name, root_id, model, module_name, editable, ui_provider, params, container_scroll, animated, show_hints, root_href, culture)
        {
            if (typeof ui_provider == 'undefined')
            {
                ui_provider = Ext.tree.stTreeNodeUI;
            }
            
            if (typeof animated == 'undefined')
            {
                animated = true;
            }    
                    
            if (typeof show_hints == 'undefined')
            {
                show_hints = true;
            } 
                        
            if (typeof ui_provider == 'undefined')
            {
                container_scroll = true;
            }            
            
            if (typeof params == 'undefined')
            {
                params = {};
            }            

            if (show_hints)
            {
	            Ext.QuickTips.init();
	            Ext.apply(Ext.QuickTips.getQuickTip(), {
	                maxWidth: 200,
	                minWidth: 100,
	                showDelay: 50,
	                dismissDelay: 10000,
	                trackMouse: true,
	            });
            }

            var tb = new Ext.Toolbar(
            {
                items:
                [
                {
                    text: params['add_button_label'],
                    cls: 'st_ext_button-icon',
                    icon: '/images/backend/icons/add.png',
                    tooltip: params['add_button_tooltip'],
                    handler: function dodaj()
                    {
                        var sn = tree.getSelectionModel().getSelectedNode();

                        if (!sn)
                        {
                            sn = root;
                        }
					
                        sn.expand(false, true, function ()
                        {							
                            Ext.Ajax.request({
                                url: Ext.SF_SCRIPT_NAME + '/' + module_name + '/appendProductOption',
                                params: { model: model, id: sn.id, name: sn.attributes.field ? params['new_field_value'] : params['new_option_value'], field: sn.attributes.field, parent_id: sn.parentNode ? sn.parentNode.id : null},
                                success: function(response)
                                {
                                    var json_data = Ext.util.JSON.decode(response.responseText);
                                    if (json_data)
                                    {
                                        var parent = tree.getNodeById(json_data.parent_id);
                                        var node = parent.appendChild(new Ext.tree.AsyncTreeNode({
                                            text: json_data.name,
                                            id: json_data.id,
											cls: json_data.cls,
											field: json_data.field,
											qtip: json_data.qtip,
											
                                            allowDrag: true,
                                            uiProvider: ui_provider,
                                        }));

										//node.fireEvent('click', node);
                                    }
                                }
                            });

                        });

                    }
                },
                {
                    text: params['del_button_label'],
                    cls: 'st_ext_button-icon',
                    icon: '/images/backend/icons/delete.png',
                    disabled: true,
                    tooltip: params['del_button_tooltip'],
                    handler: function()
                    {
                        var sn = tree.getSelectionModel().getSelectedNode();
                        if (sn)
                        {
                            Ext.Ajax.request({
                                url: Ext.SF_SCRIPT_NAME + '/' + module_name + '/removeProductOption',
                                params: { model: model, id: sn.id, parent_id: sn.parentNode.id, field: sn.attributes.field },
                                success: function(response)
                                {
                                    var json_data = Ext.util.JSON.decode(response.responseText);
                                    var node = tree.getNodeById(json_data.id);
                                    if (node)
                                    {
										node.remove();
                                    }

                                }
                            });
                        }
                    }
                },
                {
                    text: params['exp_button_label'],
                    cls: 'st_ext_button-icon',
                    icon: '/images/backend/icons/filter.png',
                    tooltip: params['exp_button_tooltip'],
                    handler: function()
                    {
                        if(this.text==params['exp_button_label'])
                        {
                            tree.expandAll();
                            this.setText(params['fold_button_label']);
                        }
                        else
                        {
                            tree.collapseAll();
                            tree.getRootNode().fireEvent('click', tree.getRootNode());
                            this.setText(params['exp_button_label']);
                        }
                    }
                },
                /**
    		     * Przycisk wstaw szablon
    		     */
    		    {
    		    	text: params['tpl_button_label'],
    		    	cls: 'st_ext_button-icon',
    		    	icon: '/images/backend/icons/add_template.png',
    		    	tooltip: params['tpl_button_tooltip'],
    		    	handler: function() {
    		    		var selected = tree.getSelectionModel().getSelectedNode();
    		    	    var form = new Ext.form.FormPanel({
    		    	        baseCls: 'x-plain',
    		    	        labelWidth: 115,
    		    	        items: [{
    		    	        	width: 			200,
    		    	        	xtype:          'combo',
                                mode:           'local',
                                triggerAction:  'all',
                                forceSelection: true,
                                editable:       false,
                                fieldLabel:     params['tpl_window_label'],
                                name:           'combo',
                                hiddenName:     'combo',
                                displayField:   'name',
                                valueField:     'value',
                                value:          params.templates[0]['value'],
    		    	        	store:          new Ext.data.JsonStore({
                                    fields : ['name', 'value'],
                                    data   : params.templates
                                }),
    		    	        	editable: false
    		    	        }]
    		    	    });
    		    	    
		    	        var w = new Ext.Window({
    		    	        title: params['tpl_window_label'],
    		    	        collapsible: false,
    		    	        maximizable: false,
    		    	        width: 336,
    		    	        height: 95,
    		    	        layout: 'fit',
    		    	        hideBorders: true,
    		    	        plain: true,
    		    	        buttonAlign: 'right',
    		    	        items: form,
    		    	        buttons: [{
    		    	            text: params['tpl_window_label'],
    		    	            handler: function () {
    		    	        		var combo = document.getElementById('combo');
    		    	        		Ext.Ajax.request( {
        		    					url: Ext.SF_SCRIPT_NAME + '/stProductOptionsBackend/useTemplate',
        		    					params: { optionId: selected.id, template: combo.value},
        		    					success: function(response) {
        		    						selected.attributes.expandable = true;
        		    						selected.attributes.isLeaf = false;
        		    						selected.reload();
        		    					}
        		    				});
    		    	        		w.close();
    		    	            }
    		    	        },{
    		    	            text: params['tpl_cancel_label'],
    		    	            handler: function ()
    		    	            {
    		    	            	w.close();
    		    	            }
    		    	        }]
    		    	    });
    		    	    w.show();
                	}
    		    }
                
                ]
            });
                        
            var Tree = Ext.tree;

            tree = new Tree.TreePanel(
            {
                el: 'st_product_options-tree-' + root_id,
                autoScroll: true,
                animate: animated,
                enableDD: editable,
				rootVisible: true,
                containerScroll: container_scroll,
                autoScroll: container_scroll,
                autoHeight: !container_scroll,
                border: false,
                shadow: false,
                bodyBorder: false,
                useArrows: true,
                tbar: editable ? tb : null,
                nodeUiProvider: Ext.tree.stTreeNodeUI,
                loader: new Tree.TreeLoader(
                { 
                    dataUrl: Ext.SF_SCRIPT_NAME + '/' + module_name + '/fetchProductOptionValues?root_id=' + root_id,
					baseParams : {model: model, parent_id:null, field:null, language:culture},
                    baseAttrs: {
                        uiProvider: ui_provider,
                    }
                }),
            });
			
            
            // set the root node
            var root = new Tree.AsyncTreeNode(
            {
                text: root_name,
                cls: 'st_product_options-tree-root',
                id: root_id,
            });   

            tree.setRootNode(root);

			// set additional parameters to POST while expanding tree
			tree.on('beforeload', function (node)
			{
				tree.loader.baseParams.parent_id = node.parentNode!=null ? node.parentNode.id : null;
				tree.loader.baseParams.field = node.attributes.field;
			});
			
			// expands first product_options after load
			tree.on('load', function (node)
			{
			   if(node == root)
			   {
			       // node.expandChildNodes();
			   } 
			});
			
			tree.on('beforecollapsenode', function (node, deep, anim)
			{
                node.fireEvent('click', node);
                return true;
			});
						
			// changes 3rd button text when any node expanded
			tree.on('beforeexpandnode', function (node, deep, anim)
			{
			    tb.items.item(2).setText(params['fold_button_label']);
			    
                node.fireEvent('click', node);
			    return true;
			});

            tree.on('textchange', function (node, value, old_value)
            {
                if (value != old_value)
                {
                    Ext.Ajax.request({
                        url: Ext.SF_SCRIPT_NAME + '/' + module_name + '/changeProductOptionValue',
                        params: {model: model, value: value, id: node.id, field: node.attributes.field, firstEdit: node.attributes.backEdit, language: node.attributes.language }
                    });
                }
				node.attributes.backEdit = false;
				if($('product_option_value'))
				{
				    $('product_option_value').value = value;
				}
				if($('field_name'))
				{
				    $('field_name').value = value;
				}
            });
                        
            if (editable)
            {
                tree.on('click', function (node, e)
                {
                    if (node.isRoot)
                    {
                        tb.items.item(1).setDisabled(true);

                    }
                    else
                    {
                        tb.items.item(1).setDisabled(false);
                    }
                    
                    tb.items.item(3).setDisabled(node.getDepth()%2);
                    
                    // aktualizowanie formularza
                    if(node.isRoot)
                    {
                        new Ajax.Updater('st_product_options-tree_edit',
                                    Ext.SF_SCRIPT_NAME + '/stProductOptionsBackend/showRoot',
                                    {asynchronous:true, evalScripts:false, parameters: {model: model, product_option_id: node.id, language:culture} });
                    }
                    else if(!node.attributes.field)
                    {
                        new Ajax.Updater('st_product_options-tree_edit',
                                    Ext.SF_SCRIPT_NAME + '/stProductOptionsBackend/showOption',
                                    {asynchronous:true, evalScripts:true, onComplete:function(){$('product_option_value').focus();}, 
                                        parameters: {model: model, product_option_id: node.id, language:culture} });
                    }
                    else
                    {
                        new Ajax.Updater('st_product_options-tree_edit',
                                    Ext.SF_SCRIPT_NAME + '/stProductOptionsBackend/showField',
                                    {asynchronous:true, evalScripts:false, onComplete:function(){$('field_name').focus();},
                                        parameters: {field_id: node.attributes.field, language:culture}});
                    }
                });
            }
                        
            tree.on('beforemovenode', function (tree, node, oldparent, new_parent, index)
            {
                if (oldparent.id == new_parent.id) {return true;} 
            	else {return false;}
                if(node.attributes.field != null)
                {
                    return false;
                }
                if(oldparent.attributes.field != null && new_parent.attributes.filed != null)
                {
                    return false;
                }
            });
             
            
            tree.on('enddrag', function (tree, node, event)
            {
                if(!node.attributes.field)
                {
                    new Ajax.Updater('st_product_options-tree_edit',
                                Ext.SF_SCRIPT_NAME + '/stProductOptionsBackend/showOption',
                                {asynchronous:true, evalScripts:true, onComplete:function(){$('product_option_value').focus();}, 
                                    parameters: {model: model, product_option_id: node.id} });
                }
                else
                {
                    new Ajax.Updater('st_product_options-tree_edit',
                                Ext.SF_SCRIPT_NAME + '/stProductOptionsBackend/showField',
                                {asynchronous:true, evalScripts:true, onComplete:function(){$('field_name').focus();},
                                    parameters: {field_id: node.attributes.field}});
                }                
            	
            });
            
            tree.on('movenode', function (tree, node, old_parent, new_parent, index)
            {

                if (node.previousSibling)
                {
                    prev_sibling_id = node.previousSibling.id;
                    prev_field_sibling_id =  node.previousSibling.attributes.field
                }
                else
                {
                    prev_sibling_id = 0;
                    prev_field_sibling_id = 0;
                }

                if (node.nextSibling)
                {
                    next_sibling_id = node.nextSibling.id;
                    next_field_sibling_id =  node.nextSibling.attributes.field
                }
                else
                {
                    next_sibling_id = 0;
                    next_field_sibling_id = 0;
                }

                Ext.Ajax.request(
                {
                    url: Ext.SF_SCRIPT_NAME + '/' + module_name + '/moveProductOption',
                    params: {model: model,prev_field_sibling_id: prev_field_sibling_id, prev_sibling_id: prev_sibling_id, next_field_sibling_id: next_field_sibling_id, next_sibling_id: next_sibling_id, old_parent_id: old_parent.id, new_parent_id: new_parent.id, id: node.id, field: node.attributes.field}
                });
                
            });

            // render the tree
            tree.render();
            root.expand();

            if (typeof Ext.attributesTree == 'undefined')
            {
               Ext.attributesTree = [];
            }

            Ext.attributesTree[root.id] = tree;

            if (model == 'ProductOptionsDefaultValue') {
            	tb.items.item(3).setVisible(false);
            }
          
            if (editable)
            {
                var ge = new Ext.tree.TreeEditor(tree,
                {
                    allowBlank: false,
                    blankText: 'Musisz podać wartość',
                    selectOnFocus:true,
                    cancelOnEsc: true,
                    editDelay: 500
                });
            }
        },
        
        // returning created tree
        get : function ()
        {
            return tree;
        },
        
        unselect : function()
        {
            tree.getRootNode().fireEvent('click', root);
        },
        
        // finds and expands node for given id
        showNode : function (node_id)
        {
            node = tree.getNodeById(node_id);
            if(node)
            {
                tree.expandPath(node.getPath());
                node.fireEvent('click', node);
            }
            else
            {
                tree.getRootNode().expand(true);
                tree.collapseAll();
                
                tree.on('beforeexpandnode', function (node, deep, anim)
    			{
    			    if(deep)
    			    {
                        node = tree.getNodeById(node_id);
                        if(node)
                        {
                            tree.collapseAll();
                            tree.expandPath(node.getPath());
                            node.fireEvent('click', node);
                            return false;
                        }
    		        }
    			});
            }
        }
    };
}();

Ext.tree.stTreeNodeUI = Ext.extend(Ext.tree.TreeNodeUI, {	
    updateExpandIcon : function()
	{
        if(this.rendered){
            var n = this.node, c1, c2;
            var cls = n.isLast() ? "x-tree-elbow-end" : "x-tree-elbow";
            var hasChild = n.hasChildNodes();
            if(hasChild || n.attributes.expandable)
			{
                if(n.expanded){
                    cls += "-minus";
                    c1 = "x-tree-node-collapsed";
                    c2 = "x-tree-node-expanded";
                }else{
                    cls += "-plus";
                    c1 = "x-tree-node-expanded";
                    c2 = "x-tree-node-collapsed";
                }
                if(this.wasLeaf){
                    this.removeClass("x-tree-node-leaf");
                    this.wasLeaf = false;
                }
                if(this.c1 != c1 || this.c2 != c2){
                    Ext.fly(this.elNode).replaceClass(c1, c2);
                    this.c1 = c1; this.c2 = c2;
                }
            }else{
                if(!this.wasLeaf){
                    Ext.fly(this.elNode).replaceClass("x-tree-node-expanded", "x-tree-node-collapsed");
                    //                    delete this.c1;
                    //                    delete this.c2;
                    this.wasLeaf = false;
                }
            }
            var ecc = "x-tree-ec-icon "+cls;
            if(this.ecc != ecc){
                this.ecNode.className = ecc;
                this.ecc = ecc;
            }
        }
    }
});

function postSubmitForm(request, json, tree, params)
{
    $('product_options_template-visible_button').style.backgroundImage = 'url(/images/backend/icons/save.png)';
    $('product_options_template-visible_button').firstChild.nodeValue = params['save_title'];
    $('product_options_template-visible_button_up').style.backgroundImage = 'url(/images/backend/icons/save.png)';
    $('product_options_template-visible_button_up').firstChild.nodeValue = params['save_title'];

    errors_to_clear.each(function(error)
        {
            error.parentNode.removeClassName('form-error');
            error.hide();
        });
    
    errors_to_clear.clear();
    
    if (!json)
    {
        //if you don't use the json tips then evaluate the renderedText instead
        json = eval('(' + request.responseText + ')');
    }

    var errors = json.errors;
	var values = json.values;
    errors.each(function(error)
        {
            if(error.msg)
            {
                errors_to_clear.push($(error.id));                
                $(error.id).parentNode.addClassName('form-error');
                $(error.id).show();
                $(error.id).innerHTML = '↓&nbsp;' + error.msg + '&nbsp;↓';
            }
            
            if(error.value)
            {
                $(error.id).setValue(error.value);
            }
        });

    values.each(function(value)
    		{
        		if ($(value.id)) $(value.id).setValue(value.value);
    		});

    if(errors.size() == 0)
    {        
        if($('field_name')!=null)
        {
            tree.getSelectionModel().getSelectedNode().setText($('field_name').value);
    	}
    	else if($('product_option_value')!=null)
    	{
    	    tree.getSelectionModel().getSelectedNode().setText($('product_option_value').value);
    	}
    	
    	$('top_green').show();
    }
    
}
