<?php
ini_set('magic_quotes_runtime', '');
ini_set('log_errors', '1');
ini_set('arg_separator.output', '&amp;');


@include('./.profile.php');

if (defined('ST_ROOT_DIR'))
{
   $sf_root_dir = dirname(__FILE__) . DIRECTORY_SEPARATOR . ST_ROOT_DIR;
}
else
{
   $sf_root_dir = dirname(__FILE__) . DIRECTORY_SEPARATOR . '..';
}

require $sf_root_dir . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.php';

require $sf_symfony_lib_dir . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'sfConfig.class.php';

sfConfig::add(array('sf_root_dir' => $sf_root_dir, 'sf_app' => 'frontend', 'sf_enviroment' => 'prod'));

require $sf_symfony_data_dir . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'constants.php';

require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'sfAssetsLibraryPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'sfAssetsLibraryTools.class.php';

$type = isset($_GET['t']) ? $_GET['t'] : null;

$image = $_GET['i'];

$source = sfConfig::get('sf_web_dir') . DIRECTORY_SEPARATOR . $image;

if (!is_file($source))
{
   $source = sfConfig::get('sf_web_dir') . DIRECTORY_SEPARATOR . 'media/shares/no_image.png';

   header("HTTP/1.0 404 Not Found");
}

$target = sfAssetsLibraryTools::getThumbnailPath(dirname($image), basename($image), $type);

$config_file = sfConfig::get('sf_data_dir') . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . '__stAsset.yml';

if (is_file($config_file))
{
   $config_time = filemtime($config_file);
}
else
{
   require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'stConfigPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'stConfig.class.php';

   require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'stConfigPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'sfYaml' . DIRECTORY_SEPARATOR . 'sfYamlParser.php';

   require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'stConfigPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'sfYaml' . DIRECTORY_SEPARATOR . 'sfYamlDumper.php';

   require $sf_symfony_lib_dir . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR . 'sfCache.class.php';

   require $sf_symfony_lib_dir . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR . 'sfFileCache.class.php';

   stConfig::getInstance(null, 'stAsset')->save(true);

   $config_time = time();
}

$time_from = max(array(filemtime($source), $config_time));

if (!$type || !is_file($target) || $time_from > filemtime($target))
{

   require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'sfThumbnailPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'sfThumbnail.class.php';

   require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'sfThumbnailPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'sfGDAdapter.class.php';

   require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'sfThumbnailPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'stGDAdapter.class.php';

   if (!class_exists('stConfig', false))
   {
      require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'stConfigPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'stConfig.class.php';

      require sfConfig::get('sf_plugins_dir') . DIRECTORY_SEPARATOR . 'stConfigPlugin' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'sfYaml' . DIRECTORY_SEPARATOR . 'sfYamlParser.php';

      require $sf_symfony_lib_dir . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR . 'sfCache.class.php';

      require $sf_symfony_lib_dir . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR . 'sfFileCache.class.php';
   }
   
   $params = array();

   if (!$type)
   {
      $params['width'] = intval($_GET['w']);

      $params['height'] = intval($_GET['h']);

      $params['quality'] = isset($_GET['q']) ? intval($_GET['q']) : 75;

      $params['auto_crop'] = isset($_GET['ac']) ? intval($_GET['ac']) : false;

      $params['watermark']['text'] = $_GET['wt'];

      $params['watermark']['position'] = $_GET['wp'];

      $params['watermark']['color'] = $_GET['wc'];

      $params['watermark']['alpha'] = intval($_GET['wa']);

      $params['watermark']['size'] = intval($_GET['ws']);

      $params['watermark']['font'] = $_GET['wf'];

      $cache = false;
   }
   else
   {
      $cache = isset($_GET['cache']) ? $_GET['cache'] : true;

      $for = $_GET['f'];

      $config = stConfig::getInstance(null, 'stAsset');

      $tmp = $config->get($for, array());

      if (!isset($tmp[$type]))
      {
         throw new sfException(sprintf('The type "%s" does not exist', $type));
      }

      $params = $tmp[$type];

      if (isset($params['watermark']) && $params['watermark'])
      {
         $params['watermark'] = $config->get('watermark');
      }
   }

   if (!$cache)
   {
      $target = null;
   }

   $thumbnail = sfThumbnail::create($source, $target, $params);

   header('Content-Type: ' . $thumbnail->getMime(), true);

   header('Expires: 0');

   header('Cache-Control: must-revalidate, post-check=0, pre-check=0');

   header('Pragma: public');

   echo $thumbnail;
}
else
{

   $info = getimagesize($target);

   header('Content-Type: ' . image_type_to_mime_type($info[2]), true);

   header('Expires: 0');

   header('Cache-Control: must-revalidate, post-check=0, pre-check=0');

   header('Pragma: public');

   readfile($target);
}