<?php

namespace gchart;


class gBarChart extends gChart
{
    
    public function __construct($width = 200, $height = 200, $type = 'g', $direction='v')
    {
        $this->setChartType($type, $direction);
        $this->setDimensions($width, $height);
    }
    protected function setChartType($type, $direction)
    {
        $this-> setProperty('cht', 'b'.$direction.$type);
    }
    public function getUrl()
    {
        $retStr = parent::getUrl();
        return $retStr;
    }
    
    public function setBarWidth($barWidth, $spaceBetweenBars = 4,$spaceBetweenGroups = 8)
    {
        $this->setProperty('chbh', $this->encodeData(array($barWidth, $spaceBetweenBars,$spaceBetweenGroups), ','));
    }
    
    public function setAutoBarWidth()
    {
        $this->setProperty('chbh', 'a');
    }
    
    public function setBarScale($barScale = 'a', $spaceBetweenBars = '4',$spaceBetweenGroups = '8')
    {
        $this->setProperty('chbh', $this->encodeData(array($barScale, $spaceBetweenBars,$spaceBetweenGroups), ','));
    }
    
    public function addColors($colors)
    {
        $this->setProperty('chco', $this->encodeData($colors, "|"), true, ",");
    }
}?>
