<?php

namespace gchart;
class gMapChart extends gChart
{
    
    function __construct($width = 440, $height = 220)
    {
        $this->setDimensions($width, $height);
        $this->setProperty('cht','t');
    }

    
    public function setZoomArea($zoomArea)
    {
        $this->setProperty('chtm', $zoomArea);
    }
    
    public function setStateCodes($stateCodes)
    {
        $this->setProperty('chld', $this->encodeData($stateCodes, ''));
    }
    
    public function setColors($defaultColor)
    {
        $gradientColors = (func_num_args() > 1) ? func_get_arg(1) : array('0000FF', 'FF0000');
        $this->setProperty('chco', $this->encodeData(array_merge(array($defaultColor), $gradientColors), ','));
    }

    public function getApplicableLabels($labels)
    {
        return array_splice($labels, 0, count($this->values[0]));
    }
}?>
