<?php

namespace gchart;
class gPieChart extends gChart
{
    public function __construct($width = 350, $height = 200)
    {
        $this->setProperty('cht', 'p');
        $this->setDimensions($width, $height);
    }
    public function getApplicableLabels($labels)
    {
        return array_splice($labels, 0, count($this->values[0]));
    }
    public function set3D($is3d = true, $resize = true)
    {
        if($is3d)
        {
            $this->setProperty('cht', 'p3');
            if ($resize)
                $this->setDimensions($this->getWidth() * 1.5, $this->getHeight());
        }
        else
        {
            $this->setProperty('cht', 'p');
            if ($resize)
                $this->setDimensions($this->getWidth() / 1.5, $this->getHeight());
        }
    }
    
    public function setLabels($labels)
    {
        $this->setProperty('chl', urlencode($this->encodeData($this->getApplicableLabels($labels),"|")));
    }
    
    public function setRotation($angle, $degree = false)
    {
        if ($degree)
            $angle = ($angle / 360) * 6.2831;
        $this->setProperty('chp', $angle);
    }
    
    public function setColors($colors)
    {
        $this->setProperty('chco', $this->encodeData($this->getApplicableLabels($colors), "|"), true);
    }
    
    public function addColors($colors)
    {
        $this->setProperty('chco', $this->encodeData($colors, "|"), true, ",");
    }
}?>
