<?php
/*
	[CTB] (C) 2007-2009 copytaobao.com
	$Id: function_common.php 2009-4-15 23:32:55 jerry $
*/

!defined('IN_CTB') && die('Access Denied');

//pothtmlʱд
function srawurlencode($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = srawurlencode($val);
		}
	} else {
		$string = rawurlencode($string);
	}
	return $string;
}

//SQL ADDSLASHES
function saddslashes($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = saddslashes($val);
		}
	} else {
		$string = addslashes($string);
	}
	return $string;
}

//ȡHTML
function shtmlspecialchars($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = shtmlspecialchars($val);
		}
	} else {
		$string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1',
			str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $string));
	}
	return $string;
}

//ַܼ
function authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {

	$ckey_length = 4;	// Կ ȡֵ 0-32;
				// ԿκιɣԭĺԿȫͬܽҲÿβͬƽѶȡ
				// ȡֵԽı䶯Խı仯 = 16  $ckey_length η
				// ֵΪ 0 ʱ򲻲Կ

	$key = md5($key ? $key : UC_KEY);
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {
		return $keyc.str_replace('=', '', base64_encode($result));
	}
}

//cookie
function clearcookie() {
	global $_TGLOBAL;

	ssetcookie('auth', '', -86400 * 365);
	$_TGLOBAL['ctb_uid'] = 0;
	$_TGLOBAL['ctb_username'] = '';
	$_TGLOBAL['member'] = array();
}

//cookie
function ssetcookie($var, $value, $life=0) {
	global $_TGLOBAL, $_CTB, $_SERVER;
	setcookie($_CTB['cookiepre'].$var, $value, $life?($_TGLOBAL['timestamp']+$life):0, $_CTB['cookiepath'], $_CTB['cookiedomain'], $_SERVER['SERVER_PORT']==443?1:0);
}

//ݿ
function dbconnect() {
	global $_TGLOBAL, $_CTB;

	include_once(S_ROOT.'./source/class_mysql.php');

	if(empty($_TGLOBAL['db'])) {
		$_TGLOBAL['db'] = new db;
		$_TGLOBAL['db']->charset = $_CTB['dbcharset'];
		$_TGLOBAL['db']->connect($_CTB['dbhost'], $_CTB['dbuser'], $_CTB['dbpassword'], $_CTB['dbname'], $_CTB['pconnect']);
	}
}

//ȡIP
function getonlineip($format=0) {
	global $_TGLOBAL;

	if(empty($_TGLOBAL['onlineip'])) {
		if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
			$onlineip = getenv('HTTP_CLIENT_IP');
		} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
			$onlineip = getenv('HTTP_X_FORWARDED_FOR');
		} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
			$onlineip = getenv('REMOTE_ADDR');
		} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
			$onlineip = $_SERVER['REMOTE_ADDR'];
		}
		preg_match("/[\d\.]{7,15}/", $onlineip, $onlineipmatches);
		$_TGLOBAL['onlineip'] = $onlineipmatches[0] ? $onlineipmatches[0] : 'unknown';
	}
	if($format) {
		$ips = explode('.', $_TGLOBAL['onlineip']);
		for($i=0;$i<3;$i++) {
			$ips[$i] = intval($ips[$i]);
		}
		return sprintf('%03d%03d%03d', $ips[0], $ips[1], $ips[2]);
	} else {
		return $_TGLOBAL['onlineip'];
	}
}

//жϵǰû¼״̬
function checkauth() {
	global $_TGLOBAL, $_CTB, $_TCONFIG, $_TCOOKIE, $_SN;

	if($_TCOOKIE['auth']) {
		@list($password, $uid) = explode("\t", authcode($_TCOOKIE['auth'], 'DECODE'));
		$_TGLOBAL['ctb_uid'] = intval($uid);
		if($_TGLOBAL['ctb_uid']) {
			$query = $_TGLOBAL['db']->query("SELECT * FROM ".tname('session')." WHERE userid='$_TGLOBAL[ctb_uid]' AND password='$password'");
			if($member = $_TGLOBAL['db']->fetch_array($query)) {
				$_TGLOBAL['ctb_username'] = addslashes($member['username']);
				$_TGLOBAL['session'] = $member;
			} else {
				$query = $_TGLOBAL['db']->query("SELECT username, usertype FROM ".tname('members')." WHERE uid='$_TGLOBAL[ctb_uid]' AND password='$password'");
				if($member = $_TGLOBAL['db']->fetch_array($query)) {
					$_TGLOBAL['ctb_username'] = addslashes($member['username']);
					$_TGLOBAL['ctb_usertype'] = addslashes($member['usertype']);
					insertsession(array('userid' => $_TGLOBAL['ctb_uid'], 'username' => $_TGLOBAL['ctb_username'], 'password' => $password));//¼
				} else {
					$_TGLOBAL['ctb_uid'] = 0;
				}
			}
		}
	}
	//!$_TGLOBAL['ctb_nickname'] && nickname_get(); //ctb_nicknameΪգȡ
	if(empty($_TGLOBAL['ctb_uid'])) {
		clearcookie();
	} else {
		$_TGLOBAL['username'] = $member['username'];
	}
}

//ȡ
function tname($name) {
	global $_CTB;
	return $_CTB['tablepre'].$name;
}

//Ի
function showmessage($msgkey, $url_forward='', $second=1, $values=array()) {
	global $_TGLOBAL, $_CTB, $_TCONFIG, $_TPL, $_SN;
	
	obclean();
	
	//ȥ
	$_TGLOBAL['ad'] = array();

	if(empty($_TGLOBAL['inajax']) && $url_forward && empty($second)) {
		header("HTTP/1.1 301 Moved Permanently");
		header("Location: $url_forward");
	} else {
		include_once(S_ROOT.'./language/lang_showmessage.php');
		if(isset($_TGLOBAL['msglang'][$msgkey])) {
			$message = lang_replace($_TGLOBAL['msglang'][$msgkey], $values);
		} else {
			$message = $msgkey;
		}
		if($_TGLOBAL['inajax']) {
			if($url_forward) {
				$message = "<a href=\"$url_forward\">$message</a><ajaxok>";
			}
			if($_GET['popupmenu_box']) {
				$message = "<h1>&nbsp;</h1><a href=\"javascript:;\" onclick=\"hideMenu();\" class=\"float_del\">X</a><div class=\"popupmenu_inner\">$message</div>";
			}
			echo $message;
			ob_out();
		} else {
			if($url_forward) {
				$message = "<a href=\"$url_forward\">$message</a><script>setTimeout(\"window.location.href ='$url_forward';\", ".($second*1000).");</script>";
			}
			echo template('showmessage', get_defined_vars());
		}
	}
	exit();
}

//жύǷȷ
function submitcheck($var) {
	if(!empty($_POST[$var]) && $_SERVER['REQUEST_METHOD'] == 'POST') {
		if((empty($_SERVER['HTTP_REFERER']) || preg_replace("/https?:\/\/([^\:\/]+).*/i", "\\1", $_SERVER['HTTP_REFERER']) == preg_replace("/([^\:]+).*/", "\\1", $_SERVER['HTTP_HOST'])) && $_POST['formhash'] == formhash()) {
			return true;
		} else {
			showmessage('submit_invalid');
		}
	} else {
		return false;
	}
}

//
function inserttable($tablename, $insertsqlarr, $returnid=0, $replace = false, $silent=0) {
	global $_TGLOBAL;

	$insertkeysql = $insertvaluesql = $comma = '';
	foreach ($insertsqlarr as $insert_key => $insert_value) {
		$insertkeysql .= $comma.'`'.$insert_key.'`';
		$insertvaluesql .= $comma.'\''.$insert_value.'\'';
		$comma = ', ';
	}
	$method = $replace?'REPLACE':'INSERT';
	$_TGLOBAL['db']->query($method.' INTO '.tname($tablename).' ('.$insertkeysql.') VALUES ('.$insertvaluesql.')', $silent?'SILENT':'');
	if($returnid && !$replace) {
		return $_TGLOBAL['db']->insert_id();
	}
}

//
function updatetable($tablename, $setsqlarr, $wheresqlarr, $silent=0) {
	global $_TGLOBAL;

	$setsql = $comma = '';
	foreach ($setsqlarr as $set_key => $set_value) {
		$setsql .= $comma.'`'.$set_key.'`'.'=\''.$set_value.'\'';
		$comma = ', ';
	}
	$where = $comma = '';
	if(empty($wheresqlarr)) {
		$where = '1';
	} elseif(is_array($wheresqlarr)) {
		foreach ($wheresqlarr as $key => $value) {
			$where .= $comma.'`'.$key.'`'.'=\''.$value.'\'';
			$comma = ' AND ';
		}
	} else {
		$where = $wheresqlarr;
	}
	$_TGLOBAL['db']->query('UPDATE '.tname($tablename).' SET '.$setsql.' WHERE '.$where, $silent?'SILENT':'');
}

//д־
function runlog($file, $log, $halt=0) {
	global $_TGLOBAL, $_SERVER;
	
	$nowurl = $_SERVER['REQUEST_URI']?$_SERVER['REQUEST_URI']:($_SERVER['PHP_SELF']?$_SERVER['PHP_SELF']:$_SERVER['SCRIPT_NAME']);
	$log = sgmdate('Y-m-d H:i:s', $_TGLOBAL['timestamp'])."\t$type\t".getonlineip()."\t$_TGLOBAL[ctb_uid]\t{$nowurl}\t".str_replace(array("\r", "\n"), array(' ', ' '), trim($log))."\n";
	$yearmonth = sgmdate('Ym', $_TGLOBAL['timestamp']);
	$logdir = './data/log/';
	if(!is_dir($logdir)) mkdir($logdir, 0777);
	$logfile = S_ROOT.$logdir.$yearmonth.'_'.$file.'.php';
	if(@filesize($logfile) > 2048000) {
		$dir = opendir($logdir);
		$length = strlen($file);
		$maxid = $id = 0;
		while($entry = readdir($dir)) {
			if(strexists($entry, $yearmonth.'_'.$file)) {
				$id = intval(substr($entry, $length + 8, -4));
				$id > $maxid && $maxid = $id;
			}
		}
		closedir($dir);
		$logfilebak = $logdir.$yearmonth.'_'.$file.'_'.($maxid + 1).'.php';
		@rename($logfile, $logfilebak);
	}
	if($fp = @fopen($logfile, 'a')) {
		@flock($fp, 2);
		fwrite($fp, "<?PHP exit;?>\t".str_replace(array('<?', '?>', "\r", "\n"), '', $log)."\n");
		fclose($fp);
	}
	if($halt) exit();
}

//ȡַ
function getstr($string, $length, $in_slashes=0, $out_slashes=0, $censor=0, $bbcode=0, $html=0) {
	global $_CTB, $_TGLOBAL;

	$string = trim($string);

	if($in_slashes) {
		//ַslashes
		$string = sstripslashes($string);
	}
	if($html < 0) {
		//ȥhtmlǩ
		$string = preg_replace("/(\<[^\<]*\>|\r|\n|\s|\[.+?\])/is", ' ', $string);
		$string = shtmlspecialchars($string);
	} elseif ($html == 0) {
		//תhtmlǩ
		$string = shtmlspecialchars($string);
	}
	if($censor) {
		//
		@include_once(S_ROOT.'./data/data_censor.php');
		if($_TGLOBAL['censor']['banned'] && preg_match($_TGLOBAL['censor']['banned'], $string)) {
			showmessage('information_contains_the_shielding_text');
		} else {
			$string = empty($_TGLOBAL['censor']['filter']) ? $string :
				@preg_replace($_TGLOBAL['censor']['filter']['find'], $_TGLOBAL['censor']['filter']['replace'], $string);
		}
	}
	if($length && strlen($string) > $length) {
		//ضַ
		$wordscut = '';
		if(strtolower($_CTB['charset']) == 'utf-8') {
			//utf8
			$n = 0;
			$tn = 0;
			$noc = 0;
			while ($n < strlen($string)) {
				$t = ord($string[$n]);
				if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
					$tn = 1;
					$n++;
					$noc++;
				} elseif(194 <= $t && $t <= 223) {
					$tn = 2;
					$n += 2;
					$noc += 2;
				} elseif(224 <= $t && $t < 239) {
					$tn = 3;
					$n += 3;
					$noc += 2;
				} elseif(240 <= $t && $t <= 247) {
					$tn = 4;
					$n += 4;
					$noc += 2;
				} elseif(248 <= $t && $t <= 251) {
					$tn = 5;
					$n += 5;
					$noc += 2;
				} elseif($t == 252 || $t == 253) {
					$tn = 6;
					$n += 6;
					$noc += 2;
				} else {
					$n++;
				}
				if ($noc >= $length) {
					break;
				}
			}
			if ($noc > $length) {
				$n -= $tn;
			}
			$wordscut = substr($string, 0, $n);
		} else {
			for($i = 0; $i < $length - 1; $i++) {
				if(ord($string[$i]) > 127) {
					$wordscut .= $string[$i].$string[$i + 1];
					$i++;
				} else {
					$wordscut .= $string[$i];
				}
			}
		}
		$string = $wordscut;
	}
	if($bbcode) {
		include_once(S_ROOT.'./source/function_bbcode.php');
		$string = bbcode($string, $bbcode);
	}
	if($out_slashes) {
		$string = saddslashes($string);
	}
	return trim($string);
}

//ʱʽ
function sgmdate($dateformat, $timestamp='', $format=0) {
	global $_TCONFIG, $_TGLOBAL;
	if(empty($timestamp)) {
		$timestamp = $_TGLOBAL['timestamp'];
	}
	$result = '';
	if($format) {
		$time = $_TGLOBAL['timestamp'] - $timestamp;
		if($time > 24*3600) {
			$result = gmdate($dateformat, $timestamp + $_TGLOBAL['setting']['timeoffset'] * 3600);
		} elseif ($time > 3600) {
			$result = intval($time/3600).lang('hour').lang('before');
		} elseif ($time > 60) {
			$result = intval($time/60).lang('minute').lang('before');
		} elseif ($time > 0) {
			$result = $time.lang('second').lang('before');
		} else {
			$result = lang('now');
		}
	} else {
		$result = gmdate($dateformat, $timestamp + $_TGLOBAL['setting']['timeoffset'] * 3600);
	}
	return $result;
}

//ַʱ仯
function sstrtotime($string) {
	global $_TGLOBAL, $_TCONFIG;
	$time = '';
	if($string) {
		$time = strtotime($string);
		if(sgmdate('H:i') != date('H:i')) {
			$time = $time - $_TGLOBAL['setting']['timeoffset'] * 3600;
		}
	}
	return $time;
}

//ҳ
function multi($num, $perpage, $curpage, $mpurl) {
	global $_TCONFIG;
	$page = 10;
	$multipage = '';
	$mpurl .= strpos($mpurl, '?') ? '&' : '?';
	$realpages = 1;
	if($num > $perpage) {
		$offset = 2;
		$realpages = @ceil($num / $perpage);
		$pages = $_TCONFIG['maxpage'] && $_TCONFIG['maxpage'] < $realpages ? $_TCONFIG['maxpage'] : $realpages;
		if($page > $pages) {
			$from = 1;
			$to = $pages;
		} else {
			$from = $curpage - $offset;
			$to = $from + $page - 1;
			if($from < 1) {
				$to = $curpage + 1 - $from;
				$from = 1;
				if($to - $from < $page) {
					$to = $page;
				}
			} elseif($to > $pages) {
				$from = $pages - $page + 1;
				$to = $pages;
			}
		}
		$multipage = ($curpage - $offset > 1 && $pages > $page ? '<a href="'.$mpurl.'page=1" class="first">1 ...</a>' : '').
			($curpage > 1 ? '<a href="'.$mpurl.'page='.($curpage - 1).'" class="prev">&lsaquo;&lsaquo;</a>' : '');
		for($i = $from; $i <= $to; $i++) {
			//$multipage .= $i == $curpage ? '<strong>'.$i.'</strong>' :
			$multipage .= $i == $curpage ? '<a href="'.$mpurl.'page='.$curpage.'"  target="_self" class="on">'.$i.'</a>' :
				'<a href="'.$mpurl.'page='.$i.'">'.$i.'</a>';
		}
		$multipage .= ($curpage < $pages ? '<a href="'.$mpurl.'page='.($curpage + 1).'" class="next">&rsaquo;&rsaquo;</a>' : '').
			($to < $pages ? '<a href="'.$mpurl.'page='.$pages.'" class="last">... '.$realpages.'</a>' : '');
		$multipage = $multipage ? ('&nbsp;'.$num.'&nbsp;'.$multipage):'';
	}
	$maxpage = $realpages;
	return $multipage;
}

//ob
function obclean() {
	global $_CTB;

	ob_end_clean();
	if ($_CTB['gzipcompress'] && function_exists('ob_gzhandler')) {
		ob_start('ob_gzhandler');
	} else {
		ob_start();
	}
}

//ģ
function template($name, $values=array()) {
	global $_TCONFIG, $_TGLOBAL;

	if(strexists($name,'/')) {
		$tpl = $name;
	} else {
		$tpl = "$name.html";
	}

	include_once(S_ROOT.'./include/smarty/Smarty.class.php');

	if(empty($_TGLOBAL['tpl'])) {
		$_TGLOBAL['tpl'] = new Smarty;
		$_TGLOBAL['tpl']->template_dir		= S_ROOT."template/$_TCONFIG[template]/";
		$_TGLOBAL['tpl']->compile_dir		= S_ROOT.'./data/tpl_cache/';
		$_TGLOBAL['tpl']->confit_dir		= S_ROOT.'./include/smarty/config/';
		$_TGLOBAL['tpl']->cache_dir			= S_ROOT.'./data/cache/';
		$_TGLOBAL['tpl']->caching			= 0;	//
		$_TGLOBAL['tpl']->cache_lifetime    = 7200; //ʱ 2Сʱ 7200
		$_TGLOBAL['tpl']->left_delimiter    = '{/';
		$_TGLOBAL['tpl']->right_delimiter   = '/}';

	}
	$_TGLOBAL['tpl']->assign($values);
	$objfile = $_TGLOBAL['tpl']->fetch($tpl);

	$objfile = str_replace('image/', "template/$_TCONFIG[template]/image/", $objfile); //滻еͼƬ·Ϊǰģµ
	
	$objfile = str_replace('<link href="style/', "<link href=\"template/$_TCONFIG[template]/style/", $objfile); //滻cssļΪǰģµ 
	
	//滻ʾе·
	$objfile = str_replace('../upload/', './upload/', $objfile);
	$objfile = str_replace('../../../', '', $objfile);

	return $objfile;
}

//ȡĿ
function getcount($tablename, $wherearr, $get='COUNT(*)') {
	global $_TGLOBAL;
	if(empty($wherearr)) {
		$wheresql = '1';
	} else {
		if (is_array($wherearr)) { //Ϊʱ
			$wheresql = $mod = '';
			foreach ($wherearr as $key => $value) {
				$wheresql .= $mod."`$key`='$value'";
				$mod = ' AND ';
			}
		} else {
			$wheresql = $wherearr;
		}
	}
	return $_TGLOBAL['db']->result($_TGLOBAL['db']->query("SELECT $get FROM ".tname($tablename)." WHERE $wheresql LIMIT 1"), 0);
}

//ַ
function simplode($ids) {
	return "'".implode("','", $ids)."'";
}

//ʾ̴ʱ
function debuginfo() {
	global $_TGLOBAL, $_CTB, $_TCONFIG;

	if(empty($_TCONFIG['debuginfo'])) {
		$info = '';
	} else {
		$mtime = explode(' ', microtime());
		$totaltime = number_format(($mtime[1] + $mtime[0] - $_TGLOBAL['ctb_starttime']), 6);
		$info = 'Processed in '.$totaltime.' second(s), '.$_TGLOBAL['db']->querynum.' queries'.
				($_CTB['gzipcompress'] ? ', Gzip enabled' : NULL);
	}

	return $info;
}

//ʽС
function formatsize($size) {
	$prec=3;
	$size = round(abs($size));
	$units = array(0=>" B ", 1=>" KB", 2=>" MB", 3=>" GB", 4=>" TB");
	if ($size==0) return str_repeat(" ", $prec)."0$units[0]";
	$unit = min(4, floor(log($size)/log(2)/10));
	$size = $size * pow(2, -10*$unit);
	$digi = $prec - 1 - floor(log($size)/log(10));
	$size = round($size * pow(10, $digi)) * pow(10, -$digi);
	return $size.$units[$unit];
}

//ȡļ
function sreadfile($filename) {
	$content = '';
	if(function_exists('file_get_contents')) {
		@$content = file_get_contents($filename);
	} else {
		if(@$fp = fopen($filename, 'r')) {
			@$content = fread($fp, filesize($filename));
			@fclose($fp);
		}
	}
	return $content;
}

//дļ
function swritefile($filename, $writetext, $openmod='w') {
	if(@$fp = fopen($filename, $openmod)) {
		flock($fp, 2);
		fwrite($fp, $writetext);
		fclose($fp);
		return true;
	} else {
		runlog('error', "File: $filename write error.");
		return false;
	}
}

//ַ
function random($length, $numeric = 0) {
	PHP_VERSION < '4.2.0' ? mt_srand((double)microtime() * 1000000) : mt_srand();
	$seed = base_convert(md5(print_r($_SERVER, 1).microtime()), 16, $numeric ? 10 : 35);
	$seed = $numeric ? (str_replace('0', '', $seed).'012340567890') : ($seed.'zZ'.strtoupper($seed));
	$hash = '';
	$max = strlen($seed) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $seed[mt_rand(0, $max)];
	}
	return $hash;
}

//жַǷ
function strexists($haystack, $needle) {
	return !(strpos($haystack, $needle) === FALSE);
}

//ȡ
function data_get($var, $isarray=0) {
	global $_TGLOBAL;

	$query = $_TGLOBAL['db']->query("SELECT * FROM ".tname('data')." WHERE var='$var' LIMIT 1");
	if($value = $_TGLOBAL['db']->fetch_array($query)) {
		return $isarray?$value:$value['datavalue'];
	} else {
		return '';
	}
}

//
function data_set($var, $datavalue, $clean=0) {
	global $_TGLOBAL;

	if($clean) {
		$_TGLOBAL['db']->query("DELETE FROM ".tname('data')." WHERE var='$var'");
	} else {
		if(is_array($datavalue)) $datavalue = serialize(sstripslashes($datavalue));
		$_TGLOBAL['db']->query("REPLACE INTO ".tname('data')." (var, datavalue) VALUES ('$var', '".addslashes($datavalue)."')");
	}
}

//վǷر
function checkclose() {
	global $_TGLOBAL, $_TCONFIG;

	//վر
	if($_TCONFIG['close']) {
		if(empty($_TCONFIG['closereason'])) {
			showmessage('site_temporarily_closed');
		} else {
			showmessage($_TCONFIG['closereason']);
		}
	}
	//IPʼ
	if((!ipaccess($_TCONFIG['ipaccess']) || ipbanned($_TCONFIG['ipbanned']))) {
		showmessage('ip_is_not_allowed_to_visit');
	}
}

//վ
function getsiteurl() {
	global $_CTB;
	
	if(empty($_CTB['siteurl'])) {
		$uri = $_SERVER['REQUEST_URI'] ? $_SERVER['REQUEST_URI'] : ($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);
		return 'http://'.$_SERVER['HTTP_HOST'].substr($uri, 0, strrpos($uri, '/')+1);
	} else {
		return $_CTB['siteurl'];
	}
}

//ȡļ׺
function fileext($filename) {
	return strtolower(trim(substr(strrchr($filename, '.'), 1)));
}

//ȥslassh
function sstripslashes($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = sstripslashes($val);
		}
	} else {
		$string = stripslashes($string);
	}
	return $string;
}

//ת
function siconv($str, $out_charset, $in_charset='') {
	global $_CTB;

	$in_charset = empty($in_charset)?strtoupper($_CTB['charset']):strtoupper($in_charset);
	$out_charset = strtoupper($out_charset);
	if($in_charset != $out_charset) {
		if (function_exists('iconv') && (@$outstr = iconv("$in_charset//IGNORE", "$out_charset//IGNORE", $str))) {
			return $outstr;
		} elseif (function_exists('mb_convert_encoding') && (@$outstr = mb_convert_encoding($str, $out_charset, $in_charset))) {
			return $outstr;
		}
	}
	return $str;//תʧ
}

//ûʱ
function interval_check($type) {
	global $_TGLOBAL, $space;

	$intervalname = $type.'interval';
	$lastname = 'last'.$type;

	$waittime = 0;
	if($interval = checkperm($intervalname)) {
		$lasttime = isset($space[$lastname])?$space[$lastname]:getcount('space', array('uid'=>$_TGLOBAL['ctb_uid']), $lastname);
		$waittime = $interval - ($_TGLOBAL['timestamp'] - $lasttime);
	}
	return $waittime;
}

//ҳ
function smulti($start, $perpage, $count, $url, $ajaxdiv='') {
	global $_TGLOBAL;

	$multi = array('last'=>-1, 'next'=>-1, 'begin'=>-1, 'end'=>-1, 'html'=>'');
	if($start > 0) {
		if(empty($count)) {
			showmessage('no_data_pages');
		} else {
			$multi['last'] = $start - $perpage;
		}
	}

	$showhtml = 0;
	if($count == $perpage) {
		$multi['next'] = $start + $perpage;
	}
	$multi['begin'] = $start + 1;
	$multi['end'] = $start + $count;

	if($multi['begin'] >= 0) {
		if($multi['last'] >= 0) {
			$showhtml = 1;
			if($_TGLOBAL['inajax']) {
				$multi['html'] .= "<a href=\"javascript:;\" onclick=\"ajaxget('$url&ajaxdiv=$ajaxdiv', '$ajaxdiv')\">|&lt;</a> <a href=\"javascript:;\" onclick=\"ajaxget('$url&start=$multi[last]&ajaxdiv=$ajaxdiv', '$ajaxdiv')\">&lt;</a> ";
			} else {
				$multi['html'] .= "<a href=\"$url\">|&lt;</a> <a href=\"$url&start=$multi[last]\">&lt;</a> ";
			}
		} else {
			$multi['html'] .= "&lt;";
		}
		$multi['html'] .= " $multi[begin]~$multi[end] ";
		if($multi['next'] >= 0) {
			$showhtml = 1;
			if($_TGLOBAL['inajax']) {
				$multi['html'] .= " <a href=\"javascript:;\" onclick=\"ajaxget('$url&start=$multi[next]&ajaxdiv=$ajaxdiv', '$ajaxdiv')\">&gt;</a> ";
			} else {
				$multi['html'] .= " <a href=\"$url&start=$multi[next]\">&gt;</a>";
			}
		} else {
			$multi['html'] .= " &gt;";
		}
	}

	return $showhtml?$multi['html']:'';
}

//齨
function renum($array) {
	$newnums = $nums = array();
	foreach ($array as $id => $num) {
		$newnums[$num][] = $id;
		$nums[$num] = $num;
	}
	return array($nums, $newnums);
}

//ip
function ipaccess($ipaccess) {
	return empty($ipaccess)?true:preg_match("/^(".str_replace(array("\r\n", ' '), array('|', ''), preg_quote($ipaccess, '/')).")/", getonlineip());
}

//ipʽֹ
function ipbanned($ipbanned) {
	return empty($ipbanned)?false:preg_match("/^(".str_replace(array("\r\n", ' '), array('|', ''), preg_quote($ipbanned, '/')).")/", getonlineip());
}

//start
function ckstart($start, $perpage) {
	global $_TCONFIG;

	$maxstart = $perpage*intval($_TCONFIG['maxpage']);
	if($start < 0 || ($maxstart > 0 && $start >= $maxstart)) {
		showmessage('length_is_not_within_the_scope_of');
	}
}

//Ƿ¼
function checklogin() {
	global $_TGLOBAL, $_TCONFIG;

	if(empty($_TGLOBAL['ctb_uid'])) {
		ssetcookie('_refer', rawurlencode($_SERVER['REQUEST_URI']));
		showmessage('to_login', 'do.php?ac='.$_TCONFIG['login_action']);
	}
}

//ǰ̨
function lang($key, $vars=array()) {
	global $_TGLOBAL;

	include_once(S_ROOT.'./language/lang_source.php');
	if(isset($_TGLOBAL['sourcelang'][$key])) {
		$result = lang_replace($_TGLOBAL['sourcelang'][$key], $vars);
	} else {
		$result = $key;
	}
	return $result;
}

//ų́
function cplang($key, $vars=array()) {
	global $_TGLOBAL;

	include_once(S_ROOT.'./language/lang_cp.php');
	if(isset($_TGLOBAL['cplang'][$key])) {
		$result = lang_replace($_TGLOBAL['cplang'][$key], $vars);
	} else {
		$result = $key;
	}
	return $result;
}

//滻
function lang_replace($text, $vars) {
	if($vars) {
		foreach ($vars as $k => $v) {
			$rk = $k + 1;
			$text = str_replace('\\'.$rk, $v, $text);
		}
	}
	return $text;
}

//ȡ
function sub_url($url, $length) {
	if(strlen($url) > $length) {
		$url = str_replace(array('%3A', '%2F'), array(':', '/'), rawurlencode($url));
		$url = substr($url, 0, intval($length * 0.5)).' ... '.substr($url, - intval($length * 0.3));
	}
	return $url;
}

//ȡе
function sarray_rand($arr, $num) {
	$r_values = array();
	if($arr && count($arr) > $num) {
		if($num > 1) {
			$r_keys = array_rand($arr, $num);
			foreach ($r_keys as $key) {
				$r_values[$key] = $arr[$key];
			}
		} else {
			$r_key = array_rand($arr, 1);
			$r_values[$r_key] = $arr[$r_key];
		}
	} else {
		$r_values = $arr;
	}
	return $r_values;
}

//ûΨһ
function space_key($space, $appid=0) {
	global $_TCONFIG;
	return substr(md5($_TCONFIG['sitekey'].'|'.$space['uid'].(empty($appid)?'':'|'.$appid)), 8, 16);
}

//formα
function formhash() {
	global $_TGLOBAL, $_TCONFIG;
	
	if(empty($_TGLOBAL['formhash'])) {
		$hashadd = defined('IN_ADMINCP') ? 'Only For copytaobao AdminCP' : '';
		$_TGLOBAL['formhash'] = substr(md5(substr($_TGLOBAL['timestamp'], 0, -7).'|'.$_TGLOBAL['ctb_uid'].'|'.md5($_TCONFIG['sitekey']).'|'.$hashadd), 8, 8);
	}
	return $_TGLOBAL['formhash'];
}

//ǷЧ
function isemail($email) {
	return strlen($email) > 6 && preg_match("/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/", $email);
}

//ȡĿ¼
function sreaddir($dir, $extarr=array()) {
	$dirs = array();
	if($dh = opendir($dir)) {
		while (($file = readdir($dh)) !== false) {
			if(!empty($extarr) && is_array($extarr)) {
				if(in_array(strtolower(fileext($file)), $extarr)) {
					$dirs[] = $file;
				}
			} else if($file != '.' && $file != '..') {
				$dirs[] = $file;
			}
		}
		closedir($dh);
	}
	return $dirs;
}

//session
function insertsession($setarr) {
	global $_TGLOBAL, $_TCONFIG;

	$_TCONFIG['onlinehold'] = intval($_TCONFIG['onlinehold']);
	if($_TCONFIG['onlinehold'] < 300) $_TCONFIG['onlinehold'] = 300;
	$_TGLOBAL['db']->query("DELETE FROM ".tname('session')." WHERE userid='$setarr[userid]' OR lastactive<'".($_TGLOBAL['timestamp']-$_TCONFIG['onlinehold'])."'");

	//
	$ip = getonlineip(1);
	$setarr['lastactive'] = $_TGLOBAL['timestamp'];
	$setarr['ip'] = $ip;
	inserttable('session', $setarr, 0, true, 1);

}

//ȡϴ·
function getfilepath($fileext, $mkdir=false) {
	global $_TGLOBAL, $_CTB;

	$filepath = "{$_TGLOBAL['ctb_uid']}_{$_TGLOBAL['timestamp']}".random(4).".$fileext";
	$name1 = gmdate('Ym');
	$name2 = gmdate('j');

	if($mkdir) {
		$newfilename = $_CTB['attachdir'].'./'.$name1;
		if(!is_dir($newfilename)) {
			if(!@mkdir($newfilename)) {
				runlog('error', "DIR: $newfilename can not make");
				return $filepath;
			}
		}
		$newfilename .= '/'.$name2;
		if(!is_dir($newfilename)) {
			if(!@mkdir($newfilename)) {
				runlog('error', "DIR: $newfilename can not make");
				return $name1.'/'.$filepath;
			}
		}
	}
	return $name1.'/'.$name2.'/'.$filepath;
}

//õĶ༶
function getclasscotename($tclass, $class_id) {
	global $_TGLOBAL;
	$len = strlen($class_id) ;
	$cid = substr($class_id, 0 , $len);
	if (isset($_TGLOBAL[$tclass][$cid])) {
		
		if ($len > 0 ){
			$return = getclasscotename($tclass, substr($class_id, 0, $len - 3)) . $_TGLOBAL[$tclass][$cid]['name'] . "->";
		}
	}
	return $return;
}

//õõpageΪpageÿλ仯
//÷ʽ get_current_url()
function get_current_url($except = array('page')) {
    if($_SERVER['QUERY_STRING'] == '') {
        return $_SERVER['PHP_SELF'];
    } else {
        if(!$except) $except = array();
        // ϲgetpostȥ$exceptųı
        $query  = '';
		$query_param = array_merge($_GET, $_POST);
        foreach($query_param as $k => $v) {
			if (eregi('|ѯ|font|img', $v) || eregi('dowhat|type_mode|new', $k)) { //ťᴫ
				continue;
			}

			$exist = false;
            foreach($except as $vv) {
                if($k==$vv) {
                    $exist = true;
                    break;
                }
            }
            if(!$exist) {
				if (trim($v) != '') { //ֵΪʱΪ
					$query .= ($query == '')?"$k={$v}":"&$k={$v}";
				}
            }
        }
    }
    return $_SERVER['PHP_SELF'] . '?' . $query;
}

//õͼƬͼͼڣ򷵻ԭͼ
function getthumbimg($file, $path='../') {
	if ($file) {
		$path && $file = str_replace($path, '', $file);
		$thumb        = $file.'.thumb.'.fileext($file);
		file_exists(S_ROOT . $thumb) && $file = $thumb;
	} else {
		$file = 'image/no_pic.gif';
	}
	return $file;
}

//ǷֵĹؼ
function checkbadwords($content) {
	global $_TCONFIG;
	if (!$_TCONFIG['prohibition']) return ;
	$ary = @split(",", $_TCONFIG['prohibition']);
	foreach($ary AS $val) {
		if(eregi($val, $content)) {
			//showmessage(cplang('post_content_bad'));
			//exit;
			return $val;
		}
	}
	return;
}

//滻еֵΪ
function arrary_replace($search, $replace, $string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = arrary_replace($search, $replace, $val);
		}
	} else {
		$string = str_replace($search, $replace, $string);
	}
	return $string;
}

//õĶ
function getclasscotesub($class_id) {
	global $_TGLOBAL;
	if (!$class_id) return ;
	$class_id = substr($class_id, 0, 3);
	$return = array();
	foreach($_TGLOBAL['news_class'] AS $key => $value) {
		if (strlen($key) == 6 && substr($key, 0, 3) == $class_id) {
			$return[$key] = array(
						'class_id' => $key,
						'name'     => $value['name']
						);
		}
	}
	ksort($return);
	return $return;
}

//class_id룬õƣ༶
function showmulzones($zones, $type='class_zone') {
	global $_TGLOBAL;
	if (!$zones) return '&nbsp;';
	$len = strlen($zones) / 3; //õĳȳ3ѭĴ
	$t = array();
	for($i=1; $i <= $len; $i++) {		
		$class_id_1 = substr($zones, 0, $i * 3); //ȡ
		$re_cname = $_TGLOBAL[$type][$class_id_1]['name'];
		$re_cname && $t[] = $re_cname;
	}
	$r .= implode(', ', $t);
	return $r;
}


//ʾʣʱ
function lefttime($spectime) {
	global $_TGLOBAL;
	 $gmt = date('O')/100;       //GMTʱ
	 $nowtime = $_TGLOBAL['timestamp'];
	 $difftime = $nowtime - $spectime;	// - $gmt*3600 ʱ

	 if ($difftime > 0) {                       //ʱǽʱ
	  $temp     = getdate($difftime);
	  $mysecond = $temp["seconds"];
	  $myminute = $temp["minutes"];
	  $myhour   = $temp["hours"] - 8; 
	  $myday    = $temp["yday"];
	  $myyear   = $temp["year"] - 1970;

	if ($myhour < 0) {
		$myday  = $myday - 1;
		$myhour = 60 + $myhour;
	}
	if ($myminute) $return = $myminute."ǰ";
	if ($myhour>0) $return = $myhour."Сʱǰ";
	if ($myday>0)  $return = $myday."ǰ";
	if ($myyear>0) $return = $myyear."";

	 } else {
		$return .= "";
	 }
	return $return;
}

//* ܣѡеԪ
function GetCheckElement($Ary, $val, $ele_name='') {

	$resutn = '';
	while(list($Line,$Value)=each($Ary)) {
		if ($ele_name) $Value = $Value[$ele_name];
		if ($val) {
			$aryzoneid = @split(',', $val);
			$return .= in_array($Line, $aryzoneid) ? ($Value. ' ') : '';
		}
	}
	return $return ? $return : $val;
}

//õǰվ
function getcurrysite() {
	return '51shop'; //
}

//õͬûĹ
//usertypeֱӴݴֵʱʾѾлԱļٲѯݿ
function getuserbuyprice($price, $uid, $usertype=0) {
	global $_TGLOBAL;
	if ($price <= 10 || $uid <= 0) return $price;
	!$usertype && $usertype = @(int)getcount('members', " uid='$uid'", 'usertype'); //ȡûļ

	$group = $_TGLOBAL['member_group'][$usertype];
	if (!isset($group)) return $price; //û𲻴ʱ򷵻г

	$return_price = $price * ($group['rate'] / 100);

	$return_price = round($return_price, 2);

	//
	if ($group['float_op'] && $group['float_price']) {
		eval("\$return_price = \$return_price {$group[float_op]} \$group[float_price];");
	}
	return $return_price > 0 ? $return_price : 0; //ļ۸С0ʱΪ0

}

//õûϢ
function getuserinfo($uid=0, $field='*') {
	global $_TGLOBAL;
	
	!$uid && $uid = $_TGLOBAL['ctb_uid']; //ʱȡǰ¼û
	if (!$uid) return;
	$userinfo_q = $_TGLOBAL['db']->query("SELECT $field FROM ".tname('members')." WHERE uid='$uid'");
	$profile	= $_TGLOBAL['db']->fetch_array($userinfo_q);
	$profile['group'] = $_TGLOBAL['member_group'][$profile['usertype']]; //õûϢ
	return $profile;
}

//$_TCOOKIE['basket_counter']ȡûÿƷÿ
function getuserbuynums($goods_id, $size_group, $size_id) {
	global $_TCOOKIE;
	/*
	Ʒidcookiek, $_TCOOKIE['basket_id']ֵΪƷid,ŷָ磺5,3,20
	ÿƷÿĹ$_TCOOKIE['basket_counter']ֵΪÿ빺:ŷָÿƷ,ŷָ 磺0:1:0:2:3, 1:0:0:0:2:0:1
	
	ݲƷidgoods_id
			飺size_group
			Ӧ±idsize_id
	$_TCOOKIE['basket_counter']ȡӦĹ
	*/
	$ary_basket_id       = @split(',', $_TCOOKIE['basket_id']);
	$ary_basket_counter  = @split(',', $_TCOOKIE['basket_counter']);
	for ($basket_counter = 0; $basket_counter < $_TCOOKIE['basket_amount']+1; $basket_counter++) {
	   
	   //ƷidӦ$_TCOOKIE['basket_id']idͬʱ
	   if ($goods_id == $ary_basket_id[$basket_counter]) {
	   
		   $nums = $ary_basket_counter[$basket_counter]; //ȡÿƷĸ

		   //ȡÿƷÿĸȻ
		   //ÿӦʽΪ3_0:4_0:5_0:6_0:7_0:8_0
		   //˴Ϊʽ֣磺3_03ʾ±꣬0ʾ˳Ĺ
		   //ڴ $size_group
		   $ary_nums = @split(':', $nums);
		   //foreach($size_group AS $key=>$val) {
		   foreach($ary_nums AS $val) {
			   
			   //Ʒsize_idsize_groupkey±λʱ򷵻ع
			   $ary_size_nums = @split('_', $val);
			   if ($size_id == $ary_size_nums[0]) {
				   return intval($ary_size_nums[1]);
			   }

		   }
		}
	}
}

//ɶ
function makeorderno($length=4) {
	global $_TGLOBAL;

	$order_no = date('ymd', $_TGLOBAL['timestamp']).random($length, 1);
	while($_TGLOBAL['db']->fetch_array($_TGLOBAL['db']->query('SELECT NULL FROM '.tname('orders') . " WHERE order_no ='$order_no'"))) {
		$order_no = date('ymd', $_TGLOBAL['timestamp']).random($length, 1);
	}

	return $order_no;
}

//Ʒ orers_total_counterԲͬĿݣ˷
function getexpressprice($express_id, $goods_num, $goods_weight=0) {
	global $_TGLOBAL;
	
	$express = $_TGLOBAL['order_express'][$express_id];

	/*շ
		һ˷	first_freight
		˷	continue_freight
	*/
	if ($express['paymethod'] == 'nums') {
		if ($goods_num <= 0) return 0;
		$price = intval($express['first_freight'] + round($express['continue_freight'] * ($goods_num - 1)));
	}

	/*շ
	ضٿ	first_weight
	ضٿ˷	first_weight_freight
	ضٿ	continue_weight
	ضٿ˷	continue_weight_freight
	*/
	if ($express['paymethod'] == 'weight') {
		if ($goods_weight <= 0) return 0;

		if ($goods_weight <= $express['first_weight']) {
			$price = $express['first_weight_freight'];
		} else {
			$weight = $goods_weight - $express['first_weight']; 
			$nums   = round($weight / $express['continue_weight']); //
			$price  = $nums * $express['continue_weight_freight']; 
			$price	+= $express['first_weight_freight'];
		}
	}

	return $price;
}

//ɿݳɱѣƷ orers_total_counterԲͬĿݣ˷
function getexpressprice_co($express_id, $goods_num, $goods_weight=0) {
	global $_TGLOBAL;
	
	$express = $_TGLOBAL['order_express'][$express_id];

	/*շ
		һ˷	first_freight
		˷	continue_freight
	*/
	if ($express['co_paymethod'] == 'nums') {
		if ($goods_num <= 0) return 0;
		$price = intval($express['co_first_freight'] + round($express['co_continue_freight'] * ($goods_num - 1)));
	}

	/*շ
	ضٿ	first_weight
	ضٿ˷	first_weight_freight
	ضٿ	continue_weight
	ضٿ˷	continue_weight_freight
	*/
	if ($express['co_paymethod'] == 'weight') {
		if ($goods_weight <= 0) return 0;

		if ($goods_weight <= $express['co_first_weight']) {
			$price = $express['co_first_weight_freight'];
		} else {
			$weight = $goods_weight - $express['co_first_weight']; 
			$nums   = round($weight / $express['co_continue_weight']); //
			$price  = $nums * $express['co_continue_weight_freight']; 
			$price	+= $express['co_first_weight_freight'];
		}
	}

	return $price;
}


//ûϢ
function setuserinfo($field, $value, $uid=0) {
	global $_TGLOBAL;
	
	!$uid && $uid = $_TGLOBAL['ctb_uid']; //ʱȡǰ¼û
	if (!$uid) return;
	$_TGLOBAL['db']->query("UPDATE ".tname('members')." SET $field = $field + $value WHERE uid='$uid'");
}


/****ģsqlserverеdateadd******* 
$part ͣstring 
ȡֵΧyear,month,day,hour,min,sec 
ʾҪӵڵĸ 
$n ֵͣ 
ʾҪӶ٣$partĸ 
Ϊ 
$datetimeͣtimestamp 
ʾӵĻ 
 ͣtimestamp 
****************************/ 
function dateadd($part, $n, $datetime){
	global $_TGLOBAL;
	$year = date("Y",$datetime); 
	$month = date("m",$datetime); 
	$day  = date("d",$datetime); 
	$hour = date("H",$datetime); 
	$min  = date("i",$datetime); 
	$sec  = date("s",$datetime); 
	$part = strtolower($part); 
	$ret  = 0; 
	switch ($part) { 
		case "year": 
			$year+=$n; 
			break; 
		case "month": 
			$month+=$n; 
			break; 
		case "day": 
			$day+=$n; 
			break; 
		case "hour": 
			$hour+=$n; 
			break; 
		case "min": 
			$min+=$n; 
			break; 
		case "sec": 
			$sec+=$n; 
			break; 
		default: 
			return $ret; 
			break; 
	} 
	$ret = mktime($hour,$min,$sec,$month,$day,$year);
	return $ret; 
} 

//ɶ ԱԤ¼
function makeorderno_subsist($length=4) {
	global $_TGLOBAL;

	$order_no = $_TGLOBAL['timestamp'];
	while($_TGLOBAL['db']->fetch_array($_TGLOBAL['db']->query('SELECT NULL FROM '.tname('member_subsist') . " WHERE order_no ='$order_no'"))) {
		$order_no = $_TGLOBAL['timestamp'] + 1;
	}

	return $order_no;
}


//ļΪadmin/other_ghost.phpļʹ
//ӵϸҳȡͼƬ
function getimgoflink($content) {
	preg_match_all('/<[\s]*img.*?src=[\'|"|\s]*(.+?|\ )[\'|"|\s|>]/is', $content, $matches);
	for($j=0; $j < count($matches[1]); $j++) {
		$aryimg[] = $matches[1][$j];		
	}
	return $aryimg; //$matches[1][$j][0] //صһƥͼ
}

//ݹгĿ¼ļ
function listdir($start_dir=".") { 
	$files = array(); 
	if (is_dir($start_dir)) { 
		$fh = opendir($start_dir); 
		while (($file = readdir($fh)) !== false) { 
			if (strcmp($file, '.')==0 || strcmp($file, '..')==0) continue; 
			$filepath = $start_dir . '/' . $file; 
			if ( is_dir($filepath) ) 
				$files = array_merge($files, listdir($filepath)); 
			else 
				array_push($files, $filepath); 
		} 
		closedir($fh); 
	} else { 
	$files = false; 
	} 
	return $files; 
}

?>