<?php
/*
	[CTB] (C) 2007-2009 copytaobao.com
	$Id: function_image.php 2009-4-21 12:16:43 jerry $
*/

!defined('IN_CTB') && die('Access Denied');

//ϴͼƬ
function pic_save($FILE, $albumid=0, $title=0) {
	global $_TGLOBAL, $_TCONFIG, $_CTB;

	//ϴ
	$allowpictype = array('jpg','gif','png', 'swf');

	//
	$FILE['size'] = intval($FILE['size']);
	if(empty($FILE['size']) || empty($FILE['tmp_name']) || !empty($FILE['error'])) {
		return cplang('lack_of_access_to_upload_file_size');
	}

	//жϺ׺
	$fileext = fileext($FILE['name']);
	if(!in_array($fileext, $allowpictype)) {
		return cplang('only_allows_upload_file_types');
	}

	//ȡĿ¼
	if(!$filepath = getfilepath($fileext, true)) {
		return cplang('unable_to_create_upload_directory_server');
	}

	//ϴ
	$new_name = $_CTB['attachdir'].'./'.$filepath;
	$tmp_name = $FILE['tmp_name'];
	if(@copy($tmp_name, $new_name)) {
		@unlink($tmp_name);
	} elseif((function_exists('move_uploaded_file') && @move_uploaded_file($tmp_name, $new_name))) {
	} elseif(@rename($tmp_name, $new_name)) {
	} else {
		return cplang('mobile_picture_temporary_failure');
	}
	
	//ǷͼƬ
	if(function_exists('getimagesize') && !@getimagesize($new_name)) {
		@unlink($new_name);
		return cplang('only_allows_upload_file_types');
	}

	//ͼ
	include_once(S_ROOT.'./source/function_image.php');
	$thumbpath = makethumb($new_name);
	$thumb = empty($thumbpath)?0:1;

	//Ƿѹ
	//ȡϴͼƬС
	if(@$newfilesize = filesize($new_name)) {
		$FILE['size'] = $newfilesize;
	}

	//ˮӡ
	if($_TCONFIG['allowwatermark']) {
		makewatermark($new_name);
	}

	//ftpϴ
	if($_TCONFIG['allowftp']) {
		include_once(S_ROOT.'./source/function_ftp.php');
		if(ftpupload($new_name, $filepath)) {
			$pic_remote = 1;
			$album_picflag = 2;
		} else {
			@unlink($new_name);
			@unlink($new_name.'.thumb.jpg');
			runlog('ftp', 'Ftp Upload '.$new_name.' failed.');
			return cplang('ftp_upload_file_size');
		}
	} else {
		$pic_remote = 0;
		$album_picflag = 1;
	}

	return array('new_name' => $new_name); //,ϴɹ
}



//ͼ
function makethumb($srcfile) {
	global $_TGLOBAL;

	//жļǷ
	if (!file_exists($srcfile)) {
		return '';
	}
	$dstfile = $srcfile.'.thumb.jpg';
	
	include_once(S_ROOT.'./data/data_setting.php');

	//ͼС
	$tow = intval($_TGLOBAL['setting']['thumbwidth']);
	$toh = intval($_TGLOBAL['setting']['thumbheight']);
	if($tow < 80) $tow = 120;
	if($toh < 60) $toh = 90;

	$make_max = 0;
	$maxtow = intval($_TGLOBAL['setting']['maxthumbwidth']);
	$maxtoh = intval($_TGLOBAL['setting']['maxthumbheight']);
	if($maxtow >= 300 && $maxtoh >= 300) {
		$make_max = 1;
	}
	
	//ȡͼƬϢ
	$im = '';
	if($data = getimagesize($srcfile)) {
		if($data[2] == 1) {
			$make_max = 0;//gif
			if(function_exists("imagecreatefromgif")) {
				$im = imagecreatefromgif($srcfile);
			}
		} elseif($data[2] == 2) {
			if(function_exists("imagecreatefromjpeg")) {
				$im = imagecreatefromjpeg($srcfile);
			}
		} elseif($data[2] == 3) {
			if(function_exists("imagecreatefrompng")) {
				$im = imagecreatefrompng($srcfile);
			}
		}
	}
	if(!$im) return '';
	
	$srcw = imagesx($im);
	$srch = imagesy($im);
	
	$towh = $tow/$toh;
	$srcwh = $srcw/$srch;
	if($towh <= $srcwh){
		$ftow = $tow;
		$ftoh = $ftow*($srch/$srcw);
		
		$fmaxtow = $maxtow;
		$fmaxtoh = $fmaxtow*($srch/$srcw);
	} else {
		$ftoh = $toh;
		$ftow = $ftoh*($srcw/$srch);
		
		$fmaxtoh = $maxtoh;
		$fmaxtow = $fmaxtoh*($srcw/$srch);
	}
	if($srcw <= $maxtow && $srch <= $maxtoh) {
		$make_max = 0;//
	}
	if($srcw > $tow || $srch > $toh) {
		if(function_exists("imagecreatetruecolor") && function_exists("imagecopyresampled") && @$ni = imagecreatetruecolor($ftow, $ftoh)) {
			imagecopyresampled($ni, $im, 0, 0, 0, 0, $ftow, $ftoh, $srcw, $srch);
			//ͼƬ
			if($make_max && @$maxni = imagecreatetruecolor($fmaxtow, $fmaxtoh)) {
				imagecopyresampled($maxni, $im, 0, 0, 0, 0, $fmaxtow, $fmaxtoh, $srcw, $srch);
			}
		} elseif(function_exists("imagecreate") && function_exists("imagecopyresized") && @$ni = imagecreate($ftow, $ftoh)) {
			imagecopyresized($ni, $im, 0, 0, 0, 0, $ftow, $ftoh, $srcw, $srch);
			//ͼƬ
			if($make_max && @$maxni = imagecreate($fmaxtow, $fmaxtoh)) {
				imagecopyresized($maxni, $im, 0, 0, 0, 0, $fmaxtow, $fmaxtoh, $srcw, $srch);
			}
		} else {
			return '';
		}
		if(function_exists('imagejpeg')) {
			imagejpeg($ni, $dstfile);
			//ͼƬ
			if($make_max) {
				imagejpeg($maxni, $srcfile);
			}
		} elseif(function_exists('imagepng')) {
			imagepng($ni, $dstfile);
			//ͼƬ
			if($make_max) {
				imagepng($maxni, $srcfile);
			}
		}
		imagedestroy($ni);
		if($make_max) {
			imagedestroy($maxni);
		}
	}
	imagedestroy($im);

	if(!file_exists($dstfile)) {
		return '';
	} else {
		return $dstfile;
	}
}

//ͼƬˮӡ
function makewatermark($srcfile) {
	global $_TGLOBAL;
	
	include_once(S_ROOT.'./data/data_setting.php');
	
	//ˮӡͼƬ
	$watermarkfile = empty($_TGLOBAL['setting']['watermarkfile'])?S_ROOT.'./image/watermark.png':$_TGLOBAL['setting']['watermarkfile'];
    if(!file_exists($watermarkfile) || !$water_info = getimagesize($watermarkfile)) {
    	return '';
    }
    $water_w = $water_info[0];
    $water_h = $water_info[1];
    $water_im = '';
    switch($water_info[2]) {
        case 1:@$water_im = imagecreatefromgif($watermarkfile);break;
        case 2:@$water_im = imagecreatefromjpeg($watermarkfile);break;
        case 3:@$water_im = imagecreatefrompng($watermarkfile);break;
        default:break;
    }
	if(empty($water_im)) {
		return '';
	}

    //ԭͼ
    if(!file_exists($srcfile) || !$src_info = getimagesize($srcfile)) {
    	return '';
    }
    $src_w = $src_info[0];
    $src_h = $src_info[1];
    $src_im = '';
    switch($src_info[2]) {
        case 1:
        	//жǷΪ
        	$fp = fopen($srcfile, 'rb');
			$filecontent = fread($fp, filesize($srcfile));
			fclose($fp);
			if(strpos($filecontent, 'NETSCAPE2.0') === FALSE) {//ͼˮӡ
        		@$src_im = imagecreatefromgif($srcfile);
			}
        	break;
        case 2:@$src_im = imagecreatefromjpeg($srcfile);break;
        case 3:@$src_im = imagecreatefrompng($srcfile);break;
        default:break;
    }
    if(empty($src_im)) {
    	return '';
    }
    
    //ˮӡͼƬĳȻȱˮӡС150px
    if(($src_w < $water_w + 150) || ($src_h < $water_h + 150)) {
    	return '';
    }
	
    //λ
	switch($_TGLOBAL['setting']['watermarkpos']) {
		case 1://˾
			$posx = 0;
			$posy = 0;
			break;
		case 2://˾
			$posx = $src_w - $water_w;
			$posy = 0;
			break;
		case 3://׶˾
			$posx = 0;
			$posy = $src_h - $water_h;
			break;
		case 4://׶˾
			$posx = $src_w - $water_w;
			$posy = $src_h - $water_h;
			break;
		default://
			$posx = mt_rand(0, ($src_w - $water_w));
			$posy = mt_rand(0, ($src_h - $water_h));
			break;
	}

    //趨ͼĻɫģʽ
	@imagealphablending($src_im, true);
	//ˮӡĿļ
	@imagecopy($src_im, $water_im, $posx, $posy, 0, 0, $water_w, $water_h);
    switch($src_info[2]) {
        case 1:@imagegif($src_im, $srcfile);break;
        case 2:@imagejpeg($src_im, $srcfile);break;
        case 3:@imagepng($src_im, $srcfile);break;
        default:return '';
    }
	@imagedestroy($water_im);
	@imagedestroy($src_im);
}

//ץȡԶͼƬ
function upload_http_img($src_name) {
	global $_CTB;	

	//ϵͳʱ 
	set_time_limit(0);

	//ϴ
	$allowpictype = array('jpg','gif','png', 'swf');
	//жϺ׺
	$fileext = fileext($src_name);
	if(!in_array($fileext, $allowpictype)) {
		return cplang('only_allows_upload_file_types');
	}

	//ȡĿ¼
	if(!$filepath = getfilepath($fileext, true)) {
		return cplang('unable_to_create_upload_directory_server');
	}

	$new_name = $_CTB['attachdir'].''.$filepath;

	if(function_exists('curl_init')) {

		/********  curlgetʽõͼƬͼƬַ  *********/
		//$v = base64_decode($src_name);
		$v = $src_name;
		$ch = curl_init($src_name);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
		$output = curl_exec($ch);
		curl_close($ch);
	/*
		$fh = fopen($new_name, 'wb');
		fwrite($fh, $output);
		fclose($fh);

		ob_start(); 
		readfile($src_name); 
		$output = ob_get_contents(); 
		ob_end_clean();
		
		$output = @file_get_contents($src_name);
	*/
		swritefile($new_name, $output);
	} else {
		copy($src_name, $new_name);
	}

	return array('new_name' => $new_name);//ͼƬļ
}


//ϴ
function pic_attach($FILE) {
	global $_TGLOBAL, $_TCONFIG, $_CTB;

	//ϴ
	$bannedtype = array('php','asp','aspx');

	//
	$FILE['size'] = intval($FILE['size']);
	if(empty($FILE['size']) || empty($FILE['tmp_name']) || !empty($FILE['error'])) {
		return cplang('lack_of_access_to_upload_file_size');
	}

	//жϺ׺
	$fileext = fileext($FILE['name']);
	if(in_array($fileext, $bannedtype)) {
		return cplang("'php','asp','aspx'ļϴ");
	}

	//ȡĿ¼
	if(!$filepath = getfilepath($fileext, true)) {
		return cplang('unable_to_create_upload_directory_server');
	}

	//ϴ
	$new_name = $_CTB['attachdir'].'./'.$filepath;
	$tmp_name = $FILE['tmp_name'];
	if(@copy($tmp_name, $new_name)) {
		@unlink($tmp_name);
	} elseif((function_exists('move_uploaded_file') && @move_uploaded_file($tmp_name, $new_name))) {
	} elseif(@rename($tmp_name, $new_name)) {
	} else {
		return cplang('mobile_picture_temporary_failure');
	}
	
	//ftpϴ
	if($_TCONFIG['allowftp']) {
		include_once(S_ROOT.'./source/function_ftp.php');
		if(ftpupload($new_name, $filepath)) {
			$pic_remote = 1;
			$album_picflag = 2;
		} else {
			@unlink($new_name);
			runlog('ftp', 'Ftp Upload '.$new_name.' failed.');
			return cplang('ftp_upload_file_size');
		}
	} else {
		$pic_remote = 0;
		$album_picflag = 1;
	}

	return array('new_name' => $new_name); //,ϴɹ
}
?>