<?php
// $Id: imgcode.php 2524 2009-05-27 05:30:30Z jerry $

/**
 *  Helper_ImgCode ࡢHelper_ImgCodeSimple  Helper_ImgCodeTTF 
 *
 * @link http://qeephp.com/
 * @copyright Copyright (c) 2006-2009 Qeeyuan Inc. {@link http://www.qeeyuan.com}
 * @license New BSD License {@link http://qeephp.com/license/}
 * @version $Id: imgcode.php 2524 2009-05-27 05:30:30Z jerry $
 * @package helper
 */

/**
 * Helper_ImgCode ṩ֤ɺͼĽӿ
 *
 * @author YuLei Liao <liaoyulei@qeeyuan.com>
 * @version $Id: imgcode.php 2524 2009-05-27 05:30:30Z jerry $
 * @package helper
 */
define('CURRENT_TIMESTAMP',time());

class Helper_ImgCode
{
    /**
     * ֤
     *
     * @var array
     */
    static private $_config = array(
        // ʲô session б֤
        'imgcode_session_key' => '_IMGCODE',

        //  session жȡ֤
        'imgcode_session_value' => null,

        // ʲô session б֤ʱ
        'expired_session_key' => '_IMGCODE_EXPIRED',

        // ֤ʱ
        'expired_session_value' => null,
    );

	/**
	 *  GD ֤ͼ񣬲װΪ QView_Output 
     *
     * $style ֵͬʱ$options ѡҲͬ
     *
     * ÷
     * @code php
     * // ļ
     * class Controller_Default
     * {
     *     function actionImgcode()
     *     {
     *         // ڿд뷵һͼ֤
     *         return Helper_ImgCode::create(6, 900, 'simple');
     *     }
     * }
     *
     * // ģļʹдһͼ֤
     * <img src="<?php echo url('default/imgcode'); ?>" border="0" />
     * @endcode
     *
     * @param int $length ֤ĳ
     * @param int $lefttime ֤Ч
     * @param string $style ֤ʽ
     * @param array $options ֤ʽѡ
     *
     * @return QView_Output ֤ͼ
	 */
    static function create($length = 4, $lefttime = 900,
                           $style = 'simple', array $options = null)
    {
        $class_name = 'Helper_ImgCode' . ucfirst(strtolower(preg_replace('/[^a-z0-9_]+/i', '', $style)));
        $options = (array)$options;
        $options['code_length'] = $length;
        $imgcode_obj = new $class_name($options);

        $code = $imgcode_obj->generateCode();
        self::_writeImgcodeToSession($code, $lefttime);
        return $imgcode_obj->generateImage($code);
    }

    /**
     * Ƚ֤Ƿ session б֤һ£ִСд
     *
     * ÷
     * @code php
     * // ļ
     * class Controller_Default
     * {
     *     function actionLogin()
     *     {
     *         if (Helper_ImgCode::isValid($this->_context->imgcode))
     *         {
     *             .... ȶͨ
     *         }
     *
     *         ....
     *     }
     * }
     * @endcode
     *
     * @param string $code ҪȶԵ֤
     * @param boolean $clean_session Ƿڱȶͨ session б֤
     * @param boolean $case_sensitive ǷִСд
     *
     * @return boolean ȶԽ
     */
    static function isValid($code, $clean_session = false, $case_sensitive = false)
    {
        $code_in_session = self::_readImgcodeFromSession();

        if (strlen($code_in_session) == 0 || strlen($code) == 0)
        {
            return false;
        }
        if ($case_sensitive)
        {
            $ret = (string)$code_in_session == (string)$code;
        }
        else
        {
            $ret = strtolower($code_in_session) == strtolower($code);
        }

        if ($ret && $clean_session)
        {
            self::_cleanImgcodeFromSession();
        }

        return $ret;
    }

	/**
     *  session е֤Ϣ
	 */
	static function clean()
    {
        self::_cleanImgcodeFromSession();
	}

	/**
	 *  16 ɫֵתΪ rgb ֵ
     *
     * ÷
     * @code php
     * $color = '#369';
     * list($r, $g, $b) = Helper_Image::hex2rgb($color);
     * echo "red: {$r}, green: {$g}, blue: {$b}";
     * @endcode
     *
     * @param string $color ɫֵ
     * @param string $default ʹЧɫֵʱصĬɫ
	 *
	 * @return array  RGB ɫɵ
	 */
	static function hex2rgb($color, $default = 'ffffff')
	{
        $hex = trim($color, '#&Hh');
        $len = strlen($hex);
        if ($len == 3)
        {
            $hex = "{$hex[0]}{$hex[0]}{$hex[1]}{$hex[1]}{$hex[2]}{$hex[2]}";
        }
        elseif ($len < 6)
        {
            $hex = $default;
        }
        $dec = hexdec($hex);
        return array(($dec >> 16) & 0xff, ($dec >> 8) & 0xff, $dec & 0xff);
	}

    /**
     * д֤֤ʱ䵽 session
     *
     * @param string $code Ҫд session ֤
     * @param int $lefttime ֤Ч
     */
    private static function _writeImgcodeToSession($code, $lefttime)
    {
        if (isset($_SESSION))
        {
            $_SESSION[self::$_config['imgcode_session_key']] = $code;
            $_SESSION[self::$_config['expired_session_key']] = CURRENT_TIMESTAMP + intval($lefttime);
        }
    }

    /**
     *  session ȡ֤֤ʱ
     */
    private static function _readImgcodeFromSession()
    {
        if (!isset($_SESSION))
        {
            return false;
        }

        $key = self::$_config['imgcode_session_key'];
        $imgcode = isset($_SESSION[$key]) ? $_SESSION[$key] : '';
        $key = self::$_config['expired_session_key'];
        $expired = isset($_SESSION[$key]) ? $_SESSION[$key] : 0;

        if (CURRENT_TIMESTAMP >= $expired) return false;
        return $imgcode;
    }

    /**
     *  session ֤֤ʱ
     */
    private static function _cleanImgcodeFromSession()
    {
        if (isset($_SESSION))
        {
            $key = self::$_config['imgcode_session_key'];
            unset($_SESSION[$key]);
            $key = self::$_config['expired_session_key'];
            unset($_SESSION[$key]);
        }
    }
}

/**
 * Helper_ImgCodeSimple ʵһʽ֤
 *
 * @author YuLei Liao <liaoyulei@qeeyuan.com>
 * @version $Id: imgcode.php 2524 2009-05-27 05:30:30Z jerry $
 * @package helper
 */
class Helper_ImgCodeSimple
{
    /**
     * ֤Ҫѡ
     *
     * @var array
     */
    protected $_options = array(
        // ֤
        'code_type'         => 2,

        // ֤볤
        'code_length'       => 4,

        // ַ¸
        'float_pixel'       => 6,

        // ͼ
        'image_type'        => IMAGETYPE_JPEG,

        // 壬Ϊ 0-5ʹ GD õ
        // ʹԶ壬font ָΪļľ·
        'font'              => 5,

        // ɫ
        'color'             => '0xffffff',

        // ɫ
        'bgcolor'           => '0x666666',

        // ֤ͼƬ߽ɫ
        'bdcolor'           => '0x000000',

        // ڿ
        'padding'           => 2,

        // ߽
        'border'            => 1,
    );

    /**
     * 캯
     *
     * @param array $options ֤ѡ
     */
    function __construct(array $options)
    {
        $this->_options = array_merge($this->_options, $options);
    }

    /**
     * ֤
     *
     * @return string
     */
    function generateCode()
    {
        $code_type = intval($this->_options['code_type']);
        $code_length = intval($this->_options['code_length']);
        if ($code_length <= 0) { $code_length = 4; }

        switch ($code_type)
        {
        case 0:
            $seed = '0123456789';
            break;
        case 1:
            $seed = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
            break;
        default:
            $seed = '346789ABCDEFGHJKLMNPQRTUVWXYabcdefghjklmnpqrtuvwxy';
        }
        $code = '';
        $len = strlen($seed) - 1;
        for ($i = 0; $i < $code_length; $i++)
        {
            $code .= substr($seed, mt_rand(0, $len), 1);
        }

        return $code;
    }

    /**
     * ֤ͼ񣬷 QView_Output 
     *
     * $param string $code
     *
     * @return QView_Output
     */
    function generateImage($code)
    {
        // ѡȷͼѡ
        $padding = intval($this->_options['padding']);
        if ($padding < 0) { $padding = 0; }
        $color = $this->_options['color'];
        $bgcolor = $this->_options['bgcolor'];
        $border = $this->_options['border'];
        $bdcolor = $this->_options['bdcolor'];
        $float_pixel = intval($this->_options['float_pixel']);

		// ȷҪʹõ
        if (is_int($this->_options['font']))
        {
            $font = intval($this->_options['font']);
            if ($font < 0 || $font > 5)
            {
                $font = 5;
            }
        }
        else
        {
            $font = imageloadfont($this->_options['font']);
        }

		// ȷȺ͸߶
		$font_width = imagefontwidth($font);
		$font_height = imagefontheight($font);

		// ȷͼĿȺ͸߶
        $width = $font_width * strlen($code) + $padding * 2 + $border * 2 + 1;
        $height = $font_height + $padding * 2 + $border * 2 + 1 + $float_pixel;

		// ͼ
		$img = imagecreate($width, $height);

		// Ʊ߿
        if ($border)
        {
            list($r, $g, $b) = Helper_ImgCode::hex2rgb($bdcolor);
			$color = imagecolorallocate($img, $r, $g, $b);
			imagefilledrectangle($img, 0, 0, $width, $height, $color);
		}

		// Ʊ
		list($r, $g, $b) = Helper_ImgCode::hex2rgb($bgcolor);
		$color = imagecolorallocate($img, $r, $g, $b);
		imagefilledrectangle($img, $border, $border, $width - $border - 1, $height - $border - 1, $color);

		// 
		list($r, $g, $b) = Helper_ImgCode::hex2rgb($color);
		$color = imagecolorallocate($img, $r, $g, $b);

		for ($i = 0, $max = strlen($code); $i < $max; $i++)
		{
    		imagestring($img, $font, $padding + $border + $font_width * $i, $padding + $border + mt_rand(0, $float_pixel), $code[$i], $color);
		}

        $filename = 'imgcode-' . $code;
		ob_start();

		// ͼ
        switch (strtolower($this->_options['image_type']))
        {
		case 'png':
			$filename .= '.png';
			$mime = image_type_to_mime_type(IMAGETYPE_PNG);
			imagepng($img);
			break;

		case 'gif':
			$filename .= '.gif';
			$mime = image_type_to_mime_type(IMAGETYPE_GIF);
			imagegif($img);
			break;

		case 'jpg':
		default:
			$filename .= '.jpg';
			$mime = image_type_to_mime_type(IMAGETYPE_JPEG);
			imagejpeg($img);
		}

		imagedestroy($img);
		unset($img);
/*
		$output = new QView_Output($filename, $mime, ob_get_clean());
		$output
            ->contentDisposition('inline')
            ->enableClientCache(false);

		return $output;*/
	}
}

/**
 * Helper_ImgCodeTTF ʹ ttf ֤
 *
 * @author YuLei Liao <liaoyulei@qeeyuan.com>
 * @version $Id: imgcode.php 2524 2009-05-27 05:30:30Z jerry $
 * @package helper
 */
class Helper_ImgCodeTTF
{
    /**
     * ֤Ҫѡ
     *
     * @var array
     */
    protected $_options = array
    (
        // ֤볤
        'code_length'       => 6,

        // ֤ͼ
        'width'             => 170,

        // ֤ͼ߶
        'height'            => 90,

        // ַ¸
        'float_pixel'       => 10,

        // תǶ
        'max_angle'         => 35,

        // С
        'font_size'         => 50,

        // ͼ
        'font_space'        => 0,

        // ͼ
        'image_type'        => IMAGETYPE_JPEG,

        // 壬Ϊ 0-5ʹ QeePHP Դ
        // ʹԶ壬font ָΪļľ·
        'font'              => 0,

        // ɫ
        'color'             => 'fff',

        // ɫ
        'bgcolor'           => '333',

        // ֤ͼƬ߽ɫ
        'bdcolor'           => 'ccc',

        // ڿ
        'padding'           => 5,

        // ߽
        'border'            => 1,
    );

    /**
     * õб
     *
     * @var array
     */
    static protected $_font_list = array
    (
        'alpha_thin.ttf',
    );

    /**
     * 캯
     *
     * @param array $options
     *   ֤ѡ
     */
    function __construct(array $options)
    {
        $this->_options = array_merge($this->_options, $options);
    }

    /**
     * ֤
     *
     * @return string
     */
    function generateCode()
    {
        $code_length = intval($this->_options['code_length']);
        if ($code_length <= 0) { $code_length = 4; }
        $seed = '346789ABCDEFGHJKLMN346789PQRTUVWXYabcdefghj346789klmnpqrt346789uvwxy';

        $code = '';
        $len = strlen($seed) - 1;
        for ($i = 0; $i < $code_length; $i++)
        {
            $code .= substr($seed, mt_rand(0, $len), 1);
        }

        return $code;
    }

    /**
     * ֤ͼ񣬷 QView_Output 
     *
     * $param string $code
     *
     * @return QView_Output
     */
    function generateImage($code)
    {
        // ȷҪʹõ
        if (isset(self::$_font_list[$this->_options['font']]))
        {
            $font = Q_DIR . '/_resources/' . self::$_font_list[$this->_options['font']];
        }
        else
        {
            $font = $this->_options['font'];
        }

        // ȷͼĿȺ͸߶
        $border = $this->_options['border'];
        $float_pixel = intval($this->_options['float_pixel']);
        $padding = intval($this->_options['padding']);

        $width = intval($this->_options['width']) + $padding * 2 + $border * 2 + 1;
        $width *= 2;
        $height = intval($this->_options['height']) + $padding * 2 + $border * 2 + 1 + $float_pixel;

        // ͼ
        $img = imagecreatetruecolor($width, $height);

        // Ʊ
        list($r, $g, $b) = Helper_ImgCode::hex2rgb($this->_options['bgcolor']);
        imagefilledrectangle($img, $border, $border, $width - $border - 1, $height - $border - 1, imagecolorallocate($img, $r, $g, $b));

        // 
        $max_angle = intval($this->_options['max_angle']);

        $x = $padding + $padding + $border;

        $bottom = $height - $padding + $border - $float_pixel * 2;
        $font_space = $this->_options['font_space'];
        $color_arr = Helper_ImgCode::hex2rgb($this->_options['color']);

        $arr = array();
        $font_size = $this->_options['font_size'];
        $min_r = $r + 50;
        $min_g = $g + 50;
        $min_b = $b + 50;
        for ($i = 0, $max = strlen($code); $i < $max; $i++)
        {
            $arr[$i]['font_size'] = (mt_rand(50, 150) / 100) * $font_size;
            $arr[$i]['angle'] = rand(0, $max_angle) - $max_angle / 2;
            list($r, $g, $b) = $color_arr;
            $r = ($r + rand(0, 2550)) % (255 - $min_r) + $min_r;
            $g = ($g + rand(0, 2550)) % (255 - $min_g) + $min_g;
            $b = ($b + rand(0, 2550)) % (255 - $min_b) + $min_b;
            $arr[$i]['color'] = imagecolorallocate($img, $r, $g, $b);
        }

        for ($i = 0; $i < $max; $i++)
        {
            $x += $font_space;
            $y = $bottom;

            list(,, $x) = imagettftext($img, $arr[$i]['font_size'], $arr[$i]['angle'], $x, $y, $arr[$i]['color'], $font, $code[$i]);
            imagecolordeallocate($img, $arr[$i]['color']);
        }

        $new_width = intval($this->_options['width']) + $padding * 2 + $border * 2 + 1;
        $img_output = imagecreatetruecolor($new_width, $height);
        imagecopyresampled($img_output, $img, 0, 0, 0, 0, $new_width, $height, $x + $padding + $border, $height);
        imagedestroy($img);

        // Ʊ߿
        if ($border)
        {
            list($r, $g, $b) = Helper_ImgCode::hex2rgb($this->_options['bdcolor']);
            imagerectangle($img_output, 0, 0, $width, $height, imagecolorallocate($img_output, $r, $g, $b));
        }

        $filename = 'imgcode-' . $code;
        ob_start();

        // ͼ
        switch (strtolower($this->_options['image_type']))
        {
        case 'png':
            $filename .= '.png';
            $mime = image_type_to_mime_type(IMAGETYPE_PNG);
            imagepng($img_output);
            break;

        case 'gif':
            $filename .= '.gif';
            $mime = image_type_to_mime_type(IMAGETYPE_GIF);
            imagegif($img_output);
            break;

        case 'jpg':
        default:
            $filename .= '.jpg';
            $mime = image_type_to_mime_type(IMAGETYPE_JPEG);
            imagejpeg($img_output);
        }

        imagedestroy($img_output);
/*
        $output = new QView_Output($filename, $mime, ob_get_clean());
        $output->enableClientCache(false);

        return $output;*/
    }
}

