<?php


class mainpage extends connector {

	function mainpage() {
		$this->softbase(false);
		$this->mlink = $this->memberlink(array(), admin_LNG);
	}

	function in_home() {
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$db_table = db_prefix . 'bbs_typelist';
		$db_table2 = db_prefix . 'bbs';
		$typearray = $this->get_bbstype_array(0, $lng, 1);
		if ($typearray['num'] > 0 && is_array($typearray['list'])) {
			foreach ($typearray['list'] as $key => $value) {
				$typearray['list'][$key]['link'] = $rsList['link'] = $this->get_link('forumlist', $value, admin_LNG);
				$typearray['list'][$key]['addlink'] = $rsList['link'] = $this->get_link('forumadd', $value, admin_LNG);
			}
			$label = $this->get_bbslabel_array(0, $lng, 1);
			$labelarray = $this->fun->key_array_name($label['list'], 'blid', 'labelname');

			foreach ($typearray['list'] as $key => $rsArray) {
				$arraylist = null;
				$typeid = $rsArray['btid'];
				$db_where = "linkebid=0 AND isclass=1 AND btid=$typeid ORDER BY pid,bid DESC LIMIT 0," . $this->CON['bbs_max_home'];
				$sql = "SELECT * FROM $db_table2 WHERE $db_where";
				$rs = $this->db->query($sql);
				while ($rsList = $this->db->fetch_assoc($rs)) {
					$rsList['link'] = $this->get_link('forumread', $rsList, admin_LNG);
					if ($rsList['userid'] > 0) {
						$member = $this->get_member(null, $rsList['userid']);
						$rsList['author'] = empty($member['alias']) ? $member['username'] : $member['alias'];
						if (empty($rsList['author'])) {
							$rsList['author'] = $this->lng['forum_anonymity'];
						}
					} else {
						$rsList['author'] = $this->lng['forum_anonymity'];
					}
					$rsList['labelname'] = $labelarray[$rsList['blid']];
					$arraylist[] = $rsList;
				}
				$typearray['list'][$key]['bbslist'] = $arraylist;
			}
		}

		$templatesDIR = $this->get_templatesdir('forum');
		$templatefilename = $lng . '/' . $templatesDIR . '/forum_center';
		$this->pagetemplate->assign('path', 'forum');
		$this->pagetemplate->assign('out', 'forumindex');
		$this->pagetemplate->assign('typelist', $typearray['list']);
		$this->pagetemplate->assign('mlink', $this->mlink);
		unset($this->mlink, $LANPACK, $this->lng);
		$this->pagetemplate->display($templatefilename, 'index', false, null, admin_LNG);
	}

	function in_add() {
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$btid = intval($this->fun->accept('btid', 'G'));
		if (empty($btid)) {
			$this->callmessage($this->lng['db_err'], $_SERVER['HTTP_REFERER'], $this->lng['gobackurlbotton']);
		}
		$btid = empty($btid) ? 0 : $btid;

		$typearray = $this->get_bbstype_array($btid, $lng, 1);

		$purview = $this->get_bbstype_view($btid, 'purview');
		$username = $this->member_cookieview('username');
		if (!$this->CON['is_anonymous'] || $username) {
			parent::member_purview($purview, null, true);
		} elseif ($purview > 0) {
			parent::member_purview($purview, null, true);
		}

		if (!empty($this->ec_member_username_id) && !empty($this->ec_member_username)) {

			$rsMember = $this->get_member(null, $this->ec_member_username_id);

			$lockusername = explode(',', $this->CON['bbs_username']);

			if (in_array($this->ec_member_username, $lockusername)) {
				$this->callmessage($this->lng['forum_mem_username'], $_SERVER['HTTP_REFERER'], $this->lng['gobackbotton']);
			}
		} else {
			$rsMember['username'] = null;
			$rsMember['userid'] = 0;
		}

		$label = $this->get_bbslabel_array(1, $lng, 1);

		$this->pagetemplate->assign('upurllist', $_SERVER['HTTP_REFERER']);
		$this->pagetemplate->assign('member', $rsMember);
		$this->pagetemplate->assign('typelist', $typearray['list']);
		$this->pagetemplate->assign('label', $label['list']);
		$this->pagetemplate->assign('mlink', $this->mlink);
		$this->pagetemplate->assign('path', 'forum');
		$this->pagetemplate->assign('bbs_isseccode', $this->CON['bbs_isseccode']);

		$this->pagetemplate->assign('seccodelink', $this->get_link('seccode'));

		$templatesDIR = $this->get_templatesdir('forum');
		$templatefilename = $lng . '/' . $templatesDIR . '/forum_center';
		$this->pagetemplate->assign('out', 'forumadd');
		unset($this->mlink, $LANPACK, $this->lng);
		$this->pagetemplate->display($templatefilename, 'index', false, null, admin_LNG);
	}

	function in_save() {
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$linkURL = $_SERVER['HTTP_REFERER'];

		if ($this->CON['bbs_isseccode']) {
			$seccode = $this->fun->accept('seccode', 'P');
			include_once admin_ROOT . 'public/class_seccode.php';
			list($new_seccode, $expiration) = explode("\t", $this->fun->eccode($_COOKIE['ecisp_home_seccode'], 'DECODE'));
			$code = new seccode();
			$code->seccodeconvert($new_seccode);
			if ($new_seccode != strtoupper($seccode)) {
				$this->callmessage($this->lng['seescodeerr'], $linkURL, $this->lng['gobackbotton']);
			}
		}
		$db_table = db_prefix . "bbs";
		$db_table2 = db_prefix . "bbs_content";
		$inputclass = $this->fun->accept('inputclass', 'P');
		$title = trim($this->fun->accept('title', 'P', true, true));
		$btid = $this->fun->accept('btid', 'P');
		$btid = empty($btid) ? 0 : intval($btid);
		$blid = $this->fun->accept('blid', 'P');
		$blid = empty($blid) ? 0 : intval($blid);
		$noreply = intval($this->fun->accept('noreply', 'P'));
		$content = $this->fun->accept('content', 'P', true, true);
		$userid = intval($this->fun->accept('userid', 'P'));

		$nowuserid = $this->fun->accept('nowuserid', 'P');
		if (empty($title) || empty($content) || empty($btid)) {
			$this->callmessage($this->lng['forum_input_err'], $linkURL, $this->lng['gobackbotton']);
		}

		$isclass = $this->CON['bbs_isclass'] ? 0 : 1;

		$purview = $this->get_bbstype_view($btid, 'purview');
		if (!$this->CON['is_anonymous']) {
			parent::member_purview($purview);
		} elseif ($purview > 0) {
			parent::member_purview($purview);
		}
		if (!empty($this->ec_member_username_id) && !empty($this->ec_member_username)) {

			$rsMember = $this->get_member(null, $this->ec_member_username_id);

			$lockusername = explode(',', $this->CON['bbs_username']);

			if (in_array($this->ec_member_username, $lockusername)) {
				$this->callmessage($this->lng['forum_mem_username'], $_SERVER['HTTP_REFERER'], $this->lng['gobackbotton']);
			}
		}
		$ipadd = $this->fun->ip($_SERVER['REMOTE_ADDR']);
		$addtime = time();

		if (!empty($this->CON['bbs_filter'])) {
			if ($this->fun->screening_key($content, $this->CON['bbs_filter']) || $this->fun->screening_key($title, $this->CON['bbs_filter'])) {
				$this->callmessage($this->lng['forum_input_filter'], $linkURL, $this->lng['gobackbotton']);
			}
		}

		if ($inputclass == 'input') {

			$usersessionid = md5($ipadd + $btid . 'input');
			$inputseesion = $this->fun->accept($usersessionid, 'C');

			if (empty($inputseesion) && $this->CON['bbs_inputtime']) {
				$this->fun->setcookie($usersessionid, $addtime, $this->CON['bbs_inputtime']);
			} elseif ($this->CON['bbs_inputtime']) {

				$this->callmessage($this->lng['repeatinput'], $linkURL, $this->lng['gobackurlbotton']);
			}

			$db_field = 'btid,linkebid,pid,userid,blid,lng,title,keyword,replynum,replyid,click,addtime,updatetime,isclass,istop,recommend,purview,noreply,ip';
			$db_values = "$btid,0,0,$userid,$blid,'$lng','$title','',0,0,0,$addtime,$addtime,$isclass,0,0,0,$noreply,$ipadd";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$insert_id = $this->db->insert_id();
			$db_field = 'bid,btid,linkebid,content';
			$db_values = "$insert_id,$btid,0,'$content'";
			$this->db->query('INSERT INTO ' . $db_table2 . ' (' . $db_field . ') VALUES (' . $db_values . ')');

			if ($userid > 0) {
				$this->set_member_integral($userid, $this->CON['bbs_inputintegral']);
			}

			$this->dbcache->clearcache('bbs_list_array_' . $btid, true);

			$this->fun->setcookie('ecisp_home_seccode', null);
			$linkURL = $this->get_link('forumlist', array('btid' => $btid), admin_LNG);
			$this->callmessage($this->lng['forum_input_ok'], $linkURL, $this->lng['gobackurlbotton']);
		}

		if ($inputclass == 'reinput') {
			$linkebid = intval($this->fun->accept('linkebid', 'P'));
			$purview = intval($this->fun->accept('purview', 'P'));
			$noreply = intval($this->fun->accept('noreply', 'P'));
			if (!$noreply) {
				$this->callmessage($this->lng['forum_re_no'], $linkURL, $this->lng['gobackurlbotton']);
			}

			$usersessionid = md5($ipadd + $linkebid . 'reinput');
			$inputseesion = $this->fun->accept($usersessionid, 'C');

			if (empty($inputseesion) && $this->CON['bbs_inputtime']) {
				$this->fun->setcookie($usersessionid, $addtime, $this->CON['bbs_inputtime']);
			} elseif ($this->CON['bbs_inputtime']) {

				$this->callmessage($this->lng['repeatinput'], $linkURL, $this->lng['gobackurlbotton']);
			}

			$db_where = "bid=$linkebid AND isclass=1";
			$db_set = "replynum=replynum+1,replyid=$userid,updatetime=$addtime";
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);

			$db_field = 'btid,linkebid,pid,userid,blid,lng,title,keyword,replynum,replyid,click,addtime,updatetime,isclass,istop,recommend,purview,noreply,ip';
			$db_values = "$btid,$linkebid,0,$userid,$blid,'$lng','$title','',0,0,0,$addtime,$addtime,$isclass,0,0,0,$noreply,$ipadd";
			$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
			$insert_id = $this->db->insert_id();
			$db_field = 'bid,btid,linkebid,content';
			$db_values = "$insert_id,$btid,$linkebid,'$content'";
			$this->db->query('INSERT INTO ' . $db_table2 . ' (' . $db_field . ') VALUES (' . $db_values . ')');

			$this->fun->setcookie('ecisp_home_seccode', null);

			if ($userid > 0) {
				$this->set_member_integral($userid, $this->CON['bbs_inputintegral']);
			}

			if ($this->CON['is_email'] == 1 && $this->CON['bbs_ismail'] && $userid > 0 && $userid != $nowuserid) {
				$this->forumsendmail('bbsre', $linkebid);
			}
			$linkURL = $this->get_link('forumread', array('bid' => $linkebid), admin_LNG);
			$this->callmessage($this->lng['forum_input_ok'], $linkURL, $this->lng['gobackurlbotton']);
		}
	}

	function in_list() {
		parent::start_pagetemplate();
		include_once admin_ROOT . 'public/class_pagebotton.php';
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;

		$page = $this->fun->accept('page', 'G');
		$page = !empty($page) ? intval($page) : 1;
		$pagesylte = 1;

		$pagemax = intval($this->CON['bbs_max_list']);
		$btid = intval($this->fun->accept('btid', 'G'));
		if (empty($btid)) {
			$this->callmessage($this->lng['db_err'], $_SERVER['HTTP_REFERER'], $this->lng['gobackurlbotton']);
		}
		$typeread = $this->get_bbstype_view($btid);
		if (!$typeread['isclass']) {
			exit("Information parameter error!");
		} elseif ($typeread['purview'] > 0) {
			parent::member_purview($typeread['purview'], null, true);
		}
		$typeread['addlink'] = $this->get_link('forumadd', $typeread, admin_LNG);
		$typeread['link'] = $this->get_link('forumlist', $typeread, admin_LNG);
		$this->pagetemplate->assign('type', $typeread);

		$db_table = db_prefix . 'bbs';
		$db_where = " WHERE isclass=1 AND linkebid=0 AND btid=$btid AND lng='$lng'";
		$countnum = $this->db_numrows($db_table, $db_where);
		if ($countnum > 0) {

			$numpage = ceil($countnum / $pagemax);
		} else {
			$numpage = 1;
		}
		$label = $this->get_bbslabel_array(0, $lng, 1);
		$labelarray = $this->fun->key_array_name($label['list'], 'blid', 'labelname');
		$sql = "SELECT bid,btid,linkebid,pid,userid,blid,lng,title,keyword,replynum,replyid,click,addtime,updatetime,isclass,istop,recommend,purview,noreply,ip FROM $db_table $db_where LIMIT 0,$pagemax";
		$this->htmlpage = new PageBotton($sql, $pagemax, $page, $countnum, $numpage, $pagesylte, $this->CON['file_fileex'], 5, $this->lng['pagebotton'], $this->lng['gopageurl'], $this->CON['is_rewrite']);
		$sql = $this->htmlpage->PageSQL('istop,pid,bid', 'down');
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$rsList['link'] = $this->get_link('forumread', $rsList, admin_LNG);
			if ($rsList['userid'] > 0) {
				$member = $this->get_member(null, $rsList['userid']);
				$rsList['author'] = empty($member['alias']) ? $member['username'] : $member['alias'];
				if (empty($rsList['author'])) {
					$rsList['author'] = $this->lng['forum_anonymity'];
				}
			} else {
				$rsList['author'] = $this->lng['forum_anonymity'];
			}
			$rsList['labelname'] = $labelarray[$rsList['blid']];
			$array[] = $rsList;
		}
		$this->pagetemplate->assign('pagetext', $this->htmlpage->PageStat($this->lng['pagetext']));
		$this->pagetemplate->assign('pagebotton', $this->htmlpage->PageList());
		$this->pagetemplate->assign('pagenu', $this->htmlpage->Bottonstyle(false));
		$this->pagetemplate->assign('pagese', $this->htmlpage->pageSelect());
		$this->pagetemplate->assign('pagevt', $this->htmlpage->Prevbotton());

		$this->pagetemplate->assign('array', $array);
		$this->pagetemplate->assign('path', 'forum');

		$templatesDIR = $this->get_templatesdir('forum');
		$templatefilename = $lng . '/' . $templatesDIR . '/forum_center';
		$this->pagetemplate->assign('out', 'forumlist');
		unset($array, $typeread, $modelview, $LANPACK, $this->lng);
		$this->pagetemplate->display($templatefilename, 'forum_list', false, '', admin_LNG);
	}

	function in_read() {
		parent::start_pagetemplate();
		include_once admin_ROOT . 'public/class_pagebotton.php';   //分页相关操作
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;

		$page = $this->fun->accept('page', 'G');
		$page = !empty($page) ? intval($page) : 1;
		$pagesylte = 1;
		$pagemax = intval($this->CON['bbs_max_read']);
		$bid = intval($this->fun->accept('bid', 'G'));
		if (empty($bid)) trigger_error("Forum parameter error!", E_USER_ERROR);

		$db_table = db_prefix . 'bbs';
		$db_where = "isclass=1 AND linkebid=0 AND bid=$bid";
		$db_set = "click=click+1";
		$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		$rsList = $this->get_bbs($bid);
		if (!$rsList) exit("Information parameter error!");

		$typeread = $this->get_bbstype_view($rsList['btid']);

		$username = $this->member_cookieview('username');
		if (!$typeread['isclass']) {
			exit("Information parameter error!");
		} elseif ($typeread['purview'] > 0 || $username) {
			parent::member_purview($typeread['purview'], null, true);
		}
		$typeread['link'] = $this->get_link('forumlist', $typeread, admin_LNG);

		if (!empty($this->ec_member_username_id) && !empty($this->ec_member_username)) {

			$rsMember = $this->get_member(null, $this->ec_member_username_id);
		} else {
			$rsMember['username'] = $this->lng['forum_anonymity'];
			$rsMember['userid'] = 0;

			if (!$this->CON['is_anonymous']) {
				$nowurl = 'http://' . $_SERVER["HTTP_HOST"] . $_SERVER['REQUEST_URI'];
				$this->fun->setcookie('ecisp_login_link', $nowurl, 600);
			}
		}
		$this->pagetemplate->assign('type', $typeread);
		$this->pagetemplate->assign('upurllist', $_SERVER['HTTP_REFERER']);
		$this->pagetemplate->assign('member', $rsMember);
		$this->pagetemplate->assign('mlink', $this->mlink);
		$this->pagetemplate->assign('path', 'forum');
		$this->pagetemplate->assign('bbs_isseccode', $this->CON['bbs_isseccode']);
		$this->pagetemplate->assign('is_anonymous', $this->CON['is_anonymous']);
		unset($rsMember, $typeread);

		$this->pagetemplate->assign('seccodelink', $this->get_link('seccode'));

		$label = $this->get_bbslabel_array(0, $lng, 1);
		$labelarray = $this->fun->key_array_name($label['list'], 'blid', 'labelname');
		$this->pagetemplate->assign('label', $label['list']);
		unset($label);

		if ($rsList['userid'] > 0) {
			$member = $this->get_member(null, $rsList['userid']);
			$rsList['author'] = empty($member['alias']) ? $member['username'] : $member['alias'];
			if (empty($rsList['author'])) {
				$rsList['author'] = $this->lng['forum_anonymity'];
			}
			unset($member);
		} else {
			$rsList['author'] = $this->lng['forum_anonymity'];
		}
		$rsList['labelname'] = $labelarray[$rsList['blid']];
		$rsList['content'] = stripslashes(htmlspecialchars_decode($rsList['content']));
		$this->pagetemplate->assign('read', $rsList);
		$linkebid = $rsList['bid'];

		$db_table = db_prefix . 'bbs';
		$db_where = " WHERE isclass=1 AND linkebid=$linkebid";
		$countnum = $this->db_numrows($db_table, $db_where);
		if ($countnum > 0) {

			$numpage = ceil($countnum / $pagemax);
		} else {
			$numpage = 1;
		}
		$sql = "SELECT bid,btid,linkebid,pid,userid,blid,lng,title,keyword,replynum,replyid,click,addtime,updatetime,isclass,istop,recommend,purview,noreply,ip FROM $db_table $db_where LIMIT 0,$pagemax";
		$this->htmlpage = new PageBotton($sql, $pagemax, $page, $countnum, $numpage, $pagesylte, $this->CON['file_fileex'], 5, $this->lng['pagebotton'], $this->lng['gopageurl'], $this->CON['is_rewrite']);
		$sql = $this->htmlpage->PageSQL('istop,pid,bid', 'up');
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$rsList['link'] = $this->get_link('forumread', $rsList, admin_LNG);
			if ($rsList['userid'] > 0) {
				$member = $this->get_member(null, $rsList['userid']);
				$rsList['author'] = empty($member['alias']) ? $member['username'] : $member['alias'];
				if (empty($rsList['author'])) {
					$rsList['author'] = $this->lng['forum_anonymity'];
				}
			} else {
				$rsList['author'] = $this->lng['forum_anonymity'];
			}
			$rsList['content'] = $this->get_bbs_content($rsList['bid'], 'content');
			$rsList['content'] = stripslashes(htmlspecialchars_decode($rsList['content']));
			$rsList['labelname'] = $labelarray[$rsList['blid']];
			$array[] = $rsList;
		}

		$templatesDIR = $this->get_templatesdir('forum');
		$templatefilename = $lng . '/' . $templatesDIR . '/forum_center';   //模板路径
		$this->pagetemplate->assign('out', 'forumread');

		$this->pagetemplate->assign('pagetext', $this->htmlpage->PageStat($this->lng['pagetext']));
		$this->pagetemplate->assign('pagebotton', $this->htmlpage->PageList());
		$this->pagetemplate->assign('pagenu', $this->htmlpage->Bottonstyle(false));
		$this->pagetemplate->assign('pagese', $this->htmlpage->pageSelect());
		$this->pagetemplate->assign('pagevt', $this->htmlpage->Prevbotton());

		$this->pagetemplate->assign('array', $array);
		unset($array, $typeread, $modelview, $LANPACK, $this->lng);
		$this->pagetemplate->display($templatefilename, 'forum_read', false, '', admin_LNG);//$1模板路径,$2缓存键值,$3是否生成html
	}

}
?>