<?php

class mainpage extends connector {

	function mainpage() {
		$this->softbase(false);
		$this->mlink = $this->memberlink(array(), admin_LNG);
	}
	
	function in_hotelsearch() {
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$country = "中国";
		$regionCode = "";
		$provinceCode = "";
		$cityCode = $this->fun->accept('cityid', 'R');    //城市ID
		$cityname = $this->fun->accept('cityname', 'R');  //城市名称
		if(!$cityname) {
			$cityname = $this->get_cityname($cityCode);
		}
		if(!$this->fun->is_utf8($cityname)) {
			$cityname = iconv("gb2312","utf-8",$cityname);
		}

		$districtCode = $this->fun->accept('districtCode', 'R');  //行政区
		$businessZoneCode = $this->fun->accept('businessZoneCode', 'R');  //商业区
		$checkInDate = $this->fun->accept('tm1', 'R');
		$checkOutDate = $this->fun->accept('tm2', 'R');
		
		if(!$cityCode) {
			$this->fun->message("城市输入有误，请返回重新输入。");
		}
		if(strtotime($checkInDate) < strtotime(date('Y-m-d')) || strtotime($checkOutDate) < strtotime(date('Y-m-d'))) {
			$checkInDate = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600));
			$checkOutDate = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600*3));
		}
		if(!$checkInDate) { $checkInDate = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600)); }
		if(!$checkOutDate) { $checkOutDate = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600*3));}
		
		$this->fun->setcookie("search_tm1",$checkInDate);
		$this->fun->setcookie("search_tm2",$checkOutDate);
		
		$categories = $this->fun->accept('hotelstar', 'R');    //星级
		$hotelprice = $this->fun->accept('hotelprice','R');
		$lowestPrice = $this->fun->accept('lowestPrice','R');
		$highestPrice = $this->fun->accept('highestPrice','R');
		if(!$lowestPrice) { $lowestPric = 0;}
		if(!$highestPrice) { $highestPrice = 0;}
		if($hotelprice) {
			if($hotelprice == "200") {
				$highestPrice = 200;
			} else if($hotelprice == "500") {
				$lowestPrice = 500;
			} else if(strpos($hotelprice,',') > 0) {
				$a = explode(',',$hotelprice);
				$lowestPrice = $a[0];
				$highestPrice = $a[1];
			}
		}
		
		$broadbandService = $this->fun->accept('broadbandService', 'R');  //宽带服务 0,1,2 不限制,收费,免费
		$keyword = $this->fun->accept('hotelname', 'R');   //酒店名关键字
		if(!$this->fun->is_utf8($keyword)) {
			$keyword = iconv("gb2312","utf-8",$keyword);
		}
		//hotelnearby_coookie
		$hotelnearby = $this->fun->accept('hotelnearby', 'R');  //地标名
		//$hotelnearby = $_COOKIE['hotelnearby_cookie'];

		if(!$this->fun->is_utf8($hotelnearby)) {
			$hotelnearby = iconv("gb2312","utf-8",$hotelnearby);
		}
		$coordinate = $this->fun->accept('coordinate', 'R');
		$lng2 = $this->fun->accept('lng', 'R');
		$lat = $this->fun->accept('lat', 'R');
		if($coordinate) {
			if($coordinate && strpos($coordinate,',') >0) {
				$coo = explode(',',$coordinate);
				$lng2 = $coo[0];
				$lat  = $coo[1];
			}
		}
		if(!$hotelnearby) {
			$lng2 = 0;
			$lat = 0;
		} else {
			if(!$lng2 || !$lat) {
				$data = array(
					'cityName' =>$cityname,
					'keyword' =>$hotelnearby
				);
				$resnear = $this->get_interface_hotelurl("hotelnearby",$data);
				$arrnear = $resnear['ResponseBody']['Landmarks'][0];
				if($arrnear) {
					$lng2 = $arrnear['Lng'];
					$lat  = $arrnear['Lat'];
				}
			}
		}
		$radius = $this->fun->accept('radius', 'R');   //查询半径
		if(!$radius) { $radius = 3000;}
		$pageIndex = $this->fun->accept('pageIndex', 'R');  //当前页码
		if(!$pageIndex) { $pageIndex = 1;}
		$pageSize = 10;   //多少条
		$sortType = $this->fun->accept('sortType', 'R');   //排序
		if(!$sortType) { $sortType=0;}
		$includeNonBooking = $this->fun->accept('includeNonBooking', 'R');
		if($includeNonBooking=="1") { $includeNonBooking=0;} else {$includeNonBooking=1;}
		$includeGuaranteeable = $this->fun->accept('includeGuaranteeable', 'R');   //是否包含担保
		if($includeGuaranteeable=="1") { $includeGuaranteeable=0;} else{ $includeGuaranteeable=1;}
		$chainBrands = $this->fun->accept('chainBrands', 'R');   //连锁品牌
		$simple = $this->fun->accept('simple', 'R');   //1或者0
		$clng = $clat = 0;
		if($simple == 2) {
			$arrlng = $this->get_hotelnglat($cityCode);
			$clng = $arrlng['Lng'];
			$clat = $arrlng['Lat'];
			
			if(!$clng || !$clat) {
				$res = $this->get_hotel_nearby($cityname,$cityname);
				$clng = $res[0]['Lng'];
				$clat = $res[0]['Lat'];
			}
		}
		$businessZoneText = "";  //商业区名称
		$param = array(
			'country' => $country,
			'regionCode' => $regionCode,
			'provinceCode' => $provinceCode,
			'cityCode' => $cityCode,
			'districtCode' => $districtCode,
			'businessZoneCode' => $businessZoneCode,
			'checkInDate' => $checkInDate,
			'checkOutDate' => $checkOutDate,
			'categories' => $categories,
			'lowestPrice' => $lowestPrice,
			'highestPrice' => $highestPrice,
			'broadbandService' => $broadbandService,
			'keyword' => $keyword,
			'landmark' => $hotelnearby,
			'lng' => $lng2,
			'lat' => $lat,
			'clng' => $clng,
			'clat' => $clat,
			'radius' => $radius,
			'pageIndex' => $pageIndex,
			'pageSize' => $pageSize,
			'sortType' => $sortType,
			'includeNonBooking' => $includeNonBooking,
			'includeGuaranteeable' => $includeGuaranteeable,
			'chainBrands' => $chainBrands,
			'cityname' => $cityname,
			'simple' => $simple
		);
		
		$arr = $arrcity = $arrland = array();
		$arrcity = $this->get_singlecity($cityCode,true,true,true);
		$arr = $this->get_hotel_search($param);

		$coordlist = "";
		foreach ($arr['Hotels'] as $k=>$hotel) {
			$isGarantee = false;	
			$coordlist .= "\"".($hotel['Lng']-0.0107).",".($hotel['Lat']-0.0002)."\",";
			$m = 0; $sroom2 =  array();
			foreach ($hotel['Rooms'] as $keymap=>$roommap) {
				if($simple == 2) {
					$m++;
					if($m <= 2) {
						$sroom = array();
						$sroom['Name'] = $roommap['Name'];
						if($roommap['Broadband'] == 1) { 
							$sroom['Broadband'] ="收费";
						} else if($roommap['Broadband'] == 2) { 
							$sroom['Broadband'] ="免费";
						} else {
							$sroom['Broadband'] ="无";
						}
						$sroom['Bed'] = str_replace("人","",$roommap['BedDescription']);
						$sroom['Price'] = intval($roommap['RatePlans'][0]['AveragePrice']);
						$sroom['Rate'] = $roommap['RatePlans'][0]['Name'];
						$sroom['canbook'] = $roommap['RatePlans'][0]['Rates'][0]['CanBook'];
						$sroom['hid'] = $hotel['_id'];
						$sroom['rid'] = $roommap['TypeId'];
						$sroom['pid'] = $roommap['RatePlans'][0]['_id'];
						$sroom['tm1'] = $checkInDate;
						$sroom['tm2'] = $checkOutDate;
						$sroom2[] = $sroom;
					}
				}
				if(!$isGarantee) {
					foreach ($roommap['RatePlans'] as $keyplan=>$ratevalue) {
						if(count($ratevalue['GaranteeRules'])>0) {
							$isGarantee = true;
							break;
						}
					}
				}
			}
			$arr['Hotels'][$k]['isGarantee'] = $isGarantee;
			$arr['Hotels'][$k]['maproom'] = $sroom2;

			
			$hotel['IntroEditor'] = str_replace(" ","",$hotel['IntroEditor']);
			$hotel['IntroEditor'] = str_replace("　","",$hotel['IntroEditor']);
			$hotel['IntroEditor'] = str_replace("	","",$hotel['IntroEditor']);
			$showurl = $this->get_link("hotelshow",array('hid'=>$hotel['_id']),$lng);
			$arr['Hotels'][$k]['showurl'] = $showurl;
			$landmark = array();
			if($hotel['Landmarks']) {    //周边地区
				$n = 0;
				foreach ($hotel['Landmarks'] as $key=>$value) {
					if(!empty($businessZoneCode) && empty($businessZoneText)) {
						if($businessZoneCode == $key) {
							$businessZoneText = $value;
						}
					}
					$markparam = array();
					$markparam['businessZoneCode'] = $key;
					$markparam['cityCode'] = $cityCode;
					$markparam['includeNonBooking'] = 1;
					$markparam['includeGuaranteeable'] = 1;
					
					$markparam['pageIndex'] = 1;$linkurl = $this->get_hotel_fliterurl($markparam);
					unset($markparam);
					$landmark[] = array('id'=>$key,'name'=>$value,'linkurl'=>$linkurl);
					$n++;
					if($n>=5) break;
				}
			} else {
				$landmark = null;
			}
			$arr['Hotels'][$k]['Landmarks'] = $landmark;
			if(count($arr['Hotels'][$k]['Landmarks'])>0) {
				$arr['Hotels'][$k]['countLandmarks'] = 1;
			} else {
				$arr['Hotels'][$k]['countLandmarks'] = 0;
			}
			if($hotel['DistrictId']) {
				foreach ($arrcity['DistrictLocations'] as $diskey=>$disvalue) {
					if($hotel['DistrictId'] ==$disvalue['Code']) {
						$arr['Hotels'][$k]['DistrictName'] = $disvalue['Name'];
						$disparam = $param;  $disparam['districtCode'] = $hotel['DistrictId'];   //行政区url
						$disparam['pageIndex'] = 1; $page_dis_url = $this->get_hotel_fliterurl($disparam);
						unset($disparam);
						$arr['Hotels'][$k]['DistrictUrl'] = $page_dis_url;
						break;
					}
				}
			} else {
				$arr['Hotels'][$k]['DistrictName'] = "";
			}
			
		}
		$coordlist = substr($coordlist,0,strlen($coordlist)-1);
		//房型 日均价 早餐 床型 宽带
		
		
		$arrlist = array(
			'Landmark' => $arr['Landmark'],
			'Lng'      => $arr['Lng'],
			'Lat'      => $arr['Lat'],
			'Radius'   => $arr['Radius'],
			'TotalItemCount'=> $arr['TotalItemCount'],
			'TotalPageCount'=> $arr['TotalPageCount'],
			'PageSize' => $arr['PageSize'],
			'PageIndex' => $arr['PageIndex'],
			'SortType' => $arr['SortType'],
			'Message' => $arr['Message']
		);
		if($arr['TotalPageCount'] == 1) {
			$pagenext = 1;
			$pagepre  = 1;
		} else {
			if($arr['PageIndex'] < $arr['TotalPageCount']) {
				$pagenext = intval($arr['PageIndex']) + 1;
				if($arr['PageIndex'] == 1) {
					$pagepre = 1;
				} else {
					$pagepre = intval($arr['PageIndex'])-1;
				}
			} else {
				$pagenext = $arr['TotalPageCount'];
				$pagepre = intval($arr['PageIndex'])-1;
			}
		}
		
		$pageparam = $param;
		$pageparam['pageIndex'] = $pagepre;
		$pagepreurl = $this->get_hotel_fliterurl($pageparam);
		$pageparam['pageIndex'] = $pagenext;
		$pagenexturl = $this->get_hotel_fliterurl($pageparam);
		$pageparam['pageIndex'] = 1;
		$pageindexurl = $this->get_hotel_fliterurl($pageparam);
		$pageparam['pageIndex'] = $arrlist['TotalPageCount'];
		$pagetotalurl = $this->get_hotel_fliterurl($pageparam);
		unset($pageparam);
		$modeparam = $param; $modeparam['pageIndex'] = 1;  $modeparam['simple'] = "{#simple#}";
		$pagemodeturl = $this->get_link('hotel_searchlist',$modeparam,$lng);
		unset($modeparam);
		$repriceparam = $param; $repriceparam['lowestPrice']="{#low#}"; $repriceparam['highestPrice']="{#hign#}"; 
		$repriceparam['pageIndex'] = 1;$page_reprice_url = $this->get_link('hotel_searchlist',$repriceparam,$lng);  //价格url
		unset($repriceparam);
		$restarparam = $param;  $restarparam['categories']="{#star#}";
		$restarparam['pageIndex'] = 1; $page_restar_url = $this->get_link('hotel_searchlist',$restarparam,$lng); //星级url
		unset($restarparam);
		//行政区url
		$reareaparam = $param;  $reareaparam['districtCode'] = "{#district#}";   
		$reareaparam['pageIndex'] = 1; $page_rearea_url = $this->get_hotel_fliterurl($reareaparam);
		unset($reareaparam);
		//商业区编码
		$relankparam = $param; $relankparam['businessZoneCode'] = "{#business#}";
		$relankparam['pageIndex'] = 1;$page_relank_url = $this->get_hotel_fliterurl($relankparam);  //商业区编码
		unset($relankparam);
		$chainparam = $param; $chainparam['chainBrands'] = "{#chain#}";
		$chainparam['pageIndex'] = 1;
		if($chainparam['includeGuaranteeable']==1 && $chainparam['includeNonBooking']==1 && empty($chainparam['keyword']) && empty($chainparam['landmark']) && ($chainparam['categories'] == '') && empty($chainparam['broadbandService']) && empty($chainparam['lowestPrice']) && empty($chainparam['highestPrice'])) {
			$page_chain_url = $this->get_link('hotel_chainlist',$chainparam,$lng);
		} else {
			$page_chain_url = $this->get_link('hotel_searchlist',$chainparam,$lng);
		}
		unset($chainparam);
		$guaranparam = $param;
		$guaranparam['includeGuaranteeable'] = 0;
		$page_guaran_url = $this->get_link('hotel_searchlist',$guaranparam,$lng);
		
		$nobookparam = $param;
		$nobookparam['includeNonBooking'] = 0;
		$page_nobook_url = $this->get_link('hotel_searchlist',$nobookparam,$lng);
		
		$keyparam = $param;  $landparam = $param; $cateparam = $param; $pparam = $param;
		$keyparam['keyword'] = "";  $cateparam['categories'] = 0;  $pparam['lowestPrice'] = 0; $pparam['highestPrice'] = 0;
		$keyparam['pageIndex'] = 1;  $landparam['pageIndex'] = 1; $cateparam['pageIndex'] = 1; $pparam['pageIndex'] = 1;
		$landparam['landmark'] = ""; $landparam['lng'] = 0; $landparam['lat'] = 0;
		$page_key_url = $this->get_link('hotel_searchlist',$keyparam,$lng);
		$page_land_url = $this->get_link('hotel_searchlist',$landparam,$lng);
		$page_cate_url = $this->get_link('hotel_searchlist',$cateparam,$lng);
		$page_pp_url = $this->get_link('hotel_searchlist',$pparam,$lng);
		$mapparam = $param;
		$mapparam['lng'] = '1'; $mapparam['lat'] = '1';
		$mapurl = $this->get_link('hotel_searchlist',$mapparam,$lng);
		
		unset($keyparam,$landparam,$cateparam,$pparam,$mapparam,$guaranparam);
		
		$pagetext = $this->get_page('hotel',$arr['TotalPageCount'],$arr['PageIndex'],$param,$lng);  
		
		$i = 0; $arrLocations = array();
		foreach ($arrcity['CommercialLocations'] as $key=>$value) {  //热门商圈
			if(!empty($businessZoneCode) && empty($businessZoneText)) {
				if($businessZoneCode == $value['Code']) {
					$businessZoneText = $value['Name'];
				}
			}
			$arrLocations[] = $value;
			$i++;
			if($i == 50) {break;}
		}
		$arrcity['CommercialLocations'] = $arrLocations;
		
		$n = 0; $arrLandmark = array();
		foreach ($arrcity['LandmarkLocations'] as $key=>$value) {  //热门地区
			if(!empty($businessZoneCode) && empty($businessZoneText)) {
				if($businessZoneCode == $value['Code']) {
					$businessZoneText = $value['Name'];
				}
			}
			$arrLandmark[] = $value;
			$n++;
			if($n == 50) {break;}
		}
		$arrcity['LandmarkLocations'] = $arrLandmark;
		
		$arrchainbrands = $this->get_hotel_listchainbrands();  //品牌信息
		
		$templatesDIR = $this->get_templatesdir('hotel');
		$templatefilename = $templatecache = "";
		if($simple==1) {
			$templatefilename = $lng . '/' . $templatesDIR . '/hotel_simple_list';
			$templatecache = "hotel_simple_list";
		} else if($simple==2) {
			$templatefilename = $lng . '/' . $templatesDIR . '/hotel_map';
			$templatecache = "hotel_map";
		} else {
			$templatefilename = $lng . '/' . $templatesDIR . '/hotel_search_list';
			$templatecache = "hotel_search_list";
		}
		$orderparam = array();
		$orderurl = $this->get_link('hotel_order',$orderparam,$lng);  //订单地址
		$dburl = $this->get_link('contrast',array(),$lng);
		if($simple==2) {$ktid = 104;} else {$ktid = 102;}
		$keylink = $this->get_keytype_purview($ktid);  //读取首页关键字描述
		$arrkeylink = array();
		if($businessZoneText) {
			$hotelnearby = $businessZoneText;
		}
		$start_land = mb_substr($hotelnearby,0,6);
		if($start_land != $cityname) {
			$keywords = str_replace('{#city#}',$cityname,$keylink['keyworklist']);
		} else {
			$keywords = str_replace('{#city#}',"",$keylink['keyworklist']);
		}
		if($hotelnearby) {
			$keywords = str_replace('{#mark#}',$hotelnearby."附近",$keywords);
		} else {
			$keywords = str_replace('{#mark#}',"",$keywords);
		}
		if($start_land != $cityname) {
			$description = str_replace('{#city#}',$cityname,$keylink['description']);
		} else {
			$description = str_replace('{#city#}',"",$keylink['description']);
		}
		if($hotelnearby) {
			$description = str_replace('{#mark#}',$hotelnearby."附近",$description);
		} else {
			$description = str_replace('{#mark#}',"",$description);
		}
		$description = str_replace('{#sitename#}',$this->CON['sitename'],$description);
		if($start_land != $cityname) {
			$keytitle = str_replace('{#city#}',$cityname,$keylink['keytitle']);
		} else {
			$keytitle = str_replace('{#city#}',"",$keylink['keytitle']);
		}
		if($hotelnearby) {
			$keytitle = str_replace('{#mark#}',$hotelnearby."附近",$keytitle);
		} else {
			$keytitle = str_replace('{#mark#}',"",$keytitle);
		}
		$keytitle = str_replace('{#sitename#}',$this->CON['sitename'],$keytitle);
		$arrkeylink['keytitle'] = $keytitle;
		$arrkeylink['Keywords'] = $keywords;
		$arrkeylink['Description'] = $description;
		$this->pagetemplate->assign('arrkeylink', $arrkeylink);
		
		$this->pagetemplate->assign('param', $param);
		$this->pagetemplate->assign('coordlist', $coordlist);
		$this->pagetemplate->assign('arrhotel', $arr['Hotels']);
		$this->pagetemplate->assign('arrlist', $arrlist);
		$this->pagetemplate->assign('arrcity', $arrcity);
		$this->pagetemplate->assign('businessZoneText', $businessZoneText);
		$this->pagetemplate->assign('arrchainbrands', $arrchainbrands);
		$this->pagetemplate->assign('pagenexturl', $pagenexturl);
		$this->pagetemplate->assign('pagepreurl', $pagepreurl);
		$this->pagetemplate->assign('pagetext', $pagetext);
		$this->pagetemplate->assign('pageindexurl', $pageindexurl);
		$this->pagetemplate->assign('dburl', $dburl);
		$this->pagetemplate->assign('mapurl', $mapurl);
		$this->pagetemplate->assign('pagetotalurl', $pagetotalurl);
		$this->pagetemplate->assign('page_reprice_url', $page_reprice_url);
		$this->pagetemplate->assign('page_restar_url', $page_restar_url);
		$this->pagetemplate->assign('page_rearea_url', $page_rearea_url);
		$this->pagetemplate->assign('page_relank_url', $page_relank_url);
		$this->pagetemplate->assign('page_chain_url', $page_chain_url);
		$this->pagetemplate->assign('page_guaran_url', $page_guaran_url);
		$this->pagetemplate->assign('page_nobook_url', $page_nobook_url);
		$this->pagetemplate->assign('page_key_url', $page_key_url);
		$this->pagetemplate->assign('page_land_url', $page_land_url);
		$this->pagetemplate->assign('page_cate_url', $page_cate_url);
		$this->pagetemplate->assign('pagemodeturl', $pagemodeturl);
		$this->pagetemplate->assign('page_pp_url', $page_pp_url);
		$this->pagetemplate->assign('orderurl', $orderurl);
		unset($arr,$arrcity,$param);
		//$1模板路径-$2模板缓存键值-$3是否生成html-$4生成文件名-$5语言
		$this->pagetemplate->display($templatefilename, $templatecache, false, '', admin_LNG);
		
	}
	
	function in_hotelmap() {
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$citylist = array();
		$citystr = hcitylist;
		$arrcity = explode(',',$citystr);
		$onecityarr = explode('|',$arrcity[0]);
		$cityname = $onecityarr[1];
		
		include_once admin_ROOT . 'datacache/citylist.php';
		foreach ($citylist as $c) {
			if($c['Name'] == $cityname) {
				$cityCode = $c['Id'];
				$clng = $c['Lng'];
				$clat = $c['Lat'];
				break;
			}
		}
		if(!$clng || !$clat) {
			$res = $this->get_hotel_nearby($cityname,$cityname);
			$clng = $res[0]['Lng'];
			$clat = $res[0]['Lat'];
		}
		$mapparam['lng'] = '1'; $mapparam['lat'] = '1';
		$mapparam['cityCode'] = $cityCode;
		$mapparam['cityname'] = $cityname;
		$mapparam['landmark'] = $cityname;
		$checkInDate = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600)); 
		$checkOutDate = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600*3));
		$mapparam['checkInDate'] = $checkInDate;
		$mapparam['checkOutDate'] = $checkOutDate;
		$mapparam['simple'] = 2;
		$mapparam['includeNonBooking'] = true;
		$mapparam['includeGuaranteeable'] = true;

		$mapurl = $this->get_link('hotel_searchlist',$mapparam,$lng);
		
		$keylink = $this->get_keytype_purview(103);  //读取首页关键字描述
		$arrkeylink = array();
		$arrkeylink['keytitle'] = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['keytitle']);
		$arrkeylink['Keywords'] = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['keyworklist']);
		$arrkeylink['Description'] = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['description']);
		$this->pagetemplate->assign('arrkeylink', $arrkeylink);
		
		$this->pagetemplate->assign('mapurl', $mapurl);
		$this->pagetemplate->assign('clng', $clng);
		$this->pagetemplate->assign('clat', $clat);
		$templatesDIR = $this->get_templatesdir('hotel');
		$templatefilename = $templatecache = "";
		$templatefilename = $lng . '/' . $templatesDIR . '/hotel_mapindex';
		$templatecache = "hotel_mapindex";
		$this->pagetemplate->display($templatefilename, $templatecache, false, '', admin_LNG);
	}
	
	function in_hotelshow() {
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$arr = $rooms = array();
		$hotelCode = $this->fun->accept('hid', 'R');    //酒店编号
		$arr = $this->get_hotel_info($hotelCode);
		//$rooms = $arr['Rooms'];
		$images = $arr['Images'];
		$arr['Rooms'] = null; $arr['Images'] = null;
		$cityid = $arr['CityCode'];
		$cityname = $this->get_cityname($cityid);
		$arr['cityname'] = $cityname;
		$tm1 = $this->fun->accept('tm1', 'R'); 
		if(!$tm1) {
			$tm1 = $_COOKIE['search_tm1'];
			if(!$tm1) {
				$tm1 = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600)); 
				$this->fun->setcookie("search_tm1",$tm1); 
			}
		}
		$tm2 = $this->fun->accept('tm2', 'R'); 
		if(!$tm2) { 
			$tm2 = $_COOKIE['search_tm2'];
			if(!$tm2) {
				$tm2 = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600*3)); 
				$this->fun->setcookie("search_tm2",$tm2); 
			}
		}
		if(strtotime($tm1) < strtotime(date('Y-m-d')) || strtotime($tm2) < strtotime(date('Y-m-d'))) {
			$tm1 = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600));
			$tm2 = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600*3));
		}
		$param = array();
		$param['cityCode'] = $cityid;
		$param['hotelCode'] = $hotelCode;
		$param['checkInDate'] = $tm1;
		$param['checkOutDate'] = $tm2;
		$param['includeNonBooking'] = true;
		$param['includeGuaranteeable'] = true;
		$param['lowestPrice'] = 0;
		$param['highestPrice'] = 0;
		$param['broadbandService'] = 0;
		$link_url = $this->get_link('hotel_city',$param,$lng);
		$arr['link_url'] = $link_url;
		$cityhotelcode = $this->get_convercity($arr['ProvinceCode'],$arr['CityCode'],$arr['DistrictCode']);
		$commenturl = $this->get_link('hotel_comment',array('hid'=>$hotelCode,'hname'=>$arr['Name'],'cityid'=>$cityhotelcode[1]),$lng);
		$arrcity = $this->get_singlecity($cityid,true,true,true);
		$i = 0; $arrLocations = array();
		foreach ($arrcity['CommercialLocations'] as $key=>$value) {
			$arrLocations[] = $value;
			$i++;
			if($i == 50) {break;}
		}
		$arrcity['CommercialLocations'] = $arrLocations;
		
		$n = 0; $arrLandmark = array();
		foreach ($arrcity['LandmarkLocations'] as $key=>$value) {
			$arrLandmark[] = $value;
			$n++;
			if($n == 50) {break;}
		}
		$arrcity['LandmarkLocations'] = $arrLandmark;
		//主要行政区
		$reareaparam = $param;  $reareaparam['districtCode'] = "{#district#}";   //行政区url
		$reareaparam['pageIndex'] = 1; $page_rearea_url = $this->get_hotel_fliterurl($reareaparam);
		unset($reareaparam);
		//商圈和热门地区
		$relankparam = $param; $relankparam['businessZoneCode'] = "{#business#}";
		$relankparam['pageIndex'] = 1;$page_relank_url = $this->get_hotel_fliterurl($relankparam);  //商业区编码
		unset($relankparam);
		$rooms = $this->get_hotel_rooms($param);
		foreach ($arr['Landmarks'] as $key=>$value) {
			$n = 0;
			$markparam = array();
			$markparam['cityCode'] = $cityid; $markparam['businessZoneCode'] = $key;
			$markparam['includeNonBooking'] = 1;$markparam['includeGuaranteeable'] = 1;
			$markparam['pageIndex'] = 1;$linkurl = $this->get_hotel_fliterurl($markparam);
			unset($markparam);
			$landmark[] = array('id'=>$key,'name'=>$value,'linkurl'=>$linkurl);
			$n++;
			if($n>=20) {break;};
		}
		$arr['Landmarks'] = null;
		
		$orderparam = array();
		$orderurl = $this->get_link('hotel_order',$orderparam,$lng);   //订单地址
		
		$showurl = $this->get_link("hotelshow",array('hid'=>$hotelCode),$lng);
		
		$keylink = $this->get_keytype_purview(105); 
		$arrkeylink = array();
		$keytitle = str_replace('{#hotelname#}',$arr['Name'],$keylink['keytitle']);
		$keytitle = str_replace('{#sitename#}',$this->lng['sitename'],$keytitle);
		$keytitle = str_replace('{#phone#}',$this->CON['ordertel'],$keytitle);
		
		$Keywords = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['keyworklist']);
		$Keywords = str_replace('{#hotelname#}',$arr['Name'],$Keywords);
		$Keywords = str_replace('{#phone#}',$this->CON['ordertel'],$Keywords);
		
		$Description = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['description']);
		$Description = str_replace('{#hotelname#}',$arr['Name'],$Description);
		$Description = str_replace('{#phone#}',$this->CON['ordertel'],$Description);
		$Description = str_replace('{#description#}',$this->fun->substr(strip_tags($arr['IntroEditor']),360),$Description);
		
		$arrkeylink['keytitle'] = $keytitle;
		$arrkeylink['Keywords'] = $Keywords;
		$arrkeylink['Description'] = $Description;
		$this->pagetemplate->assign('arrkeylink', $arrkeylink);

		$nearlist = array();
		$param['landmark'] = $arr['Name'];
		$param['lng'] = $arr['Lng'];
		$param['lat'] = $arr['Lat'];
		$param['pageIndex'] = 1;
		$param['pageSize'] = 10;
		$paramurl = $param;
		$paramurl['checkInDate'] = null;
		$paramurl['checkOutDate'] = null;
		$nearurl = $this->get_link('hotel_searchlist',$paramurl,$lng);
		$nearlist = $this->get_hotelnearlist($param);
		$templatesDIR = $this->get_templatesdir('hotel');
		$templatefilename = $templatecache = "";
		$templatefilename = $lng . '/' . $templatesDIR . '/hotel_show';
		$templatecache = "hotel_show";
		$this->pagetemplate->assign('array', $arr);
		$this->pagetemplate->assign('param', $param);
		$this->pagetemplate->assign('nearurl', $nearurl);
		$this->pagetemplate->assign('nearlist', $nearlist);
		$this->pagetemplate->assign('rooms', $rooms);
		$this->pagetemplate->assign('images', $images);
		$this->pagetemplate->assign('iswrite', $this->CON['is_rewrite']);
		$this->pagetemplate->assign('fileex', $this->CON['file_fileex']);
		$this->pagetemplate->assign('arrcity', $arrcity);
		$this->pagetemplate->assign('showurl', $showurl);
		$this->pagetemplate->assign('landmark', $landmark);
		$this->pagetemplate->assign('orderurl', $orderurl);
		$this->pagetemplate->assign('commenturl', $commenturl);
		$this->pagetemplate->assign('page_rearea_url', $page_rearea_url);
		$this->pagetemplate->assign('page_relank_url', $page_relank_url);
		
		unset($arr,$rooms,$images);
		
		$this->pagetemplate->display($templatefilename, $templatecache, false, '', admin_LNG);
	}
	
	function in_hotelchain() {  //酒店品牌
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$arr = array();
		$arr = $this->get_hotel_hotelchainbrands();
		$hotelcount = count($arr);
		$param = array(
			'cityCode' => "{#cityCode#}",
			'chainBrands' => "{#chainBrands#}",
			'includeNonBooking' => true,
			'includeGuaranteeable' => true,
		);
		$chainlink = $this->get_link('hotel_chain',$param,$lng);
		
		$templatesDIR = $this->get_templatesdir('hotel');
		$templatefilename = $templatecache = "";
		$templatefilename = $lng . '/' . $templatesDIR . '/hotel_chain';
		$templatecache = "hotel_chain";
		
		$keylink = $this->get_keytype_purview(106); 
		$arrkeylink = array();
		$Keywords = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['keyworklist']);
		$Keywords = str_replace('{#phone#}',$this->CON['ordertel'],$Keywords);
		
		$Description = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['description']);
		$Description = str_replace('{#phone#}',$this->CON['ordertel'],$Description);
		
		$keytitle = $Description = str_replace('{#sitename#}',$this->lng['sitename'],$keylink['keytitle']);
		$keytitle = $Description = str_replace('{#phone#}',$this->CON['ordertel'],$keytitle);
		
		$arrkeylink['keytitle'] = $keytitle;
		$arrkeylink['Keywords'] = $Keywords;
		$arrkeylink['Description'] = $Description;
		$this->pagetemplate->assign('arrkeylink', $arrkeylink);

		$this->pagetemplate->assign('hotelcount', $hotelcount);
		$this->pagetemplate->assign('array', $arr);
		$this->pagetemplate->assign('chainlink', $chainlink);
		unset($arr);
		$this->pagetemplate->display($templatefilename, $templatecache, false, '', admin_LNG);
		
	}
	
	function in_contrast() {
		parent::start_pagetemplate();
		$lng = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;
		$hid = $this->fun->accept('hid', 'R');
		if(strpos($hid,',') < 0) {
			$this->fun->message("酒店参数有误。");
		}
		$arrhid = explode(',',$hid);
		$arr1 = $this->get_hotel_info($arrhid[0]);
		$arr2 = $this->get_hotel_info($arrhid[1]);
		
		foreach ($arr1['Landmarks'] as $key=>$value) {
			$n = 0;
			$markparam = array();
			$landmark[] = array('id'=>$key,'name'=>$value);
			$n++;
			if($n>=20) {break;}
		}
		$arr1['Landmarks'] = null;
		
		foreach ($arr2['Landmarks'] as $key=>$value) {
			$n = 0;
			$markparam = array();
			$landmark[] = array('id'=>$key,'name'=>$value);
			$n++;
			if($n>=20) {break;}
		}
		$arr2['Landmarks'] = null;
		
		$cityarr = $this->get_singlecity($arr1['CityCode'],true,true,true);
		foreach ($cityarr['DistrictLocations'] as $key=>$value) {
			if($value['Code'] ==$arr1['DistrictCode']) {
				$arr1['DistrictName'] = $value['Name'];
			}
			if($value['Code'] ==$arr2['DistrictCode']) {
				$arr2['DistrictName'] = $value['Name'];
			}
		}
		
		foreach ($cityarr['CommercialLocations'] as $key=>$value) {
			if($value['Code'] ==$arr1['BusinessZoneCode']) {
				$arr1['BusinessName'] = $value['Name'];
			}
			if($value['Code'] ==$arr2['BusinessZoneCode']) {
				$arr2['BusinessName'] = $value['Name'];
			}
		}
		
		$arr1['OpeningDate'] = date('Y年m月d',$arr1['OpeningDate']);
		$arr2['OpeningDate'] = date('Y年m月d',$arr2['OpeningDate']);
		
		$showurl1 = $this->get_link("hotelshow",array('hid'=>$arrhid[0]),$lng);
		$showurl2 = $this->get_link("hotelshow",array('hid'=>$arrhid[1]),$lng);
		
		$arr1['showurl1'] = $showurl1;
		$arr2['showurl2'] = $showurl2;
		
		$tm1 = $_COOKIE['search_tm1']; if(!$tm1) { $tm1 = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600)); $this->fun->setcookie("search_tm1",$tm1); }
		$tm2 = $_COOKIE['search_tm2']; if(!$tm2) { $tm2 = date('Y-m-d',(strtotime(date('Y-m-d'))+24*3600*3)); $this->fun->setcookie("search_tm2",$tm2); }
		
		$param =array(); $param1 = array();
		$param['hotelCode'] = $arrhid[0];
		$param['checkInDate'] = $tm1;
		$param['checkOutDate'] = $tm2; 
		$param['includeNonBooking'] = true;
		$param['includeGuaranteeable'] = true;
		$param['lowestPrice'] = 0;
		$param['highestPrice'] = 0;
		$param['broadbandService'] = 0;
		$param1 = $param;
		$param1['hotelCode'] = $arrhid[1];
		
		$rooms1 = $this->get_hotel_rooms($param);
		$rooms2 = $this->get_hotel_rooms($param1);
		
		$orderurl = $this->get_link('hotel_order',array(),$lng);
		
		$templatesDIR = $this->get_templatesdir('hotel');
		$templatefilename = $templatecache = "";
		$templatefilename = $lng . '/' . $templatesDIR . '/hotel_contrast';
		$templatecache = "hotel_contrast";
		$this->pagetemplate->assign('array1', $arr1);
		$this->pagetemplate->assign('array2', $arr2);
		$this->pagetemplate->assign('rooms1', $rooms1);
		$this->pagetemplate->assign('param', $param);
		$this->pagetemplate->assign('rooms2', $rooms2);
		$this->pagetemplate->assign('orderurl', $orderurl);
		
		unset($arr1,$arr2,$rooms1,$rooms2);
		$this->pagetemplate->display($templatefilename, $templatecache, false, '', admin_LNG);
	}
	function in_changedate() {
		$tm1 = $this->fun->accept('tm1', 'R');
		$tm2 = $this->fun->accept('tm2', 'R');
		$this->fun->setcookie("search_tm1",$tm1);
		$this->fun->setcookie("search_tm2",$tm2);
		exit(1);
	}
	//酒店房态价格信息
	function in_hotelrooms() {
		$hotelCode = $this->fun->accept('hid', 'R');
		$roomCode = $this->fun->accept('rid', 'R');
		$roomRatePlan = $this->fun->accept('pid', 'R');
		$checkInDate = $this->fun->accept('tm1', 'R');
		if(!$checkInDate) { $checkInDate = $this->fun->accept('ordertm1', 'R');}
		$checkOutDate = $this->fun->accept('tm2', 'R');
		if(!$checkOutDate) { $checkOutDate = $this->fun->accept('ordertm2', 'R');}
		$arr = array();
		$arr = $this->get_hotel_0rderroomstatus($hotelCode,$roomCode,$roomRatePlan,$checkInDate,$checkOutDate);
		if($arr['Status'] == 0) {
			$arr = $arr['ResponseBody'];
			$nonbook = $arr['Hotel']['NonBookingPercentage'];
			if($nonbook >0) {
				$res = 0;
			} else {
				$res = 1;
			}
		} else {
			$res = 0;
		}
		echo $res;
		exit;
	}
	
}

?>