<?php
/*
  PHP version 5
  Copyright (c) 2002-2010 ECISP.CN
  声明：这不是一个免费的软件，请在许可范围内使用

  作者：Bili E-mail:huangqyun@163.com  QQ:6326420
  http://www.ecisp.cn	http://www.easysitepm.com
 */

class lib_public extends connector {

	function lib_public() {
		$this->softbase();
		parent::start_pagetemplate();
		$this->pagetemplate->libfile = true;
	}

	function call_lng($para, $filename='lng', $outHTML=null) {
		if ($this->CON['is_alonelng']) return null;
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];
		$lng_temp = $lng;
		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$db_table = db_prefix . 'lng';
		$rsList = $this->get_lng_array(null, 1);
		if (count($rsList['list']) > 0) {
			foreach ($rsList['list'] as $key => $value) {
				$rsList['list'][$key]['link'] = $this->get_link('lng', $value, $value['lng']);
			}
		}

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		$this->pagetemplate->assign('lngarray', $rsList['list']);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_menu($para, $filename='menu', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$db_table = db_prefix . 'typelist';
		$db_table2 = db_prefix . 'form_group';
		$path = empty($para[1]) ? 0 : $para[1];
		$current = empty($para[2]) ? 0 : $para[2];

		$chacherray = array();
		$db_where = " WHERE lng='$lng' AND ismenu=1 AND isclass=1";
		$sql = 'SELECT * FROM ' . $db_table . $db_where . ' ORDER BY pid,tid DESC';
		$chacherray = $this->dbcache->checkcache('typelist_array_' . $lng_temp, false);
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$rsList['title'] = $rsList['typename'];
				$rsList['path'] = 'article';

				$rsList['current'] = $rsList['tid'];
				$rsList['link'] = $this->get_link('type', $rsList, $lng_temp);
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('typelist_array_' . $lng_temp, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}

		$formarray = array();
		$db_where = " WHERE lng='$lng' AND ismenu=1 AND isclass=1";
		$sql = 'SELECT * FROM ' . $db_table2 . $db_where . ' ORDER BY pid,fgid DESC';
		$formarray = $this->dbcache->checkcache('formgroup_array_' . $lng_temp, false);
		if (!$formarray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$rsList['title'] = $rsList['formgroupname'];
				$rsList['path'] = 'form';
				$rsList['current'] = $rsList['fgid'];
				$rsList['link'] = $this->get_link('form', $rsList, $lng_temp);
				$array[] = $rsList;
			}
			$formarray = $this->dbcache->cachesave('formgroup_array_' . $lng_temp, $array);
			$formarray = $formarray ? $formarray : $array;
			unset($array);
		}

		$memberlink = array();
		if ($this->CON['member_menu']) {
			$memberlink[0]['title'] = $LANPACK['membertitle'];
			$memberlink[0]['path'] = 'member';
			$memberlink[0]['current'] = 0;
			$memberlink[0]['link'] = $this->get_link('memberlogin', array(), $lng_temp);
		}

		$orderlink = array();
		if ($this->CON['order_menu']) {
			$orderlink[0]['title'] = $LANPACK['ordertitle'];
			$orderlink[0]['path'] = 'order';
			$orderlink[0]['current'] = 0;
			$orderlink[0]['link'] = $this->get_link('order', array(), $lng_temp);
		}

		$forumlink = array();
		if ($lng == $this->CON['is_lancode']) {
			if ($this->CON['forum_menu']) {
				$forumlink[0]['title'] = $LANPACK['forumtitle'];
				$forumlink[0]['path'] = 'forum';
				$forumlink[0]['current'] = 0;
				$forumlink[0]['link'] = $this->get_link('forum', array(), $lng_temp);
			}
		}

		$enquirylink = array();
		if ($this->CON['enquiry_menu']) {
			$enquirylink[0]['title'] = $LANPACK['enquirytitle'];
			$enquirylink[0]['path'] = 'enquiry';
			$enquirylink[0]['current'] = 0;
			$enquirylink[0]['link'] = $this->get_link('enquiry', array(), $lng_temp);
		}
		$menuarray = array();
		if (is_array($chacherray) && is_array($formarray)) {
			$menuarray = array_merge_recursive($chacherray, $formarray);
		} else {
			$menuarray = is_array($chacherray) ? $chacherray : $menuarray;
		}
		$menuarray = array_merge_recursive($menuarray, $forumlink, $memberlink, $orderlink, $enquirylink);
		$homelink = $this->get_link('home', '', $lng_temp);
		$this->pagetemplate->assign('homelink', $homelink);
		$this->pagetemplate->assign('menu', $menuarray);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		$this->pagetemplate->assign('current', $current);
		$this->pagetemplate->assign('path', $path);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}
	
	function call_commentlist($para,$filename='comment_list',$outHTML=null) {
		$array = array();
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];
		$lng_temp = $lng;
		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$uid = intval($para[1]);  //用户ID
		$hid = intval($para[2]);  //酒店ID
		$limit = empty($para[3]) ? 10 : intval($para[3]);
		$array = $this->get_commentlist($uid,$hid,$limit);
		$this->pagetemplate->assign('array', $array);
		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}
	
	function call_hotelindex($para,$filename='hotelindex',$outHTML) {
		$codelist = hcitylist;
		$arr = explode(',',$codelist);
		$array = array();
		$cityId = "";
		foreach($arr as $key=>$c) {
			$a = explode('|',$c);
			$cityId .= $a[0].",";
		}
		$cityId = substr($cityId,0,strlen($cityId)-1);    //城市ID
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];
		$lng_temp = $lng; $arr = array();
		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$limit = empty($para[1]) ? 14 : intval($para[1]);
		$arr = $this->get_hotel_index($cityId,$limit);
		foreach ($arr['HotelSummaries'] as $key1=>$city) {
			$i = 0;$hotels = array(); $hotelimg = array();
			$param = array();
			$param['cityCode'] = $city['CityCode'];
			//$param['checkInDate'] = date('Y-m-d',strtotime(date('Y-m-d'))+24*3600);
			//$param['checkOutDate'] = date('Y-m-d',strtotime(date('Y-m-d'))+24*3600*3); 
			$param['includeNonBooking'] = true;
			$param['includeGuaranteeable'] = true;
			$param['lowestPrice'] = 0;
			$param['highestPrice'] = 0;
			$param['broadbandService'] = 0;
			$link_url = $this->get_link('hotel_city',$param,$lng);
			foreach($city['Hotels'] as $key2=>$hotel) {
				$i++;
				$hotelurl = $this->get_link("hotelshow",array('hid'=>$hotel['Code']),$lng);
				$hotel['hotelurl'] = $hotelurl;
				if($i<=4) {
					$hotelimg[] = $hotel;
				} else {
					if($hotel['Room']['Broadband']==1) {
						$hotel['Broadband'] = "收费";
					} else if($hotel['Room']['Broadband']==2) {
						$hotel['Broadband'] = "免费";
					}  else {
						$hotel['Broadband'] = "无";
					}
					$hotel['RateName'] = $hotel['Room']['RatePlan']['Name'];
					$hotel['RoomName'] = $hotel['Room']['Name'];
					$hotel['LowestPrice'] = $hotel['Room']['RatePlan']['LowestPrice'];
					$hotel['Room'] = '';
					$hotels[] = $hotel;
				}
			}
			$arr['HotelSummaries'][$key1]['datetime'] = date('Y-m-d H:i:s');
			$arr['HotelSummaries'][$key1]['link_url'] = $link_url;
			$arr['HotelSummaries'][$key1]['Hotels'] = $hotels;
			$arr['HotelSummaries'][$key1]['Hotelsimg'] = $hotelimg;
		}
		$this->pagetemplate->assign('array', $arr['HotelSummaries']);
		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}
	
	function call_commentread($para,$filename='comment_read',$outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];
	}

	function call_list($para, $filename='list', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';

		$mid = intval($para[1]);
		if (empty($mid)) {
			return false;
		}

		$recommend = intval($para[2]);

		$tid = intval($para[3]);

		$sid = intval($para[4]);

		$linkdid = $para[5];
		if (!empty($linkdid)) {

			$str_linkid = $this->fun->format_array_text($linkdid, '/');
			if (is_array($str_linkid)) {
				$linkdid = implode(',', $str_linkid);
			}
		}

		$limit = empty($para[6]) ? 20 : intval($para[6]);

		$ordertype = $para[7] != 'h' ? 'pid,did' : 'click';

		$cutnum = empty($para[8]) ? 200 : intval($para[8]);

		$timetype = empty($para[9]) ? 3 : intval($para[9]);

		$did = empty($para[10]) ? 0 : intval($para[10]);
		$db_table = db_prefix . 'document';
		$db_where = ' WHERE isclass=1 AND mid=' . $mid;
		if (!empty($linkdid)) {
			$db_where.=" AND did IN ($linkdid)";
		}
		if (!empty($recommend)) {
			$db_where.=" AND FIND_IN_SET('$recommend',recommend)";
		}
		if (!empty($tid)) {
			$db_where.=" AND " . $this->get_typeid($tid, 'tid', 0, $mid, 0, $lng);
		}
		if (!empty($sid)) {
			$db_where.=" AND sid=$sid";
		}
		if (!empty($lng)) {
			$db_where.=" AND lng='$lng'";
		}
		$sql = "SELECT did,lng,pid,mid,aid,tid,sid,fgid,linkdid,isclass,islink,ishtml,ismess,
			isorder,purview,recommend,tsn,title,longtitle,color,author,source,pic,link,oprice,bprice,click,addtime,
			template,keywords,description,filename,filepath FROM $db_table $db_where
			ORDER BY $ordertype DESC LIMIT 0,$limit";
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$attarray = array();
			$rsList['value'] = $this->get_document_value($rsList['did'], 'value');
			if (!empty($rsList['value'])) {
				$attarray = unserialize($rsList['value']);
				unset($rsList['value']);
			}
			if($rsList['mid'] == 9) {  //会展信息
				$exarray = $this->get_document_exhibit($rsList['did']);
				$exarray['cityname'] = $this->get_cityview($exarray['city'],'cityname');
				$rsList['cityname'] = $exarray['cityname'];
				$rsList['startdate'] = $exarray['startdate'];
				$rsList['enddate'] = $exarray['enddate'];
			}
			$rsList['buylink'] = $this->get_link('buylink', $rsList, $lng_temp);
			$rsList['enqlink'] = $this->get_link('enqlink', $rsList, $lng_temp);
			$rsList['link'] = $this->get_link('doc', $rsList, $lng_temp);
			$rsList['ctitle'] = empty($rsList['color']) ? $rsList['title'] : "<font color='" . $rsList['color'] . "'>" . $rsList['title'] . "</font>";
			$typeread = $this->get_type($rsList['tid']);
			$rsList['typename'] = $typeread['typename'];
			$rsList['typelink'] = $this->get_link('type', $typeread, $lng_temp);
			$array[] = is_array($attarray) ? array_merge_recursive($rsList, $attarray) : $rsList;
		}
		$this->pagetemplate->assign('sql', $sql);
		$this->pagetemplate->assign('did', $did);
		$this->pagetemplate->assign('cutnum', $cutnum);
		$this->pagetemplate->assign('timetype', $timetype);
		$this->pagetemplate->assign('array', $array);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_plist($para, $filename='plist', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';

		$did = intval($para[1]);
		if (empty($did)) {
			return false;
		}

		$class = intval($para[2]);
		$class = empty($class) ? 0 : $class;

		$db_table = db_prefix . 'document';

		$read = $this->get_documentview($did);
		if (!$read['tid']) {
			return false;
		}
		if ($class) {
			$sql = "SELECT * FROM $db_table WHERE isclass=1 AND tid = $read[tid] AND did > $did ORDER BY did ASC LIMIT 0,1";
		} else {
			$sql = "SELECT * FROM $db_table WHERE isclass=1 AND tid = $read[tid] AND did < $did ORDER BY did DESC LIMIT 0,1";
		}
		$rslist = $this->db->fetch_first($sql);
		if (is_array($rslist)) {
			$rslist['link'] = $this->get_link('doc', $rslist, $lng_temp);
			$rslist['buylink'] = $this->get_link('buylink', $rslist, $lng_temp);
			$rsList['enqlink'] = $this->get_link('enqlink', $rsList, $lng_temp);
			$rslist['ctitle'] = empty($rslist['color']) ? $rslist['title'] : "<font color='" . $rslist['color'] . "'>" . $rslist['title'] . "</font>";
		}
		$this->pagetemplate->assign('did', $did);
		$this->pagetemplate->assign('read', $rslist);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_read($para, $filename='read', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';

		$did = intval($para[1]);
		if (empty($did)) {
			return false;
		}

		$read = $this->get_document($did);
		$read['link'] = $this->get_link('doc', $read, $lng_temp);
		$read['buylink'] = $this->get_link('buylink', $read, $lng_temp);
		$read['enqlink'] = $this->get_link('enqlink', $read, $lng_temp);
		$read['ctitle'] = empty($read['color']) ? $read['title'] : "<font color='" . $read['color'] . "'>" . $read['title'] . "</font>";
		$read['content'] = html_entity_decode($read['content']);

		$docarray = array();
		if (!empty($read['value'])) {
			$attarray = unserialize($read['value']);
			unset($read['value']);
			$docarray = is_array($attarray) ? array_merge_recursive($read, $attarray) : $read;
		} else {
			$docarray = $read;
		}
		unset($read);

		$this->pagetemplate->assign('did', $did);
		$this->pagetemplate->assign('read', $docarray);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_bann($para, $filename='bann', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';

		$mid = intval($para[1]);
		if (empty($mid)) {
			return false;
		}

		$recommend = intval($para[2]);

		$tid = intval($para[3]);

		$filetype = intval($para[4]);

		$limit = empty($para[5]) ? 20 : intval($para[5]);

		$db_table = db_prefix . 'document';
		$db_where = ' WHERE isclass=1 AND mid=' . $mid;
		if (!empty($linkdid)) {
			$db_where.=" AND did IN ($linkdid)";
		}
		if (!empty($recommend)) {
			$db_where.=" AND FIND_IN_SET('$recommend',recommend)";
		}
		if (!empty($tid)) {
			$db_where.=" AND tid=$tid";
		}
		$typeview = $this->get_type($tid);
		if (!empty($lng)) {
			$db_where.=" AND lng='$lng'";
		}
		$typeview['width'] = empty($para[6]) ? $typeview['width'] : intval($para[6]);
		$typeview['height'] = empty($para[7]) ? $typeview['height'] : intval($para[7]);

		$bann_array = array();
		$countnum = $this->db_numrows($db_table, $db_where);
		$sql = "SELECT * FROM $db_table $db_where ORDER BY pid,did DESC LIMIT 0,$limit";

		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$rsList['num'] = $countnum;
			$rsList['link'] = htmlspecialchars_decode($this->get_link('doc', $rsList, $lng_temp));
			$rsList['ctitle'] = empty($rsList['color']) ? $rsList['title'] : "<font color='" . $rsList['color'] . "'>" . $rsList['title'] . "</font>";
/**
			$other = $this->get_document_other_view($rsList['did']);
			$rsList['width'] = $other['width'];
			$rsList['height'] = $other['height'];
			$rsList['filetype'] = $other['filetype'];
			$rsList['istime'] = $other['istime'];

			if ($other['istime'] == 1) {
				if ($other['startime'] < time() && $other['endtime'] > time()) {
					$bann_array[] = $rsList;
				}
			} else {
			**/
				$bann_array[] = $rsList;
			//}
		}

		$this->pagetemplate->assign('type', $typeview);
		$this->pagetemplate->assign('countnum', $countnum);
		$this->pagetemplate->assign('num', $limit);
		$this->pagetemplate->assign('filetype', $filetype);
		$this->pagetemplate->assign('sql', $sql);
		$this->pagetemplate->assign('array', $bann_array);
		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_path($para, $filename='path', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';

		$pathtype = empty($para[1]) ? 'type' : $para[1];
		$id = intval($para[2]);
		if (empty($id)) {
			return false;
		}
		switch ($pathtype) {
			case 'type':
				$typeview = $this->get_type($id);
				$path = $this->get_path($typeview, $lng_temp);
				break;
			case 'forum':
				$typeview = $this->get_bbstype_view($id);
				$typeview['title'] = $typeview['typename'];
				$typeview['link'] = $this->get_link('forumlist', $typeview, $lng_temp);
				$path[] = $typeview;
				break;
			case 'sub':
				$subview = $this->get_subjectlist_purview($id);
				$subview['title'] = $subview['subjectname'];
				$subview['link'] = $this->get_link('subtype', $subview, $lng_temp);
				$path[] = $subview;
				break;
		}
		$homelink = $this->get_link('home', '', $lng_temp);
		$this->pagetemplate->assign('homelink', $homelink);
		$this->pagetemplate->assign('array', $path);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_form($para, $filename='form', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$fgid = intval($para[1]);
		if (empty($fgid)) {
			return false;
		}

		$did = intval($para[2]);
		$did = empty($did) ? 0 : $did;
		$form = $this->get_form_purview($fgid);
		$form['action'] = $this->get_link('acform', $form, $lng_temp);
		$attrread = $this->get_formatt($fgid);
		$this->pagetemplate->assign('form', $form);
		$this->pagetemplate->assign('attr', $attrread);

		$this->pagetemplate->assign('seccodelink', $this->get_link('seccode'));

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('did', $did);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_type($para, $filename='typelist', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$tid = intval($para[1]);
		$now_tid = intval($para[2]);
		if (empty($tid)) {

			$tid = !empty($now_tid) ? $now_tid : $tid;
			if (empty($tid)) {
				return false;
			}
		}
		$tid = empty($tid) ? 0 : $tid;
		$typearray = $this->get_type_array($now_tid, 0, $tid, $lng);
		if (count($typearray['list']) > 0 && is_array($typearray['list'])) {
			foreach ($typearray['list'] as $key => $value) {
				$value['link'] = $this->get_link('type', $value, $lng_temp);
				$value['rsslink'] = $this->get_link('typerss', $value, $lng_temp);
				$typelist[] = $value;
			}
		}
		$this->pagetemplate->assign('nowtid', $now_tid);
		$this->pagetemplate->assign('array', $typelist);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_typepart($para, $filename='typepart', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$mid = intval($para[1]);
		$mid = empty($mid) ? 0 : $mid;
		$typeout = $this->get_type_array(0, $mid, 0, $lng, 1, 1);
		$typearray = $typeout['list'];
		if (count($typearray) > 0 && is_array($typearray)) {
			foreach ($typearray as $key => $value) {
				$value['link'] = $this->get_link('type', $value, $lng_temp);
				$value['rsslink'] = $this->get_link('typerss', $value, $lng_temp);
				$typelist[] = $value;
			}
		}
		$this->pagetemplate->assign('array', $typelist);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_typelist($para, $filename='typelist', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$tid = intval($para[1]);
		$now_tid = intval($para[2]);
		$level = intval($para[3]);
		$level = empty($level) ? 0 : $level;
		if (empty($tid)) {

			$tid = !empty($now_tid) ? $now_tid : $tid;
			if (empty($tid)) {
				return false;
			}
		}
		$tid = empty($tid) ? 0 : $tid;
		$db_table = db_prefix . 'typelist';
		$typeview = $this->get_type($tid);
		$typearray = $this->get_typelist(array(), 0, $tid, $now_tid, $typeview['lng'], $level, 1);
		$now_level = $typearray[$tid]['level'];
		unset($typearray[$tid]);

		if ($typeview['upid'] > 0) {

			foreach ($typearray as $key => $value) {
				$typearray[$key]['level'] = $value['level'] - $now_level;
			}
		}
		if (count($typearray) > 0 && is_array($typearray)) {
			foreach ($typearray as $key => $value) {
				$value['link'] = $this->get_link('type', $value, $lng_temp);
				$value['rsslink'] = $this->get_link('typerss', $value, $lng_temp);
				$typelist[] = $value;
			}
		}
		$this->pagetemplate->assign('nowtid', $now_tid);
		$this->pagetemplate->assign('array', $typelist);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_bbstypelist($para, $filename='bbstypelist', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$now_tid = intval($para[1]);
		$typearray = $this->get_bbstype_array(0, $lng);
		if (is_array($typearray['list'])) {
			foreach ($typearray['list'] as $key => $value) {
				$typearray['list'][$key]['link'] = $rsList['link'] = $this->get_link('forumlist', $value, $lng_temp);
				$typearray['list'][$key]['addlink'] = $rsList['link'] = $this->get_link('forumadd', $value, $lng_temp);
			}
		}
		$this->pagetemplate->assign('nowtid', $now_tid);
		$this->pagetemplate->assign('array', $typearray['list']);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	public function call_tags($para, $filename='tags', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$limit = intval($para[1]);
		$limit = empty($limit) ? 20 : $limit;

		$db_table = db_prefix . 'keylink';
		$db_where = ' WHERE isclass=1';
		$bann_array = array();
		$countnum = $this->db_numrows($db_table, $db_where);
		$sql = "SELECT * FROM $db_table $db_where ORDER BY pid,kid DESC LIMIT 0,$limit";
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$rsList['num'] = $countnum;
			$rsList['link'] = $this->get_link('taglink', array('key' => $rsList['keywordname']), $lng_temp);
			$rsList['title'] = $rsList['keywordname'];
			$array[] = $rsList;
		}
		$this->pagetemplate->assign('array', $array);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	public function call_subtype($para, $filename='subtype', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$mid = intval($para[1]);
		if (empty($mid)) {
			return null;
		}
		$subtype = $this->get_subjectlist_array(0, $mid, $lng, 1);
		if ($subtype['num'] > 0 && is_array($subtype['list'])) {
			$subtypelist = $subtype['list'];
			foreach ($subtypelist as $key => $value) {
				$value['link'] = $this->get_link('subtype', $value, $lng_temp);
				$value['title'] = $value['subjectname'];
				$subtypelist[$key] = $value;
			}
		}
		$this->pagetemplate->assign('array', $subtypelist);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_memmenu($para, $filename='member_menu', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$this->pagetemplate->assign('lngpack', $LANPACK);
		$this->pagetemplate->assign('mlink', $this->memberlink(array(), $lng_temp));

		$this->pagetemplate->assign('lng', $lng_temp);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_im($para, $filename='im', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		if (!$this->CON['is_imcall']) return null;
		$call['call_style'] = $this->CON['call_style'];
		$call['call_type'] = $this->CON['call_type'];
		$call['call_position'] = $this->CON['call_position'];
		$call_array = $this->get_calling_array();
		$array = $call_array['list'];
		if (is_array($array)) {
			foreach ($array as $key => $value) {
				if ($value['type'] == 1) {
					$array[$key]['code'] = stripslashes(htmlspecialchars_decode($value['code']));
				}
			}
		}
		$this->pagetemplate->assign('bbslink', $this->get_link('forum', array(), $lng_temp));
		$this->pagetemplate->assign('memberlink', $this->get_link('memberlogin', array(), $lng_temp));

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('array', $array);
		$this->pagetemplate->assign('call', $call);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_skin($para, $filename=null, $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;

		$pagetemplatefile = $lng . '/lib/' . $para[1];
		if (empty($para[1])) return null;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$this->pagetemplate->assign('lngpack', $LANPACK);
		$this->pagetemplate->assign('mlink', $this->memberlink(array(), $lng_temp));
		$this->pagetemplate->assign('userid', $para[5]);
		$this->pagetemplate->assign('username', $para[2]);
		$this->pagetemplate->assign('password', $para[3]);
		$this->pagetemplate->assign('email', $para[4]);
		$this->pagetemplate->assign('isclass', $para[6]);
		$this->pagetemplate->assign('seccodelink', $this->get_link('seccode'));
		$this->pagetemplate->assign('mem_isseccode', $this->CON['mem_isseccode']);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($pagetemplatefile);
		}
		return $output;
	}

	function call_search($para, $filename='search', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$link = $this->get_link('search', array(), $lng_temp);

		$modelarray = $this->get_model(0, $lng, 1, 1);
		$this->pagetemplate->assign('modelarray', $modelarray['list']);
		$mid = intval($para[1]);
		$mid = empty($mid) ? 0 : $mid;
		$tid = intval($para[2]);
		$tid = empty($tid) ? 0 : $tid;
		if ($tid) {
			$typearray = $this->get_typelist(array(), 0, $tid, 0, $lng, 0, 1);
			$now_level = $typearray[$tid]['level'];
			unset($typearray[$tid]);

			if ($typeview['upid'] > 0) {

				foreach ($typearray as $key => $value) {
					$typearray[$key]['level'] = $value['level'] - $now_level;
				}
			}
			if (count($typearray) > 0 && is_array($typearray)) {
				foreach ($typearray as $key => $value) {
					$typelist[] = $value;
				}
			}
			$this->pagetemplate->assign('array', $typelist);
		}

		$this->pagetemplate->assign('search_link', $link);
		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		$this->pagetemplate->assign('mid', $mid);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	public function call_login($para, $filename='search', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		$mlink = $this->memberlink(array(), $lng_temp);
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$this->pagetemplate->assign('lngpack', $LANPACK);
		$this->pagetemplate->assign('mlink', $mlink);
		$this->pagetemplate->assign('seccodelink', $this->get_link('seccode'));
		$this->pagetemplate->assign('mem_isseccode', $this->CON['mem_isseccode']);

		$ec_member_username = $this->member_cookieview('username');

		$ec_member_username_id = $this->member_cookieview('userid');

		if (!empty($ec_member_username) && !empty($ec_member_username_id) && !$this->CON['is_html']) {
			$this->pagetemplate->assign('username', $ec_member_username);
			$output = $this->pagetemplate->fetch($lng . '/lib/member_info');
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/member_login');
		}
		return $output;
	}

	public function call_order($para, $filename='order', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;

		$cartid = $this->fun->accept('ecisp_order_list', 'C');
		$cartid = stripslashes(htmlspecialchars_decode($cartid));
		$uncartid = !empty($cartid) ? unserialize($cartid) : 0;

		$total = $this->fun->accept('ecisp_order_productmoney', 'C');
		$total = empty($total) ? 0 : $total;
		$buylink = $this->get_link('order', array(), $lng_temp);
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$this->pagetemplate->assign('lngpack', $LANPACK);
		$this->pagetemplate->assign('buylink', $buylink);

		$this->pagetemplate->assign('ordertotal', number_format($total, 2));

		$this->pagetemplate->assign('total', $total);
		$this->pagetemplate->assign('uncartid', count($uncartid));
		$this->pagetemplate->assign('cartid', $cartid);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

	function call_bbslist($para, $filename='bbslist', $outHTML=null) {
		$lng = empty($para[0]) ? $this->CON['is_lancode'] : $para[0];

		$lng_temp = $lng;

		$lng = ($lng == 'big5') ? $this->CON['is_lancode'] : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';

		$recommend = intval($para[1]);

		$btid = intval($para[2]);

		$blid = intval($para[3]);

		$limit = empty($para[4]) ? 20 : intval($para[4]);

		$ordertype = $para[5] != 'h' ? 'bid' : 'click';

		$cutnum = empty($para[6]) ? 200 : intval($para[6]);

		$timetype = empty($para[7]) ? 3 : intval($para[7]);

		$db_table = db_prefix . 'bbs';
		$db_where = " WHERE linkebid=0 AND isclass=1 AND lng='$lng'";
		if (!empty($recommend)) {
			$db_where.=" AND recommend=$recommend";
		}
		if (!empty($btid)) {
			$db_where.=" AND btid=$btid";
		}
		if (!empty($blid)) {
			$db_where.=" AND blid=$blid";
		}

		$label = $this->get_bbslabel_array(0, $lng, 1);
		$labelarray = $this->fun->key_array_name($label['list'], 'blid', 'labelname');
		$sql = "SELECT * FROM $db_table $db_where ORDER BY $ordertype DESC LIMIT 0,$limit";
		$rs = $this->db->query($sql);
		while ($rsList = $this->db->fetch_assoc($rs)) {
			$rsList['link'] = $this->get_link('forumread', $rsList, $lng_temp);
			if ($rsList['userid'] > 0) {
				$member = $this->get_member(null, $rsList['userid']);
				$rsList['author'] = empty($member['alias']) ? $member['username'] : $member['alias'];
				if (empty($rsList['author'])) {
					$rsList['author'] = $LANPACK['forum_anonymity'];
				}
			} else {
				$rsList['author'] = $LANPACK['forum_anonymity'];
			}
			$rsList['labelname'] = $labelarray[$rsList['blid']];
			$array[] = $rsList;
		}
		$this->pagetemplate->assign('cutnum', $cutnum);
		$this->pagetemplate->assign('timetype', $timetype);
		$this->pagetemplate->assign('array', $array);

		$this->pagetemplate->assign('lng', $lng_temp);
		$this->pagetemplate->assign('lngpack', $LANPACK);
		if (!empty($outHTML)) {
			$output = $this->pagetemplate->fetch(null, null, $outHTML);
		} else {
			$output = $this->pagetemplate->fetch($lng . '/lib/' . $filename);
		}
		return $output;
	}

}
?>
