<?php
class connector {
	/**
	 * 初始化需要的函数
	 * @param $admin_purview
	 */
	function softbase($admin_purview=false) {
		header("Content-Type: text/html; charset=utf-8");
		$this->dbmysql();    //加载数据库链接 $this->db
		$this->commandinc(); //实例化通用函数 $this->fun
		$this->systemfile(); //加载基本配置函数 $this->CON
		$this->cachedb();   //缓存$this->dbcache
		$this->delsearch();
		if ($admin_purview) {
			$this->admin_purview();  //加载后台管理包括权限判断等
		}
		if ($this->CON['is_gzip'] == 1 && !function_exists('ob_gzhandler')) {
			ob_start('ob_gzhandler');
		} else {
			ob_start();
		}
		if ($runpage && $this->CON['is_close']) {  // 如果网站已经关闭
			exit($this->CON['close_content']);   //内容
		}
		if (!admin_FROM) {  //首页index.php页面有定义
			include admin_ROOT . adminfile . '/include/admin_language_' . db_lan . '.php';
			$this->lng = $ST;
			unset($ST);
		} else {
			$LANPACK = array();
			$lngpack = (admin_LNG == 'big5') ? $this->CON['is_lancode'] : admin_LNG;   //语言包
			if ($this->creat_lanpack($lngpack)) {
				include admin_ROOT . 'datacache/' . $lngpack . '_pack.php';
			}
			$LANPACK['sitename'] = $this->CON['sitename'];
			$this->lng = $LANPACK;
			$runpage = true;
		}
	}
	function delsearch() {
		$nowtime = intval(date('H',time()));
		if($nowtime == 4) {
			$oldlock = admin_ROOT . './datacache/'.date('Ymd',(strtotime(date('Y-m-d'))-86400)).'.lock';
			if (file_exists($oldlock)) {
				$this->fun->delfile($oldlock);
			}
			$dellock = admin_ROOT . './datacache/'.date('Ymd').'.lock';
			if (!file_exists($dellock)) {
				$cachefilename = admin_ROOT.'datacache/dbcache/hotel/';
				$this->fun->delDir($cachefilename);
				@touch(admin_ROOT . './datacache/'.date('Ymd').'.lock');
			}
		}
	}
	//根据分类ID获取地址	
	function get_menu_link($tid) {
		$db_table = db_prefix . 'typelist';
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$lng_temp = $lng;
		$db_where = " WHERE lng='$lng' AND tid=$tid ";
		$sql = 'SELECT * FROM ' . $db_table . $db_where . ' ORDER BY pid,tid DESC';
		$chacherray = $this->dbcache->checkcache('typelist_tid_'. $tid . "_" . $lng_temp, false);
		if (!$chacherray) {
			$rsList = $this->db->fetch_first($sql);
			$rsList['title'] = $rsList['typename'];
			$rsList['link'] = $this->get_link('type', $rsList, $lng_temp);
			$array = $rsList;
				
			$chacherray = $this->dbcache->cachesave('typelist_tid_'. $tid . "_" . $lng_temp, $array);
			$chacherray = $chacherray ? $chacherray : $array;
		}
		return $chacherray;
	}
	/**
	 * 数据库链接函数
	 */
	function dbmysql() {
		include_once admin_ROOT . '/public/class_dbmysql.php';
		$this->db = new dbmysql();
		$this->db->connect(db_host, db_user, db_pw, db_name, db_charset);
	}
	/**
	 * 生成系统配置缓存datacache/command.php
	 * @param bool $trueclass
	 */
	function systemfile($trueclass=false) {
		$commandfile = admin_ROOT . 'datacache/command.php';  //网站配置文件
		$varget = "9:'1T<#HO+W=W=RYY=61I;F=B86\N;F5T+P```";
		if (!is_file($commandfile) || $trueclass) {
			$sConfig = "<?php\n";
			$sConfig = $sConfig . '// updatetime:' . date('Y-m-d H:i:s', time()) . "\n";
			$sConfig = $sConfig . "// yuding8.com \n";
			$sConfig = $sConfig . "\$CONFIG=Array(\n";
			$db_table = db_prefix . 'config';
			$sql = "SELECT valname,content,value,valtype FROM $db_table ORDER BY groupid";
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$valname = $rsList['valname'];
				$value = $rsList['value'];
				$valtype = $rsList['valtype'];
				$content = $rsList['content'];
				$sConfig = $sConfig . "\x20\x20\x20\x20 //$content\n";
				if ($valtype == 'int' || $valtype == 'bool') {
					if($valname=="is_html") {
						$sConfig = $sConfig . "\x20\x20\x20\x20 '" . $valname . '\'=>0,';
					} else {
						$sConfig = $sConfig . "\x20\x20\x20\x20 '" . $valname . '\'=>' . $value . ",\n";
					}
				} else {
					$sConfig = $sConfig . "\x20\x20\x20\x20 '" . $valname . '\'=>\'' . $value . "',\n";
				}
			}
			$sConfig = $sConfig . ")\n";
			$sConfig = $sConfig . '?' . '>';
			if (!$this->fun->filewrite($commandfile, $sConfig)) {
				exit('System File Error!');
			}
		}
		include $commandfile;

		$cerfile = admin_ROOT . 'espcmslicense.cer';
		if (@is_file($cerfile) && empty($CONFIG['cer_key'])) {
			$ts = file_get_contents($cerfile);
			if (!empty($ts)) {
				$str_key = $this->fun->eccode($ts, 'DECODE', db_keycode);
				$key_array = explode('/', $str_key);
				if (is_array($key_array)) {
					list($keycode, $keysn, $keydate) = $key_array;
					$this->codesoftsn = $keysn;
					$this->codesoftdate = $keydate;
					$keysn = str_replace('ESP-', '', $keysn);
					$this->codesoftdb = $this->fun->eccode($keysn, 'DECODE', $keycode);
				}
				$db_table = db_prefix . 'config';
				$db_where = 'id=135';
				$db_set = "value='$ts'";
				$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			}
		} elseif (@is_file($cerfile) && !empty($CONFIG['cer_key'])) {

			$str_key = $this->fun->eccode($CONFIG['cer_key'], 'DECODE', db_keycode);
			$key_array = explode('/', $str_key);
			if (is_array($key_array)) {

				list($keycode, $keysn, $keydate) = $key_array;

				$this->codesoftsn = $keysn;

				$this->codesoftdate = $keydate;
				$keysn = str_replace('ESP-', '', $keysn);

				$this->codesoftdb = $this->fun->eccode($keysn, 'DECODE', $keycode);
			}
		}

		if (PHP_VERSION > '5.1') {
			$timeoffset = $CONFIG['cli_time'] * -1;
			@date_default_timezone_set('Etc/GMT' . $timeoffset);
		}
		$this->CON = $CONFIG;
		$this->CON['getnetval'] = $varget;
		//if ($this->CON['mem_isucenter']) {
		//	require admin_ROOT . 'public/uc_config.php';
		//}
		unset($CONFIG);
		$varupdatefile = admin_ROOT . 'ver.dat';
		if (is_file($varupdatefile)) {
			$ts = file_get_contents($varupdatefile);
			if ($ts != db_version) {
				$publicfile = admin_ROOT . 'datacache/public.php';
				$config = "<?php \r\ndefine('db_host', '" . db_host . "');\r\n";
				$config .= "define('db_user', '" . db_user . "');\r\n";
				$config .= "define('db_pw', '" . db_pw . "');\r\n";
				$config .= "define('db_name', '" . db_name . "');\r\n";
				$config .= "define('db_charset', '" . db_charset . "');\r\n";
				$config .= "define('db_prefix', '" . db_prefix . "');\r\n";
				$config .= "define('db_lan', '" . db_lan . "');\r\n";
				$config .= "define('headcharset', '" . headcharset . "');\r\n";
				$config .= "define('db_version', '" . $ts . "');\r\n";
				$config .= "define('db_keycode', '" . db_keycode . "');\r\n";
				$config .= "define('db_pscode', '" . db_pscode . "');\r\n";
				$config .= "define('softtitle', '" . softtitle . "');\r\n?>";
				if (!$this->fun->filewrite($publicfile, $config)) {
					exit('System Update Error!');
				}
			}
			$this->fun->delfile($varupdatefile);
		}
	}
	//创建语言包
	function creat_lanpack($lng='', $trueclass=false) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$lanpackfile = admin_ROOT . 'datacache/' . $lng . '_pack.php';
		if (!is_file($lanpackfile) || $trueclass) {

			$sConfig = "<?php\n";
			$sConfig = $sConfig . '// uptime:' . date('Y-m-d H:i:s', time()) . "\n";
			$sConfig = $sConfig . "// ECISP.CN \n";
			$sConfig = $sConfig . "\$LANPACK=Array(\n";
			$db_table = db_prefix . 'lngpack';
			$sql = "SELECT * FROM $db_table WHERE lng='$lng' ORDER BY lpid";
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$keycode = $rsList['keycode'];
				$langstr = $rsList['langstr'];
				$title = $rsList['title'];
				$sConfig = $sConfig . "\x20\x20\x20\x20 //$title\n";
				$sConfig = $sConfig . "\x20\x20\x20\x20 '" . $keycode . '\'=>\'' . $langstr . "',\n";
			}
			$sConfig = $sConfig . ")\n";
			$sConfig = $sConfig . '?' . '>';
			if (!$this->fun->filewrite($lanpackfile, $sConfig)) {
				exit('System File Error!');
			}
		}
		return true;
	}
	/**
	 * 实例化通用函数
	 */
	function commandinc() {
		include_once admin_ROOT . 'public/class_function.php';
		$this->fun = new functioninc();
	}
	//开始解析模板
	function start_template() {
		include_once admin_ROOT . 'public/ectemplates/ectemplates_class.php';
		include admin_ROOT . 'datacache/command.php';
		$this->ectemplates = new Ectemplates();

		$this->ectemplates->tpl_dir = admin_ROOT . adminfile . '/templates/';

		$this->ectemplates->tpl_c_dir = admin_ROOT . 'datacache/admin/templates/';

		$this->ectemplates->cache_dir = admin_ROOT . 'datacache/admin/cache/';

		$this->ectemplates->dbcache_dir = admin_ROOT . 'datacache/admin/dbcache/';

		$this->ectemplates->libdir = adminfile . '/control/lib_menu.php'; //列表 操作按钮调用

		$this->ectemplates->caching = false;
		$this->ectemplates->cache_time = 60 * 60 * 24;
		$this->ectemplates->templatesfileex = '.html';
		$this->ectemplates->left_delimiter = '[%';
		$this->ectemplates->right_delimiter = '%]';
		$this->ectemplates->esp_powerlist = $this->esp_powerlist;

		$this->ectemplates->assign('ST', $this->lng);
		$this->ectemplates->assign('softtitle', $CONFIG['sitename']);
		$this->ectemplates->assign('codesoftdb', $this->codesoftdb);
		$this->ectemplates->assign('softhttp', admin_http);
		$this->ectemplates->assign('softversion', db_version);
		$this->ectemplates->assign('adminurl', admin_URL);
		$this->ectemplates->assign('url', $this->CON['domain']);
		$this->ectemplates->assign('order_moneytype', $CONFIG['order_moneytype']);
		$this->ectemplates->assign('refalse', $CONFIG['is_inputclose']);

		$jinggao = array('hotel_aid'=>$this->CON['hotel_aid'],'hotel_key'=>$this->CON['hotel_key'],'sms_key'=>$this->CON['sms_key']);
		$this->ectemplates->assign('jinggao', $jinggao);
		$iframename = $this->fun->accept('iframename', 'R');
		$iframeheightwindow = $this->fun->accept('iframeheightwindow', 'R');
		$this->ectemplates->assign('iframeheightwindow', $iframeheightwindow);
		if (!empty($iframename)) {
			$this->ectemplates->assign('iframename', $iframename);
		}
	}
	//解析分页模板
	function start_pagetemplate() {
		include_once admin_ROOT . 'public/ectemplates/ectemplates_class.php';
		include admin_ROOT . 'datacache/command.php';
		$this->pagetemplate = new Ectemplates();

		$this->pagetemplate->tpl_dir = admin_ROOT . 'templates/';

		$this->pagetemplate->tpl_c_dir = admin_ROOT . 'datacache/main/templates/';

		$this->pagetemplate->cache_dir = admin_ROOT . 'datacache/main/cache/';

		$this->pagetemplate->dbcache_dir = admin_ROOT . 'datacache/dbcache/';

		$this->pagetemplate->cache_pic = admin_ROOT . 'datacache/pic/';

		$this->pagetemplate->libdir = 'interface/lib_public.php';   //列表 操作按钮调用
		
		$cuxiao = $this->get_menu_link(57);$zixun = $this->get_menu_link(59);
		$huizhan = $this->get_menu_link(104);
		$tool = $this->get_menu_link(106);$weburl = $this->get_menu_link(107);
		$mlink = $this->memberlink(array(), admin_LNG);
		$bzzx = $this->get_link('doc',array('did'=>292),admin_LNG);
		$friend = $this->get_link("friend",array(),admin_LNG);
		$map = $this->get_link("hotelmap",array(),admin_LNG);
		$chain = $this->get_link("hotelchain",array(),admin_LNG);
		$forum = $this->get_link('forum',array(),admin_LNG);
		$comment = $this->get_link('hotel_comment',array(),admin_LNG);
		$arrlink = array('map'=>$map,'bzzx'=>$bzzx,'friend'=>$friend,'comment'=>$comment,'forum'=>$forum,'login'=>$mlink['login'],'reg'=>$mlink['reg'],'cuxiao'=>$cuxiao,'zixun'=>$zixun,'huizhan'=>$huizhan,'tool'=>$tool,'weburl'=>$weburl,'chain'=>$chain);
		$codelist = hcitylist;  $selfname = subname;
		$darr = explode(',',$codelist);
		$dcityarr = explode('|',$darr[0]);
		$mydate = date('Y年m月d',time()) . "　" .$this->get_week(time());
		$this->pagetemplate->templatesDIR = $this->CON['default_templates'] . '/';
		$this->pagetemplate->caching = false;
		$this->pagetemplate->cache_time = 86400;
		$this->pagetemplate->templatesfileex = '.' . $this->CON['templates_fileex'];
		$this->pagetemplate->left_delimiter = '[%';
		$this->pagetemplate->right_delimiter = '%]';
		$this->pagetemplate->codesoftsn = $this->codesoftsn;
		$this->pagetemplate->codesoftdate = $this->codesoftdate;
		$this->pagetemplate->codesoftdb = $this->codesoftdb;
		$this->pagetemplate->assign('softtitle', softtitle);
		$this->pagetemplate->assign('softversion', db_version);
		$this->pagetemplate->assign('icp', $this->CON['icpbeian']);
		$this->pagetemplate->assign('mydate', $mydate);
		$this->pagetemplate->assign('domain', $this->CON['domain']);
		$jinggao = array('hotel_aid'=>$this->CON['hotel_aid'],'hotel_key'=>$this->CON['hotel_key'],'sms_key'=>$this->CON['sms_key']);
		$this->pagetemplate->assign('jinggao', $jinggao);
		$tongji = "";
		if (file_exists(admin_ROOT . 'datacache/tongji.php')) {
			include_once admin_ROOT . 'datacache/tongji.php';
			$tongji = stripslashes(html_entity_decode($tongji));  //转换html实体去掉反斜杠
		}
		$this->pagetemplate->assign('tongji', $tongji);
		$this->pagetemplate->assign('copyright', html_entity_decode($this->CON['copyright']));
		$this->pagetemplate->assign('dcode', $dcityarr[0]);
		$this->pagetemplate->assign('dcity', $dcityarr[1]);
		$this->pagetemplate->assign('selfname', $selfname);
		$this->pagetemplate->assign('email', $this->CON['admine_mail']);
		$this->pagetemplate->assign('url', $this->CON['domain']);
		$this->pagetemplate->assign('arrlink', $arrlink);
		$this->pagetemplate->assign('tempdir', $this->CON['default_templates']);
		$this->pagetemplate->assign('ordertel', $this->CON['ordertel']);
		$this->pagetemplate->assign('weblogo', $this->CON['weblogo']);

		if (admin_FROM) {

			if ($this->CON['is_alonelng']) {
				$pathurl = admin_URL;
			} else {
				$pathurl = admin_ClassURL . '/';
			}
			$this->pagetemplate->assign('pathurl', $pathurl);
			$this->pagetemplate->assign('lng', admin_LNG);
			$this->pagetemplate->assign('lngpack', $this->lng);
			$homelink = $this->get_link('home', '', admin_LNG);
			$this->pagetemplate->assign('homelink', $homelink);

			$this->pagetemplate->assign('piclngkey', admin_LNG == 'cn' ? '' : admin_LNG);
		}
	}
	/**
	 * 加载缓存文件
	 */
	function cachedb() {
		include_once admin_ROOT . 'public/class_cache.php';

		$dbcacheDIR = admin_ROOT . 'datacache/dbcache/';

		$dbcacheTIME = $this->CON['cache_time'];
		$this->dbcache = new cacheDB();

		$this->dbcache->cachefile = $dbcacheDIR;
		$this->dbcache->cachetime = $dbcacheTIME;
		$this->dbcache->cachefiletype = 'php';

		$this->dbcache->caching = ($this->CON['is_caching'] == 1) ? true : false;
	}
	
	/**
	 * 获取数据库统计字段
	 * @param string $db_table 表
	 * @param string $db_where 条件
	 * @return int
	 */
	function db_numrows($db_table, $db_where) {
		$resulted = $this->db->query('SELECT COUNT(*) AS num FROM ' . $db_table . $db_where);
		$resulted = $this->db->fetch_assoc($resulted);
		return $resulted['num'];
	}
	//添加数据 如果返回ID例子,$newid = inserttable('docomment', $setarr, 1); 否则inserttable('docomment', $setarr);
	function inserttable($tablename, $insertsqlarr, $returnid=0)
	{
		$insertkeysql = $insertvaluesql = $comma = '';
		foreach ($insertsqlarr as $insert_key => $insert_value) {
			$insertkeysql .= $comma.'`'.$insert_key.'`';
			$insertvaluesql .= $comma.'\''.$insert_value.'\'';
			$comma = ', ';
		}
		$this->db->query('INSERT INTO '.$tablename.' ('.$insertkeysql.') VALUES ('.$insertvaluesql.')');
		if($returnid) {
			$insert_id = $this->db->insert_id();
			return $insert_id;
		}
	}
	/**
	 * 调用接口调用地址
	 * @param string $interfacename 接口名称
	 * @param array 传的数据，数组格式
	 */
	function get_interface_hotelurl($interfacename,$data) {
		$version = "";
		$server = $_SERVER['SERVER_SOFTWARE'];
		if(substr($server,0,6)=="Apache") {
			$version = $server;
		} else {
			$version = $server ." PHP/".PHP_VERSION;
		}
		$api = $iscurl = function_exists('curl_exec')? "curl" : "file";
		
		$useragent = "YudingBao (".$version."; Ver/".db_version."; API/".$api."; http://www.yudingbao.com/);";
		$referer = $_SERVER['HTTP_REFERER'];
		include admin_ROOT . adminfile . '/include/inc_interface.php';
		if($interfacename == "memberregsms" || $interfacename == "memberpwsms") {
			$url = $URLINFOLIST[$interfacename]['url'] . "&" .  $ORDERPARAM;
			$url = str_replace("{#sid#}",hotelorder_aid,$url);
			$url = str_replace("{#skey#}",hotelorder_key,$url);
			$url = str_replace("{#aid#}",$this->CON['hotel_aid'],$url);
			$url = str_replace("{#key#}",$this->CON['sms_key'],$url);
		} else {
			$url = $URLINFOLIST[$interfacename]['url'] . "&" .  $ORDERPARAM;
			$url = str_replace("{#sid#}",hotelorder_aid,$url);
			$url = str_replace("{#skey#}",hotelorder_key,$url);
			$url = str_replace("{#aid#}",$this->CON['hotel_aid'],$url);
			$url = str_replace("{#key#}",$this->CON['hotel_key'],$url);
		}
		
		$prefix = "hotel"; $cachekey = "";
		switch ($interfacename) {
			case "hotelnearby":
			{
				$url = str_replace("{#cityName#}",$data['cityName'],$url);
				$url = str_replace("{#keyword#}",$data['keyword'],$url);
				$cachekey = $data['cityName']."_".$data['keyword'];
				break;
			}
			case "hotelsearch":
			{
				$url = str_replace("{#country#}",$data['country'],$url);
				$url = str_replace("{#regionCode#}",$data['regionCode'],$url);
				$url = str_replace("{#provinceCode#}",$data['provinceCode'],$url);
				$url = str_replace("{#cityCode#}",$data['cityCode'],$url);
				$url = str_replace("{#districtCode#}",$data['districtCode'],$url);
				$url = str_replace("{#businessZoneCode#}",$data['businessZoneCode'],$url);
				$url = str_replace("{#checkInDate#}",$data['checkInDate'],$url);
				$url = str_replace("{#checkOutDate#}",$data['checkOutDate'],$url);
				$url = str_replace("{#categories#}",$data['categories'],$url);
				$url = str_replace("{#lowestPrice#}",$data['lowestPrice'],$url);
				$url = str_replace("{#highestPrice#}",$data['highestPrice'],$url);
				$url = str_replace("{#broadbandService#}",$data['broadbandService'],$url);
				$url = str_replace("{#keyword#}",$data['keyword'],$url);
				$url = str_replace("{#landmark#}",$data['landmark'],$url);
				$url = str_replace("{#lng#}",$data['lng'],$url);
				$url = str_replace("{#lat#}",$data['lat'],$url);
				$url = str_replace("{#radius#}",$data['radius'],$url);
				$url = str_replace("{#pageIndex#}",$data['pageIndex'],$url);
				$url = str_replace("{#pageSize#}",$data['pageSize'],$url);
				if($data['landmark'] !='' && $data['lng'] > 0 && $data['lat'] > 0 && $data['radius'] > 0 && $data['sortType'] == 0) {
					$data['sortType'] = 1;
				}
				$url = str_replace("{#sortType#}",$data['sortType'],$url);
				$url = str_replace("{#includeNonBooking#}",$data['includeNonBooking'],$url);
				$url = str_replace("{#includeGuaranteeable#}",$data['includeGuaranteeable'],$url);
				$url = str_replace("{#chainBrands#}",$data['chainBrands'],$url);
				$cachekey = $data['country']."_".$data['regionCode']."_".$data['provinceCode']."_".$data['cityCode']."_".$data['districtCode'];
				$cachekey .= "_".$data['businessZoneCode']."_".$data['checkInDate']."_".$data['checkOutDate']."_".$data['categories']."_".$data['lowestPrice'];
				$cachekey .= "_".$data['highestPrice']."_".$data['broadbandService']."_".$data['keyword']."_".$data['landmark']."_".$data['lng']."_".$data['lat'];
				$cachekey .= "_".$data['radius']."_".$data['pageIndex']."_".$data['pageSize']."_".$data['sortType']."_".$data['includeNonBooking'];
				$cachekey .= "_".$data['includeGuaranteeable']."_".$data['chainBrands'];
				break;
			}
			case "hotelindex": //cityId=0101&cityId=0201&cityId=0301&cityId=0401&cityId=0501&cityId=0601&cityId=0701&cityId=0801&cityId=0901&cityId=1001&cityId=1101&cityId=1201
			{
				$url = str_replace("{#cityId#}",$data['cityId'],$url);
				$url = str_replace("{#maxHotelCount#}",$data['maxHotelCount'],$url);
				$cachekey = $data['cityId']."_".$data['maxHotelCount'];
				break;
			}
			case "hotelsubmitorder":
			{
				$url = 	str_replace("{#hotelCode#}",$data['hotelCode'],$url);
				$url = 	str_replace("{#roomCode#}",$data['roomCode'],$url);
				$url = 	str_replace("{#roomRatePlan#}",$data['roomRatePlan'],$url);
				$url = 	str_replace("{#checkInDate#}",$data['checkInDate'],$url);
				$url = 	str_replace("{#checkOutDate#}",$data['checkOutDate'],$url);
				$url = 	str_replace("{#arrivalEarlyTime#}",$data['arrivalEarlyTime'],$url);
				$url = 	str_replace("{#arrivalLateTime#}",$data['arrivalLateTime'],$url);
				$url = 	str_replace("{#note#}",$data['note'],$url);
				$url = 	str_replace("{#roomCount#}",$data['roomCount'],$url);
				$url = 	str_replace("{#guest#}",$data['guest'],$url);
				$url = 	str_replace("{#contacterName#}",$data['contacterName'],$url);
				$url = 	str_replace("{#contacterMobile#}",$data['contacterMobile'],$url);
				$url = 	str_replace("{#contacterEMail#}",$data['contacterEMail'],$url);
				$url = 	str_replace("{#isGuaranteeable#}",$data['isGuaranteeable'],$url);
				$url = 	str_replace("{#ccHolderName#}",$data['ccHolderName'],$url);
				$url = 	str_replace("{#ccNumber#}",$data['ccNumber'],$url);
				$url = 	str_replace("{#ccValidYear#}",$data['ccValidYear'],$url);
				$url = 	str_replace("{#ccValidMonth#}",$data['ccValidMonth'],$url);
				$url = 	str_replace("{#ccVeryfyCode#}",$data['ccVeryfyCode'],$url);
				$url = 	str_replace("{#ccIdTypeCode#}",$data['ccIdTypeCode'],$url);
				$url = 	str_replace("{#ccIdNumber#}",$data['ccIdNumber'],$url);
				
				break;
			}
			case "hotelallcity":
			{
				$url = str_replace("{#includeDistricts#}",$data['includeDistricts'],$url);
				$url = str_replace("{#includeCommercials#}",$data['includeCommercials'],$url);
				$url = str_replace("{#includeLandmarks#}",$data['includeLandmarks'],$url);
				$cachekey = $data['includeDistricts']."_".$data['includeCommercials']."_".$data['includeLandmarks'];
				break;
			}
			case "hotelsinglecity":
			{
				$url = str_replace("{#cityCode#}",$data['cityCode'],$url);
				$url = str_replace("{#includeDistricts#}",$data['includeDistricts'],$url);
				$url = str_replace("{#includeCommercials#}",$data['includeCommercials'],$url);
				$url = str_replace("{#includeLandmarks#}",$data['includeLandmarks'],$url);
				$cachekey = $data['cityCode']."_".$data['includeDistricts']."_".$data['includeCommercials']."_".$data['includeLandmarks'];
				break;
			}
			case "hotelshow":
			{
				$url = str_replace("{#hotelCode#}",$data['hotelCode'],$url);
				$cachekey = $data['hotelCode'];
				break;
			}
			case "hotelchainbrands":
			{
				$cachekey = "hotelchainbrands";
				break;
			}
			case "hotel0rderroomstatus":
			{
				$url = 	str_replace("{#hotelCode#}",$data['hotelCode'],$url);
				$url = 	str_replace("{#roomCode#}",$data['roomCode'],$url);
				$url = 	str_replace("{#roomRatePlan#}",$data['roomRatePlan'],$url);
				$url = 	str_replace("{#checkInDate#}",$data['checkInDate'],$url);
				$url = 	str_replace("{#checkOutDate#}",$data['checkOutDate'],$url);
				$cachekey = $data['hotelCode']."_".$data['roomCode']."_".$data['roomRatePlan']."_".$data['checkInDate']."_".$data['checkOutDate'];
				break;
			}
			case "hotelorderstutas":
			{
				$url = str_replace("{#orderId#}",$data['orderId'],$url);
				break;
			}
			case "hotelrooms":
			{
				$url = 	str_replace("{#hotelCode#}",$data['hotelCode'],$url);
				$url = 	str_replace("{#checkInDate#}",$data['checkInDate'],$url);
				$url =  str_replace("{#checkOutDate#}",$data['checkOutDate'],$url);
				$url =  str_replace("{#lowestPrice#}",$data['lowestPrice'],$url);
				$url =  str_replace("{#highestPrice#}",$data['highestPrice'],$url);
				$url =  str_replace("{#broadbandService#}",$data['broadbandService'],$url);
				$url =  str_replace("{#includeNonBooking#}",$data['includeNonBooking'],$url);
				$url =  str_replace("{#includeGuaranteeable#}",$data['includeGuaranteeable'],$url);
				$cachekey = $data['hotelCode']."_".$data['checkInDate']."_".$data['checkOutDate']."_".$data['lowestPrice']."_".$data['highestPrice']."_".$data['broadbandService']."_".$data['includeNonBooking']."_".$data['includeGuaranteeable'];
				break;
			}
			case "memberregsms":
			{
				$url = 	str_replace("{#mobileNumber#}",$data['mobileNumber'],$url);
				$url = 	str_replace("{#password#}",$data['password'],$url);
				$url =  str_replace("{#title#}",$data['title'],$url);
				break;
			}
			case "memberpwsms":
			{
				$url = 	str_replace("{#mobileNumber#}",$data['mobileNumber'],$url);
				$url = 	str_replace("{#password#}",$data['password'],$url);
				$url =  str_replace("{#title#}",$data['title'],$url);
				break;
			}
		}
		
		//$ran = $this->fun->get_random();
		//$url .= "&random=".$ran;
		$arr = $array = $cachearray = array();
		$dbcacheTIME = $URLINFOLIST[$interfacename]['cachetime'];  //缓存时间 
		include_once admin_ROOT . 'public/class_json.php';
		if($dbcacheTIME > 0) {
			include_once admin_ROOT . 'public/class_cache.php';
			$dbcacheDIR = admin_ROOT . 'datacache/dbcache/hotel/';   //缓存路径
			if($interfacename =="hotelsearch" || $interfacename=="hotelrooms" || $interfacename=="hotel0rderroomstatus") {
				$dbcacheDIR .= "hotelsearch/";
			}
			$hotelcache = new cacheDB($dbcacheDIR,$dbcacheTIME,'php',true);
			
			$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
			$array = $hotelcache->checkcache($prefix ."_" . $lng . '_' . $interfacename . '_' . md5($cachekey), true);
			if(!$array) {
				$iscurl = function_exists('curl_exec')? true : false;  //是否支持curl
				if($iscurl) {
					$result = $this->fun->get_curl($url,$useragent,$referer);
				} else {
					$result = $this->fun->get_remotefile($url,$useragent,$referer);
				}
				$result = str_replace('{$Website.Name$}',$this->CON['sitename'],$result);
				$result = str_replace('{$Website.Domain$}',$this->CON['domain'],$result);
				$isjson = function_exists('json_decode')? true : false;
				if($isjson) {
					$arr = json_decode($result,true);
				} else {
					$json = new json();
					$arr = $json->jsonDecode($result);
				}
				if(!$arr) {
					$logurl = admin_ROOT . 'datacache/log/';
					if (!is_dir($logurl)) {
						if (!@mkdir($logurl, 0777, true)) return false;
					}
					$logfile = $logurl . date("YmdHis").".txt";
					$this->fun->filewrite($logfile, $result);
					if($interfacename != "hotelsubmitorder") {
						sleep(3);
						if($iscurl) {
							$result = $this->fun->get_curl($url."&reurl=2",$useragent,$referer);
						} else {
							$result = $this->fun->get_remotefile($url."&reurl=2",$useragent,$referer);
						}
						$result = str_replace('{$Website.Name$}',$this->CON['sitename'],$result);
						$result = str_replace('{$Website.Domain$}',$this->CON['domain'],$result);
						$isjson = function_exists('json_decode')? true : false;
						if($isjson) {
							$arr = json_decode($result,true);
						} else {
							$json = new json();
							$arr = $json->jsonDecode($result);
						}
					}
				}
				if($arr['Status'] == 0) {
					$array = $hotelcache->cachesave($prefix ."_" . $lng . '_' . $interfacename . '_' . md5($cachekey), $arr);
				}
				$array = $array ? $array : $arr;
				unset($arr);
			}
		} else {
			$iscurl = function_exists('curl_exec')? true : false;  //是否支持curl
			if($iscurl) {
				$result = $this->fun->get_curl($url,$useragent,$referer);
			} else {
				$result = $this->fun->get_remotefile($url,$useragent,$referer);
			}
			$result = str_replace('{$Website.Name$}',$this->CON['sitename'],$result);
			$result = str_replace('{$Website.Domain$}',$this->CON['domain'],$result);
			$isjson = function_exists('json_decode')? true : false;
			if($isjson) {
				$arr = json_decode($result,true);
			} else {
				$json = new json();
				$arr = $json->jsonDecode($result);
			}
			
			if(!$arr) {
				$logurl = admin_ROOT . 'datacache/log/';
				if (!is_dir($logurl)) {
					if (!@mkdir($logurl, 0777, true)) return false;
				}
				$logfile = $logurl . date("YmdHis").".txt";
				$this->fun->filewrite($logfile, $result);
				if($interfacename != "hotelsubmitorder") {
					sleep(3);
					if($iscurl) {
						$result = $this->fun->get_curl($url."&reurl=2",$useragent,$referer);
					} else {
						$result = $this->fun->get_remotefile($url."&reurl=2",$useragent,$referer);
					}
					$result = str_replace('{$Website.Name$}',$this->CON['sitename'],$result);
					$result = str_replace('{$Website.Domain$}',$this->CON['domain'],$result);
					$isjson = function_exists('json_decode')? true : false;
					if($isjson) {
						$arr = json_decode($result,true);
					} else {
						$json = new json();
						$arr = $json->jsonDecode($result);
					}
				}
			}
			
			$array = $arr;
		}
		if($array['Status'] == 0) {
			return $array;
		} else {
			if($interfacename == "hotelsubmitorder" || $interfacename == "memberregsms" || $interfacename == "mobileregsms" || $interfacename == "memberpwsms") {
				return $array;
			} else {
				if($interfacename == "hotelrooms") {
					if($array['Status'] == 1) {  //发生异常再次请求
						sleep(3);
						if($iscurl) {
							$result = $this->fun->get_curl($url,$useragent,$referer);
						} else {
							$result = $this->fun->get_remotefile($url,$useragent,$referer);
						}
						$isjson = function_exists('json_decode')? true : false;
						if($isjson) {
							$arr = json_decode($result,true);
						} else {
							$json = new json();
							$arr = $json->jsonDecode($result);
						}
						$array = $arr;
						if($array['Status'] == 0) {
							return $array;
						} else {
							echo $array['Messages'][0];
							exit;
						}
					}
				} else {
					if($interfacename == "hotel0rderroomstatus") {
						return $array;
					} else {
						echo $array['Messages'][0];
						exit;
					}
					
				}
			}
		}
		
	}
	function hotelsubmitorder($param=array()) {
		$data = $param;
		$res = $this->get_interface_hotelurl("hotelsubmitorder",$data);
		return $res;
	}
	function getgaranteerule($rules, $bookingDate, $checkInDate, $arriveTime, $roomCount, $firstNightFees, $fullyFees) {
		include_once admin_ROOT . 'public/class_garanteeable.php';
		$check = false; $res = '';
		$garan = new garanteeable();
		$check = $garan->checkGaranteeableByArray($rules, $bookingDate, $checkInDate, $arriveTime, $roomCount, $firstNightFees, $fullyFees);
		if($check) {
			$res = $garan->garanteeableMessage;
		}
		return $res;
	}
	
	/**
	 * 首页城市酒店基本信息
	 * @param unknown_type $cityId  城市编号
	 * @param unknown_type $maxHotelCount  记录数
	 */
	function get_hotel_index($cityId,$maxHotelCount) {
		$data = array(
			'cityId' =>$cityId,
			'maxHotelCount' =>$maxHotelCount
		);
		$res = $this->get_interface_hotelurl("hotelindex",$data);
		return $res['ResponseBody'];
	}
	function get_hotel_rooms($param=array()) {
		$data = $param;
		$res = $this->get_interface_hotelurl("hotelrooms",$data);
		return $res['ResponseBody'];
	}
	function get_orderstatus($orderid) {
		$res = $this->get_interface_hotelurl("hotelorderstutas",array('orderId'=>$orderid));
		return $res['ResponseBody'];
	}
	/**
	 * 获取酒店品牌信息
	 */
	function get_hotel_hotelchainbrands() {
		$data = array();
		$res = $this->get_interface_hotelurl("hotelchainbrands",$data);
		return $res['ResponseBody'];
	}
	//得到品牌信息列表用
	function get_hotel_listchainbrands() {
		$listarray = array();
		$listarray = $this->dbcache->checkcache('hotel_list_chainbrands', true);
		if (!$listarray) {
			$array = array();
			$chainarray = $this->get_hotel_hotelchainbrands();
			$i = 0;
			foreach ($chainarray as $key=>$value) {
				$array[] = array('_id'=>$value['_id'],'Name'=>$value['Name'],'HotelCount'=>$value['HotelCount'],'Logo'=>$value['Logo']);
				$i++;
				if($i>=30) {
					break;
				}
			}
			$listarray = $this->dbcache->cachesave('hotel_list_chainbrands', $array);
			unset($array);
		}
		return $listarray;
	}
	function get_hotelnglat($citycode) {
		$arr = array();
		$citylist = array();
		include_once admin_ROOT . 'datacache/citylist.php';
		foreach ($citylist as $c) {
			if($c['Id'] == $citycode) {
				$arr['Lng'] = $c['Lng'];
				$arr['Lat'] = $c['Lat'];
				break;
			}
		}
		return $arr;
	}
	/**
	 * 酒店订单实时房态
	 */
	function get_hotel_0rderroomstatus($hotelCode,$roomCode,$roomRatePlan,$checkInDate,$checkOutDate) {
		$data = array(
			'hotelCode' =>$hotelCode,
			'roomCode' => $roomCode,
			'roomRatePlan' => $roomRatePlan,
			'checkInDate' => $checkInDate,
			'checkOutDate' => $checkOutDate
		);
		$res = $this->get_interface_hotelurl("hotel0rderroomstatus",$data);
		return $res;
	}
	/**
	 * 得到酒店内容信息
	 * @param string $hotelCode  酒店编号
	 */
	function get_hotel_info($hotelCode) {
		$data = array(
			'hotelCode' =>$hotelCode
		);
		$res = $this->get_interface_hotelurl("hotelshow",$data);
		return $res['ResponseBody'];
	}
	/**
	 * 获取某城市的标志性地标
	 * @param $citycode 城市代码名称
	 * @param $searchname 搜索的关键词
	 * @param $ctx 
	 */
	function get_hotel_nearby($citycode,$searchname) {
		$data = array(
			'cityName' =>$citycode,
			'keyword' =>$searchname
		);
		$res = $this->get_interface_hotelurl("hotelnearby",$data);
		return $res['ResponseBody']['Landmarks'];
	}
	/**
	 * 酒店搜索 调用接口
	 * @param array $param 参数为一个数组
	 */
	function get_hotel_search($param=array()){
		$data = $param;
		$res = $this->get_interface_hotelurl("hotelsearch",$data);
		if(!$res['ResponseBody']['TotalItemCount']) {
			sleep(2);
			$res = $this->get_interface_hotelurl("hotelsearch",$data);
		}
		return $res['ResponseBody'];
	}
	/**
	 * 写日志
	 * @param $action 操作项目
	 * @param $extra 结果
	 * @param $inuser 用户名
	 */
	function writelog($action, $extra='', $inuser=null, $orderid=0) {
		if (!$this->CON['is_log']) return false;
		$username = $this->esp_username;
		if (empty($username)) {
			$username = $inuser;
		}
		$onlineip = $this->fun->ip($_SERVER['REMOTE_ADDR']);
		$addtime = time();
		$this->db->query("INSERT INTO " . db_prefix . "logs (username,onlineip,addtime,actions,remarks,orderid) VALUES ('$username',$onlineip,$addtime,'$action','$extra',$orderid)");
	}

	function admin_cookieview($keyword=false) {
		$retrunstr = array();
		$retrunstr['powerlist'] = explode('|', $this->fun->eccode($this->fun->accept('esp_powerlist', 'C'), 'DECODE', db_pscode));
		$arr_purview = explode('|', $this->fun->eccode($this->fun->accept('ecisp_admininfo', 'C'), 'DECODE', db_pscode));

		list($retrunstr['id'], $retrunstr['username'], $retrunstr['password'], $retrunstr['useragent'], $retrunstr['powerid'], $retrunstr['inputclassid'], $retrunstr['softurl']) = $arr_purview;
		return!$keyword ? $retrunstr : $retrunstr[$keyword];
	}
	/**
	 * 加载后台管理包括权限判断等
	 */
	function admin_purview() {
		if ($this->fun->accept('archive', 'R') == 'filemanage' && $this->fun->accept('action', 'R') == 'batupfilesave') {

			$ecisp_admininfo = $this->fun->accept('ecisp_admininfo', 'G');
			$esp_powerlist = $this->fun->accept('esp_powerlist', 'G');
			$gettype = false;
		} else {
			$ecisp_admininfo = $this->fun->accept('ecisp_admininfo', 'C');
			$esp_powerlist = $this->fun->accept('esp_powerlist', 'C');
			$gettype = true;
		}

		$arr_purview = explode('|', $this->fun->eccode($ecisp_admininfo, 'DECODE', db_pscode));

		$this->esp_powerlist = explode('|', $this->fun->eccode($esp_powerlist, 'DECODE', db_pscode));

		list($this->esp_adminuserid, $this->esp_username, $this->esp_password, $this->esp_useragent, $this->esp_powerid, $this->esp_inputclassid, $this->esp_softurl) = $arr_purview;
		if ($gettype) {
			if (empty($this->esp_username) || empty($this->esp_adminuserid) || md5(admin_AGENT) != $this->esp_useragent || md5(admin_ClassURL) != $this->esp_softurl) {
				$condition = 0;
			} else {
				$condition = 1;
			}
		} else {
			if (empty($this->esp_username) || empty($this->esp_adminuserid) || md5(admin_ClassURL) != $this->esp_softurl) {
				$condition = 0;
			} else {
				$condition = 1;
			}
		}
		if ($condition == 0) {

			if ($this->fun->accept('archive', 'R') != 'adminuser' && $this->fun->accept('action', 'R') != 'login') {
				header('location: index.php?archive=adminuser&action=login');
				exit();
			}
		} else {

			if ($condition == 1 && $this->fun->accept('point', 'R') == '' && $this->fun->accept('archive', 'R') == '' && $this->fun->accept('action', 'R') == '') {
				header('location: index.php?archive=management&action=tab&loadfun=mangercenter');
				exit();
			}
		}
	}
	//权限验证 $this->esp_powerlist 个人权限数组列表 第一个参数主分类,第二个分类次分类
	function powercheck($powerlistid, $powerlistid2) {
		if (!in_array('all', $this->esp_powerlist)) {
			if ($powerlistid > 0) {
				if (!in_array($powerlistid, $this->esp_powerlist)) {  //权限错误
					exit('Permissions errors');
				}
			}
			if ($powerlistid2 > 0) {
				if (!in_array($powerlistid2, $this->esp_powerlist)) {
					exit('Permissions errors');
				}
			}
		} else {
			if (!in_array('all', $this->esp_powerlist)) {
				exit('Permissions errors');
			}
		}
	}
	//权限验证 返回ture 或者  false
	function getpower($powerlistid, $powerlistid2) {
		$power = false;
		if (in_array('all', $this->esp_powerlist)) {
			$power = true;
		} else {
			if ($powerlistid > 0 && $powerlistid2 > 0) {
				if (in_array($powerlistid, $this->esp_powerlist) && in_array($powerlistid2, $this->esp_powerlist)) {
					$power = true;
				}
			}
		}
		return $power;
	}

	function member_cookieview($keyword=false) {
		$retrunstr = array();
		$retrunstr['username'] = $this->fun->eccode($this->fun->accept('ecisp_member_username', 'C'), 'DECODE', db_pscode);
		$user_info = explode('|', $this->fun->eccode($this->fun->accept('ecisp_member_info', 'C'), 'DECODE', db_pscode));

		list($retrunstr['userid'], $retrunstr['alias'], $retrunstr['integral'], $retrunstr['mcid'], $retrunstr['email'], $retrunstr['lastip'], $retrunstr['ipadd'], $retrunstr['useragent'], $retrunstr['adminclassurl']) = $user_info;
		return!$keyword ? $retrunstr : $retrunstr[$keyword];
	}

	function member_purview($userrank=false, $url=null, $upurl=false) {

		$this->ec_member_username = $this->fun->eccode($this->fun->accept('ecisp_member_username', 'C'), 'DECODE', db_pscode);
		$user_info = explode('|', $this->fun->eccode($this->fun->accept('ecisp_member_info', 'C'), 'DECODE', db_pscode));

		list($this->ec_member_username_id, $this->ec_member_alias, $this->ec_member_integral, $this->ec_member_mcid, $this->ec_member_email, $this->ec_member_lastip, $this->ec_member_ipadd, $this->ec_member_useragent, $this->ec_member_adminclassurl) = $user_info;

		if (empty($this->ec_member_username) && empty($this->ec_member_username_id) && md5(admin_AGENT) != $this->ec_member_useragent && md5(admin_ClassURL) != $this->ec_member_adminclassurl) {

			$this->condition = 0;
			if ($url) {
				$this->fun->setcookie('ecisp_login_link', $url, 3600);
			} elseif ($upurl) {
				$nowurl = 'http://' . $_SERVER["HTTP_HOST"] . $_SERVER['REQUEST_URI'];
				$this->fun->setcookie('ecisp_login_link', $nowurl, 3600);
			}

			$linkURL = $this->get_link('memberlogin', array(), admin_LNG);

			$mlink = $this->memberlink(array(), admin_LNG);
			$this->callmessage($this->lng['memberloginerr'], $linkURL, $this->lng['memberlogin'], 1, $this->lng['member_regbotton'], 1, $mlink['reg']);
		} else {

			$this->condition = 1;

			if ($this->ec_member_mcid < $userrank && $userrank) {
				$linkURL = $this->get_link('memberlogin', array(), admin_LNG);
				$this->callmessage($this->lng['memberpuverr'], $linkURL, $this->lng['gobackurlbotton']);
			}
		}
		return $this->condition;
	}
	
	function member_purview_ajax($userrank=false, $url=null, $upurl=false) {

		$check = true;
		$this->ec_member_username = $this->fun->eccode($this->fun->accept('ecisp_member_username', 'C'), 'DECODE', db_pscode);
		$user_info = explode('|', $this->fun->eccode($this->fun->accept('ecisp_member_info', 'C'), 'DECODE', db_pscode));

		list($this->ec_member_username_id, $this->ec_member_alias, $this->ec_member_integral, $this->ec_member_mcid, $this->ec_member_email, $this->ec_member_lastip, $this->ec_member_ipadd, $this->ec_member_useragent, $this->ec_member_adminclassurl) = $user_info;

		if (empty($this->ec_member_username) && empty($this->ec_member_username_id) && md5(admin_AGENT) != $this->ec_member_useragent && md5(admin_ClassURL) != $this->ec_member_adminclassurl) {
			$check = false;
		} else {

			$this->condition = 1;

			if ($this->ec_member_mcid < $userrank && $userrank) {
				$check = false;
			}
		}
		return $check;
	}

	function get_power_view($id, $returnname=null) {
		if (empty($id)) {
			return false;
		}
		$db_table = db_prefix . 'admin_powergroup';
		$db_where = 'id=' . $id;
		$powerview = $this->dbcache->checkcache('power_view_' . $id, false);
		if (!$powerview) {
			$rsPower = $this->db->fetch_first('SELECT id,powername,powerlist,delclass FROM ' . $db_table . ' WHERE ' . $db_where);
			$powerview = $this->dbcache->cachesave('power_view_' . $id, $rsPower);
			$powerview = $powerview ? $powerview : $rsPower;
			unset($rsPower);
		}
		if (!empty($returnname)) {
			return $powerview[$returnname];
		} else {
			return $powerview;
		}
	}

	function get_power_array($powerid=0) {
		$db_table = db_prefix . 'admin_powergroup';
		$sql = 'SELECT id,powername,powerlist,delclass FROM ' . $db_table;
		$powerarray = $this->dbcache->checkcache('power_array', false);
		$arrayList = array();
		if (!$powerarray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$powerarray = $this->dbcache->cachesave('power_array', $array);
			$powerarray = $powerarray ? $powerarray : $array;
			unset($array);
		}
		$powerarray = $this->fun->reset_array($powerarray, $powerid, 'id');
		$i = count($powerarray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $powerarray;
		return $arrayList;
	}

	function get_lng_array($lng=null, $isuptype=0) {
		$db_table = db_prefix . 'lng';
		$db_where = " WHERE isopen=1";
		if ($isuptype == 0) {
			$db_where .= " AND isuptype=0";
		}
		$lngarray = $this->dbcache->checkcache('lng_array_' . $isuptype, false);
		if (!$lngarray) {
			$sql = 'SELECT id,pid,lng,lngtitle,url,isuptype FROM ' . $db_table . $db_where . ' ORDER BY pid,id DESC';
			$rs = $this->db->query($sql);
			$arrayList = array();
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$lngarray = $this->dbcache->cachesave('lng_array_' . $isuptype, $array);
			$lngarray = $lngarray ? $lngarray : $array;
			unset($array);
		}
		$lngarray = $this->fun->reset_array($lngarray, $lng, 'lng');
		$i = count($lngarray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $lngarray;
		return $arrayList;
	}

	function get_lan_view($lng, $returnname=null) {
		if (empty($lng)) {
			return false;
		}
		$db_table = db_prefix . 'lng';
		$db_where = "lng='$lng'";
		$chacheview = $this->dbcache->checkcache('lng_view_' . $lng, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('lng_view_' . $lng, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function callmessage($calltitle, $linkURL, $bottonName, $backid=0, $backBotton='', $backurlid=0, $backurllink='') {
		$this->start_pagetemplate();

		$this->pagetemplate->assign('linkURL', $linkURL);

		$this->pagetemplate->assign('calltitle', $calltitle);

		$this->pagetemplate->assign('bottonName', $bottonName);
		$this->pagetemplate->assign('path', 'message');
		if ($backurlid > 0) {

			$this->pagetemplate->assign('backlinkURL', $backurllink);
		} else {

			$this->pagetemplate->assign('backlinkURL', $_SERVER['HTTP_REFERER']);
		}
		if ($backid > 0) {
			$this->pagetemplate->assign('backid', $backid);

			$this->pagetemplate->assign('backBotton', $backBotton);
		}
		$this->pagetemplate->display(admin_LNGDIR . 'public/callmessage', '', false, $filename, admin_LNG);
		exit;
	}

	function calldialogmessage($calltitle, $bottonName, $backurl=null, $isback=0, $isfunction=0, $functionname=null) {
		$this->start_template();

		$this->ectemplates->assign('calltitle', $calltitle);

		$this->ectemplates->assign('bottonName', $bottonName);
		$this->ectemplates->assign('isback', $isback);

		$this->ectemplates->assign('linkURL', $backurl);

		$this->ectemplates->assign('functionname', $functionname);
		$this->ectemplates->assign('isfunction', $isfunction);
		$this->ectemplates->display('admin/admin_digmessage');
		exit();
	}

	function get_member_purview($id, $returnname=null) {
		if (empty($id)) {
			return false;
		}
		$db_table = db_prefix . 'member_class';
		$db_where = 'mcid=' . $id;
		$chacheview = $this->dbcache->checkcache('memberclass_view_' . $id, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT mcid,rankname,isinter,integra,isclass FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('memberclass_view_' . $id, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_member_purview_array($mcid=0) {
		$db_table = db_prefix . 'member_class';
		$sql = 'SELECT mcid,rankname,isinter,integra,isclass FROM ' . $db_table;
		$chacherray = $this->dbcache->checkcache('memberclass_array', false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('memberclass_array', $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $mcid, 'mcid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}
	
	function get_member_source_array() {
		$db_table = db_prefix . 'member';
		$sql = 'SELECT userid,username,alias FROM ' . $db_table . " WHERE mcid=99 ORDER BY userid DESC";
		$chacherray = $this->dbcache->checkcache('membersource_array', false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				if($rsList['alias']) {
					$rsList['username'] = $rsList['alias'];
				}
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('membersource_array', $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function set_member_integral($userid=0, $integral=0) {
		if (!$this->CON['mem_isintegral']) return false;
		if (empty($userid) || empty($integral)) {
			return false;
		}
		$integral = intval($integral);
		$userid = intval($userid);
		$db_table = db_prefix . 'member';
		$db_where = 'userid=' . $userid;
		$db_set = "integral=integral+$integral";
		$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		return true;
	}
	//根据抓取的城市区域代码 得到本系统的城市区域代码
	function get_convercity($HotelinProvince,$HotelinCity,$HotelinArea) {
		$arr = array();$cityarr =array();$res = array();
		include admin_ROOT . 'datacache/city.php';
		$res = $this->get_singlecity($HotelinCity,true,true,true);
		$Province = $HotelArea = "";
		foreach ($cityarr as $value) {
			if($HotelinProvince == $value['Code']) {
				$Province = $value['Name'];
			}
		}
		$City = $res['Name'];
		foreach ($res['DistrictLocations'] as $value) {
			if($HotelinArea == $value['Code']){
				$HotelArea = $value['Name'];
			}
		}
		$pid = $this->get_cityid(1,$Province);
		$cid = $this->get_cityid($pid,$City);
		$hid = $this->get_cityid($cid,$HotelArea);
		
		$arr = array($pid,$cid,$hid);
		return $arr;
	}
	function get_cityname($citycode) {
		$cityarr =array();
		$cityarr = $this->get_singlecity($citycode,true,true,true);
		$City = $cityarr['Name'];
		return $City;
	}
	function get_cityid($parentid,$cityname) {
		$re = 0;
		$db_table = db_prefix . 'city';
		$sql = "SELECT `id` FROM $db_table WHERE parentid=$parentid AND cityname='$cityname'";
		$re = $this->db->fetch_first($sql);
		if($re) {
			$id = $re['id'];
		} else {
			$id = 0;
		}
		return $id;
	}
	
	//抓取市区字段信息
	function get_citylist($includeDistricts,$includeCommercials,$includeLandmarks) {
		$data = array(
			'includeDistricts'   =>$includeDistricts,
			'includeCommercials' =>$includeCommercials,
			'includeLandmarks'   =>$includeLandmarks
		);
		$res = $this->get_interface_hotelurl("hotelallcity",$data);
		$cityarr = $res['ResponseBody'];
		return $cityarr;
	}
	//根据城市ID取得区域商圈等信息
	function get_singlecity($cityCode,$includeDistricts,$includeCommercials,$includeLandmarks) {
		$data = array(
			'cityCode'           =>$cityCode,
			'includeDistricts'   =>$includeDistricts,
			'includeCommercials' =>$includeCommercials,
			'includeLandmarks'   =>$includeLandmarks
		);
		$res = $this->get_interface_hotelurl("hotelsinglecity",$data);
		$cityarr = $res['ResponseBody'];
		return $cityarr;
	}

	function get_cityview($id, $returnname=null) {
		if (empty($id)) {
			return false;
		}
		$db_table = db_prefix . 'city';
		$db_where = 'id=' . $id;
		$chacheview = $this->dbcache->checkcache('city_view_' . $id, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT id,parentid,cityname,regiontype,agencyid FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('city_view_' . $id, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_modelview($id, $returnname=null) {
		if (empty($id)) {
			return false;
		}
		$db_table = db_prefix . 'model';
		$db_where = 'mid=' . $id;
		$chacheview = $this->dbcache->checkcache('model_view_' . $id, false);
		if (!$chacheview) {
			$rsModel = $this->db->fetch_first('SELECT mid,lng,modelname,pagemax,pagesylte,isclass,lockin,isorder,isexhibit,istime,islongtitle,istsn,isauthor,ishtml,iscontent,addtime FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('model_view_' . $id, $rsModel);
			$chacheview = $chacheview ? $chacheview : $rsModel;
			unset($rsModel);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}
	//模型列表
	function get_model($mid=0, $lng='', $isclass=0, $ishtml=0) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'model';
		$wheretext = '';
		if ($isclass > 0) {
			$wheretext.=' AND isclass=' . $isclass;
		}
		if ($ishtml > 0) {
			$wheretext.=' AND ishtml=' . $ishtml;
		}
		$db_where = ' WHERE mid>0' . $wheretext;
		$chacherray = $this->dbcache->checkcache('model_array_' . $lng . '_' . $isclass . '_' . $ishtml, false);
		$arrayList = array();
		if (!$chacherray) {
			$sql = 'SELECT mid,lng,modelname,pagemax,pagesylte,isclass,lockin,isorder,isexhibit,istime,islongtitle,istsn,isauthor,ishtml,iscontent,addtime FROM ' . $db_table . $db_where;
			$rs = $this->db->query($sql);
			$arrayList = array();
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('model_array_' . $lng . '_' . $isclass . '_' . $ishtml, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $mid, 'mid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}
	//得到酒店所属公司列表 companyid公司ID，companyname公司名字
	function get_company_array($companyid=0,$lng='') {
		$chacherray = $this->dbcache->checkcache('hotel_company_array_'.$lng, false);
		if (!$chacherray) {
			//这里加上获取公司列表的过程
			$readlist = array(
				array('companyid'=>1,'companyname'=>'E龙公司')
			);
			$chacherray = $this->dbcache->cachesave('hotel_company_array_'.$lng, $readlist);
			$chacherray = $chacherray ? $chacherray : $readlist;
			unset($readlist);
		}
		$chacherray = $this->fun->reset_array($chacherray, $companyid, 'companyid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}
	//得到酒店的房型列表$roomtypeid房型ID
	function get_roomtype_array($roomtypeid=0,$lng='') {

		//这里加上获取房型列表的过程
		$readlist = array(
			array('id'=>1,'name'=>'经济适用房(不含早，均价268元)')
		);
		
		$roomarray = $this->fun->reset_array($readlist, $roomtypeid, 'id');
		$i = count($roomarray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $roomarray;
		return $arrayList;
	}
	//得到酒店是否信用卡担保
	function get_guaranteetype($union_id,$hotel_id) {
		$is = true;
		return $is;
	}
	//得到预订员列表
	function get_admember_list($id=0,$lng='') {
		$db_table = db_prefix . 'admin_member';
		$db_where = ' WHERE `powergroup` in(1,3) ORDER BY `id`';  //powergroup=3是预订员
		$chacherray = $this->dbcache->checkcache('admember_list_array_'.$lng, false);
		if (!$chacherray) {
			$sql = 'SELECT `id`,`username`,`name` FROM ' . $db_table . $db_where;
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('admember_list_array_'.$lng, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $id, 'id');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}
	/**
	 * 得到一列管理员数据
	 * @param $username 用户名
	 * @param $userid 用户id
	 * @param $field 字段
	 */
	function get_admember($username=null, $userid=0, $field='*') {
		$db_table = db_prefix . 'admin_member';
		$db_field = empty($field) ? "*" : $field;
		$db_where = empty($username) ? " WHERE id=$userid" : " WHERE username='$username'";
		$db_sql = "SELECT $db_field FROM $db_table $db_where";
		$rsLIST = $this->db->fetch_first($db_sql);
		return $rsLIST;
	}

	function get_modelatt($mid, $selectedid=true) {
		if (empty($mid)) {
			return false;
		}

		$db_table = db_prefix . 'model_att';
		$db_where = ' WHERE isclass=1 and mid=' . $mid . ' ORDER BY pid';
		$chacherray = $this->dbcache->checkcache('modeatt_array_' . $mid . '_' . $selectedid, false);
		if (!$chacherray) {
			$sql = 'SELECT * FROM ' . $db_table . $db_where;
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				if ($rsList['inputtype'] == 'select' || $rsList['inputtype'] == 'radio' || $rsList['inputtype'] == 'checkbox') {
					$forvalue = split("\n", $rsList['attrvalue']);
					$newvalue = array();
					foreach ($forvalue as $key => $forvalue) {
						if ($key == 0 && $selectedid) {
							$newvalue[] = array('name' => $forvalue, 'selected' => 'selected');
						} else {
							$newvalue[] = array('name' => $forvalue, 'selected' => '');
						}
					}
					$rsList['attrvalue'] = $newvalue;
				}
				$attrread[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('modeatt_array_' . $mid . '_' . $selectedid, $attrread);
			$chacherray = $chacherray ? $chacherray : $attrread;
			unset($attrread);
		}
		return $chacherray;
	}

	function checkboxarray($array) {
		if (!is_array($array)) return false;
		foreach ($array as $key => $forvalue) {
			if ($forvalue['inputtype'] == 'checkbox') {
				$newvalue[] = $forvalue['attrname'];
			}
		}
		return $newvalue;
	}

	function get_memberatt($selectedid=true, $isline=false) {

		$db_table = db_prefix . 'member_attr';
		if ($isline) {
			$wheretext = ' AND isline=0';
		}
		$db_where = " WHERE isclass=1$wheretext ORDER BY pid";
		$chacherray = $this->dbcache->checkcache('memberatt_array_' . $isline . '_' . $selectedid, false);
		if (!$chacherray) {
			$sql = 'SELECT * FROM ' . $db_table . $db_where;
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				if ($rsList['inputtype'] == 'select' || $rsList['inputtype'] == 'radio' || $rsList['inputtype'] == 'checkbox') {
					$forvalue = split("\n", $rsList['attrvalue']);
					$newvalue = array();
					foreach ($forvalue as $key => $forvalue) {
						if ($key == 0 && $selectedid) {
							$newvalue[] = array('name' => $forvalue, 'selected' => 'selected');
						} else {
							$newvalue[] = array('name' => $forvalue, 'selected' => '');
						}
					}
					$rsList['attrvalue'] = $newvalue;
				}
				$attrread[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('memberatt_array_' . $isline . '_' . $selectedid, $attrread);
			$chacherray = $chacherray ? $chacherray : $attrread;
			unset($attrread);
		}
		return $chacherray;
	}

	function get_path($array=array(), $lng='') {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$array['title'] = $array['typename'];
		$array['link'] = $this->get_link('type', $array, $lng);
		$typearray = $this->get_typelist(array(), 0, $array['topid'], $array['tid'], $array['lng']);
		$level = $typearray[$array['tid']]['level'];
		$array['level'] = $level;
		$upid = $array['upid'];
		if ($upid == 0) {
			$newstype[] = $array;
		} else {
			$newstype[$level] = $array;
			for ($index = $level; $index >= 0; $index--) {
				foreach ($typearray as $key => $typeview) {
					if ($typeview['level'] == $index && $upid == $typeview['tid']) {
						$typeview['title'] = $typeview['typename'];
						$typeview['link'] = $this->get_link('type', $typeview, $lng);
						$newstype[$index] = $typeview;
						$upid = $typeview['upid'];
						break;
					}
				}
			}
			ksort($newstype);
		}
		return $newstype;
	}

	function get_typelist($t_array=array(), $mid=0, $in_tid=0, $now_tid=0, $lng='', $level=0, $isclass=0) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'typelist';
		$db_table2 = db_prefix . 'document';

		$db_where = ' WHERE c.lng=\'' . $lng . '\'';
		if ($mid > 0) {
			$db_where.=' AND c.mid=' . $mid;
		}
		if ($isclass > 0) {
			$db_where.=' AND c.isclass=' . $isclass;
		}

		if (count($t_array) < 1) {
			$sql = 'SELECT c.*,COUNT(a.tid) AS has_c
			FROM ' . $db_table . ' AS c LEFT JOIN ' . $db_table . ' AS a ON a.upid = c.tid' . $db_where . ' GROUP BY c.tid ORDER BY c.upid,c.pid';
			$t_array = $this->dbcache->checkcache('typelist_array_' . $lng . '_' . $mid . '_' . $isclass, false);
			if (!$t_array) {
				$rs = $this->db->query($sql);
				while ($rsList = $this->db->fetch_assoc($rs)) {
					$array[] = $rsList;
				}
				$t_array = $this->dbcache->cachesave('typelist_array_' . $lng . '_' . $mid . '_' . $isclass, $array);
				$t_array = $t_array ? $t_array : $array;
				unset($array);
			}
			if (count($t_array) < 1 || !is_array($t_array)) return array();
		}

		$db_where = ' WHERE lng=\'' . $lng . '\'';
		if ($mid > 0) {
			$db_where.=' AND mid=' . $mid;
		}

		$sql = 'SELECT tid,COUNT(*) AS num FROM ' . $db_table2 . $db_where . ' GROUP BY tid';
		$rsNum = $this->db->query($sql);
		while ($rsNumList = $this->db->fetch_assoc($rsNum)) {
			$arraynum[] = $rsNumList;
		}

		$newnum = array();
		if (is_array($arraynum)) {
			foreach ($arraynum as $key => $value) {
				$newnum[$value['tid']] = $value['num'];
			}
		}

		foreach ($t_array as $key => $value) {

			$t_array[$key]['infonum'] = !empty($newnum[$value['tid']]) ? $newnum[$value['tid']] : 0;

			$t_array[$key]['selected'] = ($now_tid == $value['tid']) ? 'selected' : '';
		}

		$typelist = $this->hstypelist($in_tid, $t_array);

		if ($level > 0) {
			if ($in_tid == 0) {
				$end_level = $level;
			} else {

				$first_item = reset($typelist);
				$end_level = $first_item['level'] + $level;
			}

			foreach ($typelist AS $key => $val) {
				if ($val['level'] >= $end_level) {
					unset($typelist[$key]);
				}
			}
		}

		return $typelist;
	}

	function hstypelist($in_tid, $typearray) {

		$this->newtypearray = array();
		if (isset($this->newtypearray[$in_tid])) {
			return $this->newtypearray[$in_tid];
		}
		if (!isset($this->newtypearray[0])) {

			$level = 0;

			$last_tid = 0;

			$options = array();

			$tid_array = array();

			$level_array = array();
			while (!empty($typearray)) {
				foreach ($typearray AS $key => $value) {
					$tid = $value['tid'];

					if ($level == 0 && $last_tid == 0) {
						$options[$tid] = $value;
						$options[$tid]['level'] = $level;
						$options[$tid]['id'] = $tid;
						$options[$tid]['name'] = $value['typename'];

						unset($typearray[$key]);

						if ($value['has_c'] == 0) {
							continue;
						}

						$last_tid = $tid;

						$tid_array = array($tid);

						$level_array[$last_tid] = ++$level;

						continue;
					}

					if ($value['upid'] == $last_tid) {
						$options[$tid] = $value;
						$options[$tid]['level'] = $level;
						$options[$tid]['id'] = $tid;
						$options[$tid]['name'] = $value['typename'];
						unset($typearray[$key]);

						if ($value['has_c'] > 0) {

							if (end($tid_array) != $last_tid) {
								$tid_array[] = $last_tid;
							}

							$last_tid = $tid;

							$tid_array[] = $tid;

							$level_array[$last_tid] = ++$level;
						}
					} elseif ($value['upid'] > $last_tid) {
						break;
					}
				}

				$count = count($tid_array);
				if ($count > 1) {

					$last_tid = array_pop($tid_array);
				} elseif ($count == 1) {

					if ($last_tid != end($tid_array)) {
						$last_tid = end($tid_array);
					} else {

						$level = 0;
						$last_tid = 0;
						$tid_array = array();
						continue;
					}
				}
				if ($last_tid && isset($level_array[$last_tid])) {
					$level = $level_array[$last_tid];
				} else {
					$level = 0;
				}
			}

			$newtypearray[0] = $options;
		} else {
			$options = $newtypearray[0];
		}
		if (!$in_tid) {

			return $options;
		} else {

			if (empty($options[$in_tid])) {
				return array();
			}

			$in_tid_level = $options[$in_tid]['level'];

			foreach ($options AS $key => $value) {
				if ($key != $in_tid) {
					unset($options[$key]);
				} else {
					break;
				}
			}
			$in_tid_array = array();
			foreach ($options AS $key => $value) {
				if (($in_tid_level == $value['level'] && $value['tid'] != $in_tid) ||
					($in_tid_level > $value['level'])) {
					break;
				} else {
					$in_tid_array[$key] = $value;
				}
			}
			$newtypearray[$in_tid] = $in_tid_array;
			return $in_tid_array;
		}
	}

	function get_typeselect($mid=0, $in_tid=0, $now_tid=0, $lng='', $level=0, $isclass=0) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$typelist = $this->get_typelist(array(), $mid, $in_tid, $now_tid, $lng, $level, $isclass);
		$newarray = array();
		if (is_array($typelist) && count($typelist) > 0) {
			foreach ($typelist as $key => $value) {
				$newarray[] = $value;
			}
			unset($typelist);
		}
		return $newarray;
	}
	//获取分类信息
	function get_type($tid, $returnname=null) {
		if (empty($tid)) return false;
		$db_table = db_prefix . 'typelist';  //分类表
		$db_where = 'tid=' . $tid;
		$chacheview = $this->dbcache->checkcache('typelist_view_' . $tid, false);
		if (!$chacheview) {
			$rsType = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('typelist_view_' . $tid, $rsType);
			$chacheview = $chacheview ? $chacheview : $rsType;
			unset($rsType);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_typeid($tid=0, $field_name='tid', $retid=0, $mid=0, $now_tid=0, $lng='', $level=0, $isclass=0, $returntype='in') {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;

		$getAllTypeid = $this->get_typelist(array(), $mid, $tid, $now_tid, $lng, $level, $isclass);
		if (count($getAllTypeid) > 0) {

			$newTypeidArray = array_keys($getAllTypeid);
		} else {

			if ($returntype == 'in') {
				return $field_name . ' = ' . $tid;
			} else {
				return false;
			}
		}
		if (empty($newTypeidArray)) {
			return false;
		} else {
			$item_list = array_unique($newTypeidArray);
			if ($returntype == 'in') {
				$item_list_tmp = '';
				foreach ($item_list AS $item) {
					if ($item !== '' && $item != $retid) {
						$item_list_tmp .= $item_list_tmp ? ",'$item'" : "'$item'";
					}
				}
				if (empty($item_list_tmp)) {
					return false;
				} else {
					return $field_name . ' IN (' . $item_list_tmp . ') ';
				}
			} else {
				$item_list_tmp = '';
				foreach ($item_list AS $item) {
					if ($item !== '' && $item != $retid) {
						$item_list_tmp .= $item_list_tmp ? ",$item" : "$item";
					}
				}
				return $item_list_tmp;
			}
		}
	}

	function get_type_array($tid=0, $mid=0, $upid=0, $lng='', $isclass=1, $isaccessory=0) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'typelist';
		$db_where = " WHERE lng='$lng'";
		if ($isclass > 0) $db_where.=" AND isclass=$isclass";
		if ($mid > 0) $db_where.=" AND mid=$mid";
		if ($upid > 0) $db_where.=" AND upid=$upid";
		if ($isaccessory > 0) $db_where.=" AND isaccessory=$isaccessory";
		$sql = 'SELECT * FROM ' . $db_table . $db_where . ' ORDER BY pid,tid DESC';
		$chacherray = $this->dbcache->checkcache('typelist_array_' . $lng . '_' . $mid . '_' . $upid . '_' . $isclass . '_' . $isaccessory, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('typelist_array_' . $lng . '_' . $mid . '_' . $upid . '_' . $isclass . '_' . $isaccessory, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $tid, 'tid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_subjectlist_array($sid=0, $mid=0, $lng='', $isclass=1) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'subjectlist';
		$db_where = " WHERE lng='$lng'";
		if ($isclass > 0) $db_where.=" AND isclass=$isclass";
		if ($mid > 0) $db_where.=" AND mid=$mid";
		$sql = 'SELECT sid,pid,mid,lng,subjectname,subpic,dirname,purview,isclass,styleid,template,filenamestyle,dirpath,addtime FROM ' . $db_table . $db_where . ' ORDER BY pid,sid DESC';
		$chacherray = $this->dbcache->checkcache('subjectlist_array_' . $lng . '_' . $mid . '_' . $isclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('subjectlist_array_' . $lng . '_' . $mid . '_' . $isclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $sid, 'sid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_subjectlist_purview($sid, $returnname=null) {
		if (empty($sid)) {
			return false;
		}
		$db_table = db_prefix . 'subjectlist';
		$db_where = 'sid=' . $sid;
		$chacheview = $this->dbcache->checkcache('subjectlist_view_' . $sid, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT sid,pid,mid,lng,subjectname,keywords,description,content,subpic,dirname,purview,isclass,styleid,template,filenamestyle,dirpath,addtime FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('subjectlist_view_' . $sid, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_bbstype_array($btid=0, $lng='', $isclass=1) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'bbs_typelist';
		$db_where = " WHERE lng='$lng'";
		if ($isclass > 0) $db_where.=" AND isclass=$isclass";
		$sql = 'SELECT btid,pid,lng,typename,content,purview,isclass,addtime FROM ' . $db_table . $db_where . ' ORDER BY pid,btid DESC';
		$chacherray = $this->dbcache->checkcache('bbs_typelist_array_' . $lng . '_' . $isclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('bbs_typelist_array_' . $lng . '_' . $isclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $btid, 'btid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_bbstype_view($btid, $returnname=null) {
		if (empty($btid)) {
			return false;
		}
		$db_table = db_prefix . 'bbs_typelist';
		$db_where = 'btid=' . $btid;
		$chacheview = $this->dbcache->checkcache('bbs_typelist_view_' . $btid, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT btid,pid,lng,typename,content,purview,isclass,addtime FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('bbs_typelist_view_' . $btid, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_keytype_array($ktid=0, $lng='') {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'keylink_type';
		$db_where = " WHERE lng='$lng'";
		$chacherray = $this->dbcache->checkcache('keylinktype_array_' . $lng, false);
		$arrayList = array();
		if (!$chacherray) {
			$sql = 'SELECT ktid,lng,keytypename,keyworklist,description FROM ' . $db_table . $db_where . ' ORDER BY ktid DESC';
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('keylinktype_array_' . $lng, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $ktid, 'ktid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_keytype_purview($ktid, $returnname=null) {
		if (empty($ktid)) {
			return false;
		}
		$db_table = db_prefix . 'keylink_type';
		$db_where = 'ktid=' . $ktid;
		$chacheview = $this->dbcache->checkcache('keylinktype_view_' . $ktid, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT ktid,lng,keytitle,keytypename,keyworklist,description FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('keylinktype_view_' . $ktid, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_form_array($fgid=0, $lng='', $isclass=1) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'form_group';
		$db_where = " WHERE lng='$lng'";
		if ($isclass > 0) $db_where.=" AND isclass=$isclass";
		$chacherray = $this->dbcache->checkcache('formgroup_array_' . $lng . '_' . $isclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$sql = 'SELECT fgid,pid,lng,formgroupname,formcode,emailatt,isclass,ismenu,isseccode,ismail,tmid,isinputtime,inputtime,purview,iscount FROM ' . $db_table . $db_where . ' ORDER BY pid,fgid DESC';
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('formgroup_array_' . $lng . '_' . $isclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $fgid, 'fgid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_form_purview($fgid, $returnname=null) {
		if (empty($fgid)) {
			return false;
		}
		$db_table = db_prefix . 'form_group';
		$db_where = 'fgid=' . $fgid;
		$chacheview = $this->dbcache->checkcache('formgroup_view_' . $fgid, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT fgid,pid,lng,formgroupname,formcode,content,successtext,countattrs,template,emailatt,addtime,isclass,ismenu,isseccode,ismail,tmid,isinputtime,inputtime,purview,iscount FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('formgroup_view_' . $fgid, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_formatt($fgid, $selectedid=true) {

		$db_table = db_prefix . 'form_attr';
		$db_where = ' WHERE isclass=1 and fgid=' . $fgid . ' ORDER BY pid,faid desc';
		$chacherray = $this->dbcache->checkcache('formatt_array_' . $fgid . '_' . $selectedid, false);
		if (!$chacherray) {
			$sql = 'SELECT * FROM ' . $db_table . $db_where;
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				if ($rsList['inputtype'] == 'select' || $rsList['inputtype'] == 'radio' || $rsList['inputtype'] == 'checkbox') {
					$forvalue = split("\n", $rsList['attrvalue']);
					$newvalue = array();
					foreach ($forvalue as $key => $forvalue) {
						if ($key == 0 && $selectedid) {
							$newvalue[] = array('name' => $forvalue, 'selected' => 'selected');
						} else {
							$newvalue[] = array('name' => $forvalue, 'selected' => '');
						}
					}
					$rsList['attrvalue'] = $newvalue;
				}
				$attrread[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('formatt_array_' . $fgid . '_' . $selectedid, $attrread);
			$chacherray = $chacherray ? $chacherray : $attrread;
			unset($attrread);
		}
		return $chacherray;
	}

	function get_doclabel_array($dlid=0, $mid=0) {
		$db_table = db_prefix . 'document_label';
		if ($mid > 0) {
			$db_where.=' WHERE mid=' . $mid;
		}
		$sql = 'SELECT dlid,mid,labelname FROM ' . $db_table . $db_where . ' ORDER BY dlid DESC';
		$chacherray = $this->dbcache->checkcache('doclabel_array_' . $mid, false);
		$arrayList = array();
		if (!empty($dlid)) {
			$dlidarray = explode(',', $dlid);
		}
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('doclabel_array_' . $mid, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$i = count($chacherray);
		if (!empty($dlid) && is_array($chacherray)) {
			foreach ($chacherray as $key => $value) {
				$chacherray[$key]['selected'] = (in_array($value['dlid'], $dlidarray)) ? 'CHECKED' : '';
			}
		}
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}
	/**
	 * 得到文档咨询信息
	 * @param int $did
	 * @param string $returnname
	 */
	function get_document($did, $returnname=null) {
		if (empty($did)) {
			return false;
		}
		$db_table1 = db_prefix . 'document AS a';
		$db_table2 = db_prefix . 'document_content AS b';
		$db_table3 = db_prefix . 'document_other AS c';
		$db_table4 = db_prefix . 'document_value AS d';
		$db_table5 = db_prefix . 'document_exhibition AS e';
		$db_sql = "SELECT a.*,b.dcid,b.content,c.doid,c.startime,c.endtime,c.width,c.height,c.istime,c.filetype,d.dvid,d.value,e.province,e.city,e.heldareas,e.lnglat,e.startdate,e.enddate,e.industry,e.venueaddress FROM $db_table1
			   LEFT JOIN $db_table2 ON a.did = b.did
			   LEFT JOIN $db_table3 ON a.did = c.did
			   LEFT JOIN $db_table4 ON a.did = d.did
			   LEFT JOIN $db_table5 ON a.did = e.did
			   WHERE a.did = $did ";
		$chacheview = $this->dbcache->checkcache('document_' . $did . '_all', false);
		if (!$chacheview) {
			$rsType = $this->db->fetch_first($db_sql);
			$chacheview = $this->dbcache->cachesave('document_' . $did . '_all', $rsType);
			$chacheview = $chacheview ? $chacheview : $rsType;
			unset($rsType);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}
	
	function get_exhibition($indus) {
		$heldareas = $industry = $arr = array();
		include admin_ROOT . 'datacache/exhibition.php';
		if($indus) {
			$arr['industry'] = $industry[$indus];
		}
		return $arr;
	}

	function get_document_other_view($did, $returnname=null) {
		$db_table = db_prefix . 'document_other';
		$chacheview = $this->dbcache->checkcache('document_' . $did . '_other', false);
		if (!$chacheview) {
			$rsType = $this->db->fetch_first("SELECT doid,startime,endtime,width,height,istime,filetype FROM $db_table WHERE did = $did");
			$chacheview = $this->dbcache->cachesave('document_' . $did . '_other', $rsType);
			$chacheview = $chacheview ? $chacheview : $rsType;
			unset($rsType);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_documentview($did, $returnname=null) {
		if (empty($did)) {
			return false;
		}
		$db_table = db_prefix . 'document';
		$chacheview = $this->dbcache->checkcache('document_' . $did, false);
		if (!$chacheview) {
			$rsType = $this->db->fetch_first("SELECT * FROM $db_table WHERE did = $did ");
			$chacheview = $this->dbcache->cachesave('document_' . $did, $rsType);
			$chacheview = $chacheview ? $chacheview : $rsType;
			unset($rsType);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_album_array($did=0) {
		$db_table = db_prefix . 'document_album';
		$db_where = " WHERE did=$did";
		$chacherray = $this->dbcache->checkcache('document_' . $did . '_album', false);
		$arrayList = array();
		if (!$chacherray) {
			$sql = 'SELECT daid,did,picname,picfile FROM ' . $db_table . $db_where . ' ORDER BY daid DESC';
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('document_' . $did . '_album', $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_document_value($did, $returnname=null) {
		if (empty($did)) {
			return false;
		}
		$db_table = db_prefix . 'document_value';
		$db_sql = "SELECT value FROM $db_table WHERE did = $did ";
		$rsPower = $this->db->fetch_first($db_sql);
		if (!empty($returnname)) {
			return $rsPower[$returnname];
		} else {
			return $rsPower;
		}
	}
	
	function get_document_exhibit($did) {
		if (empty($did)) {
			return false;
		}
		$rsarr = array();
		$db_table = db_prefix . 'document_exhibition';
		$db_sql = "SELECT `city`,`startdate`,`enddate` FROM $db_table WHERE did = $did";
		$rsarr = $this->db->fetch_first($db_sql);
		return $rsarr;
	}

	function get_htmlfilename($readfiletemplates, $filetext=array(), $protectval=null) {
		if ($protectval != 'dirname') $readfiletemplates = str_replace('{dirname}', $filetext['dirname'], $readfiletemplates);
		if ($protectval != 'tid') $readfiletemplates = str_replace('{tid}', $filetext['tid'], $readfiletemplates);
		if ($protectval != 'sid') $readfiletemplates = str_replace('{sid}', $filetext['sid'], $readfiletemplates);
		if ($protectval != 'did') $readfiletemplates = str_replace('{did}', $filetext['did'], $readfiletemplates);
		if ($protectval != 'pageid') $readfiletemplates = str_replace('{pageid}', $filetext['pageid'], $readfiletemplates);
		if ($protectval != 'datetime') $readfiletemplates = str_replace('{datetime}', $filetext['datetime'], $readfiletemplates);
		return $readfiletemplates;
	}

	function get_templatesdir($modelnames) {
		include admin_ROOT . adminfile . '/include/command_templatesdir.php';
		if (!array_key_exists($modelnames, $TEMPLATESDIR)) {
			return false;
		}
		return $TEMPLATESDIR[$modelnames];
	}

	function rep_keylink($content, $tags='', $lng='cn') {
		if (empty($content) || empty($tags)) return false;
		$tagArray = explode(',', $tags);
		if (!is_array($tagArray) || count($tagArray) < 1) {
			return false;
		}

		$tagArray = array_unique($tagArray);
		$newTagArray = array();
		foreach ($tagArray as $key => $value) {
			$newTagArray[$key]['title'] = $value;
			$newTagArray[$key]['link'] = $this->get_link('taglink', array('key' => $value), $lng);
		}
		if (count($newTagArray) > 0) {
			$content = $this->fun->stripslashes($content);

			$content = html_entity_decode($content);

			$content = preg_replace('/<a[\s]*class="taglink"[\s]*title="[^"]*"[\s]*href=["|\']?([^>"\' ]+)["|\']?\s*[^>]*>(.+?)<\/a>/si', "$2", $content);
			foreach ($newTagArray as $key => $value) {
				$str_temp = '<a class="taglink" title="' . $value['title'] . '" href="' . $value['link'] . '" target="_blank">' . $value['title'] . '</a>';
				$content = str_replace($value['title'], $str_temp, $content);
			}
			$content = $this->fun->daddslashes($content, 1);
			$content = htmlspecialchars($content);
			return $content;
		} else {
			return $content;
		}
	}

	function get_keyword($str, $len=10) {
		if (empty($str)) return false;
		if ($len < 1) return false;
		$str = $this->fun->stripslashes($str);
		$str = $this->fun->htmldecode(strip_tags($str));
		$str = str_ireplace("&ldquo;", "", $str);
		$str = str_ireplace("&nbsp;", "", $str);
		$datafile = admin_ROOT . 'datacache/espws_utf8.dat';
		$datainifile = admin_ROOT . 'datacache/espws_rules.ini';
		if (!is_file($datafile) || !is_file($datainifile)) {
			return false;
		}
		include_once admin_ROOT . 'public/ecwordsegmentation/ecwordsegmentation_class.php';
		$this->Ecwordsegmentation = new Ecwordsegmentation('utf8');
		$this->Ecwordsegmentation->set_charset('utf8');
		$this->Ecwordsegmentation->input_dict($datafile);
		$this->Ecwordsegmentation->input_rule($datainifile);
		$this->Ecwordsegmentation->input_text($str);
		$keywordArray = $this->Ecwordsegmentation->get_keyword($len, 'n,v');
		$keyword_str = array();
		if (count($keywordArray) > 0) {
			foreach ($keywordArray as $key => $value) {
				$keyword_str[] = $value['word'];
			}
			$keyword = implode(',', $keyword_str);
		} else {
			$keyword = false;
		}
		return $keyword;
	}
	//根据订单类型取得订单状态
	function get_ordertype($ordertype) {
		switch ($ordertype) {
			case 0:
				$ordertypename = "未知状态";
				break;
			case 1:
				$ordertypename = "新订单";
				break;
			case 2:
				$ordertypename = "电话预订";
				break;
			case 3:
				$ordertypename = "处理中";
				break;
			case 4:
				$ordertypename = "已确认";
				break;
			case 5:
				$ordertypename = "客户取消";
				break;
			case 6:
				$ordertypename = "客服取消";
				break;
			case 7:
				$ordertypename = "已入住";
				break;
			case 8:
				$ordertypename = "已离店";
				break;
			case 9:
				$ordertypename = "审核中";
				break;
			case 10:
				$ordertypename = "NOSHOW";
				break;
			case 11:
				$ordertypename = "满房";
				break;
			default:
				$ordertypename = "失败订单";
				break;
		}
		return $ordertypename;
	}
	//更新积分
	function get_user_Integral($allfees,$uid,$oid) {
		if($this->CON['mem_isintegral']==1) {  //启用积分策略
			$key = 0;
			if($this->CON['mem_selintegral']==1) { //1  按比例  0 按订单积分
				$key = $this->CON['member_ishotelpercent'];  //比例数
				$Integral = round($allfees * $key /100);
			} else {
				$key = $this->CON['member_ishotelorder'];  //每个酒店订单积分
				$Integral = $key;
			}
			$db_table = db_prefix . 'hotel_order';
			$db_set = " IsIntegral=1 ";
			$db_where = "  HotelOrderID='$oid' AND UserId=$uid "; 
			/*会员更新积分*/
			$memdb_table = db_prefix . 'member';
			$memdb_where = " userid=$uid ";
			$memdb_set = " integral=$Integral ";
			$row = $this->db->fetch_first('SELECT `IsIntegral` FROM ' . $db_table . ' WHERE ' . $db_where);
			//if($row['IsIntegral'] == 0) { //没有增加过积分的话
				$this->db->query('UPDATE ' . $memdb_table . ' SET ' . $memdb_set . ' WHERE ' . $memdb_where);
				$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
			//}
		}
	}

	function get_payplug_array($opid=0, $isclass=1) {
		$db_table = db_prefix . 'order_pay';
		if ($isclass > 0) $db_where = " WHERE isclass=$isclass";
		$sql = 'SELECT opid,payname,paycontent,paycode,payis,payplugver,pluglist,isclass,addtime FROM ' . $db_table . $db_where . ' ORDER BY pid,opid DESC';
		$chacherray = $this->dbcache->checkcache('orderpay_array_' . $isclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('orderpay_array_' . $isclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $opid, 'opid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_payplug_view($opid=0, $returnname=null) {
		if (empty($opid)) {
			return false;
		}
		$db_table = db_prefix . 'order_pay';
		$db_where = "opid=$opid";
		$chacheview = $this->dbcache->checkcache('orderpay_view_' . $opid, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT opid,payname,paycontent,paycode,payis,payplugver,pluglist,isclass,addtime FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('orderpay_view_' . $opid, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_shipplug_array($osid=0, $isclass=1) {
		$db_table = db_prefix . 'order_shipping';
		if ($isclass > 0) $db_where = " WHERE isclass=$isclass";
		$sql = 'SELECT osid,title,content,price,markup,isclass,iscash,isinsure,insureper,addtime FROM ' . $db_table . $db_where . ' ORDER BY pid,osid DESC';
		$chacherray = $this->dbcache->checkcache('ordership_array_' . $isclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('ordership_array_' . $isclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $osid, 'osid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_shipplug_view($osid=0, $returnname=null) {
		if (empty($osid)) {
			return false;
		}
		$db_table = db_prefix . 'order_shipping';
		$db_where = "osid=$osid";
		$chacheview = $this->dbcache->checkcache('ordership_view_' . $osid, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT osid,title,content,price,markup,isclass,iscash,isinsure,insureper,addtime FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('ordership_view_' . $osid, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}
	/**
	 * 酒店分页页码
	 * @param string $model 模块名称
	 * @param int $totalpage 总页数
	 * @param int $pageindex 当前页
	 * @param array $param 参数
	 * @param $lng 语言
	 */
	function get_page($model,$totalpage,$pageindex,$param,$lng) {
		$pagetext = "";
		if($totalpage > 7) {
			if($pageindex<= 3 ) {
				$min = 1;
				$max = 7;
			} else if(($pageindex+3) > $totalpage) {
				$min = $totalpage - 7;
				$max = $totalpage;
			} else {
				$min = $pageindex - 3;
				$max = $pageindex + 3;
			}
		} else {
			$min = 1;
			$max = $totalpage;
		}
		for($i=$min;$i<=$max;$i++) {   //分页页码
			$param['pageIndex'] = $i;
			$pageurl = "";
			if($model == "hotel") {
				$pageurl = $this->get_hotel_fliterurl($param);
			} else if($model == "comment") {
				$param['page'] = $param['pageIndex'];
				$pageurl = $this->get_link('hotel_comment',$param,$lng);
			}
			if($i == $pageindex) {
				$pagetext .= "<span>$i</span> ";
			} else {
				$pagetext .= "<a href=\"$pageurl\">$i</a> ";
			}
		}
		return $pagetext;
	}

	function get_member($username=null, $userid=0, $returnname=null) {
		$db_table = db_prefix . 'member';
		$db_where = empty($username) ? " WHERE userid=$userid" : " WHERE username='$username'";
		$db_sql = "SELECT * FROM $db_table $db_where";
		$rsLIST = $this->db->fetch_first($db_sql);
		if (!empty($returnname)) {
			return $rsLIST[$returnname];
		} else {
			return $rsLIST;
		}
	}

	function get_order($oid=0, $returnname=null) {
		if (empty($oid)) {
			return false;
		}
		$db_table = db_prefix . 'order';
		$db_where = "WHERE oid=$oid";
		$db_sql = "SELECT * FROM $db_table $db_where";
		$rsLIST = $this->db->fetch_first($db_sql);
		if (!empty($returnname)) {
			return $rsLIST[$returnname];
		} else {
			return $rsLIST;
		}
	}

	function get_enquiry($eid=0, $returnname=null) {
		if (empty($eid)) {
			return false;
		}
		$db_table = db_prefix . 'enquiry';
		$db_where = "WHERE eid=$eid";
		$db_sql = "SELECT * FROM $db_table $db_where";
		$rsLIST = $this->db->fetch_first($db_sql);
		if (!empty($returnname)) {
			return $rsLIST[$returnname];
		} else {
			return $rsLIST;
		}
	}

	function get_templates_array($tmid=0, $lng='', $styleclass=2, $typeclass='print') {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'templates';
		$db_where = " WHERE lng='$lng' AND styleclass=$styleclass AND typeclass='$typeclass'";
		$sql = 'SELECT tmid,lng,templatename,templatecode,title,pic,typeclass,fileclass,styleclass,lockin,addtime FROM ' . $db_table . $db_where . ' ORDER BY tmid DESC';
		$chacherray = $this->dbcache->checkcache('templates_array_' . $lng . '_' . $styleclass . '_' . $typeclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('templates_array_' . $lng . '_' . $styleclass . '_' . $typeclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $tmid, 'tmid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_templates_view($tmid=0, $returnname=null) {
		if (empty($tmid)) {
			return false;
		}
		$db_table = db_prefix . 'templates';
		$db_where = "tmid=$tmid";
		$chacheview = $this->dbcache->checkcache('templates_view_' . $tmid, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('templates_view_' . $tmid, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}

	function get_tempmail_view($tecode=null, $styleclass=0, $returnname=null) {
		if (empty($tecode)) {
			return false;
		}
		$db_table = db_prefix . 'templates';
		$db_where = "templatecode='$tecode'";
		if (!empty($styleclass)) {
			$db_where .= " AND styleclass=$styleclass";
		}
		$chacheview = $this->dbcache->checkcache('templates_view_' . $tecode, false);
		if (!$chacheview) {
			$rsPuv = $this->db->fetch_first('SELECT * FROM ' . $db_table . ' WHERE ' . $db_where);
			$chacheview = $this->dbcache->cachesave('templates_view_' . $tecode, $rsPuv);
			$chacheview = $chacheview ? $chacheview : $rsPuv;
			unset($rsPuv);
		}
		if (!empty($returnname)) {
			return $chacheview[$returnname];
		} else {
			return $chacheview;
		}
	}
	
	function get_week($timestamp) {
		if (empty($timestamp)) {
			$timestamp = time();
		}
		$w = date('N',$timestamp); $s = "";
		switch($w) {
			case 1:
			{
				$s = "星期一";	
				break;
			}
			case 2:
			{
				$s = "星期二";	
				break;
			}
			case 3:
			{
				$s = "星期三";	
				break;
			}
			case 4:
			{
				$s = "星期四";	
				break;
			}
			case 5:
			{
				$s = "星期五";	
				break;
			}
			case 6:
			{
				$s = "星期六";	
				break;
			}
			case 7:
			{
				$s = "星期日";	
				break;
			}
		}
		return $s;
	}

	function get_bbslabel_array($blid=0, $lng='', $isclass=0) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$db_table = db_prefix . 'bbs_label';
		$db_where = " WHERE lng='$lng'";
		if ($isclass > 0) {
			$db_where.=' AND isclass=' . $isclass;
		}
		$sql = 'SELECT blid,pid,lng,isclass,labelname FROM ' . $db_table . $db_where . ' ORDER BY pid,blid DESC';
		$chacherray = $this->dbcache->checkcache('bbs_label_array_' . $lng . '_' . $isclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('bbs_label_array_' . $lng . '_' . $isclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $blid, 'blid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function get_bbs($bid, $returnname=null) {
		if (empty($bid)) {
			return false;
		}
		$db_table1 = db_prefix . 'bbs AS a';
		$db_table2 = db_prefix . 'bbs_content AS b';
		$db_sql = "SELECT a.*,b.bcid,b.content FROM $db_table1
			   LEFT JOIN $db_table2 ON a.bid = b.bid
			   WHERE a.bid = $bid ";
		$rsPower = $this->db->fetch_first($db_sql);
		if (!empty($returnname)) {
			return $rsPower[$returnname];
		} else {
			return $rsPower;
		}
	}
	
	function get_commentlist($uid,$hid,$limit) {
		$lng = empty($lng) ? $this->CON['is_lancode'] : $lng;
		$where = ' WHERE 1 ';
		if($uid) {
			$where .= " and uid=$uid ";
		}
		if($hid) {
			$where .= " and hid='$hid' ";
		}
		$db_table = db_prefix . 'hotel_comment';
		$sql = "SELECT cid,uid,username,hid,hname,datetime,level,comment FROM $db_table $where ORDER BY cid DESC LIMIT 0 , $limit";
		$chacherray = $this->dbcache->checkcache('hotel_commentlist_array_' . $lng . '_' . $uid . '_' . $hid, false);
		$arrayList = array();
		if (!$chacherray) {
			$array = array();
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$showurl = $this->get_link("hotelshow",array('hid'=>$rsList['hid']),$lng);
				$rsList['showurl'] = $showurl;
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('hotel_commentlist_array_' . $lng . '_' . $uid . '_' . $hid, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		return $chacherray;
	}
	
	function get_hotelnearlist($param) {
		include_once admin_ROOT . 'public/class_cache.php';
		$dbcacheDIR = admin_ROOT . 'datacache/dbcache/hotel/';   //缓存路径
		$dbcacheTIME = 3600 * 24;
		$hotelcache = new cacheDB($dbcacheDIR,$dbcacheTIME,'php',true);
		$array = $hotelcache->checkcache('hotel_cn_' . $param['hotelCode'] . '_hotelnearlist', true);
		if(!$array) {
			$arrnear = $nearlist = array();
			$arrnear = $this->get_hotel_search($param);
			$i=0;
			foreach ($arrnear['Hotels'] as $key=>$value) {
				$nearlist[$i]['id'] = $value['_id'];
				$nearlist[$i]['name'] = $value['Name'];
				$showurl = $this->get_link("hotelshow",array('hid'=>$value['_id']),$lng);
				$nearlist[$i]['url'] = $showurl;
				$i++;
			}
			$array = $hotelcache->cachesave('hotel_cn_' . $param['hotelCode'] . '_hotelnearlist', $nearlist);
			$array = $array ? $array : $nearlist;
		}
		return $array;
	}

	function get_bbs_content($bid, $returnname=null) {
		if (empty($bid)) {
			return false;
		}
		$db_table = db_prefix . 'bbs_content';
		$db_sql = "SELECT * FROM $db_table WHERE bid = $bid ";
		$rsPower = $this->db->fetch_first($db_sql);
		if (!empty($returnname)) {
			return $rsPower[$returnname];
		} else {
			return $rsPower;
		}
	}

	function get_formcontent($ftid, $returnname=null) {
		if (empty($ftid)) {
			return false;
		}
		$db_table1 = db_prefix . 'form_time AS a';
		$db_table2 = db_prefix . 'form_value AS b';
		$db_sql = "SELECT a.*,b.fvid,b.did,b.userid,b.attrvalue,b.iscount,b.recontent FROM $db_table1
			   LEFT JOIN $db_table2 ON a.ftid = b.ftid
			   WHERE a.ftid = $ftid ";
		$rsPower = $this->db->fetch_first($db_sql);
		if (!empty($returnname)) {
			return $rsPower[$returnname];
		} else {
			return $rsPower;
		}
	}

	function get_calling_array($cid=0, $isclass=1) {
		$db_table = db_prefix . 'calling';
		if ($isclass > 0) {
			$db_where.=' WHERE isclass=' . $isclass;
		}
		$sql = 'SELECT cid,pid,type,style,name,code,addtime,isclass FROM ' . $db_table . $db_where . ' ORDER BY pid,cid DESC';
		$chacherray = $this->dbcache->checkcache('calling_array_' . $isclass, false);
		$arrayList = array();
		if (!$chacherray) {
			$rs = $this->db->query($sql);
			while ($rsList = $this->db->fetch_assoc($rs)) {
				$array[] = $rsList;
			}
			$chacherray = $this->dbcache->cachesave('calling_array_' . $isclass, $array);
			$chacherray = $chacherray ? $chacherray : $array;
			unset($array);
		}
		$chacherray = $this->fun->reset_array($chacherray, $cid, 'cid');
		$i = count($chacherray);
		$arrayList['num'] = $i;
		$arrayList['list'] = $chacherray;
		return $arrayList;
	}

	function install_tags($tags=null, $lng='cn') {
		if (empty($tags)) {
			return false;
		}
		$db_table = db_prefix . 'keylink';
		$tags_array = explode(',', $tags);
		if (is_array($tags_array) && count($tags_array) > 1) {
			foreach ($tags_array as $key => $value) {
				$db_where = " WHERE keywordname='$value'";
				$countnum = $this->db_numrows($db_table, $db_where);
				if ($countnum > 0) {
					$db_set = "hit=hit+1";
					$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . $db_where);
				} else {
					$db_field = 'lng,pid,keywordname,hit,keywordtitle,linkurl,iswindow,isclass,isreplace';
					$db_values = "'$lng',50,'$value',1,'','',0,1,0";
					$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES (' . $db_values . ')');
				}
			}
		}
		return true;
	}

	function install_pic($did, $picfile=array(), $del=true) {
		if (empty($did)) {
			return false;
		}

		$db_table = db_prefix . 'document_album';
		if ($del) {
			$db_where = "did=$did";
			$this->db->query('DELETE FROM ' . $db_table . ' WHERE ' . $db_where);
		}
		if (!is_array($picfile) || count($picfile) <= 1) {
			return false;
		}

		$temp_pic = array();
		foreach ($picfile as $key => $value) {
			if (!empty($value)) {
				$temp_pic[] = $value;
			}
		}

		$countpic = count($temp_pic);
		if ($countpic < 1 && !is_array($temp_pic)) {
			return false;
		}
		$time = time();
		$db_field = 'did,picname,picfile,addtime';
		$keynow = $countpic - 1;
		foreach ($temp_pic as $key => $value) {
			if ($key == $keynow) {
				$install.="($did,'','$value',$time)";
			} else {
				$install.="($did,'','$value',$time),";
			}
		}

		$this->db->query('INSERT INTO ' . $db_table . ' (' . $db_field . ') VALUES ' . $install . '');
		return true;
	}
	//生成文章html
	function articlehtml($did, $smilan='') {
		$smilan = empty($smilan) ? $this->CON['is_lancode'] : $smilan;
		$this->start_pagetemplate();   //初始化模板
		$db_table = db_prefix . 'document';

		$arrayout = array('c' => 0, 's' => null);

		$readinfo = $this->get_document($did);  //得到文档信息
		if ($readinfo['ishtml'] == 0 || $readinfo['islink'] == 1 || $readinfo['isclass'] == 0) return $arrayout;
		if (!empty($readinfo['linkdid'])) {
			$readinfo['linkdid'] = str_replace(',', '/', $readinfo['linkdid']);
		}
		$readinfo['content'] = html_entity_decode($readinfo['content']);

		$typeview = $this->get_type($readinfo['tid']);  //得到分类信息
		if (empty($readinfo['filename']) || empty($readinfo['filepath'])) {

			$type_styleid = $typeview['styleid'];

			$type_templates = $typeview['template'];

			$filenamestyle = $typeview['filenamestyle'];

			$readnamestyle = $typeview['readnamestyle'];

			$dirname = $typeview['dirname'];

			$dirpath = $typeview['dirpath'];

			$isdatadir = $typeview['isdatadir'];

			$readfileArray = array('dirname' => $dirname, 'tid' => $readinfo['tid'], 'did' => $did, 'datetime' => date("YmdHis"));
			$filename = empty($readinfo['filename']) ? $this->get_htmlfilename($readnamestyle, $readfileArray) : $readinfo['filename'];

			$filepath_temp = ($isdatadir == 1) ? $dirpath . '/' . date("Ymd") : $dirpath;
			$filepath = empty($readinfo['filepath']) ? $filepath_temp : $readinfo['filepath'];

			$db_where = 'did=' . $did;
			$db_set = "filename='$filename',filepath='$filepath'";
			$this->db->query('UPDATE ' . $db_table . ' SET ' . $db_set . ' WHERE ' . $db_where);
		} else {
			$filename = $readinfo['filename'];  //文件名
			$filepath = $readinfo['filepath'];  //文件路径
		}
		//读取信息
		$read_templates = ($readinfo['istemplates'] && !empty($readinfo['template'])) ? $readinfo['template'] : $typeview['readtemplate'];

		$current = !$typeview['upid'] ? $typeview['tid'] : $typeview['topid'];
		$this->pagetemplate->assign('path', 'article');
		$this->pagetemplate->assign('current', $current);

		if (!empty($readinfo['linkdid'])) {
			$readinfo['linkdid'] = str_replace(',', '/', $readinfo['linkdid']);
		}
		if (!$this->CON['is_html']) {
			return $arrayout;
		}
		$lng = $readinfo['lng'];
		$lng_templates = ($smilan != $this->CON['is_lancode']) ? $smilan : $lng;
		include admin_ROOT . 'datacache/' . $lng . '_pack.php';
		$homelink = $this->get_link('home', '', $smilan);
		$this->pagetemplate->assign('homelink', $homelink);
		$readinfo['buylink'] = $this->get_link('buylink', $readinfo, $lng_templates);
		$readinfo['enqlink'] = $this->get_link('enqlink', $readinfo, $lng_templates);

		if (!empty($readinfo['tags'])) {
			$tagArray = explode(',', $readinfo['tags']);
			$tagArray = array_unique($tagArray);
			$newTagArray = array();
			foreach ($tagArray as $key => $value) {
				$newTagArray[$key]['title'] = $value;
				$newTagArray[$key]['link'] = $this->get_link('taglink', array('key' => $value), $lng_templates);
			}
		}
		$this->pagetemplate->assign('tagarray', $newTagArray);

		$htmdirpath = admin_ROOT . $this->CON['file_htmldir'];

		if ($this->CON['is_alonelng']) {
			$docfilepath = $htmdirpath . $filepath;
		} else {
			$docfilepath = $htmdirpath . $lng_templates . '/' . $filepath;
		}

		$readfilepath = $docfilepath . '/' . $filename . '.' . $this->CON['file_fileex'];

		if ($this->fun->filemode($htmdirpath)) {

			if (!is_dir($docfilepath)) {
				if (!@mkdir($docfilepath, 0777, true)) {
					$arrayout = array('c' => 2, 's' => $docfilepath);
					return $arrayout;
				}
			}
		} else {
			$arrayout = array('c' => 3, 's' => $this->CON['file_htmldir']);
			return $arrayout;
		}
		if (!$this->CON['is_alonelng']) {

			$pathurl = admin_URL . $this->CON['file_htmldir'] . $lng_templates . '/';
		} else {
			$pathurl = admin_URL . $this->CON['file_htmldir'];
		}
		$this->pagetemplate->assign('pathurl', $pathurl);

		$albumarray = $this->get_album_array($did);

		$docarray = array();
		if (!empty($readinfo['value'])) {
			$attarray = unserialize($readinfo['value']);
			unset($readinfo['value']);
			$docarray = is_array($attarray) ? array_merge_recursive($readinfo, $attarray) : $readinfo;
		} else {
			$docarray = $readinfo;
		}

		if (!empty($readinfo['keywords'])) {
			$LANPACK['keyword'] = $readinfo['keywords'];
		}
		if (!empty($readinfo['description'])) {
			$LANPACK['description'] = $readinfo['description'];
		}
		unset($readinfo);

		$templatesDIR = $this->get_templatesdir('article');
		if ($templatesDIR) {

			$filename = $lng . '/' . $templatesDIR . '/' . $read_templates;

			$tpl_file = $this->pagetemplate->tpl_dir . $this->pagetemplate->templatesDIR . $filename . $this->pagetemplate->templatesfileex;

			if (file_exists($tpl_file)) {
				$this->pagetemplate->caching = false;
				$this->pagetemplate->assign('type', $typeview);

				$this->pagetemplate->assign('lng', $lng_templates);

				$this->pagetemplate->assign('lngpack', $LANPACK);
				$this->pagetemplate->assign('read', $docarray);
				$this->pagetemplate->assign('photo', $albumarray['list']);
				$this->pagetemplate->display($filename, $dirname . '_read', true, $readfilepath, $lng_templates);
			} else {

				$arrayout = array('c' => 4, 's' => $tpl_file);
			}
		} else {

			$arrayout = array('c' => 1, 's' => $templatesDIR);
		}
		unset($typeview);
		unset($docarray);
		unset($albumarray);
		unset($LANPACK);
		return $arrayout;
	}

	function enquirymailsend($tmcode, $eid) {
		if (empty($tmcode) || empty($eid)) {
			return false;
		}
		if ($this->CON['is_email'] == 0) return false;

		$mail = $this->get_tempmail_view($tmcode, 3);
		$rsList = $this->get_enquiry($eid);
		$email = $this->CON['admine_mail'];

		$province = $this->get_cityview($rsList['province'], 'cityname');
		$city = $this->get_cityview($rsList['city'], 'cityname');
		$district = $this->get_cityview($rsList['district'], 'cityname');

		$nowtime = $this->fun->formatdate(time(), 3);
		$rsList['addtime'] = $this->fun->formatdate($rsList['addtime'], 3);
		$mailsendcontent = stripslashes(htmlspecialchars_decode($mail['templatecontent']));
		$mailsendtitle = stripslashes(htmlspecialchars_decode($mail['title']));

		require admin_ROOT . adminfile . '/include/inc_replace_mailtemplates.php';
		foreach ($replacemail as $key => $vlaue) {

			$mailsendcontent = str_replace($vlaue['title'], $vlaue['content'], $mailsendcontent);
			$mailsendtitle = str_replace($vlaue['title'], $vlaue['content'], $mailsendtitle);
		}
		$sendtype = $this->mailsend($mailsendtitle, $mailsendcontent, $email);
		return $sendtype;
	}

	function ordermailsend($tmcode, $oid) {
		if (empty($tmcode) || empty($oid)) {
			return false;
		}
		if ($this->CON['is_email'] == 0) return false;

		$mail = $this->get_tempmail_view($tmcode, 3);
		$rsOrder = $this->get_order($oid);
		if ($tmcode == 'orderwarn') {
			$email = $this->CON['admine_mail'];
		} else {
			$email = $rsOrder['email'];
		}

		$userid = $rsOrder['userid'];

		$province = $this->get_cityview($rsOrder['province'], 'cityname');
		$city = $this->get_cityview($rsOrder['city'], 'cityname');
		$district = $this->get_cityview($rsOrder['district'], 'cityname');

		$shippingname = $this->get_shipplug_view($rsOrder['osid'], 'title');

		$payname = $this->get_payplug_view($rsOrder['opid'], 'payname');
		$rsMem = $this->get_member(null, $userid);

		$nowtime = $this->fun->formatdate(time(), 3);
		$rsOrder['addtime'] = $this->fun->formatdate($rsOrder['addtime'], 3);
		$mailsendcontent = stripslashes(htmlspecialchars_decode($mail['templatecontent']));
		$mailsendtitle = stripslashes(htmlspecialchars_decode($mail['title']));

		require admin_ROOT . adminfile . '/include/inc_replace_mailtemplates.php';
		foreach ($replacemail as $key => $vlaue) {

			$mailsendcontent = str_replace($vlaue['title'], $vlaue['content'], $mailsendcontent);
			$mailsendtitle = str_replace($vlaue['title'], $vlaue['content'], $mailsendtitle);
		}
		$sendtype = $this->mailsend($mailsendtitle, $mailsendcontent, $email);
		return $sendtype;
	}

	function formmailsend($tmid, $ftid, $tmcode=null) {
		if ($this->CON['is_email'] == 0) return false;
		if ((empty($tmid) && empty($tmcode)) || empty($ftid)) {
			return false;
		}

		$rsList = $this->get_formcontent($ftid);
		if (empty($tmcode)) {
			if (empty($rsList['email'])) {
				return false;
			}
			$mail = $this->get_templates_view($tmid);
		} else {
			$mail = $this->get_tempmail_view($tmcode, 3);
		}

		$nowtime = $this->fun->formatdate(time(), 3);
		$rsList['addtime'] = $this->fun->formatdate($rsList['addtime'], 3);
		$form = $this->get_form_purview($rsList['fgid']);
		$attrread = $this->get_formatt($rsList['fgid'], false);
		$rsList['formgroupname'] = $form['formgroupname'];

		if (!empty($rsList['attrvalue'])) {
			$value = unserialize($rsList['attrvalue']);
			unset($rsList['attrvalue']);
		}
		if (is_array($value)) {
			$attlist = $this->fun->array_merge($attrread, $value);
			foreach ($attlist as $kye => $value) {
				if ($value['isline'] == 1) {
					continue;
				}
				if ($value['inputtype'] == 'select' || $value['inputtype'] == 'radio' || $value['inputtype'] == 'checkbox') {
					foreach ($value['attrvalue'] as $key2 => $value2) {
						if ($value2['selected'] == 'selected') {
							$mailcontent.=$value['typename'] . ":" . stripslashes($value2['name']) . '<br>';
						}
					}
				} else {
					$mailcontent.=$value['typename'] . ":" . stripslashes($value['attrvalue']) . '<br>';
				}
			}
		}

		require admin_ROOT . adminfile . '/include/inc_replace_mailtemplates.php';
		$mailsendcontent = stripslashes(htmlspecialchars_decode($mail['templatecontent']));
		$mailsendtitle = stripslashes(htmlspecialchars_decode($mail['title']));
		foreach ($replacemail as $key => $vlaue) {

			$mailsendcontent = str_replace($vlaue['title'], $vlaue['content'], $mailsendcontent);
			$mailsendtitle = str_replace($vlaue['title'], $vlaue['content'], $mailsendtitle);
		}
		if (empty($tmcode)) {
			$email = $rsList['email'];
		} else {
			$email = $this->CON['admine_mail'];
		}
		$sendtype = $this->mailsend($mailsendtitle, $mailsendcontent, $email);
	}
	
	function membersmssend($interfacename,$phone,$passord) {
		if ($this->CON['is_sms'] == 0) return false;
		$data = array('mobileNumber'=>$phone,'password'=>$passord,'title'=>$this->CON['sms_text']);
		$this->get_interface_hotelurl($interfacename,$data);
	}

	function membermailsend($tmcode, $userid, $newpassword=null) {
		if ($this->CON['is_email'] == 0) return false;
		if (empty($tmcode) || empty($userid)) {
			return false;
		}

		$mail = $this->get_tempmail_view($tmcode, 3);
		$rsMem = $this->get_member(null, $userid);
		if (empty($rsMem['email'])) {
			return false;
		}
		$nowtime = $this->fun->formatdate(time(), 3);
		$rsMem['addtime'] = $this->fun->formatdate($rsMem['addtime'], 3);
		if ($rsMem['isclass'] == 2) {
			$checklink = $this->get_link('member_check', $rsMem, admin_LNG);
		}
		$rsMem['rankname'] = $this->get_member_purview($rsMem['mcid'], 'rankname');

		require admin_ROOT . adminfile . '/include/inc_replace_mailtemplates.php';
		$mailsendcontent = stripslashes(htmlspecialchars_decode($mail['templatecontent']));
		$mailsendtitle = stripslashes(htmlspecialchars_decode($mail['title']));
		foreach ($replacemail as $key => $vlaue) {

			$mailsendcontent = str_replace($vlaue['title'], $vlaue['content'], $mailsendcontent);
			$mailsendtitle = str_replace($vlaue['title'], $vlaue['content'], $mailsendtitle);
		}
		$email = $rsMem['email'];
		$sendtype = $this->mailsend($mailsendtitle, $mailsendcontent, $email);
	}

	function forumsendmail($tmcode, $bid) {
		if ($this->CON['is_email'] == 0) return false;
		if (empty($tmcode) || empty($bid)) {
			return false;
		}

		$mail = $this->get_tempmail_view($tmcode, 3);
		$rsList = $this->get_bbs($bid);
		if ($rsList['userid'] == 0) {
			return false;
		}
		$rsMem = $this->get_member(null, $rsList['userid']);
		if (empty($rsMem['email'])) {
			return false;
		}
		$nowtime = $this->fun->formatdate(time(), 3);
		$rsList['addtime'] = $this->fun->formatdate($rsList['addtime'], 3);
		$forumlink = $this->get_link('forumread', $rsList, admin_LNG);

		require admin_ROOT . adminfile . '/include/inc_replace_mailtemplates.php';
		$mailsendcontent = stripslashes(htmlspecialchars_decode($mail['templatecontent']));
		$mailsendtitle = stripslashes(htmlspecialchars_decode($mail['title']));
		foreach ($replacemail as $key => $vlaue) {

			$mailsendcontent = str_replace($vlaue['title'], $vlaue['content'], $mailsendcontent);
			$mailsendtitle = str_replace($vlaue['title'], $vlaue['content'], $mailsendtitle);
		}
		$sendtype = $this->mailsend($mailsendtitle, $mailsendcontent, $rsMem['email']);
	}
	/**
	 * 邮件发送
	 */
	function mailsend($subject, $bodycontent, $email) {
		if ($this->CON['is_email'] == 0) return false;
		if (empty($subject) || empty($email) || empty($bodycontent)) {
			return false;
		}

		include_once admin_ROOT . 'public/mail/class.phpmailer.php';
		$mail = new PHPMailer();

		$mail->From = $this->CON['admine_mail'];

		$mail->FromName = $this->CON['order_companyname'];

		$mail->Username = $this->CON['smtp_username'];

		$mail->Password = $this->CON['smtp_password'];

		$mail->Host = $this->CON['smtp_server'];

		$mail->CharSet = "UTF-8";

		$mail->SMTPAuth = true;

		$mail->Mailer = "smtp";

		$mail->Subject = $subject;

		$mail->MsgHTML($bodycontent);

		$mail->AddAddress($email);
		if (!$mail->Send()) {
			return false;
		} else {
			return true;
		}
	}
	
	function get_hotel_fliterurl($read=array()) {
		$url = "";
		$lng = $this->CON['is_lancode'];
		if($read['includeGuaranteeable']==1 && $read['includeNonBooking']==1 && empty($read['keyword']) && empty($read['landmark']) && ($read['categories'] == '') && empty($read['broadbandService']) && empty($read['lowestPrice']) && empty($read['highestPrice']) && empty($read['chainBrands'])) {
			//hotel_district hotel_business
			if($read['districtCode'] !='' && $read['businessZoneCode'] == '') {
				$url = $this->get_link('hotel_district',$read,$lng);
			} else if($read['districtCode'] =='' && $read['businessZoneCode'] != '') {
				$url = $this->get_link('hotel_business',$read,$lng);
			} else if($read['districtCode'] !='' && $read['businessZoneCode'] != '') {
				$url = $this->get_link('hotel_district',$read,$lng);
			} else if($read['districtCode'] =='' && $read['businessZoneCode'] == '') {
				$url = $this->get_link('hotel_search',$read,$lng);
			} else {
				$url = $this->get_link('hotel_searchlist',$read,$lng);
			}
		} else if($read['includeGuaranteeable']==1 && $read['includeNonBooking']==1 && empty($read['keyword']) && empty($read['landmark']) && ($read['categories'] == '') && empty($read['broadbandService']) && empty($read['lowestPrice']) && empty($read['highestPrice'])) {
			$url = $this->get_link('hotel_chainlist',$read,$lng);
		} else {
			$url = $this->get_link('hotel_searchlist',$read,$lng);
		}
		return $url;
	}

	/**
	 * 重写URL
	 * @param <string> $module	模型
	 * @param <array> $read		导入的数据
	 * @param <string> $lng_temp	当前模板语言
	 */
	function get_link($module=null, $read=array(), $lng_temp='') {
		$lng_temp = $this->CON['is_lancode'];
		if (empty($module)) return false;

		$is_html = $this->CON['is_html'];

		$is_rewrite = $this->CON['is_rewrite'];

		$file_fileex = $this->CON['file_fileex'];

		$file_htmldir = $this->CON['file_htmldir'];

		$entrance_file = $this->CON['entrance_file'];

		$http_pathtype = $this->CON['http_pathtype'];

		$file_sitemapdir = $this->CON['file_sitemapdir'];

		$lngurl = $this->get_lan_view($read['lng'], 'url');
		if ($this->CON['is_alonelng'] && !$is_html) {
			$pathdir = null;
		} else {
			$pathdir = ($this->CON['home_lng'] != $lng_temp) ? $file_htmldir . $lng_temp . '/' : null;
		}

		$typeclass = 1;
		switch ($module) {
			case 'home':
				if ($is_html) {
					$link = $this->CON['is_alonelng'] ? $file_htmldir : $file_htmldir . $lng_temp;
				} else {
					$link = $pathdir;
				}
				break;
			case 'lng':
				if ($is_html) {
					$link = empty($read['url']) ? ($this->CON['is_alonelng'] ? $this->CON['file_htmldir'] : $this->CON['file_htmldir'] . $read['lng']) : $read['url'];
				} else {
					$link = $pathdir;
				}
				break;

			case 'type':
				if ($read['styleid'] == 3) {

					$typeclass = 0;
					$link = $read['typeurl'];
				} else {
					if ($is_html && $read['pageclass']) {

						$link = $this->CON['is_alonelng'] ? $file_htmldir . $read['dirpath'] . '/' : $file_htmldir . $lng_temp . '/' . $read['dirpath'] . '/';
					} else {
						if ($is_rewrite) {

							$link = $pathdir . 'article_list_' . $read['tid'] . '.' . $file_fileex;
						} else {
							$link = $pathdir . "index.php?ac=article&at=list&tid=" . $read['tid'];
						}
					}
				}
				break;

			case 'typerss':
				if ($read['styleid'] == 3) {
					$link = null;
				} else {
					$link = $file_sitemapdir . 'rss_' . $read['dirname'] . '.xml';
				}
				break;

			case 'subtype':
				if ($is_html) {

					$link = $this->CON['is_alonelng'] ? $file_htmldir . $read['dirpath'] . '/' : $file_htmldir . $lng_temp . '/' . $read['dirpath'] . '/';
				} else {
					if ($is_rewrite) {

						$link = $pathdir . 'special_list_' . $read['sid'] . '.' . $file_fileex;
					} else {
						$link = $pathdir . "index.php?ac=special&at=list&sid=" . $read['sid'];
					}
				}
				break;

			case 'form':
				if ($is_rewrite) {
					$link = $pathdir . 'form_list_' . $read['fgid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=form&at=list&fgid=" . $read['fgid'];
				}
				break;

			case 'acform':
				if ($is_rewrite) {
					$link = $pathdir . 'form_save.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=form&at=save";
				}
				break;
			case 'friend':
				if ($is_rewrite) {
					$link = $pathdir . 'friendlink.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=public&at=friend";
				}
				break;
			case 'hotel_comment':
				if(!empty($read['hid']) || !empty($read['hname']) || !empty($read['username']) || !empty($read['uid']) || !empty($read['cityid'])) {
					//if ($is_rewrite) {
					//	$link = $pathdir . 'article/comment_'. $read['hid'] . "_"  . $read['hname'] . "_" . $read['cityid'] ."." . $file_fileex;
					//} else {
						$link = $pathdir . "index.php?ac=article&at=comment&hid=".$read['hid']."&hname=".urlencode($read['hname'])."&cityid=".$read['cityid']."&username=".urlencode($read['username'])."&uid=".$read['uid']."&page=".$read['page'];
					//}
				} else {
					if ($is_rewrite) {
						if(!$read['page'] || $read['page']==1) {
							$link = $pathdir . 'article/comment.' . $file_fileex;
						} else {
							$link = $pathdir . 'article/comment_'.$read['page'].'.' . $file_fileex;
						}
					} else {
						if($read['page'] == 1) {
							$link = $pathdir . "index.php?ac=article&at=comment";
						} else {
							$link = $pathdir . "index.php?ac=article&at=comment&page=".$read['page'];
						}
					}
				}
				break;
			case 'comment_save':
				if ($is_rewrite) {
					$link = $pathdir . 'article/commentsave.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=article&at=commentsave";
				}
				break;
			case 'hotel_city':
				$link1 = $pathdir."hotel/city";
				$link2 = $pathdir."index.php?ac=hotel&at=hotelsearch";

				$link1 .= '_'.$read['cityCode'];
				if($read['cityCode']) {
					$link2 .= "&cityid=".$read['cityCode'];
				}
				if($read['checkInDate'] && $read['checkOutDate']) {
					$t1 = strtotime(date('Y-m-d'))+24*3600;
					$t2 = strtotime(date('Y-m-d'))+24*3600*3;
					if((strtotime($read['checkInDate']) != $t1) || (strtotime($read['checkOutDate']) != $t2)) {
						$link1 .= '_'.$read['checkInDate'];
						$link2 .= "&tm1=".$read['checkInDate'];
						$link1 .= '_'.$read['checkOutDate'];
						$link2 .= "&tm2=".$read['checkOutDate'];
					}
				}
				if ($is_rewrite) {
					$link = $link1 . '.'. $file_fileex;
				} else {
					$link = $link2;
				}
				break;
			case 'hotel_search':
				$link1 = $pathdir."hotel/search";
				$link2 = $pathdir."index.php?ac=hotel&at=hotelsearch";

				$link1 .= '_'.$read['cityCode'];
				if($read['cityCode']) {
					$link2 .= "&cityid=".$read['cityCode'];
				}
				if(!$read['simple']) {
					$read['simple'] = "0";
				}
				$link1 .= '_'.$read['simple'];
				$link2 .= "&simple=".$read['simple'];
				$link1 .= '_'.$read['pageIndex'];
				$link2 .= "&pageIndex=".$read['pageIndex'];
				if($read['checkInDate'] && $read['checkOutDate']) {
					$t1 = strtotime(date('Y-m-d'))+24*3600;
					$t2 = strtotime(date('Y-m-d'))+24*3600*3;
					if((strtotime($read['checkInDate']) != $t1) || (strtotime($read['checkOutDate']) != $t2)) {
						$link1 .= '_'.$read['checkInDate'];
						$link2 .= "&tm1=".$read['checkInDate'];
						$link1 .= '_'.$read['checkOutDate'];
						$link2 .= "&tm2=".$read['checkOutDate'];
					}
				}
				if ($is_rewrite) {
					$link = $link1 . '.'. $file_fileex;
				} else {
					$link = $link2;
				}
				break;
			case 'hotel_nearby':
				$link1 = $pathdir."hotel/nearby";
				$link2 = $pathdir."index.php?ac=hotel&at=hotelsearch";
				$link1 .= '_'.$read['cityCode'];
				$link2 .= "&cityid=".$read['cityCode'];
				$link1 .= '_'.urlencode($read['landmark']);
				$link2 .= "&hotelnearby=".urlencode($read['landmark']);
				$link1 .= '_'.$read['lng'];
				$link2 .= "&lng=".$read['lng'];
				$link1 .= '_'.$read['lat'];
				$link2 .= "&lat=".$read['lat'];
				if ($is_rewrite) {
					$link = $link1 . '.'. $file_fileex;
				} else {
					$link = $link2;
				}
				break;
			case 'hotel_chain':
				$link1 .= $pathdir."hotel/chain";
				$link2 .= $pathdir."index.php?ac=hotel&at=hotelsearch";

				$link1 .= '_'.$read['cityCode'];
				if($read['cityCode']) {
					$link2 .= "&cityid=".$read['cityCode'];
				}
				$link1 .= '_'.$read['chainBrands'];
				if($read['chainBrands']) {
					$link2 .= "&chainBrands=".$read['chainBrands'];
				}
				if($read['checkInDate'] && $read['checkOutDate']) {
					$t1 = strtotime(date('Y-m-d'))+24*3600;
					$t2 = strtotime(date('Y-m-d'))+24*3600*3;
					if((strtotime($read['checkInDate']) != $t1) || (strtotime($read['checkOutDate']) != $t2)) {
						$link1 .= '_'.$read['checkInDate'];
						$link2 .= "&tm1=".$read['checkInDate'];
						$link1 .= '_'.$read['checkOutDate'];
						$link2 .= "&tm2=".$read['checkOutDate'];
					}
				}
				
				if ($is_rewrite) {
					$link = $link1 . '.'. $file_fileex;
				} else {
					$link = $link2;
				}
				break;
			case 'hotel_chainlist':
				$link1 .= $pathdir."hotel/chain";
				$link2 .= $pathdir."index.php?ac=hotel&at=hotelsearch";

				$link1 .= '_'.$read['cityCode'];
				if($read['cityCode']) {
					$link2 .= "&cityid=".$read['cityCode'];
				}
				$link1 .= '_'.$read['districtCode'];
				if($read['districtCode']) {
					$link2 .= "&districtCode=".$read['districtCode'];
				}
				$link1 .= '_'.$read['businessZoneCode'];
				if($read['businessZoneCode']) {
					$link2 .= "&businessZoneCode=".$read['businessZoneCode'];
				}
				$link1 .= '_'.$read['chainBrands'];
				if($read['chainBrands']) {
					$link2 .= "&chainBrands=".$read['chainBrands'];
				}
				if($read['checkInDate'] && $read['checkOutDate']) {
					$t1 = strtotime(date('Y-m-d'))+24*3600;
					$t2 = strtotime(date('Y-m-d'))+24*3600*3;
					if((strtotime($read['checkInDate']) != $t1) || (strtotime($read['checkOutDate']) != $t2)) {  //不是默认时间
						$link1 .= '_'.$read['checkInDate'];
						$link2 .= "&tm1=".$read['checkInDate'];
						$link1 .= '_'.$read['checkOutDate'];
						$link2 .= "&tm2=".$read['checkOutDate'];
					} else {  //如果是默认时间
						$link1 .= "__";
					}
				}
				$link1 .= '_'.$read['simple'];
				if($read['simple']) {
					$link2 .= "&simple=".$read['simple'];
				}
				$link1 .= '_'.$read['pageIndex'];
				if($read['pageIndex']) {
					$link2 .= "&pageIndex=".$read['pageIndex'];
				}
				if ($is_rewrite) {
					$link = $link1 . '.'. $file_fileex;
				} else {
					$link = $link2;
				}
				break;
			case 'hotel_district':
				$link1 = $pathdir."hotel/district";
				$link2 = $pathdir."index.php?ac=hotel&at=hotelsearch";

				$link1 .= '_'.$read['cityCode'];
				$link2 .= "&cityid=".$read['cityCode'];
				$link1 .= '_'.$read['districtCode'];
				if($read['districtCode']) {
					$link2 .= "&districtCode=".$read['districtCode'];
				}
				$link1 .= '_'.$read['businessZoneCode'];
				if($read['businessZoneCode']) {
					$link2 .= "&businessZoneCode=".$read['businessZoneCode'];
				}
				if(!$read['simple']) {
					$read['simple'] = "0";
				}
				$link1 .= '_'.$read['simple'];
				$link2 .= "&simple=".$read['simple'];
				$link1 .= '_'.$read['pageIndex'];
				$link2 .= "&pageIndex=".$read['pageIndex'];
				$t1 = strtotime(date('Y-m-d'))+24*3600;
				$t2 = strtotime(date('Y-m-d'))+24*3600*3;
				if((strtotime($read['checkInDate']) != $t1) || (strtotime($read['checkOutDate']) != $t2)) {
					$link1 .= '_'.$read['checkInDate'];
					$link2 .= "&tm1=".$read['checkInDate'];
					$link1 .= '_'.$read['checkOutDate'];
					$link2 .= "&tm2=".$read['checkOutDate'];
				}
				
				if ($is_rewrite) {
					$link = $link1 . '.'. $file_fileex;
				} else {
					$link = $link2;
				}
				break;
			case 'hotel_business':
				$link1 .= $pathdir."hotel/business";
				$link2 .= $pathdir."index.php?ac=hotel&at=hotelsearch";
				$link1 .= '_'.$read['cityCode'];
				$link2 .= "&cityid=".$read['cityCode'];
				$link1 .= '_'.$read['districtCode'];
				if($read['districtCode']) {
					$link2 .= "&districtCode=".$read['districtCode'];
				}
				$link1 .= '_'.$read['businessZoneCode'];
				$link2 .= "&businessZoneCode=".$read['businessZoneCode'];
				if(!$read['simple']) {
					$read['simple'] = "0";
				}
				$link1 .= '_'.$read['simple'];
				$link2 .= "&simple=".$read['simple'];
				$link1 .= '_'.$read['pageIndex'];
				$link2 .= "&pageIndex=".$read['pageIndex'];
				$t1 = strtotime(date('Y-m-d'))+24*3600;
				$t2 = strtotime(date('Y-m-d'))+24*3600*3;
				if($read['checkInDate'] && $read['checkOutDate']) {
					if((strtotime($read['checkInDate']) != $t1) || (strtotime($read['checkOutDate']) != $t2)) {
						$link1 .= '_'.$read['checkInDate'];
						$link2 .= "&tm1=".$read['checkInDate'];
						$link1 .= '_'.$read['checkOutDate'];
						$link2 .= "&tm2=".$read['checkOutDate'];
					}
				}
				
				if ($is_rewrite) {
					$link = $link1 . '.'. $file_fileex;
				} else {
					$link = $link2;
				}
				break;
			case 'hotel_searchlist':
				if($read['includeGuaranteeable']==1) {
					$read['includeGuaranteeable'] = 0;
				} else {
					$read['includeGuaranteeable'] = 1;
				}
				if($read['includeNonBooking']==1) {
					$read['includeNonBooking'] = 0;
				} else {
					$read['includeNonBooking'] = 1;
				}
				$read['cityname'] = urlencode($read['cityname']);
				$read['keyword'] = urlencode($read['keyword']);
				$read['landmark'] = urlencode($read['landmark']);

				$link1 .= $pathdir."hotel/search";
				$link2 .= $pathdir."index.php?ac=hotel&at=hotelsearch";

				$link1 .= '_'.$read['cityCode'];
				if($read['cityCode']) {
					$link2 .= "&cityid=".$read['cityCode'];
				}
				$link1 .= '_'.$read['districtCode'];
				if($read['districtCode']) {
					$link2 .= "&districtCode=".$read['districtCode'];
				}
				$link1 .= '_'.$read['businessZoneCode'];
				if($read['businessZoneCode']) {
					$link2 .= "&businessZoneCode=".$read['businessZoneCode'];
				}
				$link1 .= '_'.$read['categories'];
				if($read['categories'] != '') {
					$link2 .= "&hotelstar=".$read['categories'];
				}
				$link1 .= '_'.$read['cityname'];
				if($read['cityname']) {
					$link2 .= "&cityname=".$read['cityname'];
				}
				$link1 .= '_'.$read['keyword'];
				if($read['keyword']) {
					$link2 .= "&hotelname=".$read['keyword'];
				}
				$link1 .= '_'.$read['landmark'];
				if($read['landmark']) {
					$link2 .= "&hotelnearby=".$read['landmark'];
				}
				$link1 .= '_'.$read['lng'];
				if($read['lng']) {
					$link2 .= "&lng=".$read['lng'];
				}
				$link1 .= '_'.$read['lat'];
				if($read['lat']) {
					$link2 .= "&lat=".$read['lat'];
				}
				$link1 .= '_'.$read['broadbandService'];
				if($read['broadbandService']) {
					$link2 .= "&broadbandService=".$read['broadbandService'];
				}
				$link1 .= '_'.$read['lowestPrice'];
				if($read['lowestPrice']) {
					$link2 .= "&lowestPrice=".$read['lowestPrice'];
				}
				$link1 .= '_'.$read['highestPrice'];
				if($read['highestPrice']) {
					$link2 .= "&highestPrice=".$read['highestPrice'];
				}
				$link1 .= '_'.$read['checkInDate'];
				if($read['checkInDate']) {
					$link2 .= "&tm1=".$read['checkInDate'];
				}
				$link1 .= '_'.$read['checkOutDate'];
				if($read['checkOutDate']) {
					$link2 .= "&tm2=".$read['checkOutDate'];
				}
				$link1 .= '_'.$read['sortType'];
				if($read['sortType']) {
					$link2 .= "&sortType=".$read['sortType'];
				}
				$link1 .= '_'.$read['pageIndex'];
				if($read['pageIndex'] > 1) {
					$link2 .= "&pageIndex=".$read['pageIndex'];
				}
				$link1 .= '_'.$read['includeNonBooking'];
				if($read['includeNonBooking']==1) {
					$link2 .= "&includeNonBooking=".$read['includeNonBooking'];
				}
				$link1 .= '_'.$read['includeGuaranteeable'];
				if($read['includeGuaranteeable']==1) {
					$link2 .= "&includeGuaranteeable=".$read['includeGuaranteeable'];
				}
				$link1 .= '_'.$read['chainBrands'];
				if($read['chainBrands']) {
					$link2 .= "&chainBrands=".$read['chainBrands'];
				}
				$link1 .= '_'.$read['simple'];
				if($read['simple']) {
					$link2 .= "&simple=".$read['simple'];
				}
				//$link = '';
				//if ($is_rewrite) {
				//	$link .= $link1 . '.'. $file_fileex;
				//} else {
					$link = $link2;
				//}
				break;
			case 'doc':
				if ($read['islink'] == 1) {
					$typeclass = 0;
					$link = $read['link'];
				} else {
					if ($is_html && $read['ishtml']) {
						$link = $this->CON['is_alonelng'] ? $file_htmldir . $read['filepath'] . '/' . $read['filename'] . '.' . $file_fileex : $file_htmldir . $lng_temp . '/' . $read['filepath'] . '/' . $read['filename'] . '.' . $file_fileex;
					} else {
						if ($is_rewrite) {
							$link = $pathdir . 'article_read_' . $read['did'] . '.' . $file_fileex;
						} else {
							$link = $pathdir . "index.php?ac=article&at=read&did=" . $read['did'];
						}
					}
				}
				break;

			case 'seccode':
				$link = "public/seccode.php";
				break;

			case 'memberlogin':
				if ($is_rewrite) {
					$link = $pathdir . 'member_login.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=member&at=login";
				}
				break;

			case 'member_check':
				$username = $this->fun->eccode($read['username'], 'ENCODE', db_pscode);
				$password = $this->fun->eccode($read['password'], 'ENCODE', db_pscode);
				$link = "index.php?ac=member&at=emailmarketing&key=" . $username . '&code=' . $password;
				break;

			case 'member_mailsend':
				$username = $this->fun->eccode($read['username'], 'ENCODE', db_pscode);
				$password = $this->fun->eccode($read['password'], 'ENCODE', db_pscode);
				$link = $pathdir . "index.php?ac=member&at=mailsend&key=" . $username . '&code=' . $password;
				break;

			case 'member_ucenter':
				$username = $this->fun->eccode($read['username'], 'ENCODE', db_pscode);
				$password = $this->fun->eccode($read['password'], 'ENCODE', db_pscode);
				$link = $pathdir . "index.php?ac=member&at=uccheckuser&key=" . $username . '&code=' . $password;
				break;

			case 'order':
				if ($is_rewrite) {
					$link = $pathdir . 'order_list.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=order&at=list";
				}
				break;

			case 'orderread':
				if ($is_rewrite) {
					$link = $pathdir . 'ordermain_read_' . $read['oid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=ordermain&at=read&oid=" . $read['oid'];
				}
				break;

			case 'orderdel':
				if ($is_rewrite) {
					$link = $pathdir . 'ordermain_del_' . $read['oid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=ordermain&at=del&oid=" . $read['oid'];
				}
				break;

			case 'buylink':
				if ($is_rewrite) {
					$link = $pathdir . 'order_buy_' . $read['did'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=order&at=buy&did=" . $read['did'];
				}
				break;

			case 'buydel':
				if ($is_rewrite) {
					$link = $pathdir . 'order_delcart_' . $read['did'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=order&at=delcart&did=" . $read['did'];
				}
				break;

			case 'enqlink':
				if ($is_rewrite) {
					$link = $pathdir . 'enquiry_into_' . $read['did'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=enquiry&at=into&did=" . $read['did'];
				}
				break;

			case 'enquiry':
				if ($is_rewrite) {
					$link = $pathdir . 'enquiry_list.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=enquiry&at=list";
				}
				break;

			case 'enqdel':
				if ($is_rewrite) {
					$link = $pathdir . 'enquiry_delenq_' . $read['did'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=enquiry&at=delenq&did=" . $read['did'];
				}
				break;

			case 'enquiryread':
				if ($is_rewrite) {
					$link = $pathdir . 'enquirymain_read_' . $read['eid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=enquirymain&at=read&eid=" . $read['eid'];
				}
				break;

			case 'enquirydel':
				if ($is_rewrite) {
					$link = $pathdir . 'enquirymain_del_' . $read['eid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=enquirymain&at=del&eid=" . $read['eid'];
				}
				break;

			case 'forum':
				if ($is_rewrite) {
					$link = $pathdir . 'forum_home.' . $file_fileex;  //$file_fileex后缀
				} else {
					$link = $pathdir . "index.php?ac=forum&at=home";
				}
				break;

			case 'forumlist':
				if ($is_rewrite) {
					$link = $pathdir . 'forum_list_' . $read['btid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=forum&at=list&btid=" . $read['btid'];
				}
				break;

			case 'forumadd':
				if ($is_rewrite) {
					$link = $pathdir . 'forum_add_' . $read['btid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=forum&at=add&btid=" . $read['btid'];
				}
				break;

			case 'forumread':
				if ($is_rewrite) {
					$link = $pathdir . 'forum_read_' . $read['bid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=forum&at=read&bid=" . $read['bid'];
				}
				break;

			case 'forumedit':
				if ($is_rewrite) {
					$link = $pathdir . 'forummain_edit_' . $read['bid'] . '.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=forummain&at=edit&bid=" . $read['bid'];
				}
				break;

			case 'paybackurl':
				$link = $pathdir . "index.php?ac=respond&at=payok&codesn=" . $read['codesn'] . "&code=" . $read['code'] . "&ordersn=" . $read['ordersn'] . "&oid=" . $read['oid'];
				break;
			case 'hotel_orderlist': //订单列表
				//if ($is_rewrite) {
				//	$link = $pathdir . "hotelorder_{#hid#}_{#rid#}_{#pid#}_{#tm1#}_{#tm2#}.".$file_fileex;
				//} else {
					$link = $pathdir . "index.php?ac=order&at=hotelorder&hid={#hid#}&rid={#rid#}&pid={#pid#}&tm1={#tm1#}&tm2={#tm2#}";
				//}
				break;
			case 'hotel_order':
				//if ($is_rewrite) {
				//	$link = $pathdir . "hotel/order.".$file_fileex;
				//} else {
					$link = $pathdir . "index.php?ac=order&at=hotelorder";
				//}
				break;
			case 'hotelshow':
				if ($is_rewrite) {
					$link = $pathdir . "hotel/".$read['hid'].".".$file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=hotel&at=hotelshow&hid=".$read['hid'];
				}
				break;
			case 'hotelmap':
				if ($is_rewrite) {
					$link = $pathdir . "hotel/map.".$file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=hotel&at=hotelmap";
				}
				break;
			case 'hotelchain':
				if ($is_rewrite) {
					$link = $pathdir . "hotel/chain" . "." .$file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=hotel&at=hotelchain";
				}
				break;
			case 'contrast':
				if ($is_rewrite) {
					$link = $pathdir . "hotel/contrast_{#hid#}." . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=hotel&at=contrast&hid={#hid#}";
				}
				break;
			case 'search':
				if ($is_rewrite) {
					$link = $pathdir . 'search_list.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=search&at=list";
				}
				break;

			case 'bbssearch':
				if ($is_rewrite) {
					$link = $pathdir . 'bbssearch_list.' . $file_fileex;
				} else {
					$link = $pathdir . "index.php?ac=bbssearch&at=list";
				}
				break;
			case 'taglink':
				$link = $pathdir . "index.php?ac=search&at=taglist&tagkey=" . urlencode($read['key']);
				break;
		}
		if($typeclass) {
			$link = $this->CON['domain'].$link;
		}
		//$link = ($http_pathtype && $typeclass) ? !empty($lngurl) ? $lngurl . '/' . $link : admin_URL . $link : $link;
		return $link;
	}

	function memberlink($read=array(), $lng_temp='') {
		$lng_temp = empty($lng_temp) ? $this->CON['is_lancode'] : $lng_temp;

		$is_html = $this->CON['is_html'];

		$is_rewrite = $this->CON['is_rewrite'];

		$file_fileex = $this->CON['file_fileex'];

		$file_fileex = $this->CON['file_fileex'];

		$file_htmldir = $this->CON['file_htmldir'];

		$entrance_file = $this->CON['entrance_file'];

		$http_pathtype = $this->CON['http_pathtype'];

		$lngurl = $this->get_lan_view($read['lng'], 'url');
		if ($this->CON['is_alonelng']) {
			$pathdir = null;
		} else {
			$pathdir = ($this->CON['home_lng'] != $lng_temp) ? $file_htmldir . $lng_temp . '/' : null;
		}

		if ($is_rewrite) {
			$link['login'] = 'member_login.' . $file_fileex;
			$link['logindb'] = 'member_logindb.' . $file_fileex;
			$link['reg'] = 'member_reg.' . $file_fileex;
			$link['regsave'] = 'member_regsave.' . $file_fileex;
			$link['lostpasswd'] = 'member_lostpasswd.' . $file_fileex;
			$link['lostpasswdsave'] = 'member_lostpasswdsave.' . $file_fileex;
			$link['quit'] = 'member_quit.' . $file_fileex;
			$link['checkusername'] = 'public_checkusername.' . $file_fileex;
			$link['center'] = 'membermain_center.' . $file_fileex;
			$link['memedit_info'] = 'membermain_editinfo.' . $file_fileex;
			$link['memedit_password'] = 'membermain_editpassword.' . $file_fileex;
			$link['memedit_email'] = 'membermain_editemail.' . $file_fileex;

			$link['membersave'] = 'membermain_save.' . $file_fileex;

			$link['orderlist'] = 'ordermain_list_1.' . $file_fileex;

			$link['buylist'] = 'order_list.' . $file_fileex;

			$link['clearcart'] = 'order_clearcart.' . $file_fileex;

			$link['orderupdae'] = 'order_orderupdae.' . $file_fileex;

			$link['orderpay'] = 'order_orderpay.' . $file_fileex;

			$link['ordersave'] = 'order_ordersave.' . $file_fileex;

			$link['ordereditsave'] = 'ordermain_ordereditsave.' . $file_fileex;

			$link['forumlist'] = 'forummain_list_1.' . $file_fileex;

			$link['forumeditsave'] = 'forummain_save.' . $file_fileex;

			$link['forumsave'] = 'forum_save.' . $file_fileex;

			$link['cleargoods'] = 'enquiry_cleargoods.' . $file_fileex;

			$link['enquirysave'] = 'enquiry_enquirysave.' . $file_fileex;

			$link['enquirylist'] = 'enquirymain_list_1.' . $file_fileex;

			$link['enquiryeditsave'] = 'enquirymain_enquiryeditsave.' . $file_fileex;
		} else {
			$link['login'] = "index.php?ac=member&at=login";
			$link['logindb'] = "index.php?ac=member&at=logindb";
			$link['reg'] = "index.php?ac=member&at=reg";
			$link['regsave'] = "index.php?ac=member&at=regsave";
			$link['lostpasswd'] = "index.php?ac=member&at=lostpasswd";
			$link['lostpasswdsave'] = "index.php?ac=member&at=lostpasswdsave";
			$link['quit'] = "index.php?ac=member&at=quit";
			$link['checkusername'] = "index.php?ac=public&at=checkusername";
			$link['center'] = "index.php?ac=membermain&at=center";
			$link['memedit_info'] = "index.php?ac=membermain&at=editinfo";
			$link['memedit_password'] = "index.php?ac=membermain&at=editpassword";
			$link['memedit_email'] = "index.php?ac=membermain&at=editemail";
			$link['membersave'] = "index.php?ac=membermain&at=save";
			$link['orderlist'] = "index.php?ac=ordermain&at=list&al=1";
			$link['buylist'] = "index.php?ac=order&at=list";
			$link['clearcart'] = "index.php?ac=order&at=clearcart";
			$link['orderupdae'] = "index.php?ac=order&at=orderupdae";
			$link['orderpay'] = "index.php?ac=order&at=orderpay";
			$link['ordersave'] = "index.php?ac=order&at=ordersave";
			$link['ordereditsave'] = "index.php?ac=ordermain&at=ordereditsave";
			$link['forumlist'] = "index.php?ac=forummain&at=list";
			$link['forumeditsave'] = "index.php?ac=forummain&at=save";
			$link['forumsave'] = "index.php?ac=forum&at=save";
			$link['cleargoods'] = "index.php?ac=enquiry&at=cleargoods";
			$link['enquirysave'] = "index.php?ac=enquiry&at=enquirysave";
			$link['enquirylist'] = "index.php?ac=enquirymain&at=list&al=1";
			$link['enquiryeditsave'] = "index.php?ac=enquirymain&at=enquiryeditsave";
		}
		foreach ($link as $key => $value) {
			$link[$key] = $this->CON['domain'].$value;
			//$link[$key] = ($http_pathtype) ? !empty($lngurl) ? $lngurl . '/' . $value : admin_URL . $pathdir . $value : $pathdir . $value;
		}
		return $link;
	}

}
?>