<?php
//酒店担保判断类
class garanteeable {
	public $garanteeableMessage = '';
	
	function checkGaranteeableByArray($rules, $bookingDate, $checkInDate, $arriveTime, $roomCount, $firstNightFees, $fullyFees) { 
		$res = false;
	    // 担保规则为空时无需担保 
	    if ($rules == '' || count($rules) == 0) {
	    	$res =  false; 
	    } else {
		    $this->garanteeableMessage = '';
		    // 取得数组长度 
		    $ruleLength = count($rules); 
		    // 遍历每条规则 
		    for ($index = 0; $index < $ruleLength; $index++) 
		    { 
		        $rule = $rules[$index]; $check = false;
		        // 如果遇到符合条件的担保规则就直接返回 
		        $check = $this->checkGaranteeable($rule, $bookingDate, $checkInDate, $arriveTime, $roomCount, $firstNightFees, $fullyFees);
		        if($check) {
		        	$res = true;
		        	break;
		        }
		    }
	    }
	    return $res;
	}
	
	function checkGaranteeable($rule, $bookingDate, $checkInDate, $arriveTime, $roomCount, $firstNightFees, $fullyFees) {
		$date = '2000-1-1'; $re = false;
		$arriveTime      = strtotime($date." ".$arriveTime);
		$ArriveStartTime = strtotime($date." ".date('H:i',$rule['ArriveStartTime']));
		$ArriveEndTime   = strtotime($date." ".date('H:i',$rule['ArriveEndTime']));
		if ($rule['IsTomorrow']) $ArriveEndTime =strtotime('2000-1-2'); 
		$this->garanteeableMessage = '';
		$refDate = 0;
		switch ($rule['DateReference']) 
	    { 
	        case 1: // 入住日期 
	            $refDate = $checkInDate; 
	            break; 
	  
	        case 2: // 在店日期（暂时以入住日期方式处理） 
	            $refDate = $checkInDate; 
	            break; 
	  
	        case 3: // 预订日期 
	            $refDate = $bookingDate; 
	            break; 
	  
	        default: 
	            return false; 
	    }
		$weekSets = implode(",", $rule['WeekSet']);
		if ($refDate >= $rule['ActivationDate'] && $refDate <= $rule['ExpirationDate'] && strpos($weekSets,date('w',$refDate)) > -1) {
			$flag = false; 
			$this->garanteeableMessage = '担保条件：在' . date('Y-m-d',$rule['ActivationDate']) . '至' . date('Y-m-d',$rule['ExpirationDate']) . '期间入住，'; 
			// 时间担保检查 
	        if ($rule['IsArriveTimeVouch']) { 
	            if ($arriveTime > $ArriveStartTime && $arriveTime <= $ArriveEndTime) { 
	                $flag = true; 
	  
	                $this->garanteeableMessage .= '于' . date('H:i',$rule['ArriveStartTime']) . '至' . date('H:i',$rule['ArriveEndTime']) . '到店，'; 
	            }
	        } else {
	        	$flag = true; 
	        }
			// 房量担保检查 
	        if ($rule['IsRoomCountVouch']) { 
	        	if($roomCount >= $rule['RoomCount']) {
	            	$flag = true; 
	            	$this->garanteeableMessage .= '如果预订房量超过' . $rule['RoomCount'] . '间，'; 
	        	}
	        }
	        if ($flag) 
	        { 
	            $this->garanteeableMessage .= '需要您提供信用卡担保。'; 
	            if ($rule['IsChange']) { 
	                switch ($rule['ChangeRule']) { 
	                    case 2: 
	                        $this->garanteeableMessage .= '客人在' . date('Y-m-d H:i',$rule['ChangeRuleDate']) . '之前可以变更取消，之后无法变更取消。'; 
	                        break; 
	  
	                    case 3: 
	                        if ($rule['ChangeRuleHours'] == 24) $this->garanteeableMessage .= '客人最早到店1天前可以变更取消，之后无法变更取消。'; 
	                        else $this->garanteeableMessage .= '客人最早到店' . $rule['ChangeRuleHours'] . '小时前可以变更取消，之后无法变更取消。'; 
	                        break; 
	  
	                    case 4: 
	                        $this->garanteeableMessage .= '客人在到店日期的' . (24-$rule['ChangeRuleHours']) . ':00之前可以变更取消，之后无法变更取消。'; 
	                        break; 
	  
	                    default: 
	                        $this->garanteeableMessage .= '订单提交后不允许变更取消。'; 
	                        break; 
	                } 
	            } else {
	            	$this->garanteeableMessage .= '订单提交后不允许变更取消。';
	            }
	            
	            // 押金计算 
	            switch ($rule['Deposit']) { 
	                case 1: 
	                    $this->garanteeableMessage .= '如未入住，将扣除第一晚房费(' . $firstNightFees . '元)作为违约金。'; 
	                    break; 
	  
	                case 2: 
	                    $this->garanteeableMessage .= '如未入住，将扣除全额房费(' . $fullyFees . '元)作为违约金。'; 
	                    break; 
	            }
	            $re = true;
	        }
		}
		return $re;
	}
	
}
?>