/*********************************************************
请注意：
	本示例中的日期格式化使用的是 Mootools 库。
	参考地址：http://mootools.net/docs/more/Types/Date#Date:format
**********************************************************/

// 保存担保消息的全局变量
var garanteeableMessage;

// 检查规则数组
function checkGaranteeableByArray(rules, bookingDate, checkInDate, arriveTime, roomCount, firstNightFees, fullyFees)
{
	// 担保规则为空时无需担保
	if (rules == null || rules.length == 0) return false;

	// 消息复位
	garanteeableMessage = '';

	// 取得数组长度
	var ruleLength = rules.length;

	// 遍历每条规则
	for (var index = 0; index < ruleLength; index++)
	{
		var rule = rules[index];

		// 如果遇到符合条件的担保规则就直接返回
		if (checkGaranteeable(rule, bookingDate, checkInDate, arriveTime, roomCount, firstNightFees, fullyFees)) return true;
	}

	return false;
}

// 检查单条规则
function checkGaranteeable(rule, bookingDate, checkInDate, arriveTime, roomCount, firstNightFees, fullyFees)
{
	// 辅助函数
	if (!this.resetDate) this.resetDate = function (date)
	{
		date.setFullYear(2000);
		date.setMonth(1);
		date.setDate(1);

		return date;
	};

	// 参数整理，便于后面的比较
	this.arriveTime = this.resetDate(arriveTime);
	this.ArriveStartTime = this.resetDate(rule.ArriveStartTime);
	this.ArriveEndTime = this.resetDate(rule.ArriveEndTime);

	// 如果担保最晚时间是次日，则日期+1，刚才已经复位为1日，这里直接设置为2日即可
	if (rule.IsTomorrow) this.ArriveEndTime = this.ArriveEndTime.setDate(2);

	// 消息复位
	garanteeableMessage = '';

	// 提取担保时间的判断基准
	var refDate;

	switch (rule.DateReference)
	{
		case 1: // 入住日期
			refDate = checkInDate;
			break;

		case 2: // 在店日期（暂时以入住日期方式处理）
			refDate = checkInDate;
			break;

		case 3: // 预订日期
			refDate = bookingDate;
			break;

		default:
			return false;
	}

	// 将每周有效日join为已格式化的字符串，对js表示无语……
	var weekSets = rule.WeekSet.join(',');

	if (refDate >= rule.ActivationDate && refDate <= rule.ExpirationDate && weekSets.indexOf(refDate.getDay().toString()) > -1)
	{
		var flag = false;

		garanteeableMessage = '担保条件：在' + rule.ActivationDate.format('yyyy-MM-dd') + '至' + rule.ExpirationDate.format('yyyy-MM-dd') + '期间入住，';

		// 时间担保检查
		if (rule.IsArriveTimeVouch)
		{
			if (arriveTime > this.ArriveStartTime && arriveTime <= this.ArriveEndTime)
			{
				flag = true;

				garanteeableMessage = garanteeableMessage.concat('于' + rule.ArriveStartTime.format('hh:mm') + '至' + rule.ArriveEndTime.format('hh:mm') + '到店，');
			}
		}
		else flag = true;

		// 房量担保检查
		if (rule.IsRoomCountVouch)
		{
			if (roomCount >= rule.RoomCount)
			{
				flag = true;
	
				garanteeableMessage = garanteeableMessage.concat('如果预订房量超过' + rule.RoomCount + '间，');
			}
		}

		if (flag)
		{
			garanteeableMessage = garanteeableMessage.concat('需要您提供信用卡担保。');

			// 变更规则
			if (rule.IsChange)
			{
				switch (rule.ChangeRule)
				{
					case 2:
						garanteeableMessage = garanteeableMessage.concat('客人在' + rule.ChangeRuleDate.format('yyyy-MM-dd hh:mm') + '之前可以变更取消，之后无法变更取消。');
						break;

					case 3:
						if (rule.ChangeRuleHours == 24) garanteeableMessage = garanteeableMessage.concat('客人最早到店1天前可以变更取消，之后无法变更取消。');
						else garanteeableMessage = garanteeableMessage.concat('客人最早到店' + rule.ChangeRuleHours + '小时前可以变更取消，之后无法变更取消。');
						break;

					case 4:
						garanteeableMessage = garanteeableMessage.concat('客人在到店当日的' + (24 - rule.ChangeRuleHours) + ':00前可以变更取消，之后无法变更取消。');
						break;

					default:
						garanteeableMessage = garanteeableMessage.concat('订单提交后不允许变更取消。');
						break;
				}
			} else garanteeableMessage = garanteeableMessage.concat('订单提交后不允许变更取消。');

			// 押金计算
			switch (rule.Deposit)
			{
				case 1:
					garanteeableMessage = garanteeableMessage.concat('如未入住，将扣除第一晚房费(' + firstNightFees + '元)作为违约金。');
					break;

				case 2:
					garanteeableMessage = garanteeableMessage.concat('如未入住，将扣除全额房费(' + fullyFees + '元)作为违约金。');
					break;
			}

			return true;
		}
	}

	// 如果无需担保，复位消息，避免出现脏数据
	garanteeableMessage = '';

	return false;
}
//
//// 测试
//// 预订日期
//var bookingDate = new Date(2011, 6, 2);
//// 入住日期
//var checkInDate = new Date(2011, 6, 3, 8, 0, 0);
//// 假设用户晚上8点才能抵达酒店
//var arriveTime = new Date(2011, 5, 20, 18, 0, 0);
//// 房间数量
//var roomCount = 1;
//// 首晚房费
//var firstNightFees = 100;
//// 全额房费
//var fullyFees = 1000;
//// 担保规则
//var hotelGaranteeRule = {
//	"RuleMode" : 1,
//	"Description" : "担保条件：在11.06.19至11.12.31 入住 在18:00至6:00到店，需要您提供信用卡担保。客人入住日18:00点前可以变更取消，之后无法变更取消，如未入住，将扣除第一晚房费作为违约金。",
//	"Gage" : 1,
//	"DateReference" : 1,
//	"ActivationDate" : new Date(1308412800000),
//	"ExpirationDate" : new Date(1325260800000),
//	"WeekSet" : [1, 2, 3, 4, 5, 6, 0],
//	"IsArriveTimeVouch" : true,
//	"ArriveStartTime" : new Date(946720800000),
//	"ArriveEndTime" : new Date(946677600000),
//	"IsTomorrow" : true,
//	"IsRoomCountVouch" : false,
//	"RoomCount" : 0,
//	"IsChange" : true,
//	"ChangeRule" : 4,
//	"ChangeRuleDate" : new Date(1219053600000),
//	"ChangeRuleHours" : 6,
//	"Deposit" : 1
//};
//
//// 担保校验
//var result = checkGaranteeable(hotelGaranteeRule, bookingDate, checkInDate, arriveTime, roomCount, firstNightFees, fullyFees);
//
//// 需要担保时输出担保消息
//if (result) console.log(garanteeableMessage);
//else console.log('无需担保');