<?php
header("Content-Type: text/html; charset=utf-8");
ini_set("display_errors", "Off");
ini_set("log_errors", "Off");
ini_set("error_reporting", "E_ALL & ~E_NOTICE");

define('admin_ROOT', $_SERVER['DOCUMENT_ROOT']."/");
define('adminfile', "ydbsupervise");
include_once(admin_ROOT . 'datacache/public.php');

class common {
	function init() {
		$this->dbmysql();
		include admin_ROOT . 'datacache/command.php';
		$this->CON = $CONFIG;
	}
	/**
	 * 数据库链接函数
	 */
	function dbmysql() {
		global $_GLOBAL;
		include_once admin_ROOT . '/public/class_dbmysql.php';
		$_GLOBAL['db'] = new dbmysql();
		$_GLOBAL['db']->connect(db_host, db_user, db_pw, db_name, db_charset);
	}

	/**
	 * 接收类型
	 * @param 表单名称 $k
	 * @param 接收类型 $var
	 * @param bool $htmlcode
	 * @param bool $rehtml
	 */
	function accept($k, $var='R', $htmlcode=true, $rehtml=false) {
		switch ($var) {
			case 'G':
				$var = &$_GET;
				break;
			case 'P':
				$var = &$_POST;
				break;
			case 'C':
				$var = &$_COOKIE;
				break;
			case 'R':
				$var = &$_GET;
				if (empty($var[$k])) {
					$var = &$_POST;
				}
				break;
		}
		$putvalue = isset($var[$k]) ? $this->daddslashes($var[$k], 0) : NULL;
		$putvalue = trim($putvalue);
		return $htmlcode ? ($rehtml ? $this->preg_htmldecode($putvalue) : $this->htmldecode($putvalue)) : $putvalue;
	}
	
	function daddslashes($string, $force=0, $strip=FALSE) {
		if (!get_magic_quotes_gpc() || $force == 1) {
			if (is_array($string)) {
				foreach ($string as $key => $val) {
					$string[$key] = addslashes($strip ? stripslashes($val) : $val);
				}
			} else {
				$string = addslashes($strip ? stripslashes($string) : $string);
			}
		}
		return $string;
	}
	
	function preg_htmldecode($string) {
		if (is_array($string)) {
			foreach ($string as $key => $val) {
				$string[$key] = $this->preg_htmldecode($val);
			}
		} else {
			$string = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $string);
			$string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4}));)/', '&\\1', $string);
		}
		return $string;
	}
	
	function htmldecode($str) {
		if (empty($str)) return $str;
		if (!is_array($str)) {
			$str = htmlspecialchars(trim($str));
			$str = str_ireplace("Xss", "", $str);
		} else {
			foreach ($str as $key => $val) {
				$str[$key] = htmlspecialchars($val);
				$str[$key] = $this->htmldecode($val);
			}
		}
		return $str;
	}
	/**
	 * 字符串加密解密
	 * @param string $string
	 * @param string $operation
	 * @param string $key
	 */
	function eccode($string, $operation='DECODE', $key='hcfly%#%#@yinyud#^$#ing82007^#^#11out7k7k') {
		$result = '';
		if ($operation == 'ENCODE') {
			for ($i = 0; $i < strlen($string); $i++) {
				$char = substr($string, $i, 1);
				$keychar = substr($key, ($i % strlen($key)) - 1, 1);
				$char = chr(ord($char) + ord($keychar));
				$result.=$char;
			}
			$result = base64_encode($result);
			$result = str_replace(array('+', '/', '='), array('-', '_', ''), $result);
		} elseif ($operation == 'DECODE') {
			$data = str_replace(array('-', '_'), array('+', '/'), $string);
			$mod4 = strlen($data) % 4;
			if ($mod4) {
				$data .= substr('====', $mod4);
			}
			$string = base64_decode($data);
			for ($i = 0; $i < strlen($string); $i++) {
				$char = substr($string, $i, 1);
				$keychar = substr($key, ($i % strlen($key)) - 1, 1);
				$char = chr(ord($char) - ord($keychar));
				$result.=$char;
			}
		}
		return $result;
	}
	function ip($str, $type=1) {
		if (empty($str)) {
			return false;
		} else {
			if ($type) {
				$ip = ip2long($str);
			} else {
				$ip = long2ip($str);
			}
		}
		return $ip;
	}
	function setcookie($key, $value, $life=0) {
		$this->time = time();

		setcookie($key, $value, ($life ? time() + $life : 0), '/', '', ($_SERVER['SERVER_PORT'] == 443 ? 1 : 0));
	}
	function message($num=0) {
		$str = "";
		switch ($num) {
			case 1:
				$str = "恭喜你，注册会员成功";
				break;
			case 2:
				$str = "密码已发送到你的手机";
				break;
			case -1:
				$str = "错误：手机号不能为空";
				break;
			case -2:
				$str = "错误：手机号不合法";
				break;
			case -3:
				$str = "错误：密码不能为空";
				break;
			case -4:
				$str = "错误：你不是业务员不能登录";
				break;
			case -5:
				$str = "错误：用户名或者密码错误";
				break;
			case -6:
				$str = "错误：手机号已存在";
				break;
			case -7:
				$str = "错误：手机号不存在";
				break;
			default:
				$str = "";
				break;
		}
		return $str;
	}
	
	function membersmssend($interfacename,$phone,$passord) {
		if ($this->CON['is_sms'] == 0) return false;
		$data = array();
		if($interfacename == "memberpwsms") {
			$data = array('mobileNumber'=>$phone,'password'=>$passord,'title'=>$this->CON['sms_text']);
		} else {
			$data = array('mobileNumber'=>$phone,'password'=>$passord,'title'=>$this->CON['sms_text'],'custom'=>$this->CON['sms_custom']);
		}
		$this->get_interface_hotelurl($interfacename,$data);
	}
	
	function get_interface_hotelurl($interfacename,$data) {
		include admin_ROOT . adminfile . '/include/inc_interface.php';

		$url = $URLINFOLIST[$interfacename]['url'] . "&" .  $ORDERPARAM;
		$url = str_replace("{#sid#}",hotelorder_aid,$url);
		$url = str_replace("{#skey#}",hotelorder_key,$url);
		$url = str_replace("{#aid#}",$this->CON['hotel_aid'],$url);
		$url = str_replace("{#key#}",$this->CON['sms_key'],$url);

		$url = str_replace("{#mobileNumber#}",$data['mobileNumber'],$url);
		$url = str_replace("{#password#}",$data['password'],$url);
		$url = str_replace("{#title#}",$data['title'],$url);
		if($interfacename != "memberpwsms") {
			$url = str_replace("{#custom#}",$data['custom'],$url);
		}
		$result = $this->get_remotefile($url);
		include_once admin_ROOT . 'public/class_json.php';
		$isjson = function_exists('json_decode')? true : false;
		if($isjson) {
			$arr = json_decode($result,true);
		} else {
			$json = new json();
			$arr = $json->jsonDecode($result);
		}
		return $arr;
	}
	
	function get_remotefile($url) {
		$arr=file($url); 
		$content=implode('',$arr);
		return $content;
	}
}
?>