<?php


class important extends connector {

	function important() {
		$this->softbase(true);
	}

	function onfilemanage() {
		include_once admin_ROOT . adminfile . '/include/command_list.php';
		parent::start_template();
		$listfunction = $this->fun->accept('listfunction', 'G');
		if (empty($listfunction)) {
			exit('err');
		}

		$checkfrom = $this->fun->accept('checkfrom', 'R');
		$checkfrom = empty($checkfrom) ? 'edit' : $checkfrom;

		$fileinputid = $this->fun->accept('fileinputid', 'R');

		$iframename = $this->fun->accept('iframename', 'R');

		$iframeid = $this->fun->accept('iframeid', 'R');

		$dirlist = $this->fun->accept('dirlist', 'R');

		$cookpage = $this->fun->accept($CONLIST[$listfunction]['pagecoock'], 'C');
		$nowpage = empty($cookpage) ? 0 : $cookpage;
		$this->ectemplates->assign('nowpage', $nowpage);
		$this->ectemplates->assign('loadurl', $CONLIST[$listfunction]['loadurl'] . '&dirlist=' . $dirlist . '&checkfrom=' . $checkfrom . '&fileinputid=' . $fileinputid);

		$this->ectemplates->assign('MaxPerPage', $this->CON['max_list']);

		$this->ectemplates->assign('MaxHit', $this->CON['max_page']);
		$this->ectemplates->assign('listfunction', $listfunction);
		$this->ectemplates->assign('checkfrom', $checkfrom);
		$this->ectemplates->assign('iframename', $iframename);
		$this->ectemplates->assign('fileinputid', $fileinputid);
		$this->ectemplates->assign('iframeid', $iframeid);
		$this->ectemplates->display('public/public_filemanage_window');
	}

	function onfilelist() {
		include_once admin_ROOT . adminfile . '/include/command_list.php';

		$dirlist = $this->fun->accept('dirlist', 'R');
		$upfile_dir = admin_ROOT . $this->CON['upfile_dir'];
		if (!empty($dirlist)) {
			$upfile_dir = $upfile_dir . $dirlist;
		}
		if (!$this->fun->filemode($upfile_dir)) {
			exit($this->lng['filemanage_mode_err']);
		}
		parent::start_template();

		$MinPageid = $this->fun->accept('MinPageid', 'R');

		$page_id = $this->fun->accept('page_id', 'R');

		$countnum = $this->fun->accept('countnum', 'R');

		$MaxPerPage = $this->fun->accept('MaxPerPage', 'R');
		if (empty($MaxPerPage)) {
			$MaxPerPage = $this->CON['max_list'];
		}

		$checkfrom = $this->fun->accept('checkfrom', 'R');


		$fileinputid = $this->fun->accept('fileinputid', 'R');

		if (preg_match("/(\/)/i", $dirlist)) {

			$updir = explode('/', $dirlist);
			array_pop($updir);
			array_pop($updir);
			$updirfile = implode('/', $updir);
			$updirtype = 1;
			$uploadurl = empty($updirfile) ? $CONLIST['filelist']['loadurl'] . '&dirlist=&checkfrom=' . $checkfrom . '&fileinputid=' . $fileinputid : $CONLIST['filelist']['loadurl'] . '&dirlist=' . $updirfile . '/&checkfrom=' . $checkfrom . '&fileinputid=' . $fileinputid;

			$MaxPerPage--;
		} else {
			$updirtype = 2;
		}

		$files = @glob($upfile_dir . '*', GLOB_MARK);
		$filenum = count($files);

		if (!empty($countnum)) {
			exit("$filenum");
		}
		if ($filenum > 0) {

			if ($filenum > 1) {

				$filelist = array();
				foreach ($files as $key => $file) {
					$filetime = filectime($file);
					$numtype = is_dir($file) ? 0 : 1;
					if (isset($filelist[is_dir($file) ? 0 : 1][$filetime + $key])) {
						$keyset = $filetime + $key + 2;
					} else {
						$keyset = $filetime + $key;
					}

					$filelist[$numtype][$keyset] = $file;
				}
				if (!empty($filelist[0])) krsort($filelist[0]);
				if (!empty($filelist[1])) krsort($filelist[1]);
				if (!empty($filelist[0]) && !empty($filelist[1])) {
					$filelist = array_merge_recursive($filelist[0], $filelist[1]);
				} else {
					if (!empty($filelist[0])) {
						$filelist = $filelist[0];
					} else {
						$filelist = $filelist[1];
					}
				}
			} else {
				$filelist = $files;
			}
			unset($files);
			$filearray = array();
			$i = 0;
			$endpage = $MinPageid + $MaxPerPage;
			foreach ($filelist as $key => $file) {

				if (( $i >= $MinPageid ) && ($endpage > $i)) {
					$filearray_temp = array();
					$mime = $this->getMimeType($file);
					if ($mime == 'dir') {
						$dir = pathinfo($file);

						$loadurl = $CONLIST['filelist']['loadurl'] . '&dirlist=' . $dirlist . $dir['basename'] . '/&checkfrom=' . $checkfrom . '&fileinputid=' . $fileinputid;
						$filearray_temp['loadurl'] = $loadurl;

						$filearray_temp['filename'] = $dir['basename'];

						$filearray_temp['path'] = $dir['dirname'];

						$filearray_temp['type'] = 'dir';
						$filearray_temp['size'] = 0;
						$filearray_temp['picerrid'] = 1;
						$filearray_temp['bottype'] = 'dir';
					} else {

						$filearray_temp['filename'] = $mime['basename'];

						$filearray_temp['path'] = $mime['dirname'];

						$filearray_temp['type'] = strtolower($mime['extension']);

						$filearray_temp['size'] = @filesize($file);

						if ($filearray_temp['type'] == 'jpg' || $filearray_temp['type'] == 'gif' || $filearray_temp['type'] == 'jpeg' || $filearray_temp['type'] == 'png') {
							$imginfo = $this->get_imginfo($file);
							if ($imginfo) {
								$filearray_temp['picerrid'] = $imginfo['picerrid'];
								$filearray_temp['srcW'] = $imginfo['srcW'];
								$filearray_temp['srcH'] = $imginfo['srcH'];
								$filearray_temp['windowsW'] = $imginfo['windowsW'];
								$filearray_temp['windowsH'] = $imginfo['windowsH'];
							} else {
								$filearray_temp['type'] == 'unknown';
							}
							$filearray_temp['bottype'] = 'img';
						} else {
							$filearray_temp['picerrid'] = 1;
							$filearray_temp['bottype'] = 'text';
						}
					}
					$filearray_temp['time'] = filemtime($file);
					$filearray[] = $filearray_temp;
				}
				if ($endpage < $i) break;
				$i++;
			}
		}
		unset($filelist);
		$this->ectemplates->assign('dirlist', $dirlist);
		$this->ectemplates->assign('uploadurl', $uploadurl);
		$this->ectemplates->assign('updirtype', $updirtype);
		$this->ectemplates->assign('url', admin_URL . $this->CON['upfile_dir'] . $dirlist);
		$this->ectemplates->assign('dirname', $this->CON['upfile_dir'] . $dirlist);
		$this->ectemplates->assign('admin_path', admin_PATH);
		$this->ectemplates->assign('array', $filearray);
		$this->ectemplates->assign('checkfrom', $checkfrom);
		$this->ectemplates->assign('upfile_dir', $upfile_dir);
		$this->ectemplates->assign('fileinputid', $fileinputid);
		$this->ectemplates->display('public/public_filemanage_filelist');
	}

	function onimagecrop() {
		$this->powercheck(11, 124);
		parent::start_template();

		$path = $this->fun->accept('path', 'R');
		$imgname = $this->fun->accept('imgname', 'R');

		$type = $this->fun->accept('type', 'R');

		$imgpath = @realpath(admin_ROOT . $path . $imgname);
		if (!$imgpath) {
			$this->calldialogmessage($this->lng['filemanage_file_picerrupload'], $this->lng['botton_close'], '', 0, 1, 'fnUpdate');
		}





		$mime = $this->getMimeType($imgpath);

		$imagesize = @getimagesize($imgpath);
		if (!$imagesize) {
			$this->calldialogmessage($this->lng['filemanage_file_picerrupload'], $this->lng['botton_close'], '', 0, 1, 'fnUpdate');
		}
		switch ($imagesize[2]) {
			case 1:
				$im = @ImageCreateFromGIF($imgpath);
				$mime['extension'] = 'gif';
				break;
			case 2:
				$im = @ImageCreateFromJPEG($imgpath);
				$mime['extension'] = 'jpg';
				break;
			case 3:
				$im = @ImageCreateFromPNG($imgpath);
				$mime['extension'] = 'png';
				break;
		}
		if (!$im) {
			$this->calldialogmessage($this->lng['filemanage_file_picerrupload'], $this->lng['botton_close'], '', 0, 1, 'fnUpdate');
		}

		$srcW = $imagesize[0];

		$srcH = $imagesize[1];

		$newfilename = date('YmdHis') . '_' . rand(100, 999) . '_crop' . '.' . $mime['extension'];
		$this->ectemplates->assign('url', admin_URL . $path);
		$this->ectemplates->assign("path", $path);
		$this->ectemplates->assign("imgname", $imgname);
		$this->ectemplates->assign("imgpath", $imgpath);
		$this->ectemplates->assign("newfilename", $newfilename);
		$this->ectemplates->assign("srcW", $srcW);
		$this->ectemplates->assign("srcH", $srcH);
		$this->ectemplates->display("public/public_filemanage_imagecrop");
	}

	function onrenamedir() {
		parent::start_template();

		$path = $this->fun->accept('path', 'R');

		$dirname = $this->fun->accept('dirname', 'R');

		$this->ectemplates->assign("dirname", $dirname);
		$this->ectemplates->assign("path", $path);
		$this->ectemplates->display("public/public_filemanage_rename");
	}

	function onrenamesave() {
		$this->powercheck(11, 123);
		$path = $this->fun->accept('path', 'P');
		$dirname = $this->fun->accept('dirname', 'P');

		$newdirnam = $this->fun->accept('newdirnam', 'P');
		$oldfile = @realpath(admin_ROOT . $path . $dirname);

		if (stristr($newdirnam, ".php")) {
			exit('false');
		}

		$newfile = admin_ROOT . $path . $newdirnam;
		if (is_dir($newfile)) {
			exit('false');
		} else {
			if (!@rename($oldfile, $newfile)) {
				exit('false');
			} else {
				exit('true');
			}
		}
	}

	function onmkdir() {
		parent::start_template();
		$path = $this->fun->accept('path', 'R');
		$this->ectemplates->assign("path", $path);
		$this->ectemplates->display("public/public_filemanage_mkdir");
	}

	function onmadirsave() {
		$this->powercheck(11, 122);

		$path = $this->fun->accept('path', 'P');

		$dirname = $this->fun->accept('dirname', 'P');
		$cpath = admin_ROOT . $path;

		if (!$this->fun->filemode($cpath)) {
			exit('false');
		}
		$file = admin_ROOT . $path . $dirname;
		if (is_dir($file)) {
			exit('false');
		} else {
			@mkdir($file, 0777);
			exit('true');
		}
	}

	function onupfile() {
		parent::start_template();
		$path = $this->fun->accept('path', 'R');

		$maxfile = $this->CON['upfile_maxsize'];

		$img_width = $this->CON['img_width'];

		$img_height = $this->CON['img_height'];

		$img_issmallpic = $this->CON['img_issmallpic'];

		$upfile_pictype = $this->CON['upfile_pictype'];
		$this->ectemplates->assign("path", $path);
		$this->ectemplates->assign("maxfile", $maxfile);
		$this->ectemplates->assign("maxfile2", $this->fun->format_size($maxfile));
		$this->ectemplates->assign("img_width", $img_width);
		$this->ectemplates->assign("img_height", $img_height);
		$this->ectemplates->assign("img_issmallpic", $img_issmallpic);
		$this->ectemplates->assign("upfile_pictype", $upfile_pictype);
		$this->ectemplates->display("public/public_filemanage_upfile");
	}

	function onbatupfile() {
		parent::start_template();
		$path = $this->fun->accept('path', 'R');

		$maxfile = $this->CON['upfile_maxsize'];

		$img_width = $this->CON['img_width'];

		$img_height = $this->CON['img_height'];

		$img_issmallpic = $this->CON['img_issmallpic'];

		if (!empty($this->CON['upfile_pictype'])) {
			$pictypearray = explode('|', $this->CON['upfile_pictype']);
			$piccount = count($pictypearray) - 1;
			foreach ($pictypearray as $key => $value) {
				if ($piccount == $key) {
					$upfile_pictype.='*.' . $value;
				} else {
					$upfile_pictype.='*.' . $value . ';';
				}
			}
		} else {
			$upfile_pictype = '*.jpg;*.gif;*.png';
		}
		$this->ectemplates->assign("ecisp_admininfo", $this->fun->accept('ecisp_admininfo', 'C'));
		$this->ectemplates->assign("esp_powerlist", $this->fun->accept('esp_powerlist', 'C'));
		$this->ectemplates->assign("path", $path);
		$this->ectemplates->assign("maxfile", $maxfile);
		$this->ectemplates->assign("maxfile2", $this->fun->format_size($maxfile));
		$this->ectemplates->assign("img_width", $img_width);
		$this->ectemplates->assign("img_height", $img_height);
		$this->ectemplates->assign("img_issmallpic", $img_issmallpic);
		$this->ectemplates->assign("upfile_pictype", $upfile_pictype);
		$this->ectemplates->display("public/public_filemanage_batupfile");
	}

	function onbatupfilesave() {
		$this->powercheck(11, 121);
		require_once admin_ROOT . '/public/class_upload.php';
		$temppath = $this->fun->accept('path', 'R');
		$path = admin_ROOT . $temppath;

		if (!$this->fun->filemode($path)) {
			exit('false');
		}

		$img_issmallpic = $this->fun->accept('img_issmallpic', 'P');
		$img_issmallpic = empty($img_issmallpic) ? 0 : $img_issmallpic;

		$img_width = $this->fun->accept('img_width', 'P');
		$img_width = empty($img_width) ? 0 : $img_width;
		$img_height = $this->fun->accept('img_height', 'P');
		$img_height = empty($img_height) ? 0 : $img_height;

		$filename = $_FILES['Filedata']['name'];

		$filesize = intval($_FILES['Filedata']['size']);

		$filetmpname = $_FILES['Filedata']['tmp_name'];

		$fileerror = $_FILES['Filedata']['error'];

		$filetype = $_FILES['Filedata']['type'];
		if ($filesize <= 0 || $filesize > intval($this->CON['upfile_maxsize'])) {
			exit('false');
		}
		$upfile = new uploadFile();
		$upfile->upfilebase($img_width, $img_height, $img_issmallpic, $path, $filename, $filesize, $filetmpname, $fileerror, $filetype);
		exit('true');
	}

	function onupfilesave() {
		$this->powercheck(11, 121);
		require_once admin_ROOT . '/public/class_upload.php';
		$temppath = $this->fun->accept('path', 'P');
		$path = admin_ROOT . $temppath;

		if (!$this->fun->filemode($path)) {
			exit($this->lng['filemanage_js_upfile_no']);
		}
		$upfilepath = $this->fun->accept('upfilepath', 'P');

		$img_issmallpic = $this->fun->accept('img_issmallpic', 'P');
		$img_issmallpic = empty($img_issmallpic) ? 0 : $img_issmallpic;

		$img_width = $this->fun->accept('img_width', 'P');
		$img_width = empty($img_width) ? 0 : $img_width;
		$img_height = $this->fun->accept('img_height', 'P');
		$img_height = empty($img_height) ? 0 : $img_height;

		$filename = $_FILES['upfilepath']['name'];

		$filesize = intval($_FILES['upfilepath']['size']);

		$filetmpname = $_FILES['upfilepath']['tmp_name'];

		$fileerror = $_FILES['upfilepath']['error'];

		$filetype = $_FILES['upfilepath']['type'];
		if ($filesize <= 0 || $filesize > intval($this->CON['upfile_maxsize'])) {
			exit($this->lng['download_mess_size_err2']);
		}
		$upfile = new uploadFile();
		$upfile->upfilebase($img_width, $img_height, $img_issmallpic, $path, $filename, $filesize, $filetmpname, $fileerror, $filetype);
		exit('true');
	}

	function ondelfile() {
		$this->powercheck(11, 120);
		parent::start_template();

		$path = $this->fun->accept('path', 'P');
		$filedir = admin_ROOT . $path;

		if (!$this->fun->filemode($filedir)) {
			exit('false');
		}


		$files = @glob($filedir . '*', GLOB_MARK);
		$filenum = count($files);

		$filelist = array();
		foreach ($files as $key => $file) {
			$keyname = pathinfo($file, PATHINFO_BASENAME);
			pathinfo($file, PATHINFO_BASENAME);
			$filelist[$keyname] = $file;
		}
		$selectinfoid = $this->fun->accept('selectinfoid', 'P');
		$selectinfoid = explode(',', $selectinfoid);
		array_pop($selectinfoid);
		foreach ($selectinfoid as $key => $value) {
			$filename = $filelist[$value];
			$this->fun->delfile($filename);
		}
		exit('true');
	}

	function onimgagecut() {
		$this->powercheck(11, 124);
		parent::start_template();
		$path = $this->fun->accept('path', 'P');
		$imgname = $this->fun->accept('imgname', 'P');
		$selecton = $this->fun->accept('selecton', 'P');
		$newimagename = $this->fun->accept('newimagename', 'P');

		$w = $this->fun->accept('w', 'P');

		$h = $this->fun->accept('h', 'P');

		$x = $this->fun->accept('x', 'P');

		$y = $this->fun->accept('y', 'P');
		$imgpath = @realpath(admin_ROOT . $path . $imgname);
		if (!$imgpath) {
			exit('false');
		}
		if ($selecton == 0) {
			$newfiletype = admin_ROOT . $path . $newimagename;
		} else {
			$newfiletype = $imgpath;
		}
		$imagetype = @getimagesize($imgpath);
		if (!$imagetype) {
			exit('false');
		}
		switch ($imagetype[2]) {
			case 1:
				$image = @ImageCreateFromGIF($imgpath);
				break;
			case 2:
				$image = @ImageCreateFromJPEG($imgpath);
				break;
			case 3:
				$image = @ImageCreateFromPNG($imgpath);
				break;
		}

		$image_p = ImageCreateTrueColor($w, $h);

		imagecopyresampled($image_p, $image, 0, 0, $x, $y, $w, $h, $w, $h);
		switch ($imagetype[2]) {
			case 1:

				@imagegif($image_p, $newfiletype);
				break;
			case 2:

				@imagejpeg($image_p, $newfiletype);
				break;
			case 3:

				@imagepng($image_p, $newfiletype);
				break;
		}
		@ImageDestroy($image);
		exit('true');
	}

	function onzoomimage() {
		parent::start_template();
		$path = $this->fun->accept('path', 'R');
		$imgname = $this->fun->accept('imgname', 'R');
		$dstW = $this->fun->accept('dstW', 'R');
		$dstH = $this->fun->accept('dstH', 'R');

		$imgpath = @realpath(admin_ROOT . $path . $imgname);
		if (!$imgpath) {
			exit('false');
		}

		if (!is_writable($imgpath)) {
			exit('false');
		}





		$mime = $this->getMimeType($imgpath);

		$imagesize = @getimagesize($imgpath);
		if (!$imagesize) {
			exit('false');
		}
		switch ($imagesize[2]) {
			case 1:
				$im = @ImageCreateFromGIF($imgpath);
				$mime['extension'] = 'gif';
				break;
			case 2:
				$im = @ImageCreateFromJPEG($imgpath);
				$mime['extension'] = 'jpg';
				break;
			case 3:
				$im = @ImageCreateFromPNG($imgpath);
				$mime['extension'] = 'png';
				break;
		}
		if (!$im) {
			exit('false');
		}

		$srcW = $imagesize[0];

		$srcH = $imagesize[1];

		$dstWH = $dstW / $dstH;

		$srcWH = $srcW / $srcH;

		if ($dstWH <= $srcWH) {
			$ftoW = $dstW;
			$ftoH = $ftoW * ($srcH / $srcW);
		} else {
			$ftoH = $dstH;
			$ftoW = $ftoH * ($srcW / $srcH);
		}

		$url = admin_URL . $path;
		$newimgpath = $url . $imgname;

		$img_quality = intval($this->CON['img_quality']);

		if ($srcW > $dstW || $srcH > $dstH) {

			if (function_exists('imagecreatetruecolor')) {

				$ni = ImageCreateTrueColor($ftoW, $ftoH);

				ImageCopyResampled($ni, $im, 0, 0, 0, 0, $ftoW, $ftoH, $srcW, $srcH);
			} else {
				$ni = ImageCreate($ftoW, $ftoH);

				ImageCopyResized($ni, $im, 0, 0, 0, 0, $ftoW, $ftoH, $srcW, $srcH);
			}
			switch ($mime['extension']) {
				case 'gif':

					@imagegif($ni, $imgpath);
					break;
				case 'jpg':

					@imagejpeg($ni, $imgpath, $img_quality);
					break;
				case 'png':

					@imagepng($ni, $imgpath);
					break;
			}

			$upresultid = '<span id="imagelist"><img id="cropbox" width="' . $ftoW . '" height="' . $ftoH . '" src="' . $newimgpath . '"></span>';
			ImageDestroy($ni);
		} else {

			$upresultid = '<span id="imagelist"><img id="cropbox" width="' . $dstW . '" height="' . $ftoH . '" src="' . $newimgpath . '"></span>';

			ImageDestroy($im);
		}
		exit($upresultid);
	}





	function get_imginfo($imgfilepath) {
		$imagetype = @GetImageSize($imgfilepath);
		$imginfo = array();
		if ($imagetype[2] == 1 || $imagetype[2] == 2 || $imagetype[2] == 3) {
			switch ($imagetype[2]) {
				case 1:
					$im = @ImageCreateFromGIF($imgfilepath);
					break;
				case 2:
					$im = @ImageCreateFromJPEG($imgfilepath);
					break;
				case 3:
					$im = @ImageCreateFromPNG($imgfilepath);
					break;
			}

			if (!$im) {
				$imginfo['picerrid'] = 0;
			} else {
				$imginfo['picerrid'] = 1;
			}

			$srcW = $imagetype[0];
			$imginfo['srcW'] = $imagetype[0];
			$imginfo['srcH'] = $imagetype[1];

			if ($imginfo['srcW'] <= 500) {
				$windowsW = 600;
			} else {
				$windowsW = $imginfo['srcW'] + 70;
				if ($windowsW > 850) {
					$windowsW = 850;
				}
			}

			$windowsH = $imginfo['srcH'] + 300;
			if ($windowsH > 400) {
				$windowsH = 400;
			}
			$imginfo['windowsW'] = $windowsW;
			$imginfo['windowsH'] = $windowsH;

			return $imginfo;
		} else {
			return false;
		}
	}





	function getMimeType($file) {
		return @is_dir($file) ? 'dir' : $this->mime($file);
	}





	public function mime($file) {

		$file = realpath($file);

		$options = @pathinfo($file);
		return $options;
	}

}
?>
